#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "fit_param.h"
#include "poly2.h"
#include "cmd.h"

extern XtAppContext pp;
extern Widget top,text_w,main_w;
extern int flg;
static intep test;

void 
fit_param::cancel_dlog(Widget w,XtPointer client_data,
			    XtPointer call_data)
{ 
  fit_param* THIS = (fit_param*) client_data;
  if (THIS->dlog==w) 
    {
      Widget shell=THIS->dlog;
      if (shell)
	XtDestroyWidget(shell);
      delete [] THIS->text; 
      delete [] THIS->limit;
      delete [] THIS->Pbutton;
      delete [] THIS->tp_fit;
      THIS->str_fnc=0;
      THIS->text=0;
      THIS->Pbutton=0;
      THIS->limit=0;
      THIS->tp_fit=0; 
      THIS->flg=0;
      THIS->dlog=0;
    }
  return;
}
     
void 
fit_param::cancel_fit(Widget w,XtPointer client_data,
			   XtPointer call_data)
{ 
  fit_hold* HOLD = (fit_hold*) client_data;
  if (HOLD->THIS->dlog==HOLD->W)
    {
      Widget shell=HOLD->THIS->dlog;
      XtDestroyWidget(shell);
      delete [] HOLD->THIS->text; 
      delete [] HOLD->THIS->tp_fit;
      delete [] HOLD->THIS->limit;
      delete [] HOLD->THIS->Pbutton;
      HOLD->THIS->limit=0;
      HOLD->THIS->Pbutton=0;
      HOLD->THIS->text=0;
      HOLD->THIS->tp_fit=0; 
      HOLD->THIS->dlog=0;
      HOLD->THIS->flg=0;
    }
  return;
}
     
fit_param::~fit_param() 
{
  if (dlog)
    { 
      Widget tbd=dlog;
      XtDestroyWidget(tbd);
      delete [] text;
      delete [] limit;
      delete [] tp_fit;
      delete [] Pbutton;
      text=0;
      Pbutton=0;
      tp_fit=0;
      dlog=0;
      flg=0;
    }
  delete [] flag;
  delete [] v;
  delete [] vl;
}
                     
void 
fit_param::resize(const int n)   //n now includes x and y fits
{
  if (n==n_par) 
    return;
  int *f_hold;
  double* v_hold;
  double* vl_hold;
  if (n_par>0 && n>0)
    {
      f_hold=new int[n_par];
      v_hold=new double[n_par];
      vl_hold=new double[2*n_par];
      for (int i=0;i<n_par && i<n; i++)
	{
	  v_hold[i]=v[i];
	  vl_hold[2*i]=vl[2*i];
	  vl_hold[2*i+1]=vl[2*i+1];
	  f_hold[i]=flag[i];
	}
    } 
  delete [] v;
  delete [] vl;       
  delete [] flag;
  v=0;
  vl=0;
  flag=0;
  if (n>0)
    {
      v=new double[n];
      vl=new double[2*n];
      flag=new int[n];
      for(int i=0;i<n;i++)
	{
	  if (i<n_par)
	    {
	      flag[i]=f_hold[i];
	      v[i]=v_hold[i];
	      vl[2*i]=vl_hold[2*i];
	      vl[2*i+1]=vl_hold[2*i+1];
	    }
	  else
	    {
	      flag[i]=1;
	      v[i]=1.0;
	      vl[2*i]=0.0;
	      vl[2*i+1]=2.0;
	    }
	}
      if (n_par>0)
	{
	  delete [] vl_hold;
	  delete [] v_hold;
	  delete [] f_hold;
	}
    }
  n_par=n; 
  return;
}      
 
     
void 
fit_param::load_fit(const char* file)
{
  ifstream fin;
  char s[255];
  if (file)
    fin.open(file,ios::in); 
 
  if (!file || !fin) 
    {
      strcpy(s,"What is the fit param load file =>");
      l_c(s,0);
      s_line();
      int j;
      for(j=0;s[j]>' ' && j<80;j++);
      s[j]=0; 
      fin.open(s,ios::in); 
    }
      
  if (!fin)
    {
      l_c("File not found",1);
      fin.close();
      return;
    }
  int num=0;
  
  fin.getline(s,255,'\n');
  if (!fin || cnt_fnc->makeList(s))
    {
      l_c("String is an invalid function. Please check the file",1);
      fin.close();
      return;
    }

  fin>>num;
  if (!fin || num!=n_par) 
    {
      l_c("Number of parameters not in agreement",1);
      fin.close();
      return;
    }

  delete [] v;
  delete [] vl;
  delete [] flag;
  v=new double[num];
  vl=new double[2*num];
  flag=new int[num];
  if (!flag)
    error("No memory for flag!");     
  for (int i=0;i<num && fin;i++)
    fin>>flag[i]>>v[i]>>vl[2*i]>>vl[2*i+1];
  fin.close();
  make_wind();
  update_flag();
  return;
}   

void 
fit_param::save_fit()
  /* To write the file to the disk -- not updated or tested */
{
  ofstream fout;
  char s[255];
  strcpy(s,"What is the fit param save file =>");
  l_c(s,0);
  s_line();
  int j;
  for(j=0;s[j]>' ' && j<80;j++);
  s[j]=0; 
  fout.open(s,ios::out); 

  if (!fout)
    {
      l_c("Problem with file",1);
      fout.close();
      return;
    }
 
  fout<<strng<<endl;    
  fout<<n_par<<endl;
  for (int i=0;i<n_par;i++)
    fout<<flag[i]<<" "<<v[i]<<" "<<vl[2*i]<<" "
	<<" "<<vl[2*i+1]<<endl;
  fout.close();
  return;
}   

void 
fit_param::set_zero(const int n)
  /* Zero fitting parameters */
{
  qft=0.0;
  resize(n);
  return;
}
     
void 
fit_param::help_fit(Widget w,XtPointer 
			 client_data,XtPointer call_data)
{
  return;
}
           

fit_param::fit_param(intep* T) : 
  cnt_fnc(T),str_fnc(0),
  text(0),Pbutton(0),limit(0),old_fittype(0),
  dlog(0),tp_fit(0),flg(0),start(1),
  end(1),in_grp(0),out_grp(0),
  qft(0),n_par(0),flag(0),v(0),vl(0),
  f_method(1) 
{}


fit_param::fit_param(const fit_param& F)
{
  cnt_fnc = F.cnt_fnc;  //proper copy ??????
  text=0;
  Pbutton=0;
  limit=0;
  flg=0;
  f_method=F.f_method;
  old_fittype=0;
  dlog=0;
  str_fnc=0;
  start=F.start;
  end=F.end;
  in_grp=F.in_grp;
  out_grp=F.out_grp;
  qft=F.qft;
  n_par=F.n_par;     
  if (F.n_par>0)
    {
      v=new double[F.n_par];  
      vl=new double[2*F.n_par];  
      flag=new int[F.n_par];
    }
  else
    {
      v=0;
      vl=0;
      flag=0;
    }
  for(int i=0;i<n_par;i++)
    {
      v[i]=F.v[i];
      vl[2*i]=F.vl[2*i];
      vl[2*i+1]=F.vl[2*i+1];
      flag[i]=F.flag[i];
    }
}
     
     
fit_param& fit_param::operator=(const fit_param& F)
{
  if (this != &F)
    {
      cnt_fnc=F.cnt_fnc;
      start=F.start;
      end=F.end;
      in_grp=F.in_grp;
      out_grp=F.out_grp;
      f_method=F.f_method;
      if (F.n_par!=n_par)
	{
	  delete [] v;
	  delete [] vl;
	  delete [] flag;
	  if (F.n_par>0)
	    {
	      v=new double[F.n_par];
	      vl=new double[2*F.n_par];
	      flag=new int[F.n_par];
	    }
	}
      for(int i=0;i<F.n_par;i++)
	{
	  v[i]=F.v[i];
	  vl[2*i]=F.vl[2*i];
	  vl[2*i+1]=F.vl[2*i+1];
	  flag[i]=F.flag[i];
	}
      n_par=F.n_par;
      qft=F.qft;
    }
  return *this;
}

void 
fit_param::set_pts(int a, int b)
{
  if (a<1 || a>4000)  a=start;
  if (b<1 || b>4000)  b=end;
  if (a>b)
    {
      end=a;
      start=b;
    }
  else
    {
      start=a;
      end=b;
    }
  if (!text) 
    return;
  char out[6];
  int k; 
  sprintf(out,"%5i",start);
  for(k=0;k<5 && out[k]==' ';k++);
  XmTextSetString(text[n_par],out+k);
  sprintf(out,"%5i",end);
  for(k=0;k<5 && out[k]==' ';k++);
  XmTextSetString(text[n_par+1],out+k);
}  

void 
fit_param::set_str()
{
  if (!str_fnc)
    return;

  Widget lab_tbd=str_fnc;
  XtDestroyWidget(lab_tbd);
  XmString fun_str;
  if (cnt_fnc->made())
    fun_str=XmStringCreateLocalized(strng);
  else
    fun_str=XmStringCreateLocalized("No Function");
  str_fnc=
    XtVaCreateManagedWidget("name",xmLabelWidgetClass,
			    XtParent(lab_tbd),
			    XmNlabelString, fun_str,
			    XmNmarginHeight,(Dimension) 0,
			    NULL);
  XtManageChild(str_fnc);
  XmStringFree(fun_str);
  return;
}


void 
fit_param::check_consistency()
{

  extern Spec_In storage_;
  if(!in_grp) return;
  if (start>storage_.stpnt[in_grp-1] || start<1)
    start=1;

  if(end>storage_.stpnt[in_grp-1] || end<=start)
    end=storage_.stpnt[in_grp-1];
  if (!out_grp) 
    out_grp=(in_grp+1) % tg;

  char out[6];
  int k;
  sprintf(out,"%5i",start);
  for(k=0;k<5 && out[k]==' ';k++);
  XmTextSetString(text[n_par],out+k);
  sprintf(out,"%5i",end);
  for(k=0;k<5 && out[k]==' ';k++);
  XmTextSetString(text[n_par+1],out+k);
  sprintf(out,"%3i",out_grp);
  for(k=0;k<3 && out[k]==' ';k++);
  XmTextSetString(text[n_par+3],out+k);
}

void 
fit_param::set_grp(int a, int b)
{
  if (a<1 || a>40)  a=in_grp;
  if (b<1 || b>40)  b=out_grp;
  if (a>b)
    {
      in_grp=a;
      out_grp=b;
    }
  else
    {
      in_grp=a;
      out_grp=b;
    }
  if (!text) return;
  char out[6];
  int k;
  sprintf(out,"%3i",in_grp);
  for(k=0;k<3 && out[k]==' ';k++);
  XmTextSetString(text[n_par+2],out+k);
  sprintf(out,"%3i",out_grp);
  for(k=0;k<3 && out[k]==' ';k++);
  XmTextSetString(text[n_par+3],out+k);
}  

void fit_param::set_text_field()
  /* generic call to update the text fields */
{
  if (!text) return;
  char out[255];
  int k;
  for(int i=0;i<n_par;i++)
    {
      sprintf(out,"%20g",v[i]);
      for(k=0;k<250 && out[k]==' ';k++);
      XmTextSetString(text[i],out+k);

      sprintf(out,"%20g",vl[2*i]);
      for(k=0;k<250 && out[k]==' ';k++);
      XmTextSetString(limit[2*i],out+k);

      sprintf(out,"%20g",vl[2*i+1]);
      for(k=0;k<250 && out[k]==' ';k++);
      XmTextSetString(limit[2*i+1],out+k);
    }
  
  return;
}

/*
 void fit_param::save_wind(Widget w,XtPointer client_data,XtPointer  )
   {
   if dlog
*/

void 
fit_param::make_wind()
{
    
  /*  for all of this see example pg 223 of book A */

  static fit_hold check;
  static Position xx=0;
  static Position yy=0;
  static int p_count(0);
  static ActionAreaItem act[]={
    {"Fit", do_fit, NULL , 1},
    {"New String", new_string, NULL , 1},
    {"Quit", cancel_fit, NULL , 1},
    {"Help", help_fit, NULL , 1}

  };
  if (dlog && p_count!=n_par)
    {
      XtVaGetValues(dlog,XmNx,&xx,XmNy,&yy,NULL);
      cancel_fit(dlog,(XtPointer) &check,(XtPointer) 0);
    }  
     
  if (!dlog) 
    {
      old_fittype=0;
      dlog=
	XtVaCreatePopupShell("SPEC:fit",
			     topLevelShellWidgetClass,main_w,
			     XtNtitle, "Fit Parameters",
			     XmNdeleteResponse, XmDESTROY,
			     NULL);
    
      Widget mwind = XtVaCreateManagedWidget("SPEC:fit2",
					     xmMainWindowWidgetClass,dlog,
					     XtNtitle, "Fit Parameter",
					     NULL);

      menu_tp[0].THIS=this;
      menu_tp[1].THIS=this;
      menu_tp[2].THIS=this;
      menu_tp[3].THIS=this;
      menu_tp[4].THIS=this;
      menu_tp[0].i=1;
      menu_tp[1].i=2;
      menu_tp[2].i=3;
      menu_tp[3].i=4;
      menu_tp[4].i=5;

      men_item Load_menu[] = {
	{ "Load fit", &xmPushButtonGadgetClass, 'L', 0,0,
	  fit_menu, (XtPointer) menu_tp,  (men_item*) 0 },
	{ "Save fit", &xmPushButtonGadgetClass, 'S', 0,0,
	  fit_menu, (XtPointer) (menu_tp+1), (men_item*) 0 },
	{ "Hardcopy", &xmPushButtonGadgetClass, 'H', 0,0,
          change_graphics, (XtPointer) (menu_tp+2), (men_item*) 0 },
	{0,}
      }; 
 
      men_item Fit_menu[] = {
	{ "Random", &xmToggleButtonGadgetClass, 'R', 0,0,
	  spfit_menu, (XtPointer) menu_tp,  (men_item*) 0 },
	{ "Simplex", &xmToggleButtonGadgetClass, 'S', 0,0,
	  spfit_menu, (XtPointer) (menu_tp+1), (men_item*) 0 },
	{ "ME Simplex", &xmToggleButtonGadgetClass, 'M', 0,0,
          spfit_menu, (XtPointer) (menu_tp+2), (men_item*) 0 },
	{ "Powell", &xmToggleButtonGadgetClass, 'P', 0,0,
          spfit_menu, (XtPointer) (menu_tp+3), (men_item*) 0 },
	{ "L-Marquardt", &xmToggleButtonGadgetClass, 'P', 0,0,
          spfit_menu, (XtPointer) (menu_tp+4), (men_item*) 0 },
	{0,}
      };
    
      Widget pane=
	XtVaCreateWidget("form",xmPanedWindowWidgetClass,mwind,
			 XmNsashWidth,1,
			 XmNsashHeight,1,
			 NULL);
     			
      Widget out[5];
      Widget menu_bar=XmCreateMenuBar(mwind,"menubar",NULL,0);
      BuildPulldownMenu(menu_bar,"File",'F',0,Load_menu,0);
      BuildPulldownMenu(menu_bar,"Fit Type",'T',1,Fit_menu,out);
      XtManageChild (menu_bar);
      XtVaSetValues(out[f_method-1],XmNset,1,NULL);
      old_fittype=out[f_method-1];

      Widget rowtwo=
	XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,pane,
			 XmNpacking,XmPACK_COLUMN,
			 XmNisAligned, True,
			 XmNnumColumns,1,
			 XmNentryVerticalAlignment,XmALIGNMENT_END,
			 XmNorientation, XmVERTICAL,
			 NULL);                           

      XmString fun_str;
      if (cnt_fnc->made())
	fun_str=XmStringCreateLocalized(strng);
      else
	fun_str=XmStringCreateLocalized("No Function");
     
      Widget rowtop=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
				     XmNpacking,XmPACK_TIGHT,
				     XmNisAligned, True,
				     XmNnumColumns,1,
				     XmNentryVerticalAlignment,XmALIGNMENT_END,
				     XmNorientation, XmHORIZONTAL,
				     NULL);
 
      str_fnc=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowtop,
				      XmNlabelString, fun_str,  
				      XmNmarginHeight,(Dimension) 1,    
				      NULL);

      XmStringFree(fun_str); 
      XtManageChild(rowtop);

      char l_str[8]="Fit  1:";
      Widget rowcol,label;
      XmString str;
      text=new Widget[n_par+4];
      Pbutton=new Widget[n_par];
      limit=new Widget[2*n_par];
      tp_fit=new temp_hold[n_par+4];
      p_count=n_par;
      int i;
      for (i=0;i<n_par;i++)   //Start of parameter table
	{
	  rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
				  XmNpacking,XmPACK_TIGHT,
				  XmNisAligned, True,
				  XmNnumColumns,5,
				  XmNentryVerticalAlignment,XmALIGNMENT_END,
				  XmNorientation, XmHORIZONTAL,
				  NULL); 
                                
	  str=XmStringCreateLocalized(l_str);
	  label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
					XmNlabelString, str,  
					XmNmarginHeight,(Dimension) 0,    
					NULL);
	  XmStringFree(str);                             
	  Pbutton[i]=
	    XtVaCreateManagedWidget("",xmToggleButtonWidgetClass,rowcol,
				    XmNset,True,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    XmNselectColor,"Red",
				    NULL);
	  text[i]=
	    XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
           
	  limit[i*2]=
	    XtVaCreateManagedWidget("limit",xmTextFieldWidgetClass,rowcol,
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);       

	  limit[2*i+1]=
	    XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);

   
	  XtManageChild(rowcol);
	  l_str[5]=(l_str[5]=='9' ? l_str[4]++,'0' : l_str[5]+1);
	  tp_fit[i].THIS= this;
	  tp_fit[i].i=i;
	  XtAddCallback(Pbutton[i],XmNvalueChangedCallback,
			flag_change,&tp_fit[i]);
	  XtAddCallback(text[i],XmNactivateCallback,num_entry,&tp_fit[i]);     
	  XtAddCallback(limit[2*i],XmNactivateCallback,num_entry,&tp_fit[i]);
	  XtAddCallback(limit[2*i+1],XmNactivateCallback,num_entry,&tp_fit[i]);
	}
      XtManageChild(rowtwo);   //End of parameter table
   
      set_text_field();
   
      rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,4,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
			      NULL); 
                                 
      str=XmStringCreateLocalized("Start Pt:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
				    XmNmarginHeight,(Dimension) 0,    
                                    NULL);
      XmStringFree(str); 
     
      text[i]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "1",
				XmNmaxLength,5,
				XmNcolumns,5,
				XmNmarginHeight,(Dimension) 0,
				NULL);     
      i++;
       
      str=XmStringCreateLocalized("End Pt:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
				    XmNmarginHeight,(Dimension) 0,    
				    NULL);
      XmStringFree(str); 
      text[i]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "1",
				XmNmaxLength,5,
				XmNcolumns,5,
				XmNvalue, "4000",
				XmNmarginHeight,(Dimension) 0,
				NULL);
      XtManageChild(rowcol);
      tp_fit[i-1].THIS= this;
      tp_fit[i-1].i=i-1;
      tp_fit[i].THIS= this;
      tp_fit[i].i=i;
      XtAddCallback(text[i-1],XmNactivateCallback,num_entry,&tp_fit[i-1]);  
      XtAddCallback(text[i],XmNactivateCallback,num_entry,&tp_fit[i]);  
     
      rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,4,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
                              NULL);
                                
      i++;
      str=XmStringCreateLocalized("Input Grp:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
				    XmNmarginHeight,(Dimension) 0,    
				    NULL);
      XmStringFree(str);   
      text[i]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "0",
				XmNmaxLength,3,
				XmNcolumns,3,
				XmNmarginHeight,(Dimension) 0,
				NULL);     
      i++;
     
      str=XmStringCreateLocalized("Output Grp:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
                                    XmNmarginHeight,(Dimension) 0,    
                                    NULL);
      XmStringFree(str); 
                                 
      text[i]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "1",
				XmNmaxLength,3,
				XmNcolumns,3,
				XmNvalue, "0",
				XmNmarginHeight,(Dimension) 0,
				NULL);
           
          
      XtManageChild(rowcol);
      tp_fit[i-1].THIS= this;
      tp_fit[i-1].i=i-1;
      tp_fit[i].THIS= this;
      tp_fit[i].i=i;
      XtAddCallback(text[i-1],XmNactivateCallback,num_entry,&tp_fit[i-1]);  
      XtAddCallback(text[i],XmNactivateCallback,num_entry,&tp_fit[i]);
      // end of grps
     
      check.THIS = this;
      check.W = dlog;                  
      act[2].data=(XtPointer) &check; 
      CreateActionArea(pane,act,4);

      XtManageChild(pane);


      XtManageChild(mwind);
      XmMainWindowSetAreas(mwind,menu_bar,NULL,NULL,NULL,
			   pane);
          
      set_pts();
      set_grp();   
      flg=1;   
      XtAddCallback(dlog,XmNdestroyCallback,cancel_dlog,
		    (XtPointer) this);
      XtPopup(dlog,XtGrabNone);
      if (xx && yy)
	XtVaSetValues(dlog,XmNx,xx,XmNy,yy,NULL);
    }
  else
    {
      set_str();
      set_pts();
      set_grp();   
    }
}     

void 
fit_param::num_all()
  /* read the string from the window and the update the variable
     afterwards write back teh corrected numbers 
     -- deals with the fit parameters and limits &&
        grp numbers.
  */
{
  char out[255];
  int k,i;
  if (!text) return;
  for(i=0;i<n_par;i++)
    {
      strcpy(out,XmTextFieldGetString(text[i]));
      v[i]=atof(out);
      sprintf(out,"%20g",v[i]);
      for(k=0;k<250 && out[k]==' ';k++);
      XmTextPosition j=strlen(out+k);
      XmTextSetString(text[i],out+k);
      XmTextFieldSetInsertionPosition(text[i],j);    

      strcpy(out,XmTextFieldGetString(limit[2*i]));
      double a=atof(out);
      strcpy(out,XmTextFieldGetString(limit[2*i+1]));
      double b=atof(out);
      if (b>a) k=1;
      vl[2*i+(1-k)]=a;
      vl[2*i+k]=b;
      if (vl[2*i]>v[i]) vl[2*i]=v[i];
      if (vl[2*i+1]<v[i]) vl[2*i+1]=v[i];

      sprintf(out,"%20g",vl[2*i]);
      for(k=0;k<250 && out[k]==' ';k++);
      XmTextSetString(limit[2*i],out+k);

      sprintf(out,"%20g",vl[2*i+1]);
      for(k=0;k<250 && out[k]==' ';k++);
    }
  int grps[4];
  for(;i<n_par+4;i++)
    {
      strcpy(out,XmTextFieldGetString(text[i]));
      grps[i-n_par]=atoi(out);       //ERROR make atof something else!
    }
  set_pts(grps[0],grps[1]);
  set_grp(grps[2],grps[3]);
  return;
}

void 
fit_param::Kwrite_values() const
  /* This is a helper function to allow the writing of data */
{
  extern wback hold_;
  int lpt;

  if (n_par<=0)
    {
      l_c("No limits to write",1);
      return;
    }
  char ss[255];
  int flag=cmdnumber(hold_.is,lpt,80);

  while(!flag || lpt>n_par || lpt<1)
    {
      flag=1;
      sprintf(ss,"Enter the constant number =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lpt,255)) return;
    }
  lpt--;
  sprintf(ss,"%3d %15g %15g %15g",lpt+1,v[lpt],vl[lpt*2],vl[2*lpt+1]);
  l_c(ss,3);
  return;
}

void
fit_param::Kset_limits()
  /* keyboard setting of the limits */
{
  extern wback hold_;
  int lpt;
  double v1,v2;

  if (n_par<=0)
    {
      l_c("No limits to update",1);
      return;
    }
  char ss[255];
  int flag=cmdnumber(hold_.is,lpt,80);
  if (flag)
    {
      flag+=cmdnumber(hold_.is,v1);
      if (flag==2)
	flag+=cmdnumber(hold_.is,v2);
    }
  while(!flag || lpt>n_par || lpt<1)
    {
      flag=1;
      sprintf(ss,"Enter the variable limit number =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lpt,255)) return;
    }
  while(flag<3 || v2==v1)
    {
      flag=3;
      sprintf(ss,"Enter the two limits =>");
      l_c(ss,0);
      if (!cmdnumber(ss,v1,255) || !cmdnumber(ss,v2,255)) return;
    }

  lpt--;
  vl[2*lpt]=(v1<v2) ? v1 : v2;
  vl[2*lpt+1]=(v1<v2) ? v2 : v1;
  if (v[lpt]>vl[2*lpt+1])
    vl[2*lpt+1]=v[lpt]+0.1*(vl[2*lpt+1]-vl[2*lpt]);
  if (v[lpt]<vl[2*lpt])
    vl[2*lpt]=v[lpt]-0.1*(vl[2*lpt+1]-vl[2*lpt]);
  set_text_field(); //update window if it exists.
  return;
}

void
fit_param::Kset_const()
  /* keyboard setting of the limits */
{
  extern wback hold_;
  int lpt;
  double v1,v2;

  if (n_par<=0)
    {
      l_c("No constants to update",1);
      return;
    }
  char ss[255];
  int flag=cmdnumber(hold_.is,lpt);
  if (flag)
    flag+=cmdnumber(hold_.is,v1);

  while(!flag || lpt>n_par || lpt<1)
    {
      flag=1;
      sprintf(ss,"Enter the variable/const number =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lpt,255)) return;
    }
  while(flag<2)
    {
      flag=2;
      sprintf(ss,"Enter the constant =>");
      l_c(ss,0);
      if (!cmdnumber(ss,v1,255)) return;
    }

  lpt--;
  v[lpt]=v1;
  if (v1>vl[2*lpt+1]) 
    vl[2*lpt+1]=v1+0.1*(vl[2*lpt+1]-vl[2*lpt]);
  if (v1<vl[2*lpt]) 
    vl[2*lpt]=v1-0.1*(vl[2*lpt+1]-vl[2*lpt]);
  set_text_field(); //update window if it exists.
  return;
}

void 
fit_param::num_entry
(Widget w,XtPointer client_data,XtPointer call_data) 
  /*
    Called by entering a number in the groups or pts box.
    Checks agains the number of parameters to see if it is 
    a double precision parameter or a group number
   */

{
  char out[255];
  
  fit_param* THIS= ((temp_hold*)client_data)->THIS;  
  int i= ((temp_hold*)client_data)->i;
  int t_npar=THIS->n_par; 
  int k=0;
  if (i<t_npar) 
    {
      strcpy(out,XmTextFieldGetString(THIS->text[i]));
      THIS->v[i]=atof(out);
      sprintf(out,"%10g",THIS->v[i]);
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->text[i],out+k);

      strcpy(out,XmTextFieldGetString(THIS->limit[2*i]));
      double a=atof(out);
      strcpy(out,XmTextFieldGetString(THIS->limit[2*i+1]));
      double b=atof(out);
      if (b>a) k=1;
      THIS->vl[2*i+(1-k)]=a;
      THIS->vl[2*i+k]=b;
      if (THIS->vl[2*i]>THIS->v[i]) THIS->vl[2*i]=THIS->v[i];
      if (THIS->vl[2*i+1]<THIS->v[i]) THIS->vl[2*i+1]=THIS->v[i];
      
      sprintf(out,"%10g",THIS->vl[2*i]);
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->limit[2*i],out+k);

      sprintf(out,"%10g",THIS->vl[2*i+1]);
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->limit[2*i+1],out+k);

    }
  else   // integer start point
    {
      int ka,kb;
      strcpy(out,XmTextFieldGetString(THIS->text[t_npar]));

      ka=atoi(out);
      strcpy(out,XmTextFieldGetString(THIS->text[t_npar+1]));
      kb=atoi(out);
      THIS->set_pts(atoi(out),ka);

      strcpy(out,XmTextFieldGetString(THIS->text[t_npar+2]));
      ka=atoi(out);
      strcpy(out,XmTextFieldGetString(THIS->text[t_npar+3]));
      kb=atoi(out);
      THIS->set_grp(ka,kb);
      THIS->check_consistency();
    }    
  XmTextPosition j=strlen(out+k);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}

void 
fit_param::spfit_menu(Widget w,XtPointer client_data,
			   XtPointer call_data)
  /* Handles the calls for the type of fitting rand, powell etc. */
 {
  fit_param* THIS= ((temp_hold*)client_data)->THIS;  
  int type = ((temp_hold*)client_data)->i;
  //  XmToggleButtonCallbackStruct *toggle_data = 
  //    (XmToggleButtonCallbackStruct *) call_data;
  if (THIS->old_fittype)
    XtVaSetValues (THIS->old_fittype,XmNset,0,NULL);
  XtVaSetValues (w,XmNset,1,NULL);
  THIS->f_method=type;
  THIS->old_fittype=w;
  return;
}
        

void 
fit_param::fit_menu(Widget w,XtPointer client_data,
			 XtPointer call_data)
  /* Handles the calls from the menu bar File->load/save */
{
  fit_param* THIS= ((temp_hold*)client_data)->THIS;  
  int type = ((temp_hold*)client_data)->i;
  switch (type) {
  case 1:
    THIS->load_fit();
    return;
  case 2:
    THIS->save_fit();
    return;
  default:
    l_c("This function has not been written yet!",1);
    return;
  }
  return;
}
        
void 
fit_param::update_flag()
{
  if (!dlog || !Pbutton) return;
  for(int i=0;i<n_par;i++)
    {
      XmToggleButtonSetState(Pbutton[i],flag[i],0);
    }
  return;
} 


void 
fit_param::flag_change(Widget w,XtPointer client_data,
			    XtPointer call_data)
{
  fit_param* THIS= ((temp_hold*)client_data)->THIS;  
  int i = ((temp_hold*)client_data)->i;
  THIS->flag[i]= 1-THIS->flag[i];
  return;
} 

        
Widget 
CreateActionArea(Widget parent,ActionAreaItem *actions,
			int num_actions)
{
  const int TIGHTNESS(20);

  Widget action_area, widget;
  int i;

  action_area = XtVaCreateWidget ("action_area", xmFormWidgetClass, parent,
				  XmNfractionBase, TIGHTNESS*num_actions - 1,
				  XmNleftOffset,   10,
				  XmNrightOffset,  10,
				  NULL);

  for (i = 0; i < num_actions; i++) {
    widget = XtVaCreateManagedWidget (actions[i].label,
				      xmPushButtonWidgetClass, action_area,
				      XmNleftAttachment,       i? XmATTACH_POSITION : XmATTACH_FORM,
				      XmNleftPosition,         TIGHTNESS*i,
				      XmNtopAttachment,        XmATTACH_FORM,
				      XmNbottomAttachment,     XmATTACH_FORM,
				      XmNrightAttachment,
				      i != num_actions - 1 ? XmATTACH_POSITION : XmATTACH_FORM,
				      XmNrightPosition,        TIGHTNESS * i + (TIGHTNESS - 1),
				      XmNshowAsDefault,        i == 0, 
				      XmNdefaultButtonShadowThickness, 1, 
				      XmNsensitive,actions[i].gray,
				      NULL);
    if (actions[i].callback)
      XtAddCallback (widget, XmNactivateCallback,
		     actions[i].callback, actions[i].data);
    if (i == 0) {
      /* Set the action_area's default button to the first widget
       * created (or, make the index a parameter to the function
       * or have it be part of the data structure). Also, set the
       * pane window constraint for max and min heights so this
       * particular pane in the PanedWindow is not resizable.
       */
      Dimension height, h;
      XtVaGetValues (action_area, XmNmarginHeight, &h, NULL);
      XtVaGetValues (widget, XmNheight, &height, NULL);
      height += 2 * h;
      XtVaSetValues (action_area,
		     XmNdefaultButton, widget,
		     XmNpaneMaximum,   height,
		     XmNpaneMinimum,   height,
		     NULL);
    }
  }

  XtManageChild (action_area);

  return action_area;
}


