#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "wave.h"
#include "fglobal.h"
#include "cmd.h"


void wave_strip(char *A)
  /* To strip out various high and low values within a group */
{
  extern wback hold_;
  extern Spec_In storage_;
  int grp;

  char ss[256];
  int flag=0;
  if (*A=='L' || *A=='H')
    {
      if (!cmdnumber(hold_.is,grp))
	grp=0;
      while (grp<1 || grp>tg) 
	{
	  flag=1;
	  sprintf(ss,"Which group to be converted =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,grp)) return;
	} 
      grp--;
      if (storage_.stpnt[grp]<2) 
	{
	  l_c("Group has too few points",1);
	  return;
	}
      double frac;
      if (flag || !cmdnumber(hold_.is,frac))
	frac= -1.0;

      while (frac<=0.0 || frac>=1.0) 
	{
	  flag=1;
	  if (*A=='H')
	    sprintf(ss,"Fractional value (above Max * frac set to zero) =>");
	  else
	    sprintf(ss,"Fractional value (below Max * frac set to zero) =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,frac)) return;
	}
      double max=0.0;
      for(int i=0;i<storage_.stpnt[grp];i++)
	if (max<fabs(storage_.story[grp][i]))
	  max=fabs(storage_.story[grp][i]);
      sprintf(ss,"Max value : %g ",max);
      l_c(ss,1);
      if (max==0.0) return;
      int count=0;
      if (*A=='H') 
	{
	  max*=frac;
	  for(int i=0;i<storage_.stpnt[grp];i++)
	    if (max<fabs(storage_.story[grp][i]))
	      {
		storage_.story[grp][i]=0.0;
		count++;
	      }
	}
      else
	{
	  max*=frac;	  
	  for(int i=0;i<storage_.stpnt[grp];i++)
	    if (max>fabs(storage_.story[grp][i]))
	      {
		storage_.story[grp][i]=0.0;
		count++;
	      }
	}
      sprintf(ss,"Total zeroed = %d",count);
      l_c(ss,1);
      return;
    }
  return;
}

void wave_smoo(char *A)
  /* To make a wavelet transform. */
{
  extern  wback hold_;
  extern Spec_In storage_;
  static int default_smooth=4;
  int grp,grp2,grp3;
  waveflt twv;  //place to do the work.

  char ss[256];
  int flag=0;
  if (*A=='S')
    {
      if (!cmdnumber(hold_.is,grp))
	grp=0;
      while (grp!=4 && grp!=12 && grp!=20) 
	{
	  sprintf(ss,"Which default size (4,12,20) =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,grp)) return;
	} 
      default_smooth=grp;
      return;
    }
  if (*A=='F' || *A=='R')
    {
      if (!cmdnumber(hold_.is,grp))
	grp=0;
      while (grp<1 || grp>tg) 
	{
	  flag=1;
	  sprintf(ss,"Which group to be converted =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,grp)) return;
	} 
      grp--;
      if (storage_.stpnt[grp]<2) 
	{
	  l_c("Group has too few points",1);
	  return;
	}
      if (flag || !cmdnumber(hold_.is,grp2))
	grp2=0;

      while (grp2<1 || grp2>tg) 
	{
	  flag=1;
	  sprintf(ss,"Which grp to place output =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,grp2)) return;
	}
      grp2--;

      int long_length=4;
      for(;long_length<storage_.stpnt[grp];long_length<<=1);
      double *expd_work=new double[long_length];
      int ldiff=long_length-storage_.stpnt[grp];
      for(int i=0;i<ldiff;i++)
	expd_work[i]=storage_.story[grp][0];
      for(int i=0;i<storage_.stpnt[grp];i++)
	expd_work[i+ldiff]=storage_.story[grp][i];

      if (flag || !cmdnumber(hold_.is,grp3))
	flag=1;
      while (!flag && grp3!=4 && grp3!=12 && grp3!=20) 
	{
	  sprintf(ss,"Which default size (4,12,20) =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,grp3)) return;
	} 
	if (!flag && (grp3==4 || grp3==12 || grp3==20))
	  default_smooth=grp3;


      twv.pwtset(default_smooth);
      if (*A=='R')
	{
	  for(int nn=4;nn<=long_length;nn<<=1)
	    twv.pwt(expd_work,nn,-1);
	}
      else
	{
	  for(int nn=long_length;nn>=4;nn>>=1)
	    twv.pwt(expd_work,nn,1);
	}
      if (long_length>maxpts) 
	long_length=maxpts;
     
      int pnt=storage_.stpnt[grp];
      for(int i=0;i<pnt;i++)
	{
	  storage_.storx[grp2][i]=storage_.storx[grp][i];
	  storage_.story[grp2][i]=expd_work[i];
	  storage_.store[grp2][i]=storage_.store[grp][i];
	}

      double step=(storage_.storx[grp][pnt-1]
                       -storage_.storx[grp][0])/(pnt-1);

      for(int i=pnt;i<long_length;i++)
	{
	  storage_.storx[grp2][i]=storage_.storx[grp][pnt-1]+(i-pnt) * step;
	  storage_.story[grp2][i]=expd_work[i];
	  storage_.store[grp2][i]=0.0;
	}
      storage_.stpnt[grp2]=long_length;
      delete [] expd_work;
      return;
    }
  return;
}

waveflt::waveflt() 

{
  c4[0]= 0.4829629131445341;
  c4[1]= 0.8365163037378079;
  c4[2]= 0.2241438680420134;
  c4[3]= -0.1294095225512604;

  c12[0]= 0.1115400743350;
  c12[1]= 0.494623890398;
  c12[2]= 0.751133908021;
  c12[3]= 0.315250351709;
  c12[4]= -0.226264693965;
  c12[5]= -0.129766868567;
  c12[6]= 0.097501605587;
  c12[7]= 0.027522865530;
  c12[8]= -0.031582039318;
  c12[9]= 0.000553842201;
  c12[10]= 0.004777257511;
  c12[11]= -0.001077301085;

  c20[0]= 0.026670057901; 
  c20[1]= 0.188176800078; 
  c20[2]= 0.527201188932; 
  c20[3]= 0.688459039454; 
  c20[4]= 0.281172343661; 
  c20[5]= -0.249846424327; 
  c20[6]= -0.195946274377; 
  c20[7]= 0.127369340336;   
  c20[8]= 0.093057364604; 
  c20[9]= -0.071394147166; 
  c20[10]= -0.029457536822; 
  c20[11]= 0.033212674059;
  c20[12]= 0.003606553567;
  c20[13]= -0.010733175483;
  c20[14]= 0.001395351747;
  c20[15]= 0.001992405295; 
  c20[16]= -0.000685856695; 
  c20[17]= -0.000116466855; 
  c20[18]= 0.000093588670; 
  c20[19]= -0.000013264203; 
}

waveflt::~waveflt() 
{}

void 
waveflt::pwtset(const int n)
{

  ncof=n;
  if (n==12)
    {
      cc= c12;
      cr=c12r;
    }
  else if (n==20)
    {
      cc=c20;
      cr=c20r;
    }
  else 
    {
      ncof=4;
      cc=c4;
      cr=c4r;
    }

  double sig = -1.0;
  
  for(int k=0;k<ncof;k++)
    {
      cr[ncof-(k+1)]= sig*cc[k];
      sig = -sig;
    }
  ioff=joff = -(ncof >> 1);
  return;
}

void waveflt::pwt(double *a,const int len,const int dirc)
{
  if (len<4) return;
  double *wksp = new double[len];
  int nmod= ncof * len;
  int n1=len-1;
  int nhigh= len >> 1;
  for(int j=0;j<len;j++)
    wksp[j]=0.0;
  int  ni,nj,jf,jr;
  if (dirc >=0)
    {
      for(int ii=0,i=1;i<=len;i+=2,ii++)
	{
	  ni=i+nmod+ioff; 
	  nj=i+nmod+joff; 
	  for(int k=1;k<=ncof;k++)
	    {
	      jf=n1 & (ni+k);
	      jr=n1 & (nj+k);
	      wksp[ii] += cc[k-1] * a[jf];
	      wksp[ii+nhigh] += cr[k-1] * a[jr];
	    }
	}
    }
  else
    {
      double ai,ai1;
      for(int ii=0,i=1;i<=len;i+=2,ii++)
	{
	  ai=a[ii];
	  ai1=a[ii+nhigh];
	  ni=i+nmod+ioff; 
	  nj=i+nmod+joff; 
	  for(int k=1;k<=ncof;k++)
	    {
	      jf=n1 & (ni+k);
	      jr=n1 & (nj+k);
	      wksp[jf] += cc[k-1]* ai;
	      wksp[jr] += cr[k-1]* ai1;
	    }
	}
    }

  for(int j=0;j<len;j++)
    a[j]=wksp[j];
  delete [] wksp;
  return;
}
      





