#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include "fglobal.h"
#include "cmd.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"
#include "spacebox.h"
#include "space.h"
#include "new_read.h"
#include "box_plot.h"
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "XmPgplotP.hxx"



extern "C" void pgcell_(float*,int*,int*,int*,int *,int *,int *,
                        float *,float*,float*,
                        int *,float*,float*,float*);

extern "C" void grey_(float *,int*,int *,float*,float*,float*,float*,
		      float*,float*,int*);

extern Frame plook;

void 
draw2d_(int* A,int *B)
{
  draw2d(A,B);
}

void
draw2d(int *A,int *B)
{
  extern  bin_file sd;
  sd.draw_picture( (*A)-1,*B);
}

void
draw3d(int *A,int *B)
{
  extern  bin_file sd;
  sd.draw_three((*A)-1,*B);
  return;
}


void
drawrmc(const int A,const int B)
{
  extern Box_Screen bsa;
  bsa.draw_region(A,B);
}


void
bin_file::square()
{
   float cx,cy,lenx,leny;
   cx = (xyr[1]+xyr[0]) / 2.0;
   cy = (xyr[3]+xyr[2]) / 2.0;
   lenx = xyr[1]-xyr[0];
   leny = xyr[3]-xyr[2];
   if (lenx==leny) return;
   lenx = (lenx>leny) ? lenx/2.0 : leny/2.0;
   xyr[0]=cx-lenx; 
   xyr[1]=cx+lenx;
   xyr[2]=cy-lenx;   
   xyr[3]=cy+lenx;
   if (xyr[0]< 0) xyr[0]= 0.0;
   if (xyr[1]> n_hp-1) xyr[1]= n_hp-1;
   if (xyr[2]< 0) xyr[2]= 0.0;
   if (xyr[3]> n_vp-1) xyr[3]= n_vp-1;
   l_c("Squared axis",1);
   return;
}


void
bin_file::get_pt(Widget w,XtPointer client_data,XtPointer call_data)
{
  extern Motif_Pts motpt_;
  extern Plts plot_info;
  XmpCursorCallbackStruct *cursor = (XmpCursorCallbackStruct *) call_data;
  bin_file *im = (bin_file *) client_data;
  float &x = im->x = cursor->x;
  float &y = im->y = cursor->y;
  im->button = cursor->key;
  float xmin=im->xyr[0];
  float xmax=im->xyr[1];
  float ymin=im->xyr[2]; 
  float ymax=im->xyr[3];     //fractions to deal with pgimag additions 
  if (im->bt>0) 
    {
      im->bt--;      //time to exit the event loop.
      return;
    }
  float tempx,tempy;
  char ans;
  switch(motpt_.mode)
    {
    case 1:  
      ans=cursor->key;
      if (ans=='A' || ans=='X')
	im->display_pt(ans,im->x,im->y);
      else
	{
	  cpgslct(xmp_device_id(im->scn));
	  im->col_control(ans,im->x,im->y);
	  if (plot_info.screen) 
	    cpgslct(plot_info.screen);
	  else if (im->scn)
	    cpgslct(xmp_device_id(im->scn));
	}	  
      return;
    case 2:            //start of CA command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  motpt_.mode=1;
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);
	  return;
        }
      im->x1=x;
      im->y1=y;
      xmp_arm_cursor(im->scn,XMP_RECT_CURSOR,x,y,
                im->get_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 3: //start of CX command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);
	  motpt_.mode=1;
	  return;
        }
      im->x1=x;
      im->y1=y;
        xmp_arm_cursor(im->scn,XMP_XRNG_CURSOR,x,y,
                        im->get_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 4: //start of CY command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);
        motpt_.mode=1;
        return;
        }
      im->x1=x;
      im->y1=y;
      xmp_arm_cursor(im->scn,XMP_YRNG_CURSOR,x,y,
                  get_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 5:  //start of CC command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);
	  motpt_.mode=1;
	  return;
        }
      motpt_.mode*=10;
      ans=cursor->key;
      if (ans!='D' || ans!='d')
	{
	  im->cen_x=x;
	  im->cen_y=y;
	}
      else
	{
	  x=im->cen_x;
	  y=im->cen_y;
	}
      xmp_arm_cursor(im->scn,XMP_CIRCLE_CURSOR,x,y,
		     get_pt,(void *) im);

      return;
    case 6:   //first part of CV command 
      {
	if (x>xmax || x<xmin || y>ymax || y<ymin)
	  {
	    motpt_.mode=1;
	    xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			   get_pt,(void *) im);
	    return;
	  }
	motpt_.mode*=10;
	// Get Cursor from Pgx
	XmPgplotWidget ww = (XmPgplotWidget) im->scn;
	XmPgplotPart *xmp = &ww->pgplot;
	PgxWin *pgx = xmp->pgx;
	PgxState *state = pgx->state; 
	XWcursor *curs = &state->cursor;
	curs->radi=curs->ptx;
	curs->radi2=curs->pty;
	xmp_arm_cursor(im->scn,XMP_D_ARC_LINE,x,y,
		       get_pt,(void *) im);
	return;
      }
    case 20:   //end of CA command
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     get_pt,(void *) im);
      motpt_.mode=2;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      if (ans!='D')
	im->setrange(im->x1,im->y1,x,y,ans);
      else
	im->intsq(im->x1,im->y1,x,y);
      return;
    case 30:   //end of CX cmd
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     get_pt,(void *) im);
      motpt_.mode=3;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      if (ans=='D')
	im->intblock(0,im->x1,x);
      else
	im->setrangex(im->x1,x,ans);
      return;
    case 40:
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     get_pt,(void *) im);
      motpt_.mode=4;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      im->setrangey(im->y1,y,ans);
      return;

    case 50:
      if (x>xmax || x<xmin || y>ymax || y<ymin) 
	{
        motpt_.mode=1;
	xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
		       get_pt,(void *) im);
         return;
	}
      ans=cursor->key;
      tempx = x - im->cen_x;
      tempy = y - im->cen_y;
      im->rad1 = sqrt(tempx * tempx + tempy * tempy);

      if (ans!='D')
	{
	  motpt_.mode=51;
	  xmp_arm_cursor(im->scn,XMP_DOUBLE_CIRCLE,x,y,
			 get_pt,(void *) im);
	  return;  
	}
      else
        xmp_arm_cursor(im->scn,XMP_MOVE_CIRCLE,x,y,
		       get_pt,(void *) im);
      motpt_.mode=52;
      return;         //going to put in circle centre movement. 

    case 52:
      if (x>xmax || x<xmin || y>ymax || y<ymin) 
	{
        motpt_.mode=5;
	xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
		       get_pt,(void *) im);
         return;
	}
      im->cen_x = x;
      im->cen_y = y;         
      motpt_.mode=50;         //Now go back and change size
      xmp_arm_cursor(im->scn,XMP_CIRCLE_CURSOR,x,y,
		     get_pt,(void *) im);  
      return;
      
    case 51:     
      if (x>xmax || x<xmin || y>ymax || y<ymin) 
	{
	  motpt_.mode=5;
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);
         return;
	}
      motpt_.mode=1;
      tempx = x - im->cen_x;
      tempy = y - im->cen_y;
      im->rad2 = sqrt(tempx * tempx + tempy * tempy);
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
		     get_pt,(void *) im);
      ans=cursor->key;
      im->intregion();
      motpt_.mode=1; 
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
		     get_pt,(void *) im);

      return;
        
    case 60:   //closure of CV
      if (x>xmax || x<xmin || y>ymax || y<ymin) 
	{
	  motpt_.mode=1;	
	  xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			 get_pt,(void *) im);  
	  return;
	}
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
		     get_pt,(void *) im);  
      motpt_.mode=1;
      ans=cursor->key;
      im->intarc(ans);
      return;
   
    default:    //the will be others!
      motpt_.mode=1; 

      return; 
    }
}
 

void 
bin_file::dearm_v_cursor()
{
  XmPgplotWidget w = (XmPgplotWidget) scn;
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;
  XWcursor *curs = &state->cursor;
  double ha2;

  int xpc=curs->centx;
  int ypc=curs->centy;
  int x1=curs->radi;
  int y1=curs->radi2;
  x1-=xpc;
  y1-=ypc;
  ang_1=atan2((double) y1,(double) x1);
  x1=curs->ptx; 
  y1=curs->pty; 
  x1-=xpc;
  y1-=ypc;
  ang_2=atan2((double) y1,(double) x1);
  if (ang_1>ang_2)
    {
      ha2=ang_2;
      ang_2=ang_1;
      ang_1=ha2;
    }
  return;  
}

void
bin_file::arm_v_cursor(const int typ)
{
  if (cen_x>xyr[1] || cen_x<xyr[0] || 
      cen_y>xyr[3] || cen_y<xyr[2]) return;

  extern Motif_Pts motpt_;  
// Get Cursor from Pgx
  XmPgplotWidget w = (XmPgplotWidget) scn;
  if (!scn) return;
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  float convx[3]={cen_x,0,n_hp-1};
  float convy[3]={cen_y,0,n_vp-1};
  int xp[3],yp[3];
  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;

  for(int i=0;i<3;i++)
    {
      convx[i]*=world.xdiv;  
      convy[i]*=world.ydiv;
      convx[i]+=world.xoff;
      convy[i]+=world.yoff;
      xp[i]=state->geom.xmin + (int) (convx[i]+0.5);
      yp[i]=state->geom.ymax - (int) (convy[i]+0.5);     
    }
  XWcursor *curs = &state->cursor;
  
  curs->centx = xp[0];
  curs->centy = yp[0];
  curs->minx = xp[1];
  curs->miny = yp[1];
  curs->maxx = xp[2];
  curs->maxy = yp[2];
  if (!typ)
    {
      motpt_.mode=6;
      xmp_arm_cursor(scn,XMP_ARC_LINE,x,y,
		     get_pt,(void *) this);
    }
  else
    {
      x=cen_x;
      y=cen_y;
      motpt_.mode=50;
      xmp_arm_cursor(scn,XMP_CIRCLE_CURSOR,x,y,
		     get_pt,(void *) this);
    }
  return;  

}

double 
XrayMaps::itop(const double xx,const double yy) const
  /* To get the value of the point at xx, yy */ 
{
  int lx,hx;
  int ly,hy;   
  hx=(int) xx;  
  hy=(int) yy;
  lx=hx-1;
  ly=hy-1;
  if (lx<0 || ly<0 || hx>=n_hp-1 || hy>= n_vp-1) return 0.0;
  
  // Now using basic interpolation

  double t = (xx-hx);
  double u = (yy-hy);

  double out= 
    (1.0-t) * (1.0-u) * values[ly][lx]+
    t * (1.0-u) * values[ly][hx]+
    t * u * values[hy][hx] +
    (1.0-t) * u * values[hy][lx];
  return out; 
}

void
bin_file::col_control(const char s,const float x,const float y)
{
  colrep=3;
  switch (s)
    {
    case '0':
      c_type=10;
      break;
    case '1':
      c_type=0;
      break;
    case '2':
      c_type=1;
      break;
    case '3':
      c_type=2;
      break;
    case '4':
      c_type=3;
      break;
    case '5':
      c_type=4;
      break;
    case 'C':
      bright=0.5;
      contrast=1.0;
      sign = 1;
    case '-':
      sign*= -1;
    default:
      contrast= 10.0 * (x - xyr[0]) /(xyr[1]-xyr[0]);
      bright=  (y - xyr[2]) /(xyr[3]-xyr[2]);
      break;
    }
  palett(c_type,sign,contrast,bright);    
  return;
} 

void
bin_file::intensity()
{
  extern wback hold_;
  char t;
  get_first_nonumb(t,hold_.is,80);

  double hval=0.1* (us_max-us_min);
  if (t=='S') 
    {
      hval*= -1.0;
      t='T';
    }
  if (t=='T') 
    {
      us_max+= hval;
      us_min-= hval;
      set_col=1;
      draw_picture();
      return;
    }
  if (t=='A')
    {
      if (!set_col)
	{
	  l_c("Toggled off autoscale colour map",1);
	  set_col=1;
	}
      else
	{
	  l_c("Toggled on autoscale colour map",1);
	  set_col=0;
	}
      draw_picture();
      return;
    }
  char ss[256];
  int cnum;
  float vals[2];
  for(cnum=0;cnum<2 && 
	      cmdnumber(hold_.is,vals[cnum]);cnum++);
   

  if (cnum==1)
    {
      int grp=(int) vals[0]; 
      while(grp<1 || grp>max_Maps)
	{
	  sprintf(ss,"Enter group to get intensity from =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,grp)) return;
	}
      if (!DD[grp-1].setmaxmin(us_min,us_max,Zero_out))
	{
	  sprintf(ss,"New intensity : %f %f",us_min,us_max);
	  l_c(ss,1);
	  set_col=1;
	}
      draw_picture();
      return;
    }
      
      
  if (cnum!=2 || vals[0]==vals[1])
    {
      strcpy(ss,"Enter intensity range");
      l_c(ss,0);
      if (!cmdnumber(ss,vals[0]) || 
	  !cmdnumber(ss,vals[1]) ||
	  vals[0]==vals[1])
	return;
    }
  set_col=1;
  if (vals[0]>vals[1])
    {
      us_max=vals[0];
      us_min=vals[1];
    }
  else
    {
      us_max=vals[1];
      us_min=vals[0];
    }
  draw_picture();
  return;
}


void 
bin_file::twoaxis(const char type)
{
  extern wback hold_;
  int status=0;
  char ss[256];
  float n_xmin,n_xmax,n_ymin,n_ymax;
  int ptvp,pthp;
  int grp;
  float **V;

  status = cmdnumber(hold_.is,n_xmax);
  if (status) status+=cmdnumber(hold_.is,n_xmin);
  grp= (int) n_xmax -1;
  if (status==1 && grp<max_Maps 
      && grp>=0 && DD[grp].pts()) 
    {                    // grp interigation 
      DD[grp].handle(pthp,ptvp,V);
      if(type!='Y')
	{
	  xyr[0]=0;
	  xyr[1]=pthp;
	}
      if (type!='X')
	{
	  xyr[2]=0;
	  xyr[3]=ptvp;
	}
      sprintf(ss,"New Axis: %f,%f :: %f,%f \n",
	      xyr[0],xyr[1],xyr[2],xyr[3]);
      l_c(ss,1);
      return;
    }

  if (type=='Y' && status==2)   //ie y point (didn't want x axis)
    {
      setmaxaxis(1,n_xmin,n_xmax);
    }
  else if (status==2)           //ie x points and everything else 
    {
      setmaxaxis(0,n_xmin,n_xmax);
    }
  
  if (type!='X' && type!='Y' && status==2)
    {
      if (!cmdnumber(hold_.is,n_ymin) || 
	  !cmdnumber(hold_.is,n_ymax))
	status=1;
      else 
	setmaxaxis(1,n_ymin,n_ymax);
    } 


  if(status==2)
    {
      sprintf(ss,"New Axis: %f,%f :: %f,%f \n",
	      xyr[0],xyr[1],xyr[2],xyr[3]);
      l_c(ss,1);
      return;
    }

  sprintf(ss,"Old Axis: %f,%f :: %f,%f \n",
	  xyr[0],xyr[1],xyr[2],xyr[3]);
  l_c(ss,1);

  if (type=='X')
    {
      sprintf(ss,"Input X coordinates");
      l_c(ss,0);
      if (cmdnumber(ss,n_xmin) && cmdnumber(ss,n_xmax))
	{
	  setmaxaxis(0,n_xmin,n_xmax);
	}
      return;
    }
  else if (type=='Y')
    {
      sprintf(ss,"Input Y coordinates");
      l_c(ss,0);
      if (cmdnumber(ss,n_xmin) && cmdnumber(ss,n_xmax))
	{
	  setmaxaxis(1,n_xmin,n_xmax);
	}
      return;
    }
  else
    {
      sprintf(ss,"Input coordinates");
      l_c(ss,0);
      if (cmdnumber(ss,n_xmin) && cmdnumber(ss,n_xmax)
	  && cmdnumber(ss,n_ymin) && cmdnumber(ss,n_ymax))
	{
	  setmaxaxis(0,n_xmin,n_xmax);
	  setmaxaxis(1,n_ymin,n_ymax);
	}
      return;
    }
  return;  
}

void
bin_file::setmaxaxis(const int type,const float A,const float B) 
{
  if (A>B)
    {
      xyr[2*type]=B;
      xyr[2*type+1]=A;
    }
  else
    {
      xyr[2*type]=A;
      xyr[2*type+1]=B;
    }
  return;
}      




void 
bin_file::palett(const int type,int sign,float contra,float bright) const
{
  static float gl[2]={0.0, 1.0};
  static float gr[]={0.0, 1.0};
  static float gg[]={0.0, 1.0};
  static float gb[]={0.0, 1.0};

  static float hl[]={0.0, 0.2, 0.4, 0.6, 1.0};
  static float hr[]={0.0, 0.5, 1.0, 1.0, 1.0};
  static float hg[]={0.0, 0.0, 0.5, 1.0, 1.0};
  static float hb[]={0.0, 0.0, 0.0, 0.3, 1.0};

  static float rl[]={-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7};
  static float rr[]={ 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0};
  static float rg[]={ 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0};
  static float rb[]={ 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0};


  static float wl[]={0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0};
  static float wr[]={0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0};
  static float wg[]={0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0};
  static float wb[]={0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0};

  static float al[]={0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5,
		     0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0};
  static float ar[]={0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0,
		     0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
  static float ag[]={0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8,
		     0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0};
  static float ab[]={0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9,
		     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  contra*=sign;
  switch(type) 
    {
    case 10:       //original 
      return;
    case 0:        //gray scale
      cpgctab(gl, gr, gg, gb, 2, contra, bright);
      return;
    case 1:        // rainbow
      cpgctab(rl, rr, rg, rb, 9, contra, bright);
      return;
    case 2:        // heat
      cpgctab(hl, hr, hg, hb, 5, contra, bright);
      return;
    case 3:      // weird iraf
      cpgctab(wl, wr, wg, wb, 10, contra, bright);
      return;
    default:     // aips
      cpgctab(al, ar, ag, ab, 20, contra, bright);
      return;
    }
   return;
}


void
bin_file::keep()
{
  extern Plts plot_info;
  int plot_fig=0;
  static int count=1;
  char s[256];
  sprintf(s,"plot_%d.gif/GIF",count);
  count++;
  plot_fig=cpgopen(s);
  if (!plot_fig)
    {
      l_c("Error opening plot file",1);
      if (plot_info.screen) 
	cpgslct(plot_info.screen);
      else if (scn)
	cpgslct(xmp_device_id(scn));
      return;   
    }
  float r,b,g;
  for(int i=0;i<N_cols;i++)
    {
      r = 0.8 * ((1.0 * i) / (N_cols-1)) +0.2;
      g = 2.0 * (i - N_cols/2) / (1.0 * (N_cols-1));
      if (g<0.0) g=0.0;
      b = 0.2 + (0.4 * (N_cols - (i+1))) / (1.0 * N_cols);
      cpgscr(i+15,r,g,b);
    }
  cpgscir(16,16+N_cols);
  draw_picture(-1,10,1);
  l_c("Starting file drawing...",1);
  cpgslct(plot_fig);
  cpgclos();
  l_c("Successfully Closed",1);
  int temp=plot_info.screen;
  if (temp) 
      cpgslct(temp);
  else if (scn)
    cpgslct(xmp_device_id(scn));
  return;
}

void
bin_file::rearm_curs()
{
  xmp_arm_cursor(scn,XMP_NORM_CURSOR,0.0f,0.0f,
		 get_pt,(void *) this);
  return;
}

int
bin_file::draw_picture(const int n_current,const int coltype,const int keep)
  /* job is to draw the picture in the window :
     keep==1 then plot into a file 
     */
{
  if (n_current>=0 && n_current<max_Maps)
    current_Map = n_current;
  if (coltype>0 && coltype<5)
    colrep=coltype-1;

  static float amin;
  static float amax;

  extern Plts plot_info;
  if (!plot_info.twod)
    {
      plot_info.twod=make_screen(3);
      init_cont_cursor();
      xmp_arm_cursor(scn, XMP_NORM_CURSOR,0.0f,0.0f,
                     get_pt,(void *) this);     //Note we have to re-arm
	                                       //cursor  
      cpgqcol(&cmin,&cmax);
      cpgwnad(xyr[0],xyr[1],xyr[2],xyr[3]);
    }

  if (!keep)
    { 
      cpgslct(xmp_device_id(scn));
      Dimension width,height;

      XtVaGetValues(XtParent(XtParent(scn)),
		    XmNwidth, &width,
		    XmNheight, &height,
		    NULL);


      if (height>width) 
         width=height;
      else
	height=width;


      XtVaSetValues(XtParent(XtParent(scn)),
		    XmNwidth, width,
		    XmNheight, height,
		    NULL);

    }
  if (!keep)
    cpgsvp(0.1,0.8,0.1,0.80);   
  else
    cpgsvp(0.2,0.73025,0.1,0.85);   //This need to be set to aspect ratio for
                                 // for A4 paper.
  cpgask(0);
  cpgpage();
  float r,g,b;
  DD[current_Map].handle(n_hp,n_vp,values);
  if(n_hp && n_vp)
    {
      for(int i=0;i<N_cols;i++)
	{
	  r = 0.8 * ((1.0 * i) / (N_cols-1)) +0.2;
	  g = 2.0 * (i - N_cols/2) / (1.0 * (N_cols-1));
	  if (g<0.0) g=0.0;
	  b = 0.2 + (0.4 * (N_cols - (i+1))) / (1.0 * N_cols);
	  cpgscr(i+16,r,g,b);
	}
      cpgscir(16,16+N_cols);
      if(!set_col) 
	getmax(us_min,us_max);
      if (colrep>=2 && colrep<=3)
	palett(c_type,sign,contrast,bright);    

      int stp[4];

      for(int i=0;i<2;i++)
        {
          if (xyr[i]>n_hp-1) xyr[i]=n_hp-1;
          if (xyr[i]<0) xyr[i]=0;
	  stp[i] = (int) xyr[i]+1;
	  if (stp[i]<1) stp[i]=1;
	  if (stp[i]>n_hp) stp[i]=n_hp;
        }
      for(int i=2;i<4;i++)
        {
          if (xyr[i]>n_vp-1) xyr[i]=n_vp-1;
          if (xyr[i]<0) xyr[i]=0;
	  stp[i] = (int) xyr[i]+1;
	  if (stp[i]<1) stp[i]=1;
	  if (stp[i]>n_vp) stp[i]=n_vp;
        }
      float tr[6]={0,0,0,0,0,0};
      //  tr[2]= (2.0 * (n_pts-1))/n_pts;
      //  tr[4]= (2.0 * (n_pts-1))/n_pts;
      tr[1]=1.0;
      tr[5]=1.0;
      amin=us_min;
      amax=us_max;
      cpgswin(xyr[0],xyr[1],xyr[2],xyr[3]);
      //      cpgimag(values[0],n_hp,n_vp,stp[0],stp[1],stp[2],stp[3],
      //      amin,amax,tr);
      int nh=n_hp;
      int nv=n_vp;
      int ncols=N_cols;
      /*      pgcell_(values[0],&nh,&nv,&stp[0],&stp[1],&stp[2],&stp[3],
	      &amin,&amax,tr,
	      &ncols,rr,gg,bb); */
      int xp((int) (xyr[1]-xyr[0]));
      int yp((int) (xyr[3]-xyr[2]));
      int iplot=3;
      
      
      grey_(values[0],&nh,&nv,xyr,xyr+1,xyr+2,xyr+3,&amin,&amax,&iplot);
      cpgscf(2);
      
      plook.axis_make_box(xyr[0],xyr[1],xyr[2],xyr[3]);
      cpgsch(0.5);
      cpgwedg("RI",4.0f,11.0f,amin,amax,"Pixel Value");
      cpgsch(1.0);
      cpgscf(1); 
    }
  space_correct::draw(current_Map);
  int temp=plot_info.screen;
  if (temp) cpgslct(temp);
  return 1;

}

int
bin_file::draw_three(const int n_current,const int coltype,const int keep)
  /* job is to draw the picture in the window :
     keep==1 then plot into a file 
     */
{
  if (n_current>=0 && n_current<max_Maps)
    current_Map = n_current;
  if (coltype>0 && coltype<5)
    colrep=coltype-1;

  static float amin;
  static float amax;

  extern Plts plot_info;
  DD[current_Map].handle(n_hp,n_vp,values);
  float* Xpp=new float[n_hp];
  float* Ypp=new float[n_vp];
  for(int i=0;i<n_hp;i++)
    Xpp[i]=i;
  for(int i=0;i<n_vp;i++)
    Ypp[i]=i;
  int xp(n_hp),yp(n_vp);
  double xsize,ysize;
  plook.getsize(xsize,ysize);
  float size=(float) xsize;
  xtalplot_(Xpp,&n_hp,Ypp,&n_vp,values[0],&xp,&yp,&size);
  delete [] Ypp;
  delete [] Xpp;
  int temp=plot_info.screen;
  if (temp) cpgslct(temp);
  
  return 1;

}




