#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "fit_param.h"
#include "poly2.h"
#include "splx_fit.h"
#include "fglobal.h"
#include "cmd.h"


void fit::set_total(const int A)
{
  ntrue_param=A;
  return;
}

void fit::do_mrq(intep& find,const int nF,const int nT)
{
  new_calc = &find;
  newdat(new_calc->cnt.i_grp()-1);
  init_mrqmin(nF,nT);
  for(int i=0;i<20;i++)
    mrqmin();
  alamda=0.0;
  mrqmin();
  cleanup_mrqmin(0);
  for(int i=0;i<nT;i++)
    new_calc->cnt.v[i]=A[i];
  cleanup_mrqmin(1);
  new_calc->chi();
  return;
}

void fit::setparam(const double *A)      
{
  for (int i=0;i<ntrue_param;i++)
    new_calc->cnt.v[i]=A[i];
  return;
}

void fit::init_mrqmin(const int np,const int ntp)
{
  if (np<1) return;
  ntrue_param=ntp;
  ndim=np;

  if (covar)
    cleanup_mrqmin(1);
  
  covar=matrix(ntrue_param,ntrue_param);
  alpha=matrix(ntrue_param,ntrue_param);
  oneda=matrix(ntrue_param,1);

  atry=new double[ntrue_param];
  beta=new double[ntrue_param];
  da=new double[ntrue_param];
  used=new int[ntrue_param];
  A=new double[ntrue_param];

  if (plo)
    {
      delete [] plo;
      delete [] phi;
      delete [] ptry;
      delete [] psum;
      delete [] pb;
      plo=phi=ptry=psum=0;
    }

  plo=new double[ndim];
  phi=new double[ndim];
  ptry=new double[ndim];
  pb=new double[ndim];
  
  int j=0;
  st=new_calc->cnt.s_pt();
  ed=new_calc->cnt.e_pt();
  for(int i=0;i<ntrue_param;i++)
    {
      A[i]=atry[i]=new_calc->cnt.v[i];
      if (new_calc->cnt.flag[i])
	{
	  pb[j]=new_calc->cnt.v[i];
	  plo[j]=new_calc->cnt.vl[2*i];
	  phi[j]=new_calc->cnt.vl[2*i+1];
	  j++;
	  used[i]=1;
	}
      else
	used[i]=0;

    }

  if (p) freematrix(p);
  p=matrix(mpts,ndim);
  covar=matrix(ntrue_param,ntrue_param);
  alamda=0.001;
  mrqcof(atry,alpha,beta);
  ochisq=chisq;

  return;

}

void fit::cleanup_mrqmin(const int full)
{
  if (!full)
    {
      covsrt(covar,ntrue_param,used,ndim);
      l_c("Covar matrix :",1);
      char ss[256];
      int add;
      for(int j=0;j<ntrue_param;j++)
	{
	  add=0;
	  for(int i=0;i<ntrue_param;i++)
	    {
	      sprintf(ss+add," %10g",covar[j][i]);
	      add+=11;
	    }
	  ss[add]=0;
	  l_c(ss,1);
	}
      return;
    }

  if (covar)
    freematrix(covar);
  if (alpha)
    freematrix(alpha);
  if (oneda)
    freematrix(oneda);
  covar=alpha=oneda=0;
  if (atry)
    {
      delete [] atry;
      delete [] beta; 
      delete [] used; 
      delete [] da;
      delete [] A;
      A=atry=beta=da=0;
      used=0;
      
    }
  return;
}

void fit::mrqcof(const double *AA,double **alpha,double *beta) 
{
  double ymod,dy,wt;
  
  double *dyda=new double[ntrue_param];
  for(int j=0;j<ndim;j++)
    {
      for(int k=0;k<=j;k++)
	alpha[j][k]=0.0;
      beta[j]=0.0;
    }
  chisq=0.0;
  double Tpts=1.0 * (ed-st);
  setparam(AA);   //set parameters in advance of call.
  for(int i=st;i<ed;i++)
    {      
      ymod=fkd(i,dyda);  // Get y and tye array dy/da
      dy=ystr[i]-ymod;         // Get dy 
      int j(0);
      for(int l=0;l<ntrue_param;l++)
	{
	  if (used[l])
	    {
	      wt=dyda[l]*estr[i];  // Weight by error.
	      int k(0);
	      for(int m=0;m<=l;m++)  
		if (used[m]) alpha[j][k++] += wt*dyda[m];
	      beta[j] += dy*wt;
	      j++;                 
	    }
	}
      chisq +=dy*dy*estr[i];
    }
  chisq/=Tpts;
  for(int j=0;j<ndim;j++)
    {
      beta[j]/=Tpts;
      alpha[j][j]/=Tpts;
    }
  for(int j=1;j<ndim;j++)
    for(int k=0;k<j;k++)
      {
	alpha[j][k]/=Tpts;
	alpha[k][j]=alpha[j][k];
      }
  delete [] dyda;
  return;
}

void fit::mrqmin()
  /* from 685 NR.
     x=xstr,y=ystr,sig=estr,ndata=npts,a=pb,covar=covar,
     atry=
   Note initialisation is carried out by init_mrqmin()
  */
{ 
  for(int j=0;j<ndim;j++)
    {
      for(int k=0;k<ndim;k++)
	covar[j][k]=alpha[j][k];
      covar[j][j]=alpha[j][j] * (1.0+alamda);
      oneda[j][0]=beta[j];
    }
  gaussj(covar,ndim,oneda,1);
  for(int j=0;j<ndim;j++)
    da[j]=oneda[j][0];
   
  int j,l;
  for(j=0,l=0;l<ntrue_param;l++)
    {
      if (used[l])
	{
	  atry[l]=A[l]+da[j];
	  if (atry[l]<plo[j])
	    atry[l]=plo[j];
	  else if (atry[l]>phi[j])
	    atry[l]=phi[j];
	  j++;
	}
    }
  mrqcof(atry,covar,da);
  if (chisq < ochisq)
    {
      alamda *= 0.1;
      ochisq=chisq;
      for(int j=0;j<ndim;j++)
	{
	  for(int k=0;k<ndim;k++)
	    alpha[j][k]=covar[j][k];
	  beta[j]=da[j];
	}
      for(int l=0;l<ntrue_param;l++)
	A[l]=atry[l];
    }
  else
    {
      alamda *= 10.0;
      chisq=ochisq;
    }
  return;
}

static double gb_sqrarg;
#define SQ(a) ((gb_sqrarg=(a))==0.0 ? 0.0 : gb_sqrarg * gb_sqrarg)
static double dmaxarg1,dmaxarg2;
#define DMAX(a,b) (dmaxarg1=(a),dmaxarg2=(b),\
		   (dmaxarg1) > (dmaxarg2) ? (dmaxarg1) : (dmaxarg2))


void fit::powell()
{
  
  // assumed in the class are p[n] = start point
  // assume that xi[n][n]=matrix of vectors
  // vect 2 is in ix[2][0..n-1]

  // maps p[] as pb[]
  // maps n as ndim
  // maps 

  int i,ibig,j;              
  double fptt,t,del,fp;
  
  double *pt=new double[ndim];   // these are too be defined elsewhere!!
  double *ptt=new double[ndim];  //                 """""""
  double *xit=new double[ndim];  //                 """""""

  for(int i=0;i<ndim;i++)
    for(int j=0;j<ndim;j++)
      {
	if (i==j)
	  xi[i][j] = (phi[i]-plo[i])/20.0;
	else
	  xi[i][j]=0.0;
      }

  double test = fk(pb);
 
  for(j=0;j<ndim;j++) pt[j]=pb[j];
  for (nfunk=1;;nfunk++)
    {
      fp=test;
      ibig=0;
      del=0.0;
      for(i=0;i<ndim;i++)
	{
	  for (j=0;j<ndim;j++)
	    xit[j]=xi[j][i];
	  fptt=test;
	  linmin(xit,test);
	  if (fabs(fptt-test) > del) 
	    {
	      del=fabs(fptt-test);
	      ibig=i;
	    }
	}
      if (2.0*fabs(fp-test) <= ftol*(fabs(fp)+fabs(test)))
	{
	  delete [] pt;
	  delete [] ptt;
	  delete [] xit;
	  pt=ptt=xit=0;
	  return;
	}
      if (nfunk >= NMAX)
	{
	  l_c("Fit function has exceeded max iterations",1);
	  return;
	}
      for (j=0;j<ndim;j++)
	{
	  ptt[j]=2.0 * pb[j]-pt[j];
	  xit[j]=pb[j]-pt[j];
	  pt[j]=pb[j];
	}
      fptt =fk(ptt);
      if (fptt < fp) 
	{
	  t=2.0 * (fp-2.0 * test + fptt) * SQ(fp-test-del) * SQ(fp-fptt);
	  if (t < 0.0)
	    {
	      linmin(xit,test);
	      for (j=0;j<ndim;j++)
		{
		  xi[j][ibig]=xi[j][(ndim-1)];
		  xi[j][ndim-1]=xit[j];
		}
	    }
	}
    }
}

void fit::linmin(double xy[],double &fret)
{
  /* 
     xy == director , fret = returned value
     maps pb[] to p[]
     maps ndim to n
     maps ndim to ncom
     maps fit::fk to func
   */

  pcom = new double[ndim];
  xicom = new double[ndim];

  if (!xicom) error("Can't open fit::linmin.xicom");
  for(int j=0;j<ndim;j++)
    {
      pcom[j]=pb[j];
      xicom[j]=xy[j];
    }
  double ax= 0.0;
  double xx=1.0;
  double xmin;
  double bx;
  mnbrak(ax,xx,bx);
  fret=brent(ax,xx,bx,xmin);
  for (int j=0;j<ndim;j++)
    {
      xy[j] *= xmin;
      pb[j] += xy[j];
    }
  delete [] pcom;
  delete [] xicom;
  return;
}

double fit::f1dim(const double x)
{
  double *xt=new double[ndim];
  double f;
  for(int j=0;j<ndim;j++)
    xt[j]=pcom[j]+x * xicom[j];
  f=fk(xt);
  delete [] xt;
  return f;
}      

void fit::mnbrak(double &ax,double &bx,double &cx)
{
  /* 
     maps fit::f1dim to func
  */

  double fa,fb,fc;
  double ulim,u,r,q,fu,dum;

  fa=f1dim(ax);
  fb=f1dim(bx);
   
  if (fb > fa) 
    {
      SHFT(dum,ax,bx,dum);
      SHFT(dum,fb,fa,dum);
    }
  cx=bx+GOLD * (bx-ax);
  fc=f1dim(cx);
  while(fb > fc)
    {
      r=(bx-ax)*(fb-fc);
      q=(bx-cx)*(fb-fa);
      u=bx-((bx-cx) * q - (bx-ax) * r) /
	(2.0* SIGN(DMAX(fabs(q-r),TINY),q-r));
      ulim=bx+GLIMIT*(cx-bx);
      if ((bx-u) * (u-cx) > 0.0)
	{
	  fu=f1dim(u);
	  if (fu < fc)
	    {
	      ax=bx;
	      bx=u;
	      fa=fb;
	      fb=fu;
	      return;
	    }
	  else if(fu >fb)
	    {
	      cx=u;
	      fc=fu;
	      return;
	    }
	  u=cx+GOLD * (cx-bx);
	  fu=f1dim(u);
	}
      else if ((cx-u)*(u-ulim) > 0.0)
	{
	  fu=f1dim(u);
	  if (fu < fc)
	    {
	      SHFT(bx,cx,u,cx+GOLD*(cx-bx));
	      SHFT(fb,fc,fu,f1dim(u));
	    }
	 }
      else if ((u-ulim)*(ulim-cx) > 0.0)
	{
	  u=ulim;
	  fu=f1dim(u);
	}
      else
	{
	  u=cx+GOLD*(cx-bx);
	  fu=f1dim(u);
	}
      SHFT(ax,bx,cx,u);
      SHFT(fa,fb,fc,fu);
    }
}

#define ITMAX 100
#define CGOLD 0.3819660
#define ZEPS 1.0e-10


double fit::brent(const double ax,const double bx,
		  const double cx,double &xmin)
{
  /*
    maps func to fk::f1dim
   */
  const double tol(2.0e-5);
  double a,b,d,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm;
  double e=0;
  a=(ax < cx ? ax : cx);         // make a,b in assending order.
  b=(ax > cx ? ax : cx); 
  
  x=w=v=bx;
  fw=fv=fx=f1dim(x);
  for(int iter=1;iter<ITMAX;iter++)
    {
      xm=0.5*(a+b);
      tol2=2.0*(tol1=tol*fabs(x)+ZEPS);
      if (fabs(x-xm) <= (tol2-0.5*(b-a)))
	{
          xmin=x;
          return fx;
	}
      if (fabs(e) > tol1) 
	{
          r=(x-w)*(fx-fv);
          q=(x-v)*(fx-fx); 
          p=(x-v)*q-(x-w)*r;
          q=2.0*(q-r); 
          if (q>0.0) p = -p;
          q=fabs(q); 
          etemp =e; 
          e=d; 
          if (fabs(p) >= fabs(0.5*q*etemp) || p<= q*(a-x) || p>= q*(b-x))
            d=CGOLD*(e=(x >= xm ? a-x : b-x));
	  else
	    { 
	      d=p/q; 
	      u=x+d;
	      if (u-a < tol2 || b-u < tol2)
		d=SIGN(tol1,xm-x); 
	    }
	}
      else
	{
          d=CGOLD*(e=(x >= xm ? a-x : b-x));
	}
      u=(fabs(d) >= tol1 ? x+d : x+SIGN(tol1,d));
      fu=f1dim(u);
 
      if (fu <= fx) 
	{
          if (u >= x) a=x; else b=x;
          SHFT(v,w,x,u);
          SHFT(fv,fw,fx,fu);
	}
      else
	{
          if (u<x) a=u; else b=u;
          if (fu <= fw || w==x)    
            {
	      v=w; 
	      w=u; 
	      fv=fw; 
	      fw=fu;
            }
          else if (fu <= fv || v== x || v==w) 
            {
	      v=u;
	      fv=fu;
            }
	} 
    }
  l_c("Haveing some problems finding the brent minimium :(",1);
  xmin=x; 
  return fx;
}


double fit::amebsa()
{
  double sum;

  if (!ndim) return 0.0;
  if (!y) return 0.0;
  if (!p) return 0.0;
    
  int i,j;
  int ilo,ihi;
  double yt,yhi,ylo,ynhi,ysave,ytry,rtol;

  for (j=0;j<ndim;j++)
    {
      for (sum=0.0,i=0;i<mpts;i++)
	sum+= p[i][j];
      psum[j]=sum;
    }

  for(;;)
    {
      ilo=0;
      ihi=1;
      ynhi=ylo=y[0]-temp*log(ran());
      yhi=y[1]-temp*log(ran());
      if (ylo>yhi)
	{
	  ihi=0;
	  ilo=1;
	  ynhi=yhi;
	  yhi=ylo;
	  ylo=ynhi;
	}
      for (i=2;i<mpts;i++)
	{
	  yt=y[i]-temp*log(ran());
	  if (yt <= ylo)
	    {
	      ilo=i;
	      ylo=yt;
	    }
	  if (yt > yhi)
	    {
	      ynhi=yhi;
	      ihi=i;
	      yhi=yt;
	    }
	  else if (yt>ynhi)
	    ynhi=yt;
	}


      rtol=2.0 * (yhi-ylo)/(yhi+ylo);
      if (rtol < ftol || nfunk<0)
	break;

      nfunk-=2;

      ytry=amotsa(ihi,yhi,-1.0);
      if (ytry <= y[ilo])            //ie wonderful result lets see if
	{                           // we can go that way some  more 
	  ytry=amotsa(ihi,yhi,2.0);
	} 
      else if (ytry >= ynhi) 
	{
	  ysave = yhi;
	  ytry = amotsa(ihi,yhi,0.5);
	  if (ytry >= ysave)
	    {
	      for (i=0;i<mpts;i++)
		{
		  if( i!=ilo)
		    {
		      for(j=0;j<ndim;j++)
			{
			  ysave = 0.5 * (p[i][j] + p[ilo][j]);
			  p[i][j] = psum[j]= ysave;
			}
		      y[i]=fk(psum);
		    }
		}
	      nfunk -=ndim;
	      for (j=0;j<ndim;j++)
		{
		  for (sum=0.0,i=0;i<mpts;i++)
		    sum+= p[i][j];
		  psum[j]=sum;
		}
	    }
	}
      else nfunk++;
    }
  yb=fk(pb);
  return yb;
}

double fit::amotsa(int ihi,double& yhi,double fac)
{
  double fac1=(1.0-fac)/ndim;
  double fac2=fac1-fac;

  for(int j=0;j<ndim;j++)
    {
      ptry[j]=psum[j] * fac1-p[ihi][j] * fac2;
      while ((ptry[j]>phi[j]) || (ptry[j]<plo[j]))
	{
	  if (ptry[j]>phi[j]) ptry[j] =  ((2.0 * phi[j]) - ptry[j]);
	  if (ptry[j]<plo[j]) ptry[j] =  ((2.0 * plo[j]) - ptry[j]);
	}
    }
  double ylook = fk(ptry);

  if (ylook < yb) 
    {
      for (int j=0;j<ndim;j++) pb[j]=ptry[j];
      yb=ylook;
    }

  double yflu=ylook+temp*log(ran());
  if (yflu < yhi)
    {
      y[ihi]=ylook;
      yhi=yflu;
      for (int j=0;j<ndim;j++)
	{
	  psum[j] += ptry[j] - p[ihi][j];
	  p[ihi][j] = ptry[j];
	}
    }
  return yflu;
}

/*
  void fit::itostr(char* outs,const int fn) const 
    {
    int fnmb=fn;
    if (fnmb>999 || fnmb <1)
      cerr << "Error with fnmb " << fnmb << '\n';
    outs += 10; 
    for(int i=0;i<3;i++)
      {
      *outs-- = (char) ((fnmb % 10) +48);
      fnmb /= 10;
      }
    return;
    }
*/

void 
fit::reinit(intep& find,const int n_par,const int nfull)
{
  // Ensure that all the memory is correctly allocated.

  if (n_par<1) return;
  
  if (ndim!=n_par || ntrue_param!=nfull)
    {
      delete [] plo;
      delete [] phi;
      delete [] pb;

      delete [] ptry;
      delete [] psum;

      mpts=n_par+1;
      ndim=n_par;
      
      plo=new double[n_par];
      phi=new double[n_par];
      ptry=new double[n_par];
      pb=new double[n_par];
      psum=new double[n_par]; 
      y=new double[mpts];
      xi=matrix(n_par,n_par);
      if (p) freematrix(p);
      p=matrix(mpts,n_par);

      ntrue_param=nfull;
      int j=0;
      for(int i=0;i<nfull;i++)
	{
	  if (find.cnt.flag[i])
	    {
	      pb[j]=find.cnt.v[i];
	      plo[j]=find.cnt.vl[2*i];
	      phi[j]=find.cnt.vl[2*i+1];
	      j++;
	    }
	}

      p=matrix(mpts,ndim);
    }
  new_calc= &find;
  return;
}


void 
fit::reinit(const double* v,const double* vl,const int n_par)
{
  // Ensure that all the memory is correctly allocated.

  if (n_par<1) return;
  if (ndim!=n_par)
    {
      delete [] plo;
      delete [] phi;
      delete [] pb;

      delete [] ptry;
      delete [] psum;

      mpts=n_par+1;
      ndim=n_par;
      
      plo=new double[n_par];
      phi=new double[n_par];
      ptry=new double[n_par];
      pb=new double[n_par];
      psum=new double[n_par]; 
      y=new double[mpts];
      if (p) freematrix(p);
      p=matrix(mpts,n_par);
      xi=matrix(n_par,n_par);

      ntrue_param=n_par;
      for(int i=0;i<n_par;i++)
	{
	  pb[i]=v[i];
	  plo[i]=vl[2*i];
	  phi[i]=vl[2*i+1];
	}

      p=matrix(mpts,ndim);
    }
  return;
}

   
int 
fit::badfit(const int mt)
{
  if (!new_calc) return 1;
  method=mt;
  for(int i=0;i<ndim;i++)
    p[0][i]=pb[i];
  int *ct=new int[ndim];
  int bc= 2 << ndim;
  for(int i=0;i<ndim;i++)
    {
      ct[i]=int(ran() * bc);
      for (int j=0;j<i;j++)
	if (ct[i]==ct[j]) i--;
    } 
  for(int i=0;i<ndim;i++)
    {
      for(int j=1;j<mpts;j++)
	{
	  if (ct[i] & (2 << j-2))
	    p[j][i]=phi[i];
	  else
	    p[j][i]=plo[i];
	}
    }
  delete [] ct;
  return makefit();
}     

int fit::makefit() 
{
  const double tvt=0.2;
  for (int i=0;i<mpts;i++)
    y[i]=fk(p[i]);
   
  yb=y[0];
  for (int j=0;j<ndim;j++) pb[j]=p[0][j];

  int low_grp=0;
  yb=y[0];
  for(int j=1;j<mpts;j++)
    {
      if (y[j]<yb)
	{
	  yb=y[j];
	  low_grp=j;
	}
    }
  for (int i=0;i<ndim;i++) 
    pb[i]=p[low_grp][i];


  if (method) 
    {
      temp= y[1]+y[0];
      int ncalls=0;
      double tt;
      do {
	nfunk=method;
	temp*=tvt;
	tt = amebsa();
	tt -= yb;
	ncalls++;
      } while (nfunk<1);
      nfunk=ncalls * method;
    }
  else 
    {
      amoeba();
    }

  char s[255];
  sprintf(s,"nfunk = %d",nfunk);
  //  ostrstream lss(s,255,ios::out);
  // lss<<"nfunk = "<<nfunk<<'\0';
  l_c(s,1);
  return 0;
}

void fit::amoeba()
{
  if (!ndim) return;
  if (!y) return;
  if (!p) return;
  double sum;
  int i,j;
  nfunk=0;
  for (j=0;j<ndim;j++)
    {
      for (sum=0.0,i=0;i<mpts;i++) 
	sum+= p[i][j];
      psum[j]=sum;
    }
  int ilo,ihi,inhi;
  double rtol,ytry,ysave;

  for(;;)
    {
      ilo=0;
      ihi = y[0]>y[1] ? (inhi=1,0) : (inhi=0,1);
      for (i=0;i<mpts;i++)
	{
	  if (y[i] <= y[ilo]) ilo=i;
	  if (y[i] > y[ihi]) 
	    {
	      inhi=ihi;
	      ihi=i;
	    }
	  else if (y[i]>y[inhi] && i != ihi) 
	    inhi=i;
	}
      rtol=2.0 * (y[ihi]-y[ilo])/(y[ihi]+y[ilo]);
      if (rtol < ftol) 
	break;
      if (nfunk>=NMAX)
	{
	  l_c("Exiting on overrun condition",1);
	  break;
	}
      nfunk += 2;
      ytry = amotry(ihi,-1.0);
      if (ytry <= y[ilo])                  //ie wonderful result lets see if
	{
	  ytry=amotry(ihi,2.0);              // we can go that way some  more
	}
      else if (ytry >= y[inhi])
	{
	  ysave = y[ihi];
	  ytry = amotry(ihi,0.5);
	  if (ytry >= ysave) 
	    {
	      for (i=0;i<mpts;i++)
		{
		  if( i!=ilo) 
		    {
		      for(j=0;j<ndim;j++)  //this must alway be in range.
			{
			  ysave = 0.5 * (p[i][j] + p[ilo][j]);
			  p[i][j] = psum[j]= ysave;
			}
		      y[i]=fk(psum);
		    }
		}
	      nfunk +=ndim;
	      for (j=0;j<ndim;j++)
		{
		  for (sum=0.0,i=0;i<mpts;i++)
		    sum+= p[i][j];
		  psum[j]=sum;
		}
	    }
	}
      else nfunk--;
    }
  for(int k=0;k<ndim;k++)
    pb[k]=p[ilo][k];
  yb=fk(pb);
  return;
}

double fit::amotry(int ihi,double fac)
{
   
  double fac1=(1.0-fac)/ndim;
  double fac2=fac1-fac;

  for(int j=0;j<ndim;j++)
    {
      ptry[j]=psum[j] * fac1-p[ihi][j] * fac2;
      while ((ptry[j]>phi[j]) || (ptry[j]<plo[j]))
	{ 
	  if (ptry[j]>phi[j]) ptry[j] =  ((2.0 * phi[j]) - ptry[j]);
	  if (ptry[j]<plo[j]) ptry[j] =  ((2.0 * plo[j]) - ptry[j]);
	}
    }
  double ylook = fk(ptry);
  if (ylook < y[ihi]) 
    {
      y[ihi]=ylook;
      for(int j=0;j<ndim;j++)
	{
	  psum[j] += ptry[j]-p[ihi][j];
	  p[ihi][j]=ptry[j];
	}
    }
  return ylook;
} 

fit::~fit()
{
  delete[] yout;
  delete[] plo;
  delete[] phi;
  delete[] y;
  freematrix(p);
  delete[] xstr;
  delete[] ystr;
  delete[] estr;
  delete [] pb;
  delete [] ptry;
  delete [] psum; 
  delete [] used;
  delete [] beta;
  delete [] atry;
  delete [] da;
  delete [] A;
  freematrix(covar);
  freematrix(alpha);
  freematrix(oneda); 
}

inline double fit::pow(double x,double a)
{
  if (x==0.0) return 1.0;
  return (x>0.0) ? (exp(a * log(x))) : -1.0 * (exp(a * log((-1.0 * x))));
}
 

double
fit::fkd(const int pt,double* dyda)
{
  int fgrp=new_calc->cnt.i_grp();
  double midval=new_calc->point(pt,fgrp);
  double lpt,hold;
  double mult=(alamda>1e-5) ? alamda : 1e-5;
  for(int i=0;i<ntrue_param;i++)
    {
      if (used[i])
	{
	  hold=new_calc->cnt.v[i] * mult;
	  if (fabs(hold)<mult) hold=mult;
	  new_calc->cnt.v[i]+= hold;
	  lpt=new_calc->point(pt,fgrp);
	  dyda[i]=(lpt-midval)/hold;
	  new_calc->cnt.v[i]-=hold;
	}
    }
  return midval;
} 

double 
fit::fk(const double pt[])
{
  // place to put our fitting interface.
  int i=0;
  for(int j=0;j<ntrue_param;j++)
    {
      if (new_calc->cnt.flag[j])
	{
	  if (pt[i]>phi[i])
	    new_calc->cnt.v[j]=phi[i];
	  else if (pt[i]<plo[i])
	    new_calc->cnt.v[j]=plo[i];
	  else
	    new_calc->cnt.v[j]=pt[i];
	  i++;
	}
    }
  return new_calc->chi(); 
}     

void 
fit::newdat(int grp)
{
  if (grp>=tg || grp<0) return;  // make throw 
  extern Spec_In storage_;

  int pts = storage_.stpnt[grp];
  if (pts!=npts)
    {
      delete [] xstr; 
      delete [] ystr; 
      delete [] estr;
      delete [] yout;
      xstr=new double[pts]; 
      ystr=new double[pts];
      yout=new double[pts]; 
      estr=new double[pts]; 
      if (!estr) error("Can't get space for fit::newdat.estr");
    }       
  for(int i=0;i<pts;i++)
    {
      xstr[i]=storage_.storx[grp][i];
      ystr[i]=storage_.story[grp][i];
      estr[i]=storage_.store[grp][i];
      if (estr[i]<=0.0) estr[i]=1.0;
      estr[i] = 1.0/(estr[i]*estr[i]);
    }
  npts=pts;

  return;
}

fit::fit() : ftol(1e-6),npts(0),xstr(0), ystr(0),estr(0),
             yout(0),ncont(0),ndim(0),mpts(0),nfunk(0),method(0),
             new_calc(0),plo(0),phi(0),psum(0),p(0),y(0),
             ptry(0),pb(0),yb(0.0),temp(0.0),
             xi(0),pcom(0),xicom(0),chisq(0),ochisq(0),alamda(0),A(0),
             used(0),atry(0),beta(0),covar(0),alpha(0),da(0),oneda(0)
{ }





