#ifndef fit_h
#define fit_h

#define NMAX 500
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d)
#define SIGN(a,b) ((b) >=0.0 ? fabs(a) : -fabs(a))

#define CGOLD 0.3819660
#define ZEPS 1.0e-10
#define GOLD 1.618034
#define GLIMIT 100.0
#define TINY 1.0e-20



class fit {

 private:
  
  const double ftol;
  
  int npts;
  double *xstr; // made: 
  double *ystr;
  double *estr;
  double *yout;
  int st;
  int ed;
  
  double qconv;  

  int ntrue_param;  
  
  int ncont; //number of wt points ncout<=npts 
  int ndim;  //number of parameters.
  int mpts;  //number of rows in **p = ndim+1 (normally).
  int nfunk; //number of calls to the function.
  int method; //Way we are going to fit      
  
  intep *new_calc;
  
  double *plo;  //Array of lowest value the parameters can go
  // made: (reinit) set: (reinit)
  double *phi;  //Array of highest value the parameters can go 
  // made:(reinit) set: (reinit)
  double *psum; // Array of the sum of the parameters! 
  // made:(reinit) 
  double **p;   //Matrix of fitting parameters.   
                   // made:(reinit) set: (badfit)
  double *y;   // must be initilised with the values of funk(p[i])
  // made: (reinit) set: (makefit) 
  double *ptry;    // ???? 
  // made:(reinit)
  double *pb;  //Absolutely the best point (Note: used in amebsa) 
  // made:(reinit)
  double yb;
  
  double temp; // Temperature in amotsa.
  
  double amotry(int,double);
  void amoeba();
  double amebsa();
  double amotsa(int, double&,const double);
  double pow(double,double);   //do we need this ? ie is in fglobal
  double fk(const double[]);
  double fkd(const int,double*);
  int makefit(); 

  // Stuff for powell
   
  double **xi;
  void linmin(double [],double &);
  double f1dim(const double x);
  void mnbrak(double &,double &,double &);
  double brent(const double,const double,const double,double &);
  double *pcom;
  double *xicom;

 //Stuff for mrqmin //Could reuse other variables :-(

  double chisq;
  double ochisq;
  double alamda;
  double *A;
  int *used;
  double *atry;
  double *beta;
  double **covar;
  double **alpha;
  double *da;
  double **oneda;

  void mrqcof(const double *,double **,double *);
  void setparam(const double *);

 public:
  
  void do_mrq(intep &,const int,const int);
  void powell();
  void mrqmin();
  void init_mrqmin(const int,const int);
  void cleanup_mrqmin(const int =0);

  fit();
  //  fit(const double*,const double*,const int,intep* =0 );
  int splx_fit(const int grp,const int grp2);
  void newdat(const int);    // grp-1 This adds data to the fit class
  //     void udwork(const int);    // grp-1
  int badfit(const int=0);
  void reinit(intep&,const int,const int);
  void reinit(const double*,const double*,const int);
  void set_total(const int);
  ~fit();
};
#endif





