#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "cmd.h"
#include "fglobal.h"
#include "spacebox.h"
#include "space.h"
#include "baseGraph.h"
#include "new_read.h"


extern XtAppContext app;
extern Widget top,text_w,main_w;

spacebox::spacebox(space_correct* A) : 
  SC(*A),madebox(0)
{}

spacebox::~spacebox()
{
  if (madebox)
    {
      Widget shell = SBox;
      if (shell)
	XtDestroyWidget(shell);
      madebox=0;
    }
}

void
spacebox::dismiss_box(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox* THIS=static_cast<spacebox *>(client_data);
  if (THIS->SBox)
    XtPopdown(THIS->SBox);
  return;
}



void 
spacebox::cancel_box(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox* THIS=static_cast<spacebox *>(client_data);
  //  XtVaGetValues(THIS->SBox,XmNx,THIS->xx,XmNy,THIS->yy,NULL);
  THIS->madebox=0;
  Widget shell = THIS->SBox;
  if (shell)
    {
      XtDestroyWidget(shell);
    }
  return;
}


void 
spacebox::remove_over(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox* THIS=static_cast<spacebox*>(client_data);
  bin_file* BF=static_cast<bin_file*>(&THIS->SC);
  if (!BF)
    return;
  BF->overlap();
  BF->complete_draw();
  return;
}
void 
spacebox::boxhelp(Widget w,XtPointer client_data,XtPointer call_data)
{
  //  spacebox *THIS=static_cast<spacebox*>(client_data);
  return;
}

void 
spacebox::dismiss(Widget w,XtPointer client_data,XtPointer call_data)
{
  
  //  spacebox *THIS=static_cast<spacebox*>(client_data);
  return;
}
void 
spacebox::replot(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox* THIS=static_cast<spacebox*>(client_data);
  //  space_correct* SPC=static_cast<space_correct*>(THIS);
  bin_file* BF=static_cast<bin_file*>(&THIS->SC);
  if (BF)
    BF->complete_draw();      
  return;
}

void
spacebox::getvalues()
{
  char out[255];
  double tnum;
  strncpy(out,XmTextFieldGetString(minTW),255); //min sep (pixels)
  if (cmdnumber(out,tnum) &&
      tnum>0.0)
    SC.update('D',tnum);

  strncpy(out,XmTextFieldGetString(fracTW),255); //min sep (pixels)
  if (cmdnumber(out,tnum) &&
      tnum>0.0 && tnum<100.0)
    SC.update('X',tnum);
  return;
}


void
spacebox::settextfield(Widget w,const double value)
{
  char s[25];
  sprintf(s,"%20g",value);
  int k;
  for(k=0;k<25 && s[k]==' ';k++);
  XmTextPosition j=strlen(s+k);
  XmTextSetString(w,s+k);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}

void
spacebox::setvalues()
{
  double tnum;
  tnum=SC.getvalues('D');
  settextfield(minTW,tnum);
  tnum=SC.getvalues('X');
  settextfield(fracTW,tnum);
  return;
}    


void 
spacebox::sl_menu(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox *THIS=static_cast<spacebox*>(client_data);
  return;
}
void 
spacebox::ss_menu(Widget w,XtPointer client_data,XtPointer call_data)
{
  //  spacebox *THIS=static_cast<spacebox*>(client_data);
  return;
}


void 
spacebox::minCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox *THIS=static_cast<spacebox*>(client_data);
  THIS->getvalues();
  THIS->setvalues();
  return;
}
void 
spacebox::fracCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  spacebox *THIS=static_cast<spacebox*>(client_data);
  THIS->getvalues();
  THIS->setvalues();
  return;
}


void 
spacebox::make_menu()
{
  static ActionAreaItem  sact[]={
    {"Overlap", remove_over, (XtPointer) this, 1},
    {"Replot", replot, (XtPointer) this, 1},
    {"Quit", cancel_box, (XtPointer) this, 1},
    {"Help", boxhelp,  (XtPointer) this, 1},
  };

  if (madebox)
    {
      XtPopup(SBox,XtGrabNone);
      return;
    }
  
  SBox=XtVaCreatePopupShell("SBox",
			    topLevelShellWidgetClass,main_w,
			    XtNtitle, "Space Box",
			    XmNdeleteResponse,XmDESTROY,
			    NULL);
  Widget SMain = 
    XtVaCreateManagedWidget("SboxInner",
			    xmMainWindowWidgetClass,SBox,
			    XtNtitle, "Space Fitting Table",
			    NULL);
  
  men_item Load_menu[] = {
    { "Load corrections", &xmPushButtonGadgetClass, 'L', 0,0,
      sl_menu, (XtPointer) this,  (men_item*) 0 },
    { "Save corrections", &xmPushButtonGadgetClass, 'S', 0,0,
      ss_menu, (XtPointer) this, (men_item*) 0 },
    {0,}
  }; 

  Widget menu_bar=XmCreateMenuBar(SMain,"menubar",NULL,0);
  BuildPulldownMenu(menu_bar,"File",'F',0,Load_menu,0);
  XtManageChild(menu_bar);

  Widget RowList=
    XtVaCreateWidget("SForm",xmFormWidgetClass,SMain,
		     NULL);                           
  XmString Word;
  
  //Start  of downward list of things to change/edit/write


  //Min Dist 
  Word=XmStringCreateLocalized(" Min Seperation ");
  
  Widget 
    minW=XtVaCreateManagedWidget("MinW",xmLabelWidgetClass,RowList,
				 XmNlabelString, Word,
				 XmNmarginHeight,(Dimension) 4,
				 XmNtopAttachment, XmATTACH_FORM,
				 XmNleftAttachment,XmATTACH_FORM,
				 NULL);
  XmStringFree(Word);
  
  minTW=
    XtVaCreateManagedWidget("mintext",xmTextFieldWidgetClass,RowList,
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,minW,
			    XmNmarginHeight,(Dimension) 4,
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,minW,
			    XmNcolumns,10,
			    NULL);
  

  // Display Fraction

  Word=XmStringCreateLocalized(" X size (%) ");
  Widget 
    fracW=XtVaCreateManagedWidget("Xfrac",xmLabelWidgetClass,RowList,
				  XmNlabelString, Word,
				  XmNmarginHeight,(Dimension) 4,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget,minTW,
				  XmNleftAttachment,XmATTACH_FORM,
				  NULL);
  XmStringFree(Word);

  
  fracTW=
    XtVaCreateManagedWidget("fractext",xmTextFieldWidgetClass,RowList,
			    XmNvalue, "20.0",
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,fracW,
			    XmNmarginHeight,(Dimension) 4,
			    XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNleftWidget,minTW,
			    XmNcolumns,10,
			    NULL);


  Widget pane =
    XtVaCreateWidget("paneB",xmPanedWindowWidgetClass,RowList,
		     XmNsashWidth,1,
		     XmNsashHeight,1,
		     NULL);
  CreateActionArea(pane,sact,4);
  XtVaSetValues(pane,XmNbottomAttachment,XmATTACH_FORM,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,fracTW,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);

  XtManageChild(pane);
  XtManageChild(RowList);
  XmMainWindowSetAreas(SMain,menu_bar,NULL,NULL,NULL,RowList);
  XtManageChild(SMain);

  XtAddCallback(minTW,XmNactivateCallback,minCB,
		(XtPointer) this); 
  XtAddCallback(fracTW,XmNactivateCallback,fracCB,
		(XtPointer) this); 

  madebox=1;
  XtPopup(SBox,XtGrabNone);
  setvalues();
  return;
}












