#ifndef space_h
#define space_h

class bin_file;
class spacebox;


struct Peak
{
  float x;
  float y;
  double pow;
  double width;

  //  peak() : x(0),y(0),pow(0),width(0)
  //  {}
  Peak(const float a=0.0,const float b=0.0) : x(a),y(b),pow(0),width(0) 
    {}
  ~Peak() {}
  double sep(const Peak&) const;
  //  bool lessX(const Peak& A) const { return x<A.x; }
  //  bool lessY(const Peak& A) const { return y<A.y; }
};

class xPeak_less
{
 public:
  
  bool operator() (const Peak& A,const Peak& B) const 
    { return A.x<B.x; }
};

class yPeak_less
{
 public:
  
  bool operator() (const Peak& A,const Peak& B) const 
    { return A.y<B.y; }
};




class space_correct 
{
private:
  
  spacebox* SpcWind;

  int grp;
  float **V;  //points of bin file.
  int xp,yp;    //range of V;

  float ax[4]; //axis xmin,xmax...

  double Xfrac;   //fraction of linesize to use
  float lsx,lsy;   //linesize x,y

  double zoneX[2];  //one orthoganal direction
  double zoneY[2];
  double distX;  //distance to search round in x direct.
  double distY;

  double min_dist;  //min distance between peaks 
  int npeak;  //total peaks found 
  int RefPeak;  //do we refine peaks added by cursor 1== yes
  
  std::vector<Peak> Pk; //peaks 
  
  void draw_cross(const float,const float) const;
  double refine(Peak &) const;
  int add_refined(Peak &,const double);  
  int directions();  //returns the peak that is central to the triangle.
  int init_grp(const int);
  void converge(Peak&,const Peak& ) const;

public:
  
  space_correct();
  virtual ~space_correct();
  void corr_values();
  int init_search(const int);
  void draw(const int = -1) const;
  int cursor_addition(const int); //Allow cursor addition.
  void complete_draw();  //draw picture as well.
  double getvalues(const char) const;  //update user-variables
  int overlap();
  void make_menu();
  void update(const char,double&);  //update user-variables

};

#endif
















