#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "fortran.h"
#include "cmd.h"


void sums(const char* ans)
  /* Carry out various integrations on the grp
     Options are -- 
       T == sum total calculation
       D == approx true functional integration
  */
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;

  static double scafac(-1.0);
  

  char ss[256];
  int grp=0;
  int grp2=0;
  double sfn;

  int flag=cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,grp2);
  if (flag==2) flag+=cmdnumber(hold_.is,sfn);

  while (flag<1 || grp<1 || grp>tg)
    {
      flag=1;
      sprintf(ss,"Group to be integrated =>");
      l_c(ss);
      if(!cmdnumber(ss,grp)) return;
    }
  while (flag<2 || grp2<1 || grp2>tg || grp==grp2)
    {
      flag=2;
      sprintf(ss,"Group to put integration =>");
      l_c(ss);
      if(!cmdnumber(ss,grp2)) return;
    }
  grp--;
  grp2--;
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  double *E=storage_.store[grp];

  double *Xo=storage_.storx[grp2];
  double *Yo=storage_.story[grp2];
  double *Eo=storage_.store[grp2];

  strncpy(ss,about_.hd[grp],40); //no terminating 0;
  ss[40]=0;
  std::string headname(ss);

  if (*ans=='T') 
    {
      double ssum=0.0;
      double es=0.0;
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  Xo[i]=X[i];
	  ssum+=Y[i];
	  es+=E[i]*E[i];
	  Yo[i]=ssum;
	  Eo[i]=sqrt(es);
	}
      sprintf(ss,"Total integration : 10%g (+/- 10%g)",ssum,sqrt(es));
      l_c(ss,1);
      storage_.stpnt[grp2]=storage_.stpnt[grp];
    }
  else if (*ans=='D')
    {
      *Xo= *X;
      *Yo= 0.0;
      *Eo= 0.0;
      double step;
      double ssum=0.0;
      double es(0.0);
      for(int i=1;i<storage_.stpnt[grp];i++)
	{
          step=0.5*(X[i]-X[i-1]);
	  ssum+=(Y[i]+Y[i-1])*step;
	  Xo[i]=X[i];
	  Yo[i]=ssum;
	  es=(step*step)*(E[i]*E[i]+E[i-1]*E[i-1]);
	  Eo[i]=sqrt(es);
	}
      storage_.stpnt[grp2]=storage_.stpnt[grp];
    }
  else
    {
      if (flag>2)
	scafac=sfn;
      else
	sfn=scafac;
      while (sfn<=0.0) 
	{
	  sprintf(ss,"Enter scattering prefactor =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,sfn)) return;
	}
      scafac=sfn;
      double ssum=0.0;
      double es=0.0;
	
      Xo[0]=X[0];
      *Yo=0.0;
      double xm2,x2,step;
      for(int i=1;i<storage_.stpnt[grp];i++)
	{
          step=0.5*(X[i]-X[i-1]);
	  xm2=X[i-1]*X[i-1];
	  x2=X[i]*X[i];
          ssum+=step*(Y[i]*x2+Y[i-1]*xm2);
	  Xo[i]=X[i];
	  Yo[i]=ssum*scafac;
	  es=(step*step)*(x2*x2*E[i]*E[i]+xm2*xm2*E[i-1]*E[i-1]);
	  Eo[i]=scafac*sqrt(es);
	}
      storage_.stpnt[grp2]=storage_.stpnt[grp];
      headname.insert(0,"R. Int ");
      strncpy(about_.hd[grp2],headname.c_str(),40);
      return;
    }
  std::string::size_type pos;
  pos=headname.find("d/dx ");  //simple case d/dx
  if ((pos!=std::string::npos))   
    {
      headname.append("     ");  //add space at end.
      headname.erase(pos,5); //remove d/dx bit.
      strncpy(about_.hd[grp2],headname.c_str(),40);
      return;
    }
  pos=headname.find("/dx^");  // case of d^?/dx^? 
  if (pos!=std::string::npos &&
      pos>2 && pos<39 && 
      headname[pos-3]=='d' && headname[pos-2]=='^')
    {
      if (headname[pos-1]=='2')
	{
	  headname.append("    "); 
	  headname.erase(pos-2,2);
	  headname.erase(pos+3,2);
	}
      else
	{
	  headname[pos-1]--;  //decrease number..
	  headname[pos+4]--;
	}
      strncpy(about_.hd[grp2],headname.c_str(),40);
    }
  headname.insert(0,"Int. ");
  strncpy(about_.hd[grp2],headname.c_str(),40);
  return;
   
}

void SwapGrps(const char *ans) 
{
  extern titls about_;
  extern wback hold_;
  extern Spec_In storage_;
  char ss[256];
  int grp=0;
  int grp2=0;
  int flag=cmdnumber(hold_.is,grp);
  flag+=cmdnumber(hold_.is,grp2);

  if (*ans=='E') 
    {
      while (grp<1 || grp>tg || grp2==grp || grp2>tg || grp2<1)
	{
	  sprintf(ss,"Transfer grps [A(x,e)->B(x,y)]  =>");
	  l_c(ss);
	  if(!cmdnumber(ss,grp) || !cmdnumber(ss,grp2) ) return;
	}
      grp--;
      grp2--;
      const int npts(storage_.stpnt[grp]);
      double *Xa=storage_.storx[grp];
      double *Ea=storage_.store[grp];
      double *Xb=storage_.storx[grp2];  
      double *Yb=storage_.story[grp2];
      for(int i=0;i<npts;i++)
	{
	  *Xb++ = *Xa++;
	  *Yb++ = *Ea++;
	}
      storage_.stpnt[grp2]=npts;
      strncpy(about_.hd[grp2],"Err: ",5);
      strncpy(about_.hd[grp2]+5,about_.hd[grp],35);
      return;
    }
  if (*ans=='Y')
    {
      while (grp<1 || grp>tg || grp2==grp || grp2>tg || grp2<1)
	{
	  sprintf(ss,"Transfer grps [A(e)->B(y)]  =>");
	  l_c(ss);
	  if(!cmdnumber(ss,grp) || !cmdnumber(ss,grp2) ) return;
	}
      grp--;
      grp2--;
      if (storage_.stpnt[grp]!=storage_.stpnt[grp2])
	{
	  l_c("No point number agreement",1);
	  return;
	}
      
      const int npts(storage_.stpnt[grp]);
      double *Ya=storage_.story[grp];
      double *Eb=storage_.store[grp2];
      for(int i=0;i<npts;i++)
	*Eb++ = *Ya++;

      strncpy(about_.hd[grp2],"Err: ",5);
      strncpy(about_.hd[grp2],about_.hd[grp],35);
      return;
    }
  if (*ans=='X')
    {
      while (grp<1 || grp>tg || grp2==grp || grp2>tg || grp2<1)
	{
	  sprintf(ss,"Transfer grps [A->B]  =>");
	  l_c(ss);
	  if(!cmdnumber(ss,grp) || !cmdnumber(ss,grp2) ) return;
	}
      grp--;
      grp2--;
      
      const int npts(storage_.stpnt[grp]);
      const int npts2(storage_.stpnt[grp2]);
      double *Xa=storage_.storx[grp];
      double *Xb=storage_.storx[grp2];
      for(int i=0;i<npts && i<npts2;i++)
	*Xb++ = *Xa++;
      return;
    }

  while (grp<1 || grp>tg || grp2>tg 
	 || grp2<1 || grp2==grp) 
    {
      sprintf(ss,"Which two grps to swap [if copy 1-->2] =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp) || !cmdnumber(ss,grp2) ) return;
    }
  grp--;
  grp2--;
  const int npts(storage_.stpnt[grp]);
  double *Xa=storage_.storx[grp];
  double *Ya=storage_.story[grp];
  double *Ea=storage_.store[grp];
  double *Xb=storage_.storx[grp2];  
  double *Yb=storage_.story[grp2];
  double *Eb=storage_.store[grp2];
  if (*ans=='C' || storage_.stpnt[grp2]<1)
    {
      for(int i=0;i<npts;i++)
	{
	  *Xb++ = *Xa++;
	  *Yb++ = *Ya++;
	  *Eb++ = *Ea++;
	}
      storage_.stpnt[grp2]=npts;
      strncpy(about_.hd[grp2],about_.hd[grp],40);
    }
  else
    {
      double tx,ty,te;
      for(int i=0;i<npts;i++)
	{
	  tx= *Xb;
	  ty= *Yb;
	  te= *Eb;
	  *Xb++ = *Xa;
	  *Yb++ = *Ya;
	  *Eb++ = *Ea;
	  *Xa++ = tx;
	  *Ya++ = ty;
	  *Ea++ = te;
	}
      int tnpts=storage_.stpnt[grp2];
      storage_.stpnt[grp2]=storage_.stpnt[grp];
      storage_.stpnt[grp]=tnpts;
      strncpy(ss,about_.hd[grp],40);
      strncpy(about_.hd[grp],about_.hd[grp2],40);
      strncpy(about_.hd[grp2],ss,40);
    }
  return;
}

void log10grp_(int * grp,int * SD)
{
  log10grp(*grp-1,*SD);
}

void log10grp(const int grp,const int sides)
{
  extern Spec_In storage_;
  if (grp>tg || grp<0) return;
  const double errdiv(log(1.0));
  int npts=storage_.stpnt[grp];
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  double *E=storage_.story[grp];
  for(int i=0;i<npts;i++)
    {
      if (sides & 2) 
	{
	  if (*Y)
	    {		
	      *E /= errdiv * *Y;
	      *Y = log10(fabs(*Y));
	    }
	  E++;
	  Y++;
	}
      if (sides & 1) 
	{
	  if (*X)
	    *X = log10(fabs(*X));
	  X++;
	}
    }
  return;
}



void self(const char ans)
  /*
        This swaps the X,Y on ans2=S ; it self divides if ans2=D y/x and
         mults if ans2=T; and R for resiprical
  */
{
  extern wback hold_;
  extern Spec_In storage_;
  char ss[256];
  int grp=0;
  char third,logten;
  get_first_nonumb(third,hold_.is,80);  
  third=toupper(third);
  if (third!=' ' && (ans=='E' || ans=='L'))
    {
      if (third=='T')
	{
	  logten='T';
	  get_first_nonumb(third,hold_.is,80);
	}
      else
	get_first_nonumb(logten,hold_.is,80);
    }	
	  
  int flag=cmdnumber(hold_.is,grp);

  while (grp<1 || grp>tg)
    {
      sprintf(ss,"Which group to be self worked =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }  
  grp--;

  if (ans=='F')  //xray-form correction
    {
      if (third=='X') //exafs correction
	ex_phase(flag,grp);
      else
	xsct(grp);
      return;
    }

  const int npts(storage_.stpnt[grp]);
  double *X(storage_.storx[grp]);
  double *Y(storage_.story[grp]);
  double *E(storage_.store[grp]);
  double add,mult;
  if (ans==' ')     //standard 
    {
      if (flag)
	{
	  flag+=cmdnumber(hold_.is,add);
	  flag+=cmdnumber(hold_.is,mult);
	}
      char chk;
      if (flag==3)
	get_first_nonumb(chk,hold_.is,80);  //get d or / from end
      while(flag<3 || mult==0.0)
	{
	  flag=3;
	  sprintf(ss,"Addition and multiplication factor =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,add) || !cmdnumber(ss,mult)) return;
	  get_next_char(chk,ss,80);
	}
      if (chk=='\\' || chk=='D' || chk=='d')
	mult=1.0/mult;
      for(int i=0;i<npts;i++)
	{
	  *Y *= mult;
	  *Y++ += add;
	  *E++ *= mult;
	}
      return;
    }
  else if (ans=='S')   //swap x,y
    {
      double tmp;
      if (third!='E')
	{
	  for(int i=0;i<npts;i++)
	    {
	      tmp= *X;
	      *X++ = *Y;
	      *Y++ = tmp;
	    }
	}
      else
	{
	  for(int i=0;i<npts;i++)
	    {
	      tmp= *Y;
	      *Y++ = *E;
	      *E++ = tmp;
	    }
	}	  
      return;
    }
  else if (ans=='L')   // Log transform
    {
      
      double (*fnc)(double);
      double errdiv;
      if (logten=='T')
	{
	  errdiv=log(10.0);
	  fnc= &log10;
	}
      else
	{
	  errdiv=1.0;
	  fnc= &log;
	}
      
      for(int i=0;i<npts;i++)
	{
	  if (!(third=='X') && !(third=='E'))
	    {
	      if (*Y)
		{		
		  *E /= errdiv * *Y;
		  *Y = fnc(fabs(*Y));
		}
	      E++;
	      Y++;
	    }
	  if (third=='X' || third=='B')
	    {
	      if (*X)
		*X = fnc(fabs(*X));
	      X++;
	    }
	  if (third=='E')
	    {
	      if (*E)
		*E= fnc(fabs(*E));
	      E++;
	    }
	}
      return;
    }
  else if (ans=='E')   // Log transform
    {
      double povalue=(logten=='T') ? 10.0 : exp(1.0); 
      for(int i=0;i<npts;i++)
	{
	  if (!(third=='X') && !(third=='E'))
	    {
	      if (*Y<700)
		*Y = pow(povalue,*Y);
	      Y++;
	    }
	  if (third=='X' || third=='B')
	    {
	      if (*X<700)
		*X = pow(povalue,*X);
	      X++;
	    }
	  if (third=='E')
	    {
	      if (*E<700)
		*E = pow(povalue,*E);
	      E++;
	    }
	}
      return;
    }
  else if (ans=='D' || ans=='/')   //divide
    {
      double powV,txp;
      if(flag)
	flag=cmdnumber(hold_.is,powV);
      if (!flag || powV>10.0 || powV< -10.0)
	powV=1.0; 
      for(int i=0;i<npts;i++)
	{
	  txp=pow(*X,powV);
	  if (txp)
	    {
	      *Y /= txp;
	      *E /= txp;
	    }
	  Y++;
	  E++;
	  X++;
	}
      return;
    }
  else if (ans=='A' || ans=='+')   //add
    {
      for(int i=0;i<npts;i++)
	*Y++ += *X++;
      return;
    }      
  else if (ans=='M' || ans=='-')  //subtract
    {
      for(int i=0;i<npts;i++)
	*Y++ -= *X++;
      return;
    }      
  else if (ans=='T' || ans=='*')  //multiplye
    {
      double powV,txp;
      if(flag)
	flag=cmdnumber(hold_.is,powV);
      if (!flag || powV>10.0 || powV< -10.0)
	powV=1.0; 
      for(int i=0;i<npts;i++)
	{
	  txp=pow(*X,powV);
	  *Y++ *= txp;
	  *E++ *= txp;
	  X++;
	}
      return;
    }      
  else if (ans=='R')  //reciprical
    {
      for(int i=0;i<npts;i++)
	{
	  if (*Y)
	    *Y = 1.0 / *Y;
	  *E++ *= *Y * *Y;
	  Y++;
	}
      return;
    }
  else if (ans=='N')  // absolute number
    {
      for(int i=0;i<npts;i++)
	{
	  *Y++ = fabs(*Y);
	}
      return;
    }
  else if (ans=='Z')  // Zero all negative 
    {
      for(int i=0;i<npts;i++)
	{
	 if (*Y<0.0) 
	   *Y=0.0;
	  Y++;
	}
      return;
    }
  else if (ans=='P') //powers
    {
      if (flag)
	flag+=cmdnumber(hold_.is,add);
      while(flag<2 || add==0 || add>30 || add<-30)
	{
	  flag=2;
	  sprintf(ss,"Power to raise y by ==>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,add)) return;
	}
      if (add==1) return;
      for(int i=0;i<npts;i++)
	{
	  if (*Y)
	    {
	      *Y =pow(*Y,add);
	      *E *=pow(*Y,add-1.0);
	    }
	  Y++;
	  E++;
	}
      return;
    }
  else if (ans=='C')    //convert to radians.
    {
      if (third!='D')
	for(int i=0;i<npts;i++)
	  *X++ /=57.29577951;
      else
	for(int i=0;i<npts;i++)
	  *X++ *=57.29577951;
    }
  return;
}


void 
ex_phase(const int flag,const int grp)
  /* Calculates grp = grp * sin(grp2) 
     Phase calculate for EXAFS 
  */
{
  char ss[256];
  extern wback hold_;
  extern Spec_In storage_;
  int grp2;

  if (flag && cmdnumber(hold_.is,grp2))
    grp2--;
  else
    grp2=grp+1;
  while(grp2>=tg || grp2<0)
    {
      strcpy(ss,"Enter the group containing the phase");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
      grp2--;
    }
  const int namp(storage_.stpnt[grp]);
  const int npha(storage_.stpnt[grp2]);
  if (namp>npha)
    l_c("Using shortened phase list",1);

  double* PP=storage_.story[grp2];
  double* AP=storage_.story[grp];
  double* AE=storage_.store[grp];

  for(int i=0;i<namp && i<npha;i++)
    {
      *AP *= sin(*PP);
      *AE *= sin(*PP);
      AE++;
      AP++;
      PP++;
    }
  return;
}

void xsct(const int grp)
/* 
     Used to compute f^2(q)=(f(q)+f'-if'')**2 for xrays
*/
{
  char ss[256];
  extern wback hold_;
  extern Spec_In storage_;
  double fp,fpp;

  if (!cmdnumber(hold_.is,fp) ||
       !cmdnumber(hold_.is,fpp))
    {
      sprintf(ss,"Input F'' and F'''' =>");
      l_c(ss,0);
      if (!cmdnumber(ss,fp) || !cmdnumber(ss,fpp)) return;
    }
  const int npts(storage_.stpnt[grp]);
  double *Y(storage_.story[grp]);
  double *E(storage_.store[grp]);
  fpp*=fpp;
  for(int i=0;i<npts;i++)
    {
      *Y+=fp;
      *E++ *= *Y;
      *Y *= *Y;
      *Y++ += fpp;
    }
  return;
}





