#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <fstream.h>
#include <string>
#include <vector>

#include "fglobal.h"
#include "cmd.h"


void 
lubcmp(double **A,const int n,int *indx,double &d)
{
  int imax,j,k;
  double sum,dum,big,temp;
  if (n<2) return;
  double *vv=new double[n];

  if (!vv) error("No space for the fitting vector");
  d=1;
  for(int i=0;i<n;i++)
    {
      big=0.0;
      for(j=0;j<n;j++)
	if ((temp=fabs(A[i][j])) > big) big=temp;
      if (big == 0.0) return;

      vv[i]=1.0/big;

    }

  for (j=0;j<n;j++)
    {
      for(int i=0;i<j;i++)
	{
	  sum=A[i][j];
	  for(k=0;k<i;k++)
	    sum-= A[i][k] * A[k][j];
	  A[i][j]=sum;
	}
      big=0.0;
      for (int i=j;i<n;i++)
	{
	  sum=A[i][j];
	  for (k=0;k<j;k++)
	    sum -= A[i][k] * A[k][j];
	  A[i][j]=sum;
	  if ( (dum=vv[i] * fabs(sum)) >=big)
	    {
	      big=dum;
	      imax=i;
	    }
	}

      if (j!=imax)
	{
	  for(k=0;k<n;k++)
	    {                     //Interchange rows
	      dum=A[imax][k];
	      A[imax][k]=A[j][k];
	      A[j][k]=dum;
	    }
	  d= -d;

	  vv[imax]=vv[j];
	}
      indx[j]=imax;

      if (A[j][j] == 0.0) A[j][j]=1e-10;
      if (j!=(n-1))
	{
	  dum=1.0/(A[j][j]);
	  for(int i=j+1;i<n;i++)
	    A[i][j] *= dum;
	}
    }
  delete [] vv;
  return;
}

void 
lubksb(double **A,const int n,int *indx,double *b)
{
  int ii= -1;
  int ip,j;
  double sum;
 
  for(int i=0;i<n;i++)
    {
      ip=indx[i];
      sum=b[ip];
      b[ip]=b[i];
      if (ii!= -1) 
	for (j=ii;j<=(i-1);j++) sum -= A[i][j] * b[j];
      else if (sum) ii=i;
      b[i]=sum;
    }

  for (int i=n-1;i>=0;i--)
    {
      sum=b[i];
      for (j=i+1;j<n;j++)
	sum -= A[i][j] * b[j];
      b[i]=sum/A[i][i];
    }
  return;
}

void 
savgol(double *c,int np,int nl,int nr,int ld, int m)

  /*  first c= the y coordinate fraction
        ld = derivative power (0= smoothing) 
        m = number of polynominal,
     */

{
  if (np<nl+nr+1 || nl<0 || nr<0 || ld>m || nl+nr<m)
    {
      cout<<np<<"  "<<nl<<"  "<<nr<<"  "<<ld<<"  "<<"  "<<m<<endl;
      cout<<"Error on entry conditions"<<endl;
      return;
    }    
  int imj,ipj,j,k,kk,mm; 
  double d,fac,sum;
  double **A=matrix(m+1,m+1);
  double *b=new double[m+1];
  int *indx=new int[m+1];
  if (!indx) error("Unable to allocate memory for indx");
  for(ipj=0;ipj<=(m << 1);ipj++)
    {
      sum=(ipj ? 0.0 : 1.0);
      for (k=1;k<=nr;k++) 
	sum += pow(double(k),double(ipj));
      for(k=1;k<=nl;k++) 
	sum += pow(double(-k),double(ipj));    
      mm= ( ipj < (2 * m -ipj) ? ipj : (2 * m -ipj) );
      for (imj = -mm;imj<=mm;imj+=2)
	A[(ipj+imj)/2][(ipj-imj)/2]=sum;
    }
  lubcmp(A,m+1,indx,d);
  for (j=0;j<m+1;j++)
    b[j]=0.0;
  b[ld]=1.0;
  lubksb(A,m+1,indx,b);
     
  for(kk=0;kk<np;kk++)
    c[kk]=0.0;
  kk=0;
  for(k=-nl;k<=nr;k++)
    {
      sum=b[0];
      fac=1.0;
      for (mm=0;mm<m;mm++)
	sum += b[mm+1] * (fac *= k);
      c[kk]=sum;
      kk++;
    }
  freematrix(A);
  delete [] b;
  delete [] indx;
  return;
}

void 
smo_savg(const int grp,const int grp2,const int dev,
	 const int pow,const int numb)
  /* dev =derivative powd
      pow=power of polynominal 
      numb = number of points to use 
   */

{
  extern Spec_In storage_;
  
  int stp=storage_.stpnt[grp];
  int wl,wr;    // right - left width
  int splt=numb/2;
  double *c=new double[(2*splt) +1];
  int i;
  double y,e,ep;
 
  double step=storage_.storx[grp][stp-1]-
    storage_.storx[grp][0];
  step/=(double) stp-1.0; 
  y=step;
  for(i=1;i<dev;i++)
    step*=y/(i+1.0);
  if (!dev) step=1.0;
  for(i=0;i<splt;i++)
    {
      wl= i;
      wr=2*splt - wl;
      savgol(c,2*splt+1,wl,wr,dev,pow); 

      y=0;
      e=0;
      for(int j=0;j<2*splt+1;j++)
	{
	  y+=storage_.story[grp][j+(i-wl)] * c[j];
	  ep=storage_.store[grp][j+(i-wl)] * c[j];
	  e += ep * ep;
	}
      storage_.storx[grp2][i]=storage_.storx[grp][i]; 
      storage_.story[grp2][i]=y/step;
      storage_.store[grp2][i]=sqrt(e);
    }
  savgol(c,2*splt+1,splt,splt,dev,pow);
  for(;i<stp-(splt+1);i++)
    {
      y=0;
      e=0;
      for(int j=0;j<2*splt+1;j++)
	{
	  y+=storage_.story[grp][j+(i-splt)] * c[j];
	  ep=storage_.store[grp][j+(i-splt)] * c[j];
	  e += ep * ep;
	}
      
      storage_.storx[grp2][i]=storage_.storx[grp][i];
      storage_.story[grp2][i]=y/step;
      storage_.store[grp2][i]=sqrt(e);
    }
  for(;i<stp;i++)
    {
      wr= stp-(i+1);
      wl=2*splt - wr;
      savgol(c,2*splt+1,wl,wr,dev,pow); 
      y=0;
      e=0;
      for(int j=0;j<2*splt+1;j++)
	{
	  y+=storage_.story[grp][j+(i-wl)] * c[j];
	  ep=storage_.store[grp][j+(i-wl)] * c[j];
	  e += ep * ep;
	}
      storage_.storx[grp2][i]=storage_.storx[grp][i]; 
      storage_.story[grp2][i]=y/step;
      storage_.store[grp2][i]=sqrt(e);
    }

  delete [] c; 
  storage_.stpnt[grp2]=storage_.stpnt[grp];
  return;

}

void 
derivative()
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  int dev(1),nmb(4),ply(2);
  int grp(0),grp2(0);
  int flag=cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,grp2);
  if (flag>1) flag+=cmdnumber(hold_.is,dev);
  if (flag>2) flag+=cmdnumber(hold_.is,nmb);
  if (flag>3) flag+=cmdnumber(hold_.is,ply);
  char ss[256];

  while (flag<1 || grp>tg || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to take derivative =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  while (flag<2 || grp2>tg || grp2<1 || grp==grp2)
    {
      flag=2;
      strcpy(ss,"Output grp =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  grp--; grp2--;
  if (storage_.stpnt[grp]<3) 
    return;
  while(dev>nmb || nmb<ply || 
	nmb>storage_.stpnt[grp] ||
        dev<0 || ply<0 || dev>ply) 
    {
      strcpy(ss,"Enter Deriv Order :  npts <4>  : poly <2> =>");
      l_c(ss,0);
      if(!cmdnumber(ss,dev)) return;
      if (!cmdnumber(ss,nmb))
	{
	  nmb=4;
	  ply=2;
	}
      else if (!cmdnumber(ss,ply))
	ply=2;
    }
  smo_savg(grp,grp2,dev,ply,nmb);
  strncpy(about_.hd[grp2],about_.hd[grp],40);
  char* hder=about_.hd[grp2];
  char check[4];

  for(int j=0;j<dev;j++)
    {
      strncpy(check,hder,4);
      if (check[0]=='d' && 
	  (check[1]=='/' || check[3]=='/'))
	{
	  if (check[3]=='/')
	    {
	      hder[2]++;
	      hder[7]++;
	    }
	  else
	    {
	      strcpy(hder,"d^2/dx^2 ");
	      strncpy(hder+9,about_.hd[grp]+5,31);
	    }
	}
      else
	{
	  strcpy(hder,"d/dx ");
	  strncpy(hder+5,about_.hd[grp],35);
	}
    }
  return;
}
      








