#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fglobal.h"

void sort_(int *GP)
{
  sort(*GP);
}

/* Rebin has seven types :::
  (I)  1 == exact copy                          X000
  (R)  2 == range                               XXX0
  (J)  3 == join copy (rebing at overlap only) X000
  (P)  4 == points                              XX00
  (S)  5 == spline smoothing                    XXX0
  (L)  6 == log smoothing                       XX00
  (G)  7 == sav-gol smoothing                   X000
  (B)  8 == Blend (merge equal X) 
*/ 



void cut_pts(const int grp,int flag)
{
  extern Spec_In storage_;
  extern wback hold_;

  char ss[256];
  int xmin,xmax;
  if (storage_.stpnt[grp]<1)
    {
      l_c("No points in grp",1);
      return;
    }
  if (flag!=2)
    {
      flag+=cmdnumber(hold_.is,xmin);
      if (flag==2) flag+=cmdnumber(hold_.is,xmax);
    }
  
  while(flag<3 && xmin>=xmax || xmin<1 || xmax>storage_.stpnt[grp])
    {
      flag=3;
      sprintf(ss,"Total points in group == %d",storage_.stpnt[grp]);
      l_c(ss,1);
      sprintf(ss,"Enter start and end pt of cut-rebin =>");
      l_c(ss,0);
      if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax))
	return;
    }
  xmin--;
  if (xmin==0)
    {
      storage_.stpnt[grp]=xmax;
      return;
    }
  for(int i=xmin,indx=0;i<xmax;indx++,i++)
    {
      storage_.storx[grp][indx]=storage_.storx[grp][i];
      storage_.story[grp][indx]=storage_.story[grp][i];
      storage_.store[grp][indx]=storage_.store[grp][i];
    }
  storage_.stpnt[grp]=xmax-xmin;
  return;
}

void self_range(const int grp,int flag)
{
  extern Spec_In storage_;
  extern wback hold_;

  char ss[256];
  double xmin,xmax;
  double step;
  if (flag!=2)
    {
      flag+=cmdnumber(hold_.is,xmin);
      if (flag==2) flag+=cmdnumber(hold_.is,xmax);
      if (flag==3) flag+=cmdnumber(hold_.is,step);
    }
  
  while(flag<3 || xmin>=xmax)
    {
      flag=3;
      sprintf(ss,"Enter xmin amd xmax of rebin =>");
      l_c(ss,0);
      if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax))
	return;
    }
  while(flag<4 || step==0.0 || 
	(step>0.0 && (xmax-xmin)/step>maxpts))
    {
      flag=4;
      sprintf(ss,"Enter step size (negative to use average step) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,step)) return;
    }
  int npts(storage_.stpnt[grp]);
  double* xv=storage_.storx[grp];
  double* yv=storage_.story[grp];
  double* ev=storage_.store[grp];

  if (step<0.0)
    {
      if (npts<2) 
	{
	  l_c("No points in grp to get default step",1);
	  return;
	}
      step=(xv[npts-1]-xv[0])/(npts-1);
    }
  
  double* xsp=new double[npts];
  double* ysp=new double[npts];
  double* esp=new double[npts];
  double* ysp_v=new double[npts];  //place for spline points
  double* esp_v=new double[npts];  
  for(int i=0;i<npts;i++)
    {
      xsp[i]=xv[i];
      ysp[i]=yv[i];
      esp[i]=ev[i];
    }
  int rypts=spline(xsp,ysp,&npts,ysp_v);     
  int repts=spline(xsp,esp,&npts,esp_v);     //both should be ry==re
  double xpt=xmin;
  int count=0;
  while(count<maxpts && xpt<=xmax)
    {
      xv[count]=xpt;
      yv[count]=splint(xsp,ysp,ysp_v,npts,xpt);
      ev[count]=splint(xsp,esp,esp_v,npts,xpt);
      count++;
      xpt+=step;
    }
  storage_.stpnt[grp]=count;
  sprintf(ss,"Group now has %d pts using %d different points",count,rypts);
  l_c(ss,1);
  delete [] xsp;
  delete [] ysp;
  delete [] esp;
  delete [] ysp_v;
  delete [] esp_v;
  return;
}
	
void mirror(const char ans)
{
  extern wback hold_;
  extern Spec_In storage_;

  int grp,grp2;
  int flag=cmdnumber(hold_.is,grp);

  while (!flag || grp<1 || grp>tg)
    {
      char ss[256];
      flag=2;
      sprintf(ss,"Enter template group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;

  if (flag==1) 
    flag=cmdnumber(hold_.is,grp2);
  grp2--;
  while (flag!=1 || grp2<0 || grp2>=tg || grp==grp2)
    {
      flag=1;
      char ss[256];
      sprintf(ss,"Enter grp to rebin =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
      grp2--;
    }

  if (storage_.stpnt[grp2]<1) 
    {
      l_c("No points in group",1);
      return;
    }

  const int n2pts(storage_.stpnt[grp2]);
  double* x2v=storage_.storx[grp2];
  double* y2v=storage_.story[grp2];
  double* e2v=storage_.store[grp2];
  double* xv=new double[n2pts];
  double* yv=new double[n2pts];
  double* ev=new double[n2pts];
  double* yb=new double[n2pts];  //place for spline points
  double* eb=new double[n2pts];  
  for(int i=0;i<n2pts;i++)         //only need spline throught 
    {                              //all of grp2 data.
      xv[i]=x2v[i];
      yv[i]=y2v[i];
      ev[i]=e2v[i];
    }

  int nslp=n2pts;
  spline(xv,yv,&nslp,yb);     
  spline(xv,ev,&nslp,eb);   
  int npts=storage_.stpnt[grp];
  if (ans=='I')
    {
      double *x1v=storage_.storx[grp];
      for(int i=0;i<npts;i++)
	{
	  x2v[i]=x1v[i];
	  y2v[i]=splint(xv,yv,yb,nslp,x1v[i]);
	  e2v[i]=splint(xv,ev,eb,nslp,x1v[i]);
	}
      storage_.stpnt[grp2]=npts;
      return;
    }
  else  //overlap fix
    /* grp2 will == grp2 except where grp1 is in range */
    {
      int count=0;
      double* x1v=storage_.storx[grp];
      //      double* x2s=x2v;
      double* mem_xtemp(0);
      double* xtemp = x2v;   //must be a saved x value
      if (x2v[n2pts-1]>x1v[npts-1])
	{
	  xtemp=new double[n2pts];
	  for(int i=0;i<n2pts;i++)
	    xtemp[i]=x2v[i];
	  mem_xtemp=xtemp;
	}

      while(count++<n2pts && *x1v>*xtemp++);   //n2pts must be < maxpts
      if (count!=n2pts) xtemp--;
      count--;
      //      cout<<"Test a "<<*xtemp<<" "<< *x1v <<" "<<
      //	count<<" "<<storage_.storx[grp2][count]<<endl;
      int g1count=0;     //number of points from grp 1
      int g2count=count; // number of points used from grp2
      while(count<maxpts && g1count<npts)   // grp2 
	{
	  storage_.storx[grp2][count]= *x1v;
	  storage_.story[grp2][count]=
             splint(xv,yv,yb,nslp,*x1v);
	  storage_.store[grp2][count]=(*xtemp<*x1v) ?
             splint(xv,ev,eb,nslp,*x1v) : 0.0;
	  count++;      //another point in grp2
	  x1v++;
	  g1count++;    //one more from grp1
	}
      x1v--;          // make it the last real point
      if (count<maxpts)
	while(*xtemp++ < *x1v && g2count++ <n2pts);

      if (g2count<n2pts)
	xtemp--;
      while(g2count<n2pts && count<maxpts)
	{
	  storage_.storx[grp2][count]= *xtemp++;
	  storage_.story[grp2][count]= yv[g2count];
	  storage_.store[grp2][count]= ev[g2count];
	  count++;
	  g2count++;
	}
      storage_.stpnt[grp2]=count;
      if (mem_xtemp)
	delete [] mem_xtemp;
    }
  delete [] xv;
  delete [] yv;
  delete [] ev;
  delete [] yb;
  delete [] eb;
  return;
}

void cmd_rebin(char ans)
{
  extern wback hold_;
  extern Spec_In storage_;


  if (ans!='I' && ans!='R' && ans!='J' &&
      ans!='P' && ans!='S' && ans!='L' &&
      ans!='G' && ans!='O' && ans!='B')
    {
      char ss[256];
      l_c("Rebin options are --",1);
      l_c("Rebin from template to gp        -- I",1);
      l_c("Rebin with user given ranges     -- R",1);
      l_c("Rebin from template zone and grp -- J",1);
      //      l_c("Average near points in x         -- N",1);
      l_c("Order the data (sort)            -- O",1); 
      l_c("Cut group to selected points     -- P",1);
      l_c("Smooth data with even pt spline  -- S",1);
      l_c("Smooth data with log pt spline   -- L",1);
      l_c("Smooth data with Sav-gold filter -- G",1);
      l_c("Blend data together              -- B",1);
      sprintf(ss,"Enter selection letter =>");
      l_c(ss,0);
      get_first_letter(ans,ss,80);
      if (ans!='I' && ans!='R' && ans!='J' &&
	  ans!='P' && ans!='S' && ans!='L' &&
	  ans!='G' && ans!='O' && ans!='B')
	return;
    }      
      
  if (ans=='I' || ans=='J' )
    {
      mirror(ans);    //Deal with rebinings
      return;
   }
  if (ans=='O') 
    {
      sort();
      return;
    }
  if (ans=='B')
    {
      blend();
      return;
    }
  double *xx;
  double *yy;
  double *ee;

  int grp;
  int flag=cmdnumber(hold_.is,grp);
  while (!flag || grp<1 || grp>tg)
    {
      char ss[256];
      flag=2;
      sprintf(ss,"Enter grp to rebin =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;
  if (ans=='R')
    {
      self_range(grp,flag);
      return;
    }
  if (ans=='P')
    {
      cut_pts(grp,flag);
      return;
    }

  int grp2;

  if (ans=='S' || ans=='L' || ans=='G')
    {
      if (storage_.stpnt[grp]<2) 
	{
	  l_c("No data in group",1);
	  return;
	}

      flag= (flag==1) ? cmdnumber(hold_.is,grp2) : 0;
      while (!flag || grp2<1 || grp2>tg || grp2==grp)
	{
	  char ss[256];
	  flag=2;
	  sprintf(ss,"Enter output grp =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,grp2)) return;
	}
      grp2--;
      if (ans=='G')  //Sav-gold
	{
	  int nmb,ply;
	  if (flag!=2)
	    {
	      flag+=cmdnumber(hold_.is,nmb);
	      if (flag==2) 
		flag+=cmdnumber(hold_.is,ply);
	    }
	  while (flag<3 || ply<1 || ply>=nmb)
	    {
	      flag=3;
	      char ss[256];
	      sprintf(ss,"Enter number points and polynominal power =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,nmb) || !cmdnumber(ss,ply)) return;
	    }
	  smo_savg(grp,grp2,0,ply,nmb);
	  return;
	}

      else if(ans=='S' || ans=='L')   //Spline fits.
	{
	  xx=storage_.storx[grp];
	  yy=storage_.story[grp];
	  ee=storage_.store[grp];
	  int intval;
	  flag= (flag==1) ? cmdnumber(hold_.is,intval) : 0;

	  int npts=storage_.stpnt[grp];
	  while (!flag || intval>=npts )
	    {
	      char ss[256];
	      flag=2;
	      sprintf(ss,"Enter number of intervals =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,intval)) return;
	    }
	  double* tx=new double[intval+2];
	  double* ty=new double[intval+2];
	  double* te=new double[intval+2];
	  double* spl_y=new double[intval+2];
	  double* spl_e=new double[intval+2];
	  double frc;
	  if (ans=='S')
	    {
	      double step=(xx[npts-1]- *xx)/(1.0*intval);
	      int pt=0;
	      tx[0]= *xx;
	      ty[0]= *yy;
	      te[0]= *ee;
	      tx[intval-1]= xx[npts-1];
	      ty[intval-1]= yy[npts-1];
	      te[intval-1]= ee[npts-1];
	      for(int i=1;i<intval-1;i++)
		{
		  tx[i]=*xx+i*step;
		  for(;pt<npts && tx[i]>xx[pt];pt++);
		  if (!pt)
		    {
		      ty[i]=yy[0];
		      te[i]=ee[0];
		    }
		  else if (pt<npts)
		    {
		      frc=(tx[i]-xx[pt-1])/(xx[pt]-xx[pt-1]);
		      ty[i]=frc*yy[pt]+(1.0-frc)*yy[pt-1];
		      te[i]=frc*ee[pt]+(1.0-frc)*ee[pt-1];
		    }
		  else
		    {
		      ty[i]=yy[npts-1];
		      te[i]=ee[npts-1];
		    }
		}
	    }
	  else   //L case
	    {
	      double step=(xx[npts-1]- *xx) /(pow(2.0,intval-1)-1);
	      tx[0]=xx[0];
	      int pt=0;
	      tx[0]= *xx;
	      ty[0]= *yy;
	      te[0]= *ee;
	      tx[intval-1]= xx[npts-1];
	      ty[intval-1]= yy[npts-1];
	      te[intval-1]= ee[npts-1];
	      for(int i=1;i<intval-1;i++)
		{
		  tx[i]=xx[0]+step*(pow(2.0,i)-1.0);
		  cout<<"Tx "<<tx[i]<<endl;
		  for(;pt<npts && tx[i]<xx[pt];pt++);
		  if (!pt)
		    {
		      ty[i]=yy[0];
		      te[i]=ee[0];
		    }
		  else if (pt<npts)
		    {
		      frc=(tx[i]-xx[pt-1])/(xx[pt]-xx[pt-1]);
		      ty[i]=frc*yy[pt]+(1.0-frc)*yy[pt-1];
		      te[i]=frc*ee[pt]+(1.0-frc)*ee[pt-1];
		    }
		  else
		    {
		      ty[i]=yy[npts-1];
		      te[i]=ee[npts-1];
		    }
		}
	    }

	  spline(tx,ty,&intval,spl_y);
	  spline(tx,ty,&intval,spl_e);

	  for(int i=0;i<npts;i++)
	    {
	      storage_.storx[grp2][i]=xx[i];
	      storage_.story[grp2][i]=
		splint(tx,ty,spl_y,intval,xx[i]);
	      storage_.store[grp2][i]=
		splint(tx,te,spl_e,intval,xx[i]);
	    }
	  storage_.stpnt[grp2]=npts;
	  
	  delete [] tx;
	  delete [] ty;
	  delete [] te;
	  delete [] spl_y;
	  delete [] spl_e;
	  return;
	}
      return;
    }
}

void 
find_maxmin(const int grp,double &xmax,double &xmin)
{
  extern Spec_In storage_;
  if (grp<0 || grp>tg || storage_.stpnt[grp]<1)
    {
      xmin=-1;
      xmax=1;
      return;
    }
  double *X=storage_.storx[grp];
  xmin = *X;
  xmax = X[(storage_.stpnt[grp]-1)];
  for(int i=0;i<storage_.stpnt[grp];i++)
    {
      if (*X>xmax)
	xmax= *X;
      else if (*X<xmin)
	xmin= *X;
      X++;
    }
  return;
}
  
void blend()
  /* Job is to reduce a group to a smaller number of point when
     points are very close or identical */
{
  extern wback hold_;
  extern Spec_In storage_;
  
  int grp;
  int flag;
  double tol;
  char ss[256];

  flag=cmdnumber(hold_.is,grp);
  if (flag)
    flag+=cmdnumber(hold_.is,tol);

  while(!flag || grp<1 || grp>tg ||
	storage_.stpnt[grp-1]<2)
    {
      flag=1;
      sprintf(ss,"Grp to blend =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;
  
  double xmin,xmax;
  find_maxmin(grp,xmax,xmin);
  sprintf(ss,"Displacemnt %g",xmax-xmin);
  l_c(ss,1);

  if (flag<2) 
    tol=0.1;
  if (tol>2 || tol<xmin-xmax )
    {
      sprintf(ss,"Percent tolorance (negative for aboolute)");
      l_c(ss,0);
      if (!cmdnumber(ss,tol)) 
	return;
    }
  tol=(tol>0.0) ? (xmax-xmin)*tol/100.0 : -tol;
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  double *E=storage_.store[grp];
  int count=0;
  int pts=1;
  double Wx= *X+tol; //set x tol point 
  double Xc= *X; //set x 
  double Yc= *Y; //set y
  double Ec= *E * *E; //set e 
  for(int i=1;i<storage_.stpnt[grp];i++)
    {
      if (X[i]-tol<=(Xc/pts))
	{
	  pts++;
	  Xc+= X[i];
	  Yc+= Y[i];
	  Ec+= E[i] * E[i];
	  E++;
	}
      else
	{
	  X[count]=Xc/pts;
	  Y[count]=Yc/pts;
	  E[count]=sqrt(Ec)/pts;
	  count++;
	  pts=1;
	  Xc= X[i]; 
	  Yc= Y[i]; 
	  Ec= E[i] * E[i]; 
	}
    }
  //tidy up at the end..
  X[count]=Xc/pts;
  Y[count]=Yc/pts;
  E[count]=sqrt(Ec)/pts;
  count++;
  sprintf(ss,"Merged %d into %d pts",storage_.stpnt[grp],count);
  l_c(ss,1);
  storage_.stpnt[grp]=count;
  return;
}

	  

void sort(const int gp)
{
  extern wback hold_;
  extern Spec_In storage_;

  int grp;
  int flag;
  if (gp>0 && gp<tg) 
    {
      grp=gp;
      flag=1;
    }
  else
    flag=cmdnumber(hold_.is,grp);

  while(!flag || grp<1 || grp>tg)
    {
      char ss[256];
      flag=1;
      sprintf(ss,"Grp to sort =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;
  int inc=1;
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  double *E=storage_.store[grp];
  int j;
  while(inc<=storage_.stpnt[grp])
    {
      inc=1+inc*3;
    }
  double min,miny,mine;
  while(inc>1)
    {
      inc/=3;
      for(int i=inc;i<storage_.stpnt[grp];i++)
	{
	  min=X[i];
	  miny=Y[i];
	  mine=E[i];
	  j=i;

          while(X[j-inc]>min && j>=inc)
	    {
	      X[j]=X[j-inc];
	      Y[j]=Y[j-inc];
	      E[j]=E[j-inc];
	      j-=inc;
	    }
          X[j]=min;
          Y[j]=miny;
          E[j]=mine;
        }
    }
  return;
}
