#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fortran.h"
#include "fglobal.h"


void norm(const char ans)
{
  /*
     Electric complex seperation from E=E' + i E'' into |E| and tan delta
  */
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;

  int grp,grp2,grp3;
  int flag=cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,grp2);
  if (flag==2) flag+=cmdnumber(hold_.is,grp3);
  char ss[255];
  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      sprintf(ss,"Group containing E' =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  flag--;
  while(!flag || grp2>tg || grp2<1)
    {
      flag=1;
      sprintf(ss,"Group containing E'' =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  flag--;
  if(storage_.stpnt[grp-1]!=storage_.stpnt[grp2-1]) 
    {
      l_c("Groups need identical to have numbers of points",1);
      return;
    }
  while(!flag || grp3>tg || grp3<1 || 
         grp3==grp2 || grp3==grp)
    {
      flag=1;
      sprintf(ss,"Normalisation output group =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp3)) return;
    }
  grp--;
  grp2--;
  grp3--;
  double *E1=storage_.store[grp];
  double *E2=storage_.store[grp2];
  if (ans=='S') 
    {
      double px,py,den;
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
          storage_.storx[grp3][i]=storage_.storx[grp][i];
	  px=storage_.story[grp][i];
	  py=storage_.story[grp2][i];
          den=px*px+py*py;
          storage_.story[grp3][i]=sqrt(den);
          storage_.store[grp3][i]=sqrt( (E1[i]*E1[i]*px*px
                            +py*py*E2[i]*E2[i])/den);
          if (grp3<tg-1)
	    {
	      storage_.storx[grp3+1][i]=storage_.storx[grp][i];
	      storage_.story[grp3+1][i]=atan2(py,px);
	      storage_.store[grp3+1][i]=storage_.store[grp3][i];
	    }
        }
      if (grp3<tg-1)
	{
	  storage_.stpnt[grp3+1]=storage_.stpnt[grp];
	  strcpy(about_.hd[grp3+1],"Phase angle ");
	  strncpy(about_.hd[grp3+1]+12,about_.hd[grp],28);
	}
        storage_.stpnt[grp3]=storage_.stpnt[grp];
	strcpy(about_.hd[grp3],"Mag. of ");
	strncpy(about_.hd[grp3]+8,about_.hd[grp],32);
        return;
    }
  double px,py,den;
  for(int i=0;i<storage_.stpnt[grp];i++)
    {
      storage_.storx[grp3][i]=storage_.storx[grp][i];
      px=storage_.story[grp][i];
      py=storage_.story[grp2][i];
      den=px*px+py*py;
      if (den<=0.0) den=1.0;
      storage_.story[grp3][i]=storage_.story[grp2][i]/den;
      storage_.store[grp3][i]=sqrt(E2[i]*E2[i]+
                    (px*px-py*py)*(px*px-py*py)+
		     E1[i]*E1[i]*4.0*px*px)/(den*den);
    }
  storage_.stpnt[grp3]=storage_.stpnt[grp];
  strcpy(about_.hd[grp3],"Imped of ");
  strncpy(about_.hd[grp3]+9,about_.hd[grp],31);
  return;
}


void qspace(char *ans2)
{
  extern wback hold_;
  extern Spec_In storage_;
  static double angle=0.0;
  static double Eo= -1.0;
  static int keV_flag=1;           //0== eV energy , 1 =  KeV energys.

  int grp;
  char ss[256];
  int flag=0;

  if (*ans2=='K') 
    {
      if ((keV_flag=1-keV_flag))
        l_c("Using KeV in Exafs corrections",1);
      else
        l_c("Using eV in Exafs corrections",1);
      return;
    }


  if (!cmdnumber(hold_.is,grp))
    grp=0;

  while (grp<1 || grp>tg) 
    {
      flag=1;
      sprintf(ss,"Which group to be converted =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }
  grp--;

  
  if (*ans2=='X') 
    {
      // k = sqrt(2m(E-E_o)) / h_bar.
      double tEo; 
      if (!flag && cmdnumber(hold_.is,tEo))
	Eo=tEo;
      while (Eo < -0.001 || Eo>100000.0) 
	{
	  if (keV_flag)
	    sprintf(ss,"Enter E zero (KeV) =>");
	  else
	    sprintf(ss,"Enter E zero (eV) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,Eo)) return;
	}
      sprintf(ss,"Eo is %g",Eo);
      l_c(ss,1);  
      
      
      const double scale((!keV_flag) ? 0.5123147 : 16.200815); 
      if (keV_flag)
	l_c("Using keV values ",1);
      else
	l_c("Using eV values ",1);

      double Ediff;
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  Ediff=storage_.storx[grp][i]-Eo;
	  if (Ediff>0.0)
	    Ediff=sqrt(Ediff);
	  else
	    Ediff= -1.0 * sqrt( -Ediff );
	  storage_.storx[grp][i]=scale * Ediff;
	}
      return;
    }

  if (*ans2=='B') 
    {
      // k = sqrt(2m(E-E_o)) / h_bar.
      double tEo; 
      if (!flag && cmdnumber(hold_.is,tEo))
	Eo=tEo;
      while (Eo < -0.001 || Eo>100000.0) 
	{
	  if (keV_flag)
	    sprintf(ss,"Enter E zero (KeV) =>");
	  else
	    sprintf(ss,"Enter E zero (eV) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,Eo)) return;
	}
      sprintf(ss,"Eo is %g",Eo);
      l_c(ss,1);  
      
      double scale((!keV_flag) ? 0.5123147 : 16.200815); 
      scale*=scale;
      double kval;
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  kval=storage_.storx[grp][i];
	  if (kval>0.0)
	    kval*=kval/scale;
	  else
	    kval*= -1.0 * kval/scale;
	  storage_.storx[grp][i]=kval+Eo;
	}
      return;
    }

  if (*ans2=='L') 
    {
      // Convert Energy -- Lambda
      if (keV_flag)
	l_c("Using keV energy scale",1);
      else
	l_c("Using eV energy scale",1);
      double scale((!keV_flag) ? 12398.52066 : 12.39852066 ); 
      double *X=storage_.storx[grp];
      double *Xs=storage_.storx[grp];
      double *Y=storage_.story[grp];
      double *Ys=storage_.story[grp];
      double *E=storage_.store[grp];
      double *Es=storage_.store[grp];
      Xs += (storage_.stpnt[grp]-1);
      Ys += (storage_.stpnt[grp]-1);
      Es += (storage_.stpnt[grp]-1);
      for(;Xs>=X;Xs--,X++)
	{
	  double temp = scale / *X;
	  *X = scale / *Xs;
	  *Xs = temp;
	  temp = *Ys;
	  *Ys-- = *Y;
	  *Y++ = temp;
	  temp = *Es;
	  *Es-- = *E;
	  *E++ = temp;
	}
      if (Xs==X)  //if odd number of points.
	{
	  *Xs = scale / *Xs;
	  *Ys = scale / *Ys;
	  *Es = scale / *Es;
	}
      return;
    }

  if (*ans2=='E' || *ans2=='Q') 
    {
      double t_angle;     //temp angle
      if (!flag && cmdnumber(hold_.is,t_angle))
        angle=t_angle;
      while (angle<0.01 || angle>180.0) 
	{
          sprintf(ss,"Enter Angle =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,angle)) return;
	}
      sprintf(ss,"Angle is %g",angle);
      l_c(ss,1);
	
      angle *=  pi / 360.0 ; // Artifical divide by 2.
      double Sang=sin(angle);
      double sub;
      double step,step2,tp;
      if (*ans2=='E') 
	{
	  sub=1.30631046e-4/(Sang * Sang);
	  for(int i=1;i<storage_.stpnt[grp]-2;i++)
	    {
	      if (storage_.storx[grp][i]>0.0) 
		{
		  step=(storage_.storx[grp][i+1]-
			storage_.storx[grp][i-1])/2.0;
		  step2=storage_.storx[grp][i+1]+storage_.storx[grp][i];
		  step2*=step2;
		  tp=storage_.storx[grp][i-1]+storage_.storx[grp][i];
		step2+=tp*tp;
		if (step2)
		  {
		    storage_.story[grp][i]*= step/(sub*step2);
		    storage_.store[grp][i]*= step/(sub*step2);
		  }
		}
	    }
	  double lam;
	  for (int i=0;i<storage_.stpnt[grp];i++)
	    {
	      if (storage_.storx[grp][i]>0.0) 
		{
		  lam=4.0 * pi * Sang/ storage_.storx[grp][i];
		  storage_.storx[grp][i]=0.082513712/(lam*lam);
		}
	  }
	  angle*=360.0 / pi;
	  return;
	}
      else
	{
	  sub=Sang * Sang * 30.93369533;
	  for(int i=1;i<storage_.stpnt[grp]-2;i++)
	    {
	      if (storage_.storx[grp][i]>0.0) 
		{
		  step=(storage_.storx[grp][i+1]-
		       storage_.storx[grp][i-1])/2.0;
		  step2=sqrt(storage_.storx[grp][i+1]+
			     storage_.storx[grp][i])-
		         sqrt(storage_.storx[grp][i-1]+
			    storage_.storx[grp][i]);
		  if (step2)
		    {
		      storage_.story[grp][i]*= step/(sub*step2);
		      storage_.store[grp][i]*= step/(sub*step2);
		    }
	       }
	    }
	  for (int i=0;i<storage_.stpnt[grp];i++)
	    {
	      if (storage_.storx[grp][i]>0.0) 
		storage_.storx[grp][i]=4 * pi * Sang * 
		  sqrt(storage_.storx[grp][i])/0.287252;
	    }
	  angle*=360.0 / pi;
	  return;
	}
    }
  double lambda;
  if (!flag && !cmdnumber(hold_.is,lambda))
    lambda= -1.0;
  while (lambda<1e-5 || lambda>100.0) 
    {
      sprintf(ss,"Enter Lambda =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lambda)) return;
    }
  
  sprintf(ss,"Lambda == %g",lambda);
  l_c(ss,1);
  
  double temp;     // allow large Q conversions
  int add;      
  
  if (*ans2!='W')
    {
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  storage_.storx[grp][i]=(4.0/lambda) * pi *
	    sin(storage_.storx[grp][i] * pi / 360.0);
	}
    }
  else
    {
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  temp=storage_.storx[grp][i] * lambda / (4.0 * pi);
	  add=int(temp) * 180;
	  temp -= int(temp);
	  storage_.storx[grp][i]= (360.0/pi) * asin(temp)+add;
	}
    }
  return;
}

void
window_func(char *a)
  /* Applies window function to the data 
    if a= V then you can use scale factor to the windowing parameter
  */
{
  extern Spec_In storage_;
  extern wback hold_;
  extern titls about_;
  
  int flag;
  int grp,spt,ept;
  double add;
  char ss[256];
  flag=cmdnumber(hold_.is,grp);
  flag+=cmdnumber(hold_.is,spt);
  flag+=cmdnumber(hold_.is,ept);
  flag+=cmdnumber(hold_.is,add);
  while (!flag || grp<1 || grp>tg) 
    {
      flag=1;
      sprintf(ss,"Which group to be windowed =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }
  grp--;
  while(flag<2 || spt<1 || spt>storage_.stpnt[grp])
    {
      flag=2;
      sprintf(ss,"Total points = %d ",storage_.stpnt[grp]);
      l_c(ss,1);
      sprintf(ss,"Enter window start point =>");
      l_c(ss,0);
      if(!cmdnumber(ss,spt)) return;
    }

  while(flag<3 || ept<1 || ept>storage_.stpnt[grp])
    {
      flag=3;
      sprintf(ss,"Total points = %d ",storage_.stpnt[grp]);
      l_c(ss,1);
      sprintf(ss,"Enter window end point =>");
      l_c(ss,0);
      if(!cmdnumber(ss,ept)) return;
    }
  if (spt==ept) 
    return;
  spt--;
  ept--;
  if (flag!=4) add=0.0;
  int step= (ept>spt) ? 1 : -1;
  int diff=step * (ept-spt);
  
  if (*a=='V') 
    {
      while(flag<4 || add<=0.0 || add>1.0)
	{
	  flag=3;
	  sprintf(ss,"Enter scale factor (0.0 <s< 1.0) =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,add)) return;
	}
      double scale;
      for(int i=0;i<diff;i++)
	{
	  int j=spt+(step*i);
	  scale=1.0-add*(1.0-cos(pi_by_2*i/diff));
	  storage_.story[grp][j]*=scale;
          storage_.store[grp][j]*=scale;
	}
      if (step == -1)
	{
	  for(int i=ept;i>=0;i--)
	    {
	      storage_.story[grp][i]*=1.0-add;
	      storage_.store[grp][i]*=1.0-add;
	    }
	}
      else
	{
	  for(int i=ept;i<storage_.stpnt[grp];i++)
	    {
	      storage_.story[grp][i]*=1.0-add;
	      storage_.store[grp][i]*=1.0-add;
	    }
	}
      return;
    }
  else
    {
      double scale;
      for(int i=0;i<diff;i++)
	{
	  int j=(step*i)+spt;
	  scale = cos(pi_by_2*i/diff);
	  storage_.story[grp][j]=add+
	    (storage_.story[grp][j]-add) * scale;  
	  storage_.store[grp][j]*=scale;
	}
    }
  if (step == -1)
    {
      for(int i=ept;i>=0;i--)
	{
          storage_.story[grp][i]=add;
	  storage_.store[grp][i]=0.0;
        }
    }
  else
    {
      for(int i=ept;i<storage_.stpnt[grp];i++)
	{
          storage_.story[grp][i]=add;
	  storage_.store[grp][i]=0.0;
	}
    }
  if(!check_string(about_.hd[grp],"Win",40,3))
    {
      for(int i=39;i>=4;i--)
        about_.hd[grp][i]=about_.hd[grp][i-4];
      strncpy(about_.hd[grp],"Win ",4);
    }
  return;
}


void
smoof()
  /* 
     Function to do an AKS smoothing of the data n_smo times.
   */
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;

  int grp,n_smo;
  int flag=cmdnumber(hold_.is,grp); 

  while (!flag || grp<1 || grp>tg)
    {
      char ss[256];
      flag=2;
      sprintf(ss,"Grp to smooth =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return;
    }    
  grp--;
  int npts=storage_.stpnt[grp];
  if (npts<1) 
    {
      l_c("No points in group",1);
      return;
    }

  flag = (flag!=2) ? cmdnumber(hold_.is,n_smo) : 0;

  while (!flag || n_smo<1 || n_smo>npts)
    {
      char ss[256];
      flag=2;
      sprintf(ss,"Number of smoothings =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,n_smo,255)) return;
    }    

  double sf,sm,se;
  double ef,em,ee;
  double *Yv=storage_.story[grp];
  double *Ev=storage_.store[grp];

  for(int i=0;i<n_smo;i++)
    {
      sf= *Yv;
      ef= *Ev;
      ef*= ef;
      sm=sf;
      em=ef;
      for(int j=1;j<npts;j++)
	{
          se= Yv[j];
          ee= Ev[j];
	  ee*=ee;
          Yv[j-1]=0.25*(sf+sm+sm+se);
          Ev[j-1]=0.25*sqrt(ef+em+em+ee);
          sf=sm;
          sm=se;
	  ef=em;
	  em=ee;
        }
      Yv[npts-1]=0.25*(sf+3.0*sm);
      Ev[npts-1]=0.25*sqrt(ef+3.0*em);
    }

  if(!check_string(about_.hd[grp],"Smoof",40,5))
    {
      for(int i=39;i>=6;i--)
        about_.hd[grp][i]=about_.hd[grp][i-6];
      strncpy(about_.hd[grp],"Smoof ",6);
    }
  return;
}

void endby()
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  
  char ss[256];
  int flag=0;
  int grp;

  if (!cmdnumber(hold_.is,grp))
    grp=0;
  while (grp<1 || grp>tg)
    {
      flag=1;
      sprintf(ss,"Grp to place Endby fit =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return;
    }    
  grp--;
  double cond;
  if (flag || !cmdnumber(hold_.is,cond))
    cond= -1.0;
  while (cond<=0)
    {
      flag=1;
      sprintf(ss,"Enter the conductivity =>");
      l_c(ss,0);
      if (!cmdnumber(ss,cond,255)) return;
    }

  double a;
  if (flag || !cmdnumber(hold_.is,a))
    a= -1.0;
  while (a<0)
    {
      flag=1;
      sprintf(ss,"Enter the radius =>");
      l_c(ss,0);
      if (!cmdnumber(ss,a,255)) return;
    }

  double q;
  if (flag || !cmdnumber(hold_.is,q))
    q= -1.0;
  while (q<0)
    {
      flag=1;
      sprintf(ss,"Enter the Q factor =>");
      l_c(ss,0);
      if (!cmdnumber(ss,q,255)) return;
    }

  double fill;
  if (flag || !cmdnumber(hold_.is,q))
    fill= -1.0;

  while (fill<0)
    {
      flag=1;
      sprintf(ss,"Enter the fill factor =>");
      l_c(ss,0);
      if (!cmdnumber(ss,fill,255)) return;
    }
  
  double sw,ew;
  if (flag || !cmdnumber(hold_.is,sw) || !cmdnumber(hold_.is,ew))
    {
      sw= -0.1;
      ew= -0.1;
    }
  while (sw<0 || ew<0 || sw>=ew)
    {
      flag=1;
      sprintf(ss,"Enter the omega min and max=>");
      l_c(ss,0);
      if (!cmdnumber(ss,sw) || !cmdnumber(ss,ew)) 
	return;
    }

  sw*=2.0*pi;
  ew*=2.0*pi;     
  double stepw=(ew-sw)/(maxpts-1);
  double w,d,alpha;
  for(int i=0;i<maxpts;i++)
    {
      w=sw+(i*stepw);
      d=sqrt((2.0/(w*cond*1.256637061e-6)));
  /*           hold=(2.*a/d)
           alpha=(a/d)*(sinh(hold)+sin(hold))/(cosh(hold)-cos(hold))
           alpha=9.0*d**2/(16.0*pi*a**2)*(1.0-alpha)
           dq=q*fill*alpha*100
  */
        alpha=2.28558e-5*(pow(1.0/d,3));
        alpha=(1./(20.0*pi))*(pow(a/d,3));
	//          alpha=(9.0/(16*pi))*(d/a)
        storage_.storx[grp][i]=pi*w/2.0;
        storage_.story[grp][i]=alpha;
        storage_.store[grp][i]=0.0;
    }
  storage_.stpnt[grp]=maxpts;
  return;
}
 









