#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include "fglobal.h"
         
poly::poly(const double* xx,double* yy,
	   const int npts,const int pp) : x(xx),y(yy)
{
  polyn= pp;
  if (npts>0)
    {
      yfit=new double[npts];
      npt= npts;
    }
  else
    npt=0;
  
}

poly::~poly()
{
  delete [] yfit;
}


void 
poly::chebypol() 
{
  double *coef = new double [(npt/2)+1];      
  if (!coef) error("Sorry, no space for chebypol::coef");

  chebft(coef);
  chebev(coef);
  for (int i=0;i<npt;i++)
    y[i]=yfit[i];
  delete [] coef;

  return;
}  
   
    
void poly::chebev(double *c) const
{
  double d=0.0,dd=0.0,sv,yy,y2;
  int j;
  double a=x[0];
  double b=x[npt-1];
   
  for(int i=0;i<npt;i++)
    {
      y2=2.0*(yy=(2.0 * x[i]-(a+b))/(b-a));
      for (j=polyn-1;j>=1;j--)
	{
	  sv=d;
	  d=y2 * d-dd+c[j];
	  dd=sv;
	}
      yfit[i] = yy * d - dd + 0.5 * c[0];
      dd=0.0;
      d=0.0;
    }

  return;
}


void poly::chebft(double *c) const
  //   
  //   n= number of c_j to calculate and *c is space for them ??
  //
{
     
  if (npt<2) return;
  int rpts=npt/2;
   
  double fac;
  double bpa=0.5 * (x[npt-1]+x[0]);
  double bma=0.5 * (x[npt-1]-x[0]);
  double *f=new double[rpts];
  if (!f) error("Not enough room for the chebft f");

  double y;

  for (int k=0;k<rpts;k++)
    {
      y=cos(pi * (k+0.5)/rpts);
      f[k] = fit(y*bma+bpa);
    }
  fac=2.0/rpts;
  double sum; 
  for (int j=0;j<rpts;j++)
    {
      sum=0.0;
      for (int k=0;k<rpts;k++)
	sum += f[k] * cos(pi* j * (k+0.5)/rpts);
      c[j]=fac*sum;
    }
  delete[] f;
  return;
}
    
  
double poly::fit(double point) const
{
  if (point<=x[0]) return y[0];
  if (point>=x[(npt-1)]) return y[(npt-1)];
  int j=npt;
  int jl=0;
  int jm;

  do 
    {
      jm=(j+jl)/2;
      (point>x[jm]) ? jl=jm : j=jm;
    } while((j-jl)>1);
     
  if (jl<1) jl=1;
  if (jl>npt-2) jl=npt-2;
  return polint(x+jl-1,y+jl-1,3,point);
}
               

/*    
      //
      //   NUMBERED LIST CLASS
      //


      template<class T>      
      class numb_list   //This is an index 
      {
      private:
      

      int max_cont;
      int cont;    //number of members
      int* index;   // place for our index 
      T** item;      // array of items that are pointed to by 
      // the index ie item[i]== the ith item
      int in_list(const int) const;

      public:
     
      int push(const int,const int,T&);
      int remove(const int);
      void swap(int,int);
      T& get(const int) const;
      virtual ~numb_list();
      numb_list(int=1);         //passes the number of relations
      numb_list(const numb_list<T>&);   //copy constructor

      };

      template<class T>
      int numb_list<T>::in_list(const int a) const
      {
      for (int i=0;index[i]!=a && i<cont;i++)
      if (i==cont) return 0;
      return i;
      }


      template<class T>
      numb_list<T>::numb_list(const numb_list<T>& A)
      {
      max_cont=A.max_cont;
      cont=A.cont;
      if (max_cont>0) 
      {
      item=new T*[cont];
      index=new int[cont];
      if (!index) 
      {
      if (item) delete [] item;      //Better clear up the mess!
      throw NoMem("numb_list::copy:index");
      }
      }
      for(int j=0;j<cont;j++)
      {
      index[j]=A.index[j]; 
      item[j]=new T(*A.item[j]);
      }
      }    
  

      template<class T>
      void numb_list<T>::swap(int a,int b)
      {
      if (a==b) return;
      for (int i=0;index[i]!=a && index[i]!=b && i<cont;i++);
      int sw1=i;
      if (index[i]==a) 
      {
      for (;index[i]!=b && i<cont;i++);
      if (i==cont) return;
      index[i]=a;
      index[sw1]=b;
      }  
      else
      {
      for (;index[i]!=a && i<cont;i++);
      if (i==cont) return;
      index[i]=b;
      index[sw1]=a;
      }
      return;
      }
 
      template<class T>
      numb_list<T>::numb_list(int a) : max_cont((a>1) ? a:1),cont(0),index(0),
      item(0) 
      {
      item=new T*[max_cont];
      index=new int[cont];
      if (!index) 
      {
      if (item) delete [] item;      //Better clear up the mess!
      throw NoMem("numb_list::list:index");
      }
      }


      template<class T> 
      int numb_list<T>::push(const int a,T& in)
      {

      //returns 0 if this is unsuccessful, ie we have seen this item before.

      if (!in_list(a)) return 0;
      if (max_cont==cont)     //Time for some new space!   
      {
      int* temp_i=new int[2*max_cont];
      T** temp=new T*[2*max_cont];
      if (!temp) throw NoMem("numb_list::push:temp"); 
      for (int i=0;i<max_cont;i++)
      {
      temp[i]=item[i];
      temp_i[i]=index[i];
      }
      for (;i<2*max_cont;i++)
      {
      temp[i]=0;
      temp_i[i]=0;
      }
      delete [] item;
      delete [] index; 
      item=temp;
      index=temp_i;
      max_cont*=2;
      } 
      cont++;
      item[cont]=new T(in);
      if (!(*item[cont])) 
      { 
      cont--;                             //WARNING:Should throw a reduced
      throw NoMem("Numb_list::new item");     // sub-class item.
      }                                         
      index[cont]=a;
      return a;
      }

      template<class T>
      int numb_list<T>::remove(const int a)     //Actually REMOVE an item
      {                                 
      if (cont<1) return 0;
      for (int i=0;a!=index[i] && i<cont;i++)
      if (i==cont) return 0;
      delete [] item[i];
      cont--;
      for (int j=i;j<cont;j++)
      {
      index[j]=index[j+1];
      item[j]=item[j+1];
      }
      return 1;
      }

      template<class T>
      T& numb_list<T>::get(const int a) const  
      {                       //Just get an item leave list as is
      if (cont<1) return T(0);
      for (int i=0;a!=index[i] && i<cont;i++);
      if (i==cont) return T(0);
      return *item[i];
      }
     
      template<class T>  
      virtual numb_list<T>::~numb_list()
      {
      for (int i=0;i<cont;i++)
      delete [] item[i];
      delete [] item; 
      delete [] index;    //Note: it is not our job to delete 
      }
      */

//   template class vector<my_pair<int,int> >;
//   template class my_stack<intep_box * >;
//   template class vector<intep_box* >;

