#ifndef poly2_h
#define poly2_h

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <utility>
#include <stdio.h>
#include <stdlib.h>
#include "fglobal.h"
#include "wshare.h"

#define sign(a) ((a)>0 ? 1 : -1)

class intep_box;
class intep;
class fit_param;
           
void do_fit(Widget,XtPointer,XtPointer);
void new_string(Widget,XtPointer,XtPointer);
     
class str_make
{
 private:
   
 public:
      
  str_make(char* =0) {;}
 
};
//  op_code = 1,2,3,4,5  + - * / ^       
//  type 1=const, 2=DATA_X, 3=DATA_Y -1 = data_from field
//   if function op_code == offset on function call.

class intep_box
{
 private:
           
  int a_type;    // 0=ptr, 1=X[op_code], 2=y[op_code] 3=const;       
  const double K;      // number.
  const int op_code;   // primary attactchment type or grp 1-40 etc. 
  const intep_box* A;  // Then next box that it is attached to.
  const intep_box* B;  //     
  const fit_param* C; 
            
 public:
          
  intep_box(const intep_box*,const intep_box*,const int);
  intep_box(const int,const int,const int =0);
  intep_box(const double=0);
  intep_box(const intep_box*,const int);
  intep_box(const int,const fit_param*,const int minus =0);
         
  ~intep_box();
  double intepY(const double,const int,const int) const;
  double value(const int,const int) const; // evaluate box at point 1-xx 
                                           // if 0 return 1
                                          // if evaluatable and 1 if not.
          
};
          
class intep
{    

public:
     
  fit_param cnt;       //parameters for the fit. 

private:
     

  int con_dep;                 //does the function depend on c,xy or grp
  //informaion.
  int vc;                         // number of items in vector list_items
  std::vector<intep_box*> list_items;  //This is a vector of the resolved brackets.
  
  intep_box* chain;          //Top of the chain of intep_box    
  int prep_string(char*,int); 
  void clean_boxes();        // destrop memory for intep_box.
  void clear_dep() {con_dep=0; }
  intep_box* subbrack(const string&); //STRING REPLACEMENT
  intep_box* eval_unit(string&);        //STRING REPLACEMENT
  int isfunc(const string&,int&) const;  //STRING REPLACEMENT
  void setbox();  //job is to set the static param table
  int print_flag();   // Ask user for the flag setings 
  int grpString(const string&) const;

public:

  intep(); 
  ~intep();
  void set_const(double *,const int);
  int make_list(const char* =0);
  int makeList(const char* =0);  //string replacement for make_list
  int made() const {return (chain ? 1 :0);}
  double point(const int,const int=0) const;    //returns the value at 
                                                    // a specific point
  
  void set_points(int=-1,int=-1) const; //sets grp2 to the to output
  // of the function,grp is the x image.        
  double chi();
  double chi(const double*);
};
 

#endif






