#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "outinfo.h"
#include "cmd.h"
#include "fglobal.h"
#include "extract.h"

extern outinfo wrtout;

void output_cont(char *a)
{
  extern wback hold_;

  if (*a=='W')
    {
      char ss[255];
      strncpy(ss,hold_.is,80);
      ss[80]=0;
      wrtout.file_control(ss,10);
    }

  if (*a=='L')   //set level
    {
      int lvl;
      if (!cmdnumber(hold_.is,lvl))
	lvl = 1;
      while(lvl<0 && lvl>2)
	{
	  char ss[255];
	  sprintf(ss,"Input level of file output (0:1:2) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,lvl)) return;
	}
      wrtout.setlevel(lvl);
      return;
    }
  if (*a=='C')    //close
    {
      wrtout.closeF();
      return;
    }

  if (*a=='F' || *a=='N')    //new and file open
    {
      char nam[256];
      int flg,oflg;
      if (*a!='N')
	{
	  if (!cmdnumber(hold_.is,flg)) 
	    flg=0;
	  while(flg< 0 && flg>1)
	    { 
	      char ss[255];
	      sprintf(ss,"Flag for appending or creating file (0:1) =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,flg)) return;
	    }
	}
      else
	flg=1;
      extractfile(nam,hold_.is,80);
      if (strlen(nam) < 3 )
	oflg=wrtout.setfile();
      else
	oflg=wrtout.setfile(nam,flg);
      if (oflg)
	l_c("Error opening file",1);
      return;
    }
  return;

}

outinfo::outinfo() : valid(0),level(2)
{}

outinfo::~outinfo() 
{
  if (Fout)
    Fout.close();
}

int
outinfo::cur_level() const
{
  if (level == -1) 
    return 2;
  if (level == 2) 
    return 1;
  if (level == 4)
    return 0;
  return -1;
}

void 
outinfo::setlevel(const int a)
{
  if (a==2)
    level= -1;
  else if (a==1)
    level=2;
  else if (!a)
    level=4;
  return;
}

void
outinfo::closeF()
{
  valid=0;
  Fout.close();
  return;
}

int
outinfo::setfile(const char *tname,const int flag)
{
  if (valid || Fout)
    {
      valid=0;
      Fout.close();
    }
  const char *afname = (!tname) ? fname.c_str() : tname;
  if (!flag)
    Fout.open(afname,ios::app|ios::out);
  else if (flag==1)
    Fout.open(afname,ios::out);
  else
    return 1;
  
  if (!(Fout))
    {
      valid=0;
      return 2;
    }
  valid=1;
  if (tname)
    {
      fname = tname;
    }
  return 0;
}


void 
outinfo::file_control(const char *s,const int ctl)
{
  if (valid &&  ctl>level)
    Fout<<s<<endl;
  return;
}
  


