#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "extract.h"
#include "cmd.h"
#include "fortran.h"

void transf(char *A,int *grpA,int *grpB)
  /* Handle the fourier transforms */
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  static double conc=0.0;
  static int req_leng=4000;
  int grp,grp2;
  char third;
  get_first_nonumb(third,hold_.is,80);  

  if (*A=='D')   //Deal with differentuation seperately
    {
      derivative();
      return;
    }

  char ss[256];
  int flag=cmdnumber(hold_.is,grp);
  if (flag)
    flag+=cmdnumber(hold_.is,grp2);
  int hflag=flag;
  while(!flag || grp>tg || grp<1  || storage_.stpnt[grp-1]<2 )
    {
      flag=1;
      strcpy(ss,"Grp to transform =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    

  while(flag<2 || grp2>tg || grp2<1  || grp2==grp)
    {
      flag=2;
      strcpy(ss,"Grp place transform =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp2))  return;
    }

  grp--;
  grp2--;

  if (*A=='L')  // Laud transform. 
    {
      int max;
      double prob;
      period(grp,grp2,max,prob);
      return;
    }
  if (*A=='K')
    {
      /* Kramers-Kronig equation and transform */
      double* Q=storage_.storx[grp];
      double* S=storage_.story[grp];
      double* epts=storage_.store[grp];

      double* R=storage_.storx[grp2];
      double* Y=storage_.story[grp2];
      double* E=storage_.store[grp2];
      const int ftpt(storage_.stpnt[grp]);
      double* stepA= new double[ftpt];
      double* Qval = new double[ftpt];
      stepA[0]=fabs(Q[1]-Q[0]);
      for(int i=1;i<ftpt-1;i++)
	stepA[i]=fabs((Q[i+1]-Q[i-1])/2.0);
      if (ftpt>1)
	stepA[ftpt-1]=Q[ftpt-1]-Q[ftpt-2];
      double w2,wp2;
      //optimizations.....
      for(int i=0;i<ftpt;i++)  
	{
	  Qval[i]=Q[i]*Q[i];
	  stepA[i]*=Qval[i];  //pre mult by Q*Q
	}
      //main loop....
      double mval;  //temp. var.
      for(int i=0;i<ftpt;i++)     
	{
	  *R++ =Q[i];
	  *Y = 0.0;
	  *E = 0.0;
	  w2=Qval[i];
	  for(int j=0;j<ftpt;j++)   //q loop
	    {
	      if (j!=i)
		{
		  wp2=Qval[j];
		  mval=stepA[j]/(wp2-w2);
		  *Y +=mval*S[j];
		  *E +=mval*mval*epts[j]*epts[j];
		  // Y[i]+=(wp2*S[j]*stepA[j])/(wp2-w2);
		}
	    }
	  *E++ = sqrt(*E) / (-pi_by_2 * Q[i]);  //Do this later....
	  *Y++ /= -pi_by_2 * Q[i];
	}
      delete [] stepA;
      delete [] Qval;
      storage_.stpnt[grp2]=ftpt;
      return;
    }
  
  if (*A=='T' || *A=='F')
    {
      if (hflag!=2 || !cmdnumber(hold_.is,conc) 
	  || !cmdnumber(hold_.is,req_leng))
	req_leng=storage_.stpnt[grp];
      int long_length=4;
      if (req_leng<storage_.stpnt[grp])
	req_leng = storage_.stpnt[grp];
      
      for(;long_length<req_leng;long_length<<=1);
      if (long_length<=4) 
	{
	  l_c("Insufficient points in input grp for transform",1);
	  return;
	}

      const double 
	qstep=((storage_.storx[grp][storage_.stpnt[grp]-1]
	      -storage_.storx[grp][0])
	      /(storage_.stpnt[grp]-1.0));
      
      const int ftpt(storage_.stpnt[grp]);
      const int stpt((long_length<maxpts) ? long_length : maxpts);

      const double rstep = pi / (stpt * qstep);
      sprintf(ss,"Q-Step : %g R-step %g Number Density %g",qstep,rstep,conc); 
      l_c(ss,1);

      double *Sq=storage_.story[grp];
      double *epts=storage_.store[grp];
      double *Q=storage_.storx[grp];
      double *R=storage_.storx[grp2];
      double *Y=storage_.story[grp2];
      double *E=storage_.store[grp2];
      for(int i=0;i<stpt;i++)
	{
	  R[i]=(0.5+i)*rstep;
	  Y[i]=0.0;
	  E[i]=0.0;
	}
      //delta Q == tstep
      double Qr;
      const double ts2(rstep*rstep);
      for(int i=0;i<stpt;i++)     //r loop
	for(int j=0;j<ftpt;j++)   //q loop
	  {
	    Qr = Q[j]*R[i];
	    Qr = sin(Qr);
	    Y[i]+=Sq[j] * Qr * qstep;
	    E[i]+=ts2*Qr*Qr*epts[j]*epts[j];
	  }
	
      double rr2;
      for(int i=0;i<stpt;i++)
	{
	  rr2=R[i]*pi2*conc*pi;
	  Y[i]/= 1.0;   //rr2
	  E[i]=sqrt(E[i])/1.0;  ///rr2;
	}
      storage_.stpnt[grp2]=stpt;
      return;
    }

  if (*A=='E')
    {
      if (hflag!=2 || !cmdnumber(hold_.is,conc) 
	  || !cmdnumber(hold_.is,req_leng))
	req_leng=storage_.stpnt[grp];
      while (conc<0.0001 || conc>100)
	{
	  strcpy(ss,"Enter the number density =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,conc))  return;
	}
      int long_length=4;
      if (req_leng<storage_.stpnt[grp])
	req_leng = storage_.stpnt[grp];
      
      for(;long_length<req_leng;long_length<<=1);
      if (long_length<=4) 
	{
	  l_c("Insufficient points in input grp for transform",1);
	  return;
	}

      const double 
	qstep=((storage_.storx[grp][storage_.stpnt[grp]-1]
	      -storage_.storx[grp][0])
	      /(storage_.stpnt[grp]-1.0));
      
      const int ftpt(storage_.stpnt[grp]);
      const int stpt((long_length<maxpts) ? long_length : maxpts);

      const double rstep = pi / (stpt * qstep);
      sprintf(ss,"Q-Step : %g R-step %g Number Density %g",qstep,rstep,conc); 
      l_c(ss,1);

      double *Sq=storage_.story[grp];
      double *epts=storage_.store[grp];
      double *Q=storage_.storx[grp];
      double *R=storage_.storx[grp2];
      double *Y=storage_.story[grp2];
      double *E=storage_.store[grp2];
      for(int i=0;i<stpt;i++)
	{
	  R[i]=(0.5+i)*rstep;
	  Y[i]=0.0;
	  E[i]=0.0;
	}
      //delta Q == tstep
      double Qr;
      const double ts2(rstep*rstep);
      for(int i=0;i<stpt;i++)     //r loop
	for(int j=0;j<ftpt;j++)   //q loop
	  {
	    Qr = Q[j]*R[i];
	    Qr = sin(Qr);
	    Y[i]+=Q[j] * Sq[j] * Qr * qstep;
	    E[i]+=ts2*Q[j]*Q[j]*Qr*Qr*epts[j]*epts[j];
	  }
	
      double rr2;
      for(int i=0;i<stpt;i++)
	{
	  rr2=R[i]*pi2*conc*pi;
	  Y[i]/=rr2;
	  E[i]=sqrt(E[i])/rr2;
	}
      storage_.stpnt[grp2]=stpt;
      return;
    }
  if (*A=='B' || *A=='H' || *A=='G')  //back EXAFS transform
    {

      double lstep=0.05;      //change these later.
      int ilstep=800;
      const int stpt(storage_.stpnt[grp]);
      double *ypts=storage_.story[grp];
      double *xpts=storage_.storx[grp];
      double *fspace=storage_.story[grp2];
      double *ys=new double[1000];
      double *yc=new double[1000];
      double *sides=new double[stpt];
      double xvp;
      sides[0]=ypts[0] * (xpts[1]-xpts[0]) * (pi * pi)/ 2.0 ;
      sides[stpt-1]= ypts[stpt-1] * (xpts[1]-xpts[0]) * (pi*pi) / 2.0;
      for (int i=1;i<storage_.stpnt[grp]-1;i++)
	sides[i]=0.25 * ypts[i] * (xpts[i+1] - xpts[i-1]) * (pi * pi);
      for(int i=0;i<1000;i++)
	ys[i]=yc[i]=0.0;

      double rval;
      for(int i=0;i<ilstep;i++)
	{
	  rval=i * lstep;
	  storage_.storx[grp2][i]=rval/2.0;
	  storage_.store[grp2][i]=0.0;
	  for(int j=0;j<stpt;j++)
	    {
	      xvp= xpts[j] * rval;
	      ys[i]+= sides[j] * sin(xvp);
	      yc[i]+= sides[j] * cos(xvp);
	    }
	  fspace[i]=sqrt(ys[i]*ys[i]+yc[i]*yc[i]);
	}
      storage_.stpnt[grp2]=ilstep;
      if (*A=='G')
	for(int i=0;i<ilstep;i++)
	  fspace[i]=ys[i];
      else if (*A=='H')
	for(int i=0;i<ilstep;i++)
	  fspace[i]=yc[i];
      delete [] sides;
      delete [] ys;
      delete [] yc;
      return;
    }


  if (*A=='X' || *A=='S' || *A=='C')
    {
      double lstep=0.025;      //change these later.
      int ilstep=400;
      const int stpt(storage_.stpnt[grp]);
      double *ypts=storage_.story[grp];
      double *xpts=storage_.storx[grp];
      double *fspace=storage_.story[grp2];
      double *ys=new double[1000];
      double *yc=new double[1000];
      double *sides=new double[stpt];
      double xvp;
      sides[0]=ypts[0] * (xpts[1]-xpts[0]) / (2.0 * pi * pi);
      sides[stpt-1]= ypts[stpt-1] * (xpts[1]-xpts[0]) /(2.0 * pi * pi);
      for (int i=1;i<storage_.stpnt[grp]-1;i++)
	sides[i]=0.25 * ypts[i] * (xpts[i+1] - xpts[i-1]) / (pi * pi);
      for(int i=0;i<1000;i++)
	ys[i]=yc[i]=0.0;

      double rval;
      for(int i=0;i<ilstep;i++)
	{
	  rval=i * lstep;
	  storage_.storx[grp2][i]=rval;
	  storage_.store[grp2][i]=0.0;
	  for(int j=0;j<stpt;j++)
	    {
	      xvp=2.0 * xpts[j] * rval;
	      ys[i]+= sides[j] * sin(xvp);
	      yc[i]+= sides[j] * cos(xvp);
	    }
	  fspace[i]=sqrt(ys[i]*ys[i]+yc[i]*yc[i]);
	}
      storage_.stpnt[grp2]=ilstep;
      if (*A=='S')
	for(int i=0;i<ilstep;i++)
	  fspace[i]=fabs(ys[i]);
      else if (*A=='C')
	for(int i=0;i<ilstep;i++)
	  fspace[i]=fabs(yc[i]);
      delete [] sides;
      delete [] ys;
      delete [] yc;
      return;
    }

  if (hflag==2 && cmdnumber(hold_.is,conc))
    flag=cmdnumber(hold_.is,req_leng);
  else
    flag=0;

  while (conc<0.0001 || conc>100)
    {
      strcpy(ss,"Enter the number density =>");
      l_c(ss,0);
      if(!cmdnumber(ss,conc))  return;
    }
  int long_length=4;
  if (req_leng<storage_.stpnt[grp])
    req_leng = storage_.stpnt[grp];

  for(;long_length<req_leng;long_length<<=1);
  if (long_length<=4) 
    {
      l_c("Insufficient points in input grp for transform",1);
      return;
    }
  double *fspace;
  int tleng;
  if (long_length>maxpts)
    {
      tleng=maxpts;
      fspace=new double[long_length];
    }
  else
    {
      tleng=long_length;
      fspace=storage_.story[grp2];
    }
  
  fspace[0]=0.0;
  for(int i=1;i<storage_.stpnt[grp];i++)
    fspace[i]=storage_.story[grp][i] * storage_.storx[grp][i];
  for(int i=storage_.stpnt[grp];i<long_length;i++)
    fspace[i]=0.0;
  double 
    step=(storage_.storx[grp][storage_.stpnt[grp]-1]-storage_.storx[grp][0])
            /(storage_.stpnt[grp]-1.0);
  sprintf(ss,"X-Step : %g Number Density %g",step,conc); 
  l_c(ss,1);
  sinft(fspace,&long_length);

  double xmax = (long_length-1)  * step;
  double dum;
  if (*A=='Q')
    dum= (xmax * 4.0 * pi * conc) / long_length;
  else
    dum = xmax / (2.0 * pi * pi * conc * long_length );
  double tstep = pi / (long_length * step);
  storage_.storx[grp2][0]=0.0;
  storage_.story[grp2][0]=0.0;
  storage_.store[grp2][0]=0.0;
  for (int i=1;i<tleng;i++)
    {
      storage_.storx[grp2][i]=i* tstep;
      storage_.story[grp2][i]=(fspace[i] * dum) / (i * tstep);
      storage_.store[grp2][i]=0.0;
    }
  if (long_length>maxpts)
    delete [] fspace;
  storage_.stpnt[grp2]=tleng;
  int spnt=check_string(about_.hd[grp],"FT of",40,4);
  if (spnt)
    {
      for(int i=0;i<spnt-1;i++)
        about_.hd[grp2]=about_.hd[grp];
      for(int i=spnt-1;i<34;i++)
        about_.hd[grp2][i]=about_.hd[grp][i+5];
      for(int i=35;i<40;i++)
        about_.hd[grp2][i]=' ';
    }
  else
    {
      strncpy(about_.hd[grp2],"FT of",5);
      for(int i=5;i<40;i++)
        about_.hd[grp2][i]=about_.hd[grp][i-5];
    }


  return;
}

void 
output_screen(const char ans)
  /* 
     This function copies the section required to the screen
   */
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  int grp;

  char ss[256];
  int flag=cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1  || !storage_.stpnt[grp-1] )
    {
      flag=1;
      strcpy(ss,"Grp to output =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  grp--;
  l_c("Title: ",1);
  strncpy(ss,about_.hd[grp],40);  //write title
  ss[40]=0;
  l_c(ss,1);
  if (ans=='P') 
    {
      int xmin,xmax;
      if (!cmdnumber(hold_.is,xmin) || !cmdnumber(hold_.is,xmax))
	{
	  do 
	    {
	      sprintf(ss,"Group has %d pts",storage_.stpnt[grp]);
	      l_c(ss,1);
	      sprintf(ss,"Enter start and end pts =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax)) return;
	    } while(xmin<1 || xmax<1 ||  
		    xmin>storage_.stpnt[grp] || xmax>storage_.stpnt[grp]);
	}
      if (xmax<xmin)
	{
	  int temp=xmax;
	  xmax=xmin;
	  xmin=temp;
	}
      for(int i=xmin-1;i<xmax;i++)
	{
	  sprintf(ss,"%15.8g %15.8g %15.8g",storage_.storx[grp][i],
		  storage_.story[grp][i],storage_.store[grp][i]);
	  l_c(ss,1);
	}
    }
  else
    {
      double xmin,xmax;
      if (!cmdnumber(hold_.is,xmin) || !cmdnumber(hold_.is,xmax))
	{
	  sprintf(ss,"Group xrange %g :: %g ",
		  storage_.storx[grp][0],
		  storage_.storx[grp][storage_.stpnt[grp]-1]);
	  l_c(ss,1);
	  sprintf(ss,"Enter Xmin and Xmax =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax)) return;
	}
      if (xmax<xmin)
	{
	  double temp=xmax;
	  xmax=xmin;
	  xmin=temp;
	}
      int count=0;
      for(int i=0;i<storage_.stpnt[grp];i++)
	{
	  if (storage_.storx[grp][i]<=xmax && 
	      storage_.storx[grp][i]>=xmin)
	    {
	      count++;
	      sprintf(ss,"%15.8g %15.8g %15.8g",storage_.storx[grp][i],
		      storage_.story[grp][i],storage_.store[grp][i]);
	      l_c(ss,1);
	    }
	}
      if (!count)
	l_c("No points in range",1);
    }
  return;
}
		
void 
output(const char ans,const char *ngrp)
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;
  int grp;
  static int outtype=0;
  const int maxout(2);

  char ss[256];
  if (ngrp)
    strncpy(ss,ngrp,80);
  else
    strncpy(ss,hold_.is,80);

  if (ans=='C' || ans=='c') 
    {
      int count=0;
      while (!cmdnumber(ss,grp) || 
		grp<1 || grp>maxout)
	{
	  if (count) return;
	  count++;
	  l_c("1 -- Fourbris output ",1);
	  l_c("2 -- X-ray output  ",1);
	  sprintf(ss,"Enter the type of output =>");
	  l_c(ss,0);
	}
      outtype=grp-1;
      return;
    }
  if (ans!='F' && ans!='A')
    {
      output_screen(ans);
      return;
    }
  int count=0;
  int flag=cmdnumber(ss,grp);
  char *filename=0;
  char ssin[256];
  char ans2='A';
  ofstream ofs;
  while(flag || !count)
    {
      count++;
      if (!flag)
	{
	  sprintf(ss,"Group for output =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,grp)) return;
	}
      if (grp>0 && grp<=tg)
	{
	  if (!filename)
	    {
	      filename=new char[256];
	      sprintf(ssin,"Enter output filename =>");
	      l_c(ssin,0);
	      extractfile(filename,ssin,256);
	      while(ans2!='Y' && ans2!='N')
		{
		  sprintf(ssin,"With errors (y/n) or q to quit");
		  l_c(ssin,0);
		  get_first_letter(ans2,ssin);
		  if (ans2>='a' && ans2<='z')
		    ans2+=('A'-'a');
		  
		  if (ans2=='Q') 
		    {
		      delete [] filename;
		      return;
		    }
		}
	      ofs.open(filename,ios::out);
	    }
	  if (!ofs)
	    {
	      l_c("Error with filename: File already exists ? ",1);
	      delete [] filename;
	      return;
	    }
	  grp--;
	  if (storage_.stpnt[grp]>0)
	    {
	      ofs.setf(ios::scientific,ios::floatfield);
	      ofs.precision(10);
	      ofs<<"3 "<<storage_.stpnt[grp]<<" 0.02 1.0"<<endl;
	      strncpy(ssin,about_.hd[grp],40);
	      ssin[40]=0;
	      ofs<<ssin<<endl;
	      if (ans2=='Y')
		for(int i=0;i<storage_.stpnt[grp];i++)
		  {
		    ofs<<storage_.storx[grp][i]<<" "
		       <<storage_.story[grp][i]<<" "
		       <<storage_.store[grp][i]<<endl;
		  }
	      else
		for(int i=0;i<storage_.stpnt[grp];i++)
		  {
		    ofs<<storage_.storx[grp][i]<<" "
		       <<storage_.story[grp][i]<<" "
		       <<" 1.0 "<<endl;
		  }
	    }
	}	     
      flag=cmdnumber(ss,grp);
    }

  ofs.close();
  delete [] filename;
  return;
}


