#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fglobal.h"
#include "extract.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"

class ObjItem;

ostream& 
operator<<(ostream& s,const Objects& OJ)
{
  if (OJ.OItem)
    {
      std::vector<ObjItem*>::const_iterator vc = OJ.OI.begin(); 
      for(
	  vc=(OJ.OI.begin());
	  vc<OJ.OI.end();
	  vc++)
	  {
	    //	  s<< OJ.my_getchar((*vc)->obj_type())<<endl;
	    (*vc)->write_obj(s);
	  }
    }
  return s;
}

istream& 
operator>>(istream& s,Objects& OJ)
  /* Called if we only want to load in object units. */
{
  char ss[80];
  std::string check;
  Oline* olhold(0);
  while(s)
    {
      s.getline(ss,80,'\n');
      check=ss;
      if (check.find("Text")!=std::string::npos)
	{
	  Otext *ob=new Otext();
	  ob->read_obj(s);
	  OJ.OI.push_back(ob);
	  OJ.OItem++;
	}
      else if (check.find("Box")!=std::string::npos)
	{
	  Obox *ob=new Obox();
	  ob->read_obj(s);
	  OJ.OI.push_back(ob);
	  OJ.OItem++;
	}
      else if (check.find("Line")!=std::string::npos)
	{
	  Oline *ol=new Oline();
	  OJ.OI.push_back(ol);
	  OJ.OItem++;
	  ol->read_obj(s);   //now will read whole of aline!
	  olhold=ol;
	}
      else if (check.find("Point")!=std::string::npos)
	{
	  Oline *ol=new Oline(*olhold);
	  OJ.OI.push_back(ol);
	  OJ.OItem++;
	  ol->read_obj(s);   //now will read whole of aline!
	  olhold=ol;
	}
      else if (check.find("End")!=std::string::npos)
	{
	  return s;
	}
    }
  return s;
}


void
Obox::read_obj(istream& s)
  /* nneds checks on values */
{
  s>>abs;
  if (abs<0 || abs>1) abs=1;
  s>>x1>>y1;
  s>>x2>>y2;
  s>>colour;
  if (colour<0) colour=1;
  s>>line_style>>line_size>>fill_style;
  return;
}


void
Obox::Lcdisplay() const
{
  char ss[255];
  sprintf(ss,"Box colour : style : size : fill");
  l_c(ss,1);
  sprintf(ss,"   %d     :   %d : %d  :  %d",
	  colour,line_style,line_size,fill_style);
  l_c(ss,1);
  sprintf(ss,"%d %d %d %d",colour,line_style,line_size,fill_style);
  place_cmd(ss);
  return;
}

int
Obox::update(char* ss)
{
  int col;
  int style;
  int size;
  int fill;

  if (!cmdnumber(ss,col)) return 1;
  if (!cmdnumber(ss,style)) return 1;
  if (!cmdnumber(ss,size)) return 1;
  if (!cmdnumber(ss,fill)) return 1;
   
  if(style<1 || style>5) return 1;
  if (size>255 || size<1) return 1;
  if (fill<1 || fill>4) return 1;
  if (col>255 || col<0) return 1;
  
  colour=col;
  line_style=style;
  line_size=size;
  fill_style=fill;

  return 0;
}


void
Obox::write_obj(ostream& s) const
{
  s<<"# Box"<<endl;
  s<<abs<<endl;
  s<<x1<<" "<<y1<<endl;
  s<<x2<<" "<<y2<<endl;
  s<<colour<<endl;
  s<<line_style<<" "<<
    line_size<<" "<<
    fill_style<<endl;
  return;
}

ObjItem::ObjItem() : colour(1),abs(1),x1(0.0),y1(0.0)
{}

ObjItem::ObjItem(const int col,const float xx,const float yy) 
  : colour((col<0) ? 1 : col),abs(1),x1(xx),y1(yy)
{}

ObjItem::ObjItem(const ObjItem& A) 
  : colour(A.colour),abs(A.abs),x1(A.x1),y1(A.y1)
{}


int
ObjItem::getcurrent(int& A,float* P) const
  /* puts current positon into the variable P 
     and abs into A, returns number of coordinates. */
{
  if (!P) return 0;
  A=abs;
  P[0]=x1;
  P[1]=y1;
  return 1;
}

float*
ObjItem::makecurrent(int& A,int &npts) const
  /* MAKES and puts current positon into the variable P 
     and abs into A, returns number of coordinates. */
{
  float* P=new float[2];
  A=abs;
  P[0]=x1;
  P[1]=y1;
  npts=1;
  return P;
}

double 
ObjItem::distance(const float xx,const float yy,
		  const float axx,const float ayy) const
{
  double tx,ty;
  if (abs)
    {
      tx=axx-x1;
      ty=ayy-y1;
    }
  else
    {
      tx=xx-x1;
      ty=yy-y1;
    }    
  tx*=tx;
  ty*=ty;
  return sqrt(tx+ty);
}

void
ObjItem::make_rel(const Frame* Ofm)
{
  if (!abs || !Ofm) return;
  if (!Ofm->relcoord(x1,y1))
    abs=0;
  return;
}

void
ObjItem::make_abs(const Frame* Ofm)
{
  if (abs || !Ofm) return;
  if (!Ofm->abscoord(x1,y1))
    abs=1;
  return;
}

void
ObjItem::set_pos(const Frame* Ofm,const float x,const float y)
{
  x1=x;
  y1=y;
  if (abs && Ofm)
    Ofm->abscoord(x1,y1);
  return;
}

void
ObjItem::reset_pos(const Frame* Ofm,const int pts,const float *xy)
{
  if (pts)
    {
      x1=xy[0];
      y1=xy[1];
      if (abs && Ofm)
	Ofm->abscoord(x1,y1);
     }
  return;
}

void
ObjItem::move_pos(const Frame* Ofm,const float x,const float y)
{
  x1=x;
  y1=y;
  if (abs && Ofm)
    Ofm->abscoord(x1,y1);
  return;
}


ObjItem::~ObjItem() 
{}

Otext::Otext() : 
  ObjItem(1,0.0,0.0),Tsize(1.0),angle(0.0),format(0.0)
{}

Otext::Otext(const int col,const float size,const float ang,
             const float ft,const char *ST) : ObjItem(col,0.0,0.0)
{
  Tsize=(size<0.05) ? 1.0 : size;
  angle=(ang>360.0 || ang<-360.0) ? 0.0 : ang;
  format=(ft>1.0|| ft<0.0) ? 0.0 : ft;
  if (ST)
    {
      if (strlen(ST)>255)
	{
	  str=std::string(ST,255);
	}
      else
	str= ST;
    }
  return;
}

void
Otext::getvalues(int &c,float &s,float &a,float &f) const
{
  c=colour;
  s=Tsize;
  a=angle;
  f=format;
  return;
}

int
Otext::update(char* ss)
{
  int col;
  float tang;
  float tsize;
  float tformat;

  if (!cmdnumber(ss,col)) return 1;
  if (!cmdnumber(ss,tsize)) return 1;
  if (!cmdnumber(ss,tang)) return 1;
  if (!cmdnumber(ss,tformat)) return 1;
   
  if(tang>360.0 || tang<-360.0) return 1;
  if (tsize>10.0 || tsize<0.1) return 1;
  if (tformat<0.0 || tformat>1.0) return 1;
  if (col>255 || col<0) return 1;
  
  colour=col;
  angle=tang;
  Tsize=tsize;
  format=tformat;
  char stmp[255];
  int i,mp;
  for(i=0;i<255 && ss[i]==' ';i++);
  mp=i;
  for(int j=i;j<255 && ss[j];j++)
    {
      if (ss[j]!=' ')
	mp=j;
    }
  if (mp!=i)
    {
      mp++;  //make it after the point
      strncpy(stmp,ss+i,mp-i);
      stmp[mp-i]=0;
      str=static_cast<std::string>(stmp);
    }
  return 0;
}

void
Otext::Lcdisplay() const
{
  char ss[512];
  sprintf(ss,"Colour : Size  : Angle  : Centre Format");
  l_c(ss,1);
  sprintf(ss,"   %d   : %2.2f: %2.2f :%2.2f ",
	  colour,Tsize,angle,format);
  l_c(ss,1);
  sprintf(ss,"Text : %s",str.c_str());
  l_c(ss,1);
  sprintf(ss,"%d %3.2f %2.2f %2.2f %s",colour,Tsize,angle,format,str.c_str());
  place_cmd(ss);
  return;
}

void
Otext::write_obj(ostream& s) const
{
  s<<"# Text"<<endl;
  s<<abs<<endl;
  s<<x1<<" "<<y1<<endl;
  s<<colour<<endl;
  s<<Tsize<<" "<<
    angle<<endl;
  int count=0;
  for(int i=0;i<(int) str.size();i++)
    if (str[i]=='\n')
      count++;
  s<<count+1<<endl;
  s<<str<<endl;
  
  return;
}

void
Otext::read_obj(istream& s)
{
  s>>abs;
  s>>x1>>y1;
  s>>colour;
  s>>Tsize>>angle;
  int count;
  char ss[256];
  s>>count;
  s.getline(ss,255,'\n');  //remove character.
  str="";
  for (int i=0;i<count-1;i++)
    {
      s.getline(ss,255,'\n');
      str+=ss; 
      str+='\n';
    }
  s.getline(ss,255,'\n');
  str+=ss;
  return;
}

void
Otext::draw(const Frame* Ofm,const int type) const      //default 0
{
  cpgscf(2);
  cpgsls(1);
  cpgslw(1);    // line width!
  cpgsfs(1);     //fill style
  cpgsch(Tsize);
  if (type==1)
    cpgsci(0);
  else if(type==2)
    cpgsci(2);
  else
    cpgsci(colour);
  const char *words=str.c_str();
  if (!abs)
    cpgptxt(x1,y1,angle,format,words);
  else if (Ofm)
    {
      float xa,ya;
      xa=x1; ya=y1;
      Ofm->relcoord(xa,ya);
      cpgptxt(xa,ya,angle,format,words);
    }
  return;
}


Otext::~Otext()
{}


int
Oline::drawforward(const Frame* Ofm,const int type) const
{
  if (!next_pt) return 1;
  cpgsclp(0);
  cpgscf(2);
  cpgsls(lstyle);
  cpgslw(lsize);
  if (type==1)
    cpgsci(0);
  else if(type==2)
    cpgsci(2);
  else
    cpgsci(colour);
  float xp(x1),yp(y1);
  if (abs) 
    Ofm->relcoord(xp,yp);
  next_pt->drawline(Ofm,xp,yp);
  return 0;
}

int
Oline::drawbackward(const Frame* Ofm,const int type) const
{
  if (!prev_pt) return 1;
  cpgsclp(0);
  cpgscf(2);
  cpgsls(lstyle);
  cpgslw(lsize);
  if (type==1)
    cpgsci(0);
  else if(type==2)
    cpgsci(2);
  else
    cpgsci(colour);
  float xp(x1),yp(y1);
  if (abs) 
    Ofm->relcoord(xp,yp);
  prev_pt->drawline(Ofm,xp,yp);
  return 0;
}


void
Oline::drawline(const Frame *Ofm,const float xf,const float yf) const
{
  if (abs && !Ofm) return;
  float xx[2],yy[2];
  xx[0]=xf;
  yy[0]=yf;
  xx[1]=x1;
  yy[1]=y1;
  if (abs)
    Ofm->relcoord(xx[1],yy[1]);
  cpgline(2,xx,yy);
}


Oline::Oline() : 
  ObjItem(1,0.0,0.0),lstyle(1),lsize(1),next_pt(0),prev_pt(0)
{}

Oline::Oline(const int col,const int form,const int sz,
	     Oline* P,Oline* N) : 
  ObjItem(col,0.0,0.0)
{
  lstyle=(form<1 || form>5) ? 1 : form;
  lsize=(sz<1 || sz>200) ? 1 :sz;
  prev_pt=P;
  if (prev_pt) 
    //    prev_pt->Next(this);
    prev_pt->next_pt=this;
  next_pt=N;
  if (next_pt) 
    next_pt->Prev(this);
}

Oline::Oline(const Oline &A) :
  ObjItem(A)
{
  lstyle=A.lstyle;
  lsize=A.lsize;
  prev_pt=0;;
  next_pt=0;
}

Oline::~Oline()
  /* Not takes care of being in a linked list of points */
{
  if (prev_pt)
    prev_pt->Next(next_pt);
  if (next_pt)
    next_pt->Prev(prev_pt);
}


void
Oline::reset_pos(const Frame* Ofm,const int pts,const float *xy)
{
  x1=xy[0];
  y1=xy[1];
  if (abs && Ofm)
    Ofm->abscoord(x1,y1);
  return;
}


int
Oline::count_forward() const
  /* recursive count to end of list */
{
  return (next_pt) ? 1+next_pt->count_forward() : 1;
}

int
Oline::count_back() const
  /* recursive count to start of list */
{
  return (prev_pt) ? 1+prev_pt->count_back() : 1;
}

int 
Oline::count_line() const
{
  int total=0;
  if (prev_pt)
    total=prev_pt->count_back();
  if (next_pt)
    total+=next_pt->count_forward();
  return total+1;
}

int
Oline::vector_current(int &rt,std::vector<float>& Pts) const
  /* adds all the points of the line into the vector and returns number. 
     rt = abs/rel 
  */
{
  Oline const* Fpt =  get_first();
  int count=0;
  do
    {
      count++;
      Pts.push_back(Fpt->x1);
      Pts.push_back(Fpt->y1);
      Fpt=Fpt->next_pt;
    } while (Fpt);
  rt=abs;
  return count;
}


int 
Oline::set_array(float* xy) const
  /* assuming and array of x,y that is sufficientlly long
     change the x,y values of the points 
  */
{
  int count;
  const Oline* pt=this;
  while(pt->prev_pt)
    pt= pt->prev_pt;
  while(pt)
    {
      count++;
      *xy++ = pt->x1;
      *xy++ = pt->y1;
      pt=pt->next_pt;
    }
  return count;
}

float*
Oline::makecurrent(int& A,int& npts) const
  /* check setting of A */
{
  A=abs;
  float *P=new float[2];
  P[0]=x1;
  P[1]=y1;
  npts=1;
  return P;
}

int 
Oline::getcurrent(int &A,float* P) const
{
  if (!P) return 0;
  if (!A)
    {
      P[0]=x1;
      P[1]=y1;
      A=abs;
      return 1;
    }
  A=abs;
  int rv=count_line();
  set_array(P);
  return rv;
}

void
Oline::vector_reset_pos(const std::vector<float>& Pts)
{
  Oline* Fpt = const_cast<Oline*>(get_first());
  std::vector<float>::const_iterator vc=Pts.begin();
  while (Fpt && vc!=Pts.end())
    {
      Fpt->x1 = (*vc);
      vc++;
      if (vc != Pts.end())
	Fpt->y1=(*vc);
      Fpt=Fpt->next_pt;
    }
  return;
}


void 
Oline::getvalues(int &C,int &S,int &Z) const
  /* return the values of a single point */
{
  C=colour;
  S=lstyle;
  Z=lsize;
  return;
}

void
Oline::move_line(const Frame* Ofm,float mx,float my)
  /* adds all the points of the line into the vector and returns number. 
     rt = abs/rel 
  */
{
  Oline* Fpt =  give_first();
  if (abs)
    Ofm->relcoord(mx,my);
  float diffx=mx-Fpt->x1;
  float diffy=my-Fpt->y1;
  do
    {
      Fpt->x1+=diffx;
      Fpt->y1+=diffy;
      Fpt=Fpt->next_pt;
    } while (Fpt);
  return;
}

void
Oline::draw(const Frame* Ofm,const int type) const      //default 0
{
  if (!next_pt && !prev_pt) return; 
  cpgsclp(0);
  cpgscf(2);
  cpgsls(lstyle);
  cpgslw(lsize);
  if (type==1)
    cpgsci(0);
  else if(type==2)
    cpgsci(2);
  else
    cpgsci(colour);
  if (!abs)
    {
      if (next_pt) 
	next_pt->drawline(Ofm,x1,y1);
      if (prev_pt)
	prev_pt->drawline(Ofm,x1,y1);
    }
  else if (Ofm)
    {
      float xa,ya;
      xa=x1;  ya=y1;
      Ofm->relcoord(xa,ya);
      if (next_pt) 
	next_pt->drawline(Ofm,xa,ya);
      if (prev_pt)
	prev_pt->drawline(Ofm,xa,ya);
    }
  cpgsclp(1);
  return;
}

void
Oline::read_obj(istream& s)
  /* needs checks on values */
{
  s>>abs;
  if (abs<0 || abs>1) abs=1;
  s>>x1>>y1;
  s>>colour;
  if (colour<0) colour=1;
  s>>lstyle>>lsize;
  if (prev_pt) 
    prev_pt->Next(this);
  next_pt=0;           //incase end pt.
  return;
}

void
Oline::Lcdisplay() const
{
  char ss[512];
  sprintf(ss,"Line colour : style : size");
  l_c(ss,1);
  sprintf(ss,"   %d     :  %d   : %d ",
	  colour,lstyle,lsize);
  l_c(ss,1);
  return;
}

int
Oline::update(char* ss)
{
  int col;
  int style;
  int size;

  if (!cmdnumber(ss,col)) return 1;
  if (!cmdnumber(ss,style)) return 1;
  if (!cmdnumber(ss,size)) return 1;
   
  if(style<1 || style>5) return 1;
  if (size>255 || size<1) return 1;
  if (col>255 || col<0) return 1;
  
  colour=col;
  lstyle=style;
  lsize=size;

  return 0;
}


void
Oline::write_obj(ostream& s) const
{
  if (!prev_pt && !next_pt) //no line to write....
    return;
  if (!prev_pt)  // First point....
    {
      s<<"# Line"<<endl;
      s<<abs<<endl;
      s<<x1<<" "<<y1<<endl;
      s<<colour<<" "<<lstyle<<" "<<lsize<<endl;
    }
  else
    {
      s<<"#L. Point"<<endl;
      s<<x1<<" "<<y1<<endl;
    }      
  return; 
}

Oline*
Oline::write_line(ostream& s) const
{
  s<<"# L. Point"<<endl;
  s<<abs<<endl;
  s<<x1<<" "<<y1<<endl;
  s<<colour<<endl;
  s<<lstyle<<" "<<
    lsize<<endl;
  return next_pt;
}


Obox::Obox() : 
  ObjItem(1,0.0,0.0),line_style(1),line_size(1),fill_style(2)
{}

Obox::Obox(const int col,const int lstyle,
	   const int lsize,const int stl) : ObjItem(col,0.0,0.0)
{
  line_style=(lstyle<1) ? 1 : lstyle;
  line_size=(lsize<1) ? 1 : lsize;
  fill_style=(stl<1 || stl>4) ? 2 : stl;
}

void
Obox::getvalues(int &c,int &s,int &z,int &f) const
{
  c=colour;
  s=line_style;
  z=line_size;
  f=fill_style;
  return;
}

float*
Obox::makecurrent(int& A,int& npts) const
  /* puts current positon into the variable P 
     and abs into A, returns number of coordinates. */
{
  float* P=new float[4];
  npts=2;
  A=abs;
  P[0]=x1;
  P[1]=y1;
  P[2]=x2;
  P[3]=y2;
  return P;
}

int
Obox::getcurrent(int &A,float *P) const
  /* puts current positon into the variable P 
     and abs into A, returns number of coordinates. */
{
  if (!P) return 0;
  A=abs;
  P[0]=x1;
  P[1]=y1;
  P[2]=x2;
  P[3]=y2;
  return 2;
}


Obox::~Obox()
{};


void
Obox::make_abs(const Frame *Ofm)
{
  if (abs || !Ofm) return;
  if (!Ofm->abscoord(x1,y1) &&
      !Ofm->abscoord(x2,y2))
    {
      abs=1;
    }
  return;
}

void
Obox::make_rel(const Frame *Ofm)
{
  if (!abs || !Ofm) return;
  if (!Ofm->relcoord(x1,y1) &&
      !Ofm->relcoord(x2,y2))
    {
      abs=0;
    }
  return;
}


void
Obox::set_pos(const Frame *Ofm,const float xa,const float ya,
	      const float xb,const float yb)
{
  x1=xa;
  x2=xb;
  y1=ya;
  y2=yb;
  if (abs && Ofm)
    {
      Ofm->abscoord(x1,y1);
      Ofm->abscoord(x2,y2);
    }
  return;
}

void
Obox::reset_pos(const Frame *Ofm,const int pts,const float *xy)
{
  if (pts)
    {
      x1=xy[0];
      y1=xy[1];
      if (abs && Ofm)
	Ofm->abscoord(x1,y1);
      if (pts>1)
	{
	  x2=xy[2];
	  y2=xy[3];
	  if (abs && Ofm)
	    Ofm->abscoord(x2,y2);
	}
    }
  return;
}

void
Obox::move_pos(const Frame *Ofm,float xa,float ya)
{
  if (abs && Ofm)
    Ofm->abscoord(xa,ya);
  float diffx=xa-x1;
  float diffy=ya-y1;
  x1=xa;
  x2+=diffx;
  y1=ya;
  y2+=diffy;
  return;
}

void
Obox::draw(const Frame* Ofm,const int type) const      //default 0
{
  cpgsclp(0);
  cpgscf(2);
  cpgsls(line_style);
  cpgslw(line_size);
  cpgsfs(fill_style);
  if (type==1)
    cpgsci(0);
  else if(type==2)
    cpgsci(2);
  else
    cpgsci(colour);
  if (!abs)
    cpgrect(x1,x2,y1,y2);
  else if (Ofm)
    {
      float xa,xb,ya,yb;
      xa=x1; xb=x2;
      ya=y1; yb=y2;
      Ofm->relcoord(xa,ya);
      Ofm->relcoord(xb,yb);
      cpgrect(xa,xb,ya,yb);
    }
  cpgsclp(1);
  return;
}


Objects::Objects() : Graph_Data(),OItem(0)
{
}

Objects::~Objects() 
{
  for(int i=0;i<OItem;i++)
   delete OI[i];
}

int
Objects::eliminate_all(const int type)
{
  if (OItem<1) return 0;
  std::vector<ObjItem*>::iterator vc;
  int count=0;
  if (!type)  //simple eliminate everything.
    {
      count=OItem;
      for(vc=OI.begin();vc!=OI.end();vc++)
	delete (*vc);
      OItem=0;
      OI.erase(OI.begin(),OI.end());
    }
  else
    {
      for(vc=OI.begin();vc!=OI.end();vc++)  //this will eliminate all lines
	{
	  if ((*vc)->obj_type()==type)
	    {
	      delete (*vc);  
	      OItem--;
	      count++;
	      OI.erase(vc,vc++);
	    }
	}
    }
  return count;
}

int
Objects::eliminate(const int type,const int count)
  /*
    This funcntion deletes a given type of object 
     and a certain number back.
    Type ==0 means any graphic object.
  */
{
  if (count<1 || OItem<1) return 1;
  int ct=count;
  std::vector<ObjItem*>::iterator vc=OI.end();
  do
    {
      vc--;
      if ((*vc)->obj_type()==type || !type)
	{
	  ct--;
	  if (!ct)
	    {
	      delete (*vc);
	      OI.erase(vc,vc+1);
	      OItem--;
	      Frame *fm = dynamic_cast<Frame*>(this);
	      if(fm)
		fm->redraw();
	      return 0;
	    }
	}
    }
  while(vc!=OI.begin());
  return 2;
}

int
Objects::gettype(const char ans2) const
{
  switch (ans2)
    {
    case 'B':
      return 1;
    case 'T':
      return 2;
    case 'L':
      return 3;
    case 'S':
      return 4;
    case 'P':   //get whole line!
      return 5; //get point of line
    default:
      return 0;
    }  
}

char
Objects::my_getchar(const int nmb) const
{
  switch (nmb)
    {
    case 1:
      return 'B';
    case 2:
      return 'T';
    case 3:
      return 'L';
    case 4:
      return 'S';
    default:
      return 0;
    }  
}

int
Objects::count_item(const int type) const
  /* 
     special option for line types that are both 3 and 5 
   */
{
  if (type<1) return OItem;
  int stype=(type!=3) ? type : 5;

  std::vector<ObjItem*>::const_iterator vc=OI.begin();
  int count=0;
  for(;vc!=OI.end();vc++)
    {
      if ((*vc)->obj_type()==stype)
	{
	  if (stype!=type)
	    {
	      Oline* pt = dynamic_cast<Oline*>(*vc);
	      if (pt && !pt->isFirst())
		count++;
	    }
	  else
	    count++;
	}
    }
  return count;
}

ObjItem*
Objects::select(const int type,const char* fail_text,
		const char* sel_text) const
  /* Helper function returns the object pointer */
{
  extern wback hold_;
  int ntype=count_item(type); //correctly deals with type=0,3,5
  if (ntype<1) 
    {
      l_c(const_cast<char*>(fail_text),1);
      return 0;
    }
  const Frame*  fm = dynamic_cast<Frame const*>(this);
  if (!fm) return  static_cast<ObjItem*>(0);  // failed

  std::vector<ObjItem*>::const_iterator mitem;
  if (ntype>1)    //more than one item
    {
      layer_command(sel_text); // take control of point 
                               // (Must return control later)
      char ans;
      float x1,y1,ax1,ay1;
      if (!mpgband(0,0,0.0,0.0,x1,y1,ans))
	{
	  hold_.graph_flag=1;
          s_line();
	  return static_cast<ObjItem*>(0);  //failed
	}
      hold_.graph_flag=1;
      //      s_line();

      ax1=x1;
      ay1=y1;
      fm->abscoord(ax1,ay1); 
      std::vector<ObjItem*>::const_iterator vc=OI.begin();
      double dist= -1.0;
      double tmp;
      int stype = (type==3) ? 5 : type;

      for(;vc!=OI.end();vc++)
	{
	  if (!type || (*vc)->obj_type()==stype) //!type == all objects
	    {
	      tmp=(*vc)->distance(x1,y1,ax1,ay1);
	      if (dist<0.0 || tmp<dist)
		{
		  mitem=vc;
		  dist=tmp;
		}
	    }
	}
      if ((!type && (*mitem)->obj_type()==5)
	  || type==3) 
	{
          Oline* pt=dynamic_cast<Oline*>(*mitem);
	  return (!pt) ? 0 : pt->give_first();
	}
      return *mitem;
    }
  else if (type && type!=3) //only one item but a selection necessary
    {
      std::vector<ObjItem*>::const_iterator vc=OI.begin();
      for(;vc!=OI.end() && (*vc)->obj_type()!=type;vc++);
      if (vc==OI.end())
	return static_cast<ObjItem*>(0);  //again no type
      return *vc;
    }
  else if (type==3)
    {
      std::vector<ObjItem*>::const_iterator vc=OI.begin();
      for(;vc!=OI.end() && (*vc)->obj_type()!=5;vc++)
	{
          Oline* pt=dynamic_cast<Oline*>(*vc);
	  return (!pt) ? 0 : pt->give_first();
	}
	return static_cast<ObjItem*>(0);  //again no type
    }
  else  //only 1 item of anything
    {
      return *(OI.begin());
    }
  return static_cast<ObjItem*>(0);  //no objects
}

void
Objects::edit_item(const char ans2)
{
  char ss[256];
  int type=gettype(ans2);
  ObjItem* otbm = select(type,"No items to edit","Select object to change");
  if (!otbm) 
    return;
  otbm->Lcdisplay();
  sprintf(ss,"Enter new values =>");
  l_c(ss,0);
  if (otbm->update(ss))
    l_c("Unable to update graphical item",1);
  Frame *fm = dynamic_cast<Frame*>(this);
  if(fm)
    fm->redraw();
  return;
}

void
Objects::move(const char ans2)
  /*
    Move object, first select,second move  
    ans2 == type of object to move 
  */
{
  
  extern wback hold_;
  int type=gettype(ans2);
  ObjItem* otbm = select(type,"No items to move","Select object to move");

  layer_command("Place object in new position");  //freeze command options
  float x1,y1;
  float* old_pos;   //record positions  (this FUNC deletes)
  int rel_type,ncord;
  Frame* fm=dynamic_cast<Frame*>(this);
  if (!fm) 
    {
      hold_.graph_flag=1;
      return;
    }

  if (ans2=='P' || otbm->obj_type()!=3)  //OL and O move whole lines
    {
      old_pos=otbm->makecurrent(rel_type,ncord); //returns 1,2 pts.
      if (rel_type)
	{
	  for(int j=0;j<ncord;j++)
	    fm->relcoord(old_pos[j*2],old_pos[1+j*2]);
	}
      otbm->draw(fm);
      char ans='a';
      while(ans!='X')
	{
	  if (!mpgband(0,0,0.0,0.0,x1,y1,ans))
	    ans='X';
	  if (ans=='D')
	    {
	      otbm->draw(fm,1);
	      otbm->reset_pos(fm,ncord,old_pos);
	    }
	  else if (ans!='X')
	    {
	      otbm->draw(fm,1);
	      otbm->move_pos(fm,x1,y1);
	    }
	  otbm->draw(fm);
	}
    }
  else 
    {
      Oline* pline=dynamic_cast<Oline*>(otbm);
      if (pline) 
	{
	  std::vector<float> Pts;
	  pline->vector_current(rel_type,Pts);  //put all the points
	                                               //of line into vector.
	  pline->draw(fm);
	  char ans='a';
	  while(ans!='X')
	    {
	      if (!mpgband(0,0,0.0,0.0,x1,y1,ans))
		ans='X';
	      if (ans=='D')
		{
		  pline->draw(fm,1);
		  pline->vector_reset_pos(Pts);
		}
	      else if (ans!='X')
		{
		  pline->draw(fm,1);
		  pline->move_line(fm,x1,y1);
		}
	      pline->draw(fm);
	    }
	}
      
      fm->redraw();
      return;
    }
  // otbm MUST == first point in line....  

  //ready to move mitem..
  char ans='a';
  while(ans!='X')
    {
      if (!mpgband(0,0,0.0,0.0,x1,y1,ans))
	ans='X';
      if (ans=='D')
	{
	  otbm->draw(fm,1);
	  otbm->reset_pos(fm,ncord,old_pos);
	}
      else if (ans!='X')
	{
	  otbm->draw(fm,1);
	  otbm->move_pos(fm,x1,y1);
	}
      otbm->draw(fm);
    }
  delete [] old_pos;
  hold_.graph_flag=1;
  fm->redraw();
  return;
}

void
Objects::clear_obj(const char ans2)
  /* depending upon entry will remove lines,text,symbols,graphs etc. */
{
  extern wback hold_;
  
  int count;
  int type=gettype(ans2);
  if (!cmdnumber(hold_.is,count))
    count=1;
  
  eliminate(type,count);
  return;
}


void
Objects::do_line(const char ans2)
  /* Enters new box for the plot 
     L == add new line col,line type,size (continuous)
     LR == redo last line
     LL == another copy of the last box 
     LD == delete lines
     5-12-99 added fake start item (type 5) //now removed
  */
  
{
  extern wback hold_;
  int col;
  int lsize;
  int lform;
  int flag=0;

  if (ans2=='D')
    {
      flag=cmdnumber(hold_.is,col);
      if (!flag) 
	col=1;
      else if (col<1) 
	return;
      if (eliminate(3,col)==2)
	l_c("Insufficient lines to delete",1);
      return;
    }
  int fline;
  if (ans2=='L' || ans2=='R')  //last or repeat
    {
      for(fline=OItem-1;fline>=0 && OI[fline]->obj_type()!=3;fline--);
      if (fline>=0)
	{
	  Oline* oll=dynamic_cast<Oline*>(OI[fline]);
	  if (oll)
	    {
	      oll->getvalues(col,lsize,lform);
	      flag=4;
	    }
	  else
	    fline= -1;
	}
    }
  if (!flag) flag=cmdnumber(hold_.is,col);
  if (flag==1) flag+=cmdnumber(hold_.is,lsize);
  if (flag==2) flag+=cmdnumber(hold_.is,lform);
  if (flag==2)
    lform=1;
  else if (flag>2)
    flag=4;

  char ss[256];
  while (flag<1 || col<0)
    {
      flag=1;
      sprintf(ss,"Line colour =>");
      l_c(ss,0);
      if (!cmdnumber(ss,col)) return;
    } 
  while (flag<2 || lsize<1 || lsize>50)
    {
      flag=2;
      sprintf(ss,"Line size =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lsize)) return;
    } 
  if (flag==2) 
    {
      lform=1;
      flag=4;
    }
  while (flag<3 || lform<1 || lform>5)
    {
      flag=3;
      sprintf(ss,"Line style =>");
      l_c(ss,0);
      if (!cmdnumber(ss,lform)) return;
    } 
  l_c("Left Mouse B to place, Right to go back,",1);
  l_c("Middle to finish",1);
  layer_command("Place line :: ");
  int tst=1;
  char ans='A';
  float x1(0.0),y1(0.0);   //start point for cursor.
  Frame *fm = dynamic_cast<Frame*>(this);
  if (!fm)  //no way to do redraw.
    {
      hold_.graph_flag=1;
      return;
    }
  float x2,y2;
  float xy[2]; 
  Oline *ol(0);  //for additional point
  Oline *op(0);

  int nf=0;
  tst=mpgband(nf,0,x1,y1,x2,y2,ans);
  while(tst && ans!='D')
    {
      if (ans=='X')     //remove 1 point.
	{
	  if (!op)      //just exit
	    {
	      ans='D';
	    }
	  else
	    {
	      ol->drawbackward(fm,1);  //delete last line
	      OI.pop_back();
	      OItem--;
	      delete ol; //get rid of ol;
	      ol=op;     //make ol the op
	      if (ol)
		{
		  op= ol->Prev();
		  int t_abs=0; //needed for the switch in getcurrent
 		  ol->getcurrent(t_abs,xy);  //get x,y values
		  x1=xy[0]; y1=xy[1];
		  if (t_abs) 
		    fm->relcoord(x1,y1);
		}
	      else
		{
		  op=0;  //new point
		  nf=0;
		}
	      cpgsci(col);
	      tst=mpgband(nf,0,x1,y1,x2,y2,ans);
	    }
	}
      else
	{
	  op=ol;
	  try
	    {
	      ol=new Oline(col,lform,lsize,op,0);  //get a new point
	    }
	  catch(...)  //size stuff stupid exit.
	    {
	      hold_.graph_flag=1;
	      fm->redraw();
	      return;
	    }
	  ol->set_pos(fm,x2,y2);
	  OI.push_back(ol);
	  OItem++;
	  ol->drawbackward(fm);
	  x1=x2;
	  y1=y2;
	  nf=1;  //now draw bands from op...
	  cpgsci(col);
	  tst=mpgband(nf,0,x1,y1,x2,y2,ans);
	}
    }
  fm->redraw();
  hold_.graph_flag=1;
  return;
}

void 
Objects::include_item(ObjItem* OB)
{
  if (OB)
    {
      OI.push_back(OB);
      OItem++;
    }
  return;
}

void 
Objects::do_sym(const char ans2)
{
  /* SR repeat last symbol
     SM add many of new symbol
     SD delete last symble 
  */
  extern wback hold_;
  int col;
  //  float size;
  // int symn;
  int  flag=0;
  // int fsym=0;
  if (ans2=='D')
    {
      flag=cmdnumber(hold_.is,col);
      if (!flag) 
	col=1;
      if (flag && col<1) return;
      if (eliminate(2,col)==2)
	l_c("Insufficient text items to delete",1);
      return;
    }
  return;
  
}


void
Objects::do_text(const char ans2)
  /* Enters new box for the plot 
     T == add new text col,line type,size fill
     TR == rotated text
     TL == another copy of the last text
     TD == delete items of text
     TC == edit text.
  */
  
{
  extern wback hold_;
  int col;
  float tang;
  float tsize;
  float tformat;
  int  flag=0;
  int ftext=0;   //have we found old box

  if (ans2=='D')
    {
      flag=cmdnumber(hold_.is,col);
      if (!flag) 
	col=1;
      if (flag && col<1) return;
      if (eliminate(2,col)==2)
	l_c("Insufficient text items to delete",1);
      return;
    }

  if (ans2=='L' || ans2=='P')
    {
      
      for(ftext=OItem-1;ftext>=0 && OI[ftext]->obj_type()!=2;ftext--);
      if (ftext>=0)
	{
	  Otext* ott=dynamic_cast<Otext*>(OI[ftext]);
	  if (ott)
	    {
	      ott->getvalues(col,tsize,tang,tformat);
	      flag=5;
	    }
	  else
	    ftext= -1;
	}
    }
  if (!flag) 
    flag=cmdnumber(hold_.is,col);
  if (flag==1) 
    flag+=cmdnumber(hold_.is,tsize);
  if (ans2=='R')  //if already selected rotated text.
    {
      tang=90.0;
      if (flag==2) 
	flag++;
    }
  else if (flag==2) 
    flag+=cmdnumber(hold_.is,tang);
  if (flag==3) 
    flag+=cmdnumber(hold_.is,tformat);
  if (flag<4)
    tformat=0.5;


  char ss[256];
  while (flag<1 || col<0)
    {
      flag=1;
      sprintf(ss,"Text colour =>");
      l_c(ss,0);
      if (!cmdnumber(ss,col)) return;
    } 
  while (flag<2 || tsize<0.05 || tsize>10.0)
    {
      flag=2;
      sprintf(ss,"Text size =>");
      l_c(ss,0);
      if (!cmdnumber(ss,tsize)) return;
    } 
  if (flag==2) 
    {
      tang= (ans2!='R') ? 0.0 : 90.0;
      tformat=0.5;
      flag=3;
    }
  while (ans2!='R' && (flag<3 || tang<-360.0 || tang>360.0))
    {
      flag=3;
      sprintf(ss,"Text angle =>");
      l_c(ss,0);
      if (!cmdnumber(ss,tang)) return;
    } 
  while (tformat<0.0 || tformat>1.0)
    {
      flag=4;
      sprintf(ss,"Text justification (0.0 to 1.0) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,tformat)) return;
    } 

  int a,b;
  if (extractname(ss,hold_.is,80,a,b,80))
    {
      sprintf(ss,"Enter Text =>");
      l_c(ss,0);
      for(a=0;a<80 && ss[a]==' ';a++);
      if (a==80) return;
    }
  else
    {
      ss[b]=0;
      a=0;
    }

  l_c("Right mouse button when satisfied, Middle to cancel",1);
  layer_command("Place cursor on text position");
  int tst=1;
  char ans='A';
  float x1(0),y1(0);
  float xh,yh;
  Frame *fm = dynamic_cast<Frame*>(this);
  Otext *ob=new Otext(col,tsize,tang,tformat,ss+a);
  int first=1;
  while(tst && ans!='X' && ans!='D')
    {
      xh=x1;
      yh=y1;
      tst=mpgband(0,0,0.0,0.0,x1,y1,ans);  //check can't cast this to sband
      if (!first) 
	ob->draw(fm,1);
      ob->set_pos(fm,x1,y1);
      ob->draw(fm);
      first=0;
    }
  if (ans=='D' || first) 
    {
      delete ob;
      if (fm)
	fm->redraw();
      hold_.graph_flag=1;
      s_line();
      return;
    }
  ob->set_pos(fm,xh,yh);
  if (ans2!='P' || ftext<0)
    {
      OI.push_back(ob);
      OItem++;
    }
  else
    OI[ftext]=ob;
  fm->redraw();
  hold_.graph_flag=1;
  return;
}


void
Objects::do_box(const char ans2)
  /* Enters new box for the plot 
     B == add new box col,line type,size fill
     BR == redo last box
     BL == another copy of the last box 
  */
{
  extern wback hold_;
  int bcol,bltype,bsize,bfill;
  int flag=0;
  int fbox=0;   //have we found old box
  bfill=2;
  if (ans2=='D')
    {
      flag=cmdnumber(hold_.is,bcol);
      if (!flag) 
	bcol=1;
      if (flag && bcol<1) return;
      if (eliminate(1,bcol)==2)
	l_c("Insufficient box items to delete",1);
      return;
    }
  if (ans2=='L' || ans2=='R')
    {
      
      for(fbox=OItem-1;fbox>=0 && OI[fbox]->obj_type()!=1;fbox--);
      if (fbox>=0)
	{
	  Obox* obb=dynamic_cast<Obox*>(OI[fbox]);
	  if (obb)
	    {
	      obb->getvalues(bcol,bltype,bsize,bfill);
	      flag=4;
	    }
	  else
	    fbox= -1;
	}
    }
  if (!flag) flag=cmdnumber(hold_.is,bcol);
  if (flag==1) flag+=cmdnumber(hold_.is,bltype);
  if (flag==2) flag+=cmdnumber(hold_.is,bsize);
  if (flag==3) flag+=cmdnumber(hold_.is,bfill);

  char ss[256];

  while (flag<1 || bcol<0)
    {
      flag=1;
      sprintf(ss,"Box colour =>");
      l_c(ss,0);
      if (!cmdnumber(ss,bcol)) return;
    } 
  while (flag<2 || bltype>5 || bltype<-4 || !bltype)
    {
      flag=2;
      sprintf(ss,"Line type =>");
      l_c(ss,0);
      if (!cmdnumber(ss,bltype)) return;
    } 
  if (bltype<0)
    {
      bfill= -1*bltype;
      bltype=1;
      if (flag<3)
	{
	  bsize=1;
	  flag=4;
	}
    }
  while (flag<3 || bsize>300)
    {
      flag=4;
      sprintf(ss,"Line size =>");
      l_c(ss,0);
      if (!cmdnumber(ss,bsize)) return;
    }
  while(bfill>4 || bfill<1)
    {
      sprintf(ss,"Fill type (1-4) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,bfill)) return;
    }

  layer_command("Drag cursor to form box");
  int tst=1;
  char ans='X';
  float x1,y1,x2,y2;
  while(tst && ans=='X')
    {
      tst=mpgband(0,0,0.0,0.0,x1,y1,ans);  //check can't cast this to sband
      tst=mpgband(2,0,x1,y1,x2,y2,ans);
    }
  Frame *fm = dynamic_cast<Frame*>(this);
  if (!tst) 
    {
      hold_.graph_flag=1;
      return; //cursor failed  
    }
  Obox* ob=new Obox(bcol,bltype,bsize,bfill);
  ob->set_pos(fm,x1,y1,x2,y2);
  if (ans2!='R' || fbox<0)
    {
      OI.push_back(ob);
      OItem++;
    }
  else
    OI[fbox]= ob;
  hold_.graph_flag=1;
  if(fm)
    fm->redraw();
  return;
}

void
Objects::all_obj()
{
  Frame *fm=dynamic_cast<Frame*>(this);
  std::vector<ObjItem*>::iterator Ditem=OI.begin();
  for(;Ditem!=OI.end();Ditem++)   //have to remove specifically line 3 types
    {
      if ((*Ditem)->obj_type()!=3)
	(*Ditem)->draw(fm);
      else 
	{
	  Oline* tl = dynamic_cast<Oline*>((*Ditem));
	  if (tl)     //  && !tl->isFirst())
	    tl->drawforward(fm);

	}
    } 

  return;
}
