#include <math.h>
#include "wshare.h"
#include "npic.h"
#include "cmd.h"

#include <Xm/DrawingA.h>




XImage *
Rottext::MakeXImage(Display* dpy,int w,int h) const
/* CHECK MEMORY ALLOCATION AND DEALLOCATION */
{
  XImage *I;
  char *data;
  /* reserve memory for image */
  data=(char *)calloc((unsigned)(((w-1)/8+1)*h), 1);
  if(!data)
    return NULL;
  
  /* create the XImage */
  I=XCreateImage(dpy, DefaultVisual(dpy, DefaultScreen(dpy)), 1, XYBitmap,
		 0, data, w, h, 8, 0);
  if(!I)
    return 0;
  
  I->byte_order=I->bitmap_bit_order=MSBFirst;
  return I;
} 

XImage *
Rottext::XRotMagnifyImage(Display* dpy, XImage* xim)
  /* not yest changed */
{
    int i, j;
    float x, y;
    float u,t;
    XImage *I_out;
    int cols_in, rows_in;
    int cols_out, rows_out;
    register int i2, j2;
    float z1, z2, z3, z4;
    int byte_width_in, byte_width_out;
    float mag_inv;

    /* size of input image */
    cols_in=xim->width;
    rows_in=xim->height;

    /* size of final image */
    cols_out=(int) ((float)cols_in*this->magnify);
    rows_out=(int) ((float)rows_in*this->magnify);

    /* this will hold final image */
    I_out=MakeXImage(dpy, cols_out, rows_out);
    if(I_out==NULL)
	return NULL;

    /* width in bytes of input, output images */
    byte_width_in=(cols_in-1)/8+1;
    byte_width_out=(cols_out-1)/8+1;

    /* for speed */
    mag_inv=1./this->magnify;

    y=0.;

    /* loop over magnified image */
    for(j2=0; j2<rows_out; j2++) 
      {
	x=0;
	j=(int) y;

	for(i2=0; i2<cols_out; i2++) 
	  {
	    i=(int) x;

	    /* bilinear interpolation - where are we on bitmap ? */
	    /* right edge */
	    if(i==cols_in-1 && j!=rows_in-1) 
	      {
		t=0;
		u=y-(float)j;

		z1=(xim->data[j*byte_width_in+i/8] & 128>>(i%8))>0;
		z2=z1;
		z3=(xim->data[(j+1)*byte_width_in+i/8] & 128>>(i%8))>0;
		z4=z3;
	    }
	    /* top edge */
	    else if(i!=cols_in-1 && j==rows_in-1) {
		t=x-(float)i;
		u=0;

		z1=(xim->data[j*byte_width_in+i/8] & 128>>(i%8))>0;
		z2=(xim->data[j*byte_width_in+(i+1)/8] & 128>>((i+1)%8))>0;
		z3=z2;
		z4=z1;
	    }
	    /* top right corner */
	    else if(i==cols_in-1 && j==rows_in-1) {
		u=0;
		t=0;

		z1=(xim->data[j*byte_width_in+i/8] & 128>>(i%8))>0;
		z2=z1;
		z3=z1;
		z4=z1;
	    }
	    /* somewhere `safe' */
	    else {
		t=x-(float)i;
		u=y-(float)j;

		z1=(xim->data[j*byte_width_in+i/8] & 128>>(i%8))>0;
		z2=(xim->data[j*byte_width_in+(i+1)/8] & 128>>((i+1)%8))>0;
		z3=(xim->data[(j+1)*byte_width_in+(i+1)/8] &
		    128>>((i+1)%8))>0;
		z4=(xim->data[(j+1)*byte_width_in+i/8] & 128>>(i%8))>0;
	    }

	    /* if interpolated value is greater than 0.5, set bit */
	    if(((1-t)*(1-u)*z1 + t*(1-u)*z2 + t*u*z3 + (1-t)*u*z4)>0.5)
		I_out->data[j2*byte_width_out+i2/8]|=128>>i2%8;

	    x+=mag_inv;
	}
	y+=mag_inv;
    }
    
    /* destroy original */
    XDestroyImage(xim);

    /* return big image */
    return I_out;
}




void
Rottext::no_n_str(char *st) const 
{
  int i=0;
  if (!st)
    return;
  for(i=0;st[i] && st[i]!='\n';i++);
  st[i]=0;
  return;
}

void 
Rottext::SetMagnification(const double m)
{
  if (m>0.0)
    magnify=m;
  return;
}


int
Rottext::MakeCache(Display *dpy,XFontStruct* font,double R_ang,
                   double Mag,char *str)
  /*
     Differs from original in that it is only going to 
     look at teh current class. 
     It looks, sees if we are identical if not remakes it.

     Changed to reflect the idea of only one class, and no list.
  */

{
  Font new_fid;
  char *new_font_name(0);
  long unsigned int name_value;
  //  rottext *item=0;
  //rottext *i1=first_text_item;

  if(XGetFontProperty(font, XA_FONT, &name_value) )
    {
      new_font_name=XGetAtomName(dpy, name_value);  //get net text name
      new_fid=0;
    }
  else
    {
      new_font_name=0;
      new_fid=0;
    }
  //check next items to find match.
  // match everything EXCEPT fontname/ID 
  int found=0;
  if(strcmp(str, this->text)==0 &&
     fabs(R_ang- this->angle)<0.0001 &&
     Mag==this->magnify)
    {
      // now match fontname/ID 
      if(new_font_name && this->font_name) 
	{
	  if(strcmp(new_font_name, this->font_name)==0) 
	    found=1;;
	}
    }

	
  if (!found)       //missed the match
    {
      found=CreateTextItem(dpy,font,R_ang,str);
      if (!found)
	return 0;
      
      //      this->text=strdup(str);  Done by CreateTextItem
      if (new_font_name)
	{
	  this->font_name=strdup(font_name);
	  this->fid=0;
	}
      else
	{
	  this->font_name=0;
	  this->fid=fid;
	}
      this->angle=angle;
      this->align=0;
      this->magnify=magnify;
    }
  if (font_name)
    XFree(font_name);
  
  //#ifdef CACHE_XIMAGES

  GC depth_one_gc;
  
  /* create bitmap to hold rotated text */
  this->bitmap=XCreatePixmap(dpy, DefaultRootWindow(dpy),
			     this->cols_out, this->rows_out, 1);
  
  /* depth one gc */
  depth_one_gc=XCreateGC(dpy, this->bitmap, 0, 0);   //CHECK THIS
  XSetBackground(dpy, depth_one_gc, 0);
  XSetForeground(dpy, depth_one_gc, 1);
  
	/* make the text bitmap from XImage */
  XPutImage(dpy, this->bitmap, depth_one_gc, this->ximage, 0, 0, 0, 0,
	    this->cols_out, this->rows_out);
  
  XFreeGC(dpy, depth_one_gc);
  
  //#endif /*CACHE_XIMAGES*/
    
  return 1;

}


int
Rottext::CreateTextItem(Display* dpy,XFontStruct *font,double R_ang,
                    char *str)
  /* 
     sets text,cols_in,rows_in,rows_out,cols_out
  */
{
    Pixmap canvas;
    GC font_gc;
    XImage *I_in;

    //    char *str1, *str2, *str3;
    //    char *str2_a="\0", *str2_b="\n\0";
    int height;
    int byte_w_in, byte_w_out;
    int xp, yp;
    float sin_angle, cos_angle;
    int it, jt;
    float di, dj;
    int ic=0;
    float xl, xr, xinc;
    int byte_out;
    int dir, asc, desc;
    XCharStruct overall;
    int old_cols_in=0, old_rows_in=0;
    
    /* deallocate memory   (if it is a old item) */
      if (text)
	{
	  delete [] text;
	  text=0;
	}

    /* find width of longest section */

    if(!str)   //no string no need, to make
      return 0;
    
    // change we are going to strip string to remove /n and 0 
    no_n_str(str); //first 

    XTextExtents(font, str, strlen(str), &dir, &asc, &desc,
		 &overall);
    
    this->max_width=overall.rbearing;  //get max width
    
    /* loop through each section */
    /* overall font height */

    height=font->ascent+font->descent;    //check font
    
    /* dimensions horizontal text will have */
    this->cols_in=this->max_width;
    this->rows_in=height;   //nl =1
    
    /* bitmap for drawing on */
    canvas=XCreatePixmap(dpy, DefaultRootWindow(dpy),
			 this->cols_in, this->rows_in, 1);
    
    /* create a GC for the bitmap */
    font_gc=XCreateGC(dpy, canvas, 0, 0);
    XSetBackground(dpy, font_gc, 0);
    XSetFont(dpy, font_gc, font->fid);   //CHECK font
    
    /* make sure the bitmap is blank */
    XSetForeground(dpy, font_gc, 0);
    XFillRectangle(dpy, canvas, font_gc, 0, 0, 
		   this->cols_in+1, this->rows_in+1);
    XSetForeground(dpy, font_gc, 1);
    
    /* pre-calculate sin and cos */
    sin_angle=sin(R_ang);
    cos_angle=cos(R_ang);
    
    /* text background will be drawn using XFillPolygon */
     /* draw text horizontally */
    
    /* start at top of bitmap */
    yp=font->ascent;
    /*    
    str1=strdup(this->text);
    if(str1==NULL)
	return NULL;
    
    str3=my_strtok(str1, str2);
    */

    /* loop through each section in the string */
    XTextExtents(font, this->text, strlen(this->text), &dir, &asc, &desc,
		 &overall);
    if(align==TLEFT || align==MLEFT || align==BLEFT || align==NONE)
      xp=0;
    else if(align==TCENTRE || align==MCENTRE || align==BCENTRE)
      xp=(this->max_width-overall.rbearing)/2;
    else
      xp=this->max_width-overall.rbearing;
    
    /* draw string onto bitmap */
    XDrawString(dpy, canvas, font_gc, xp, yp, this->text, strlen(this->text));
	
    /* keep a note of corner positions of this string */
    this->corners_x[0]=((float)xp-(float)this->cols_in/2)*this->magnify;
    this->corners_y[0]=((float)(yp-font->ascent)-(float)this->rows_in/2)
      *this->magnify;
    this->corners_x[1]=this->corners_x[0];
    this->corners_y[1]=this->corners_y[0]+(float)height*this->magnify;
    this->corners_x[3]=this->corners_x[0]+
      (float)overall.rbearing*this->magnify;
    this->corners_y[3]=this->corners_y[0];   // may need to move 3/2 around.
    this->corners_x[2]= this->corners_x[3];
    this->corners_y[2]=this->corners_y[1];


    /* create image to hold horizontal text */    // Should this be ximage ?
    I_in=MakeXImage(dpy, this->cols_in, this->rows_in);
    if(!I_in)
      return 0;
    
    /* extract horizontal text */
    XGetSubImage(dpy, canvas, 0, 0, this->cols_in, this->rows_in,
		 1, XYPixmap, I_in, 0, 0);
    I_in->format=XYBitmap;
    
    /* magnify horizontal text */
    if(this->magnify!=1.) 
      {
	I_in=XRotMagnifyImage(dpy, I_in);

	old_cols_in=this->cols_in;
	old_rows_in=this->rows_in;
	this->cols_in=(int) ((float)this->cols_in*this->magnify);
	this->rows_in=(int) ((float)this->rows_in*this->magnify);
    }

    /* how big will rotated text be ? */
    this->cols_out=(int) (fabs((float)this->rows_in*sin_angle) +
	fabs((float)this->cols_in*cos_angle) +0.99999 +2);

    this->rows_out=(int) (fabs((float)this->rows_in*cos_angle) +
	fabs((float)this->cols_in*sin_angle) +0.99999 +2);

    if(this->cols_out%2==0)
	this->cols_out++;
    
    if(this->rows_out%2==0)
	this->rows_out++;
    
    /* create image to hold rotated text */
    this->ximage=MakeXImage(dpy, this->cols_out, this->rows_out);
    if(!this->ximage)
	return 0;
    
    byte_w_in=(this->cols_in-1)/8+1;
    byte_w_out=(this->cols_out-1)/8+1;
    
    /* we try to make this bit as fast as possible - which is why it looks
       a bit over-the-top */
    
    /* vertical distance from centre */
    dj=0.5-(float)this->rows_out/2;

    /* where abouts does text actually lie in rotated image? */
    if(angle==0 || angle==M_PI/2 || 
       angle==M_PI || angle==3*M_PI/2) {
	xl=0;
	xr=(float)this->cols_out;
	xinc=0;
    }
    else if(angle<M_PI) {
	xl=(float)this->cols_out/2+
	    (dj-(float)this->rows_in/(2*cos_angle))/
		tan(angle)-2;
	xr=(float)this->cols_out/2+
	    (dj+(float)this->rows_in/(2*cos_angle))/
		tan(angle)+2;
	xinc=1./tan(angle);
    }
    else {
	xl=(float)this->cols_out/2+
	    (dj+(float)this->rows_in/(2*cos_angle))/
		tan(angle)-2;
	xr=(float)this->cols_out/2+
	    (dj-(float)this->rows_in/(2*cos_angle))/
		tan(angle)+2;
	
	xinc=1./tan(angle);
    }

    /* loop through all relevent bits in rotated image */
    for(int j=0; j<this->rows_out; j++) {
	
	/* no point re-calculating these every pass */
	di=(float)((xl<0)?0:(int)xl)+0.5-(float)this->cols_out/2;
	byte_out=(this->rows_out-j-1)*byte_w_out;
	
	/* loop through meaningful columns */
	for(int i=((xl<0)?0:(int)xl); 
	    i<((xr>=this->cols_out)?this->cols_out:(int)xr); i++) {
	    
	    /* rotate coordinates */
	    it=(int) ((float)this->cols_in/2 + ( di*cos_angle + dj*sin_angle));
	    jt=(int) ((float)this->rows_in/2 - (-di*sin_angle + dj*cos_angle));
	    
            /* set pixel if required */
            if(it>=0 && it<this->cols_in && jt>=0 && jt<this->rows_in)
                if((I_in->data[jt*byte_w_in+it/8] & 128>>(it%8))>0)
                    this->ximage->data[byte_out+i/8]|=128>>i%8;
	    
	    di+=1;
	}
	dj+=1;
	xl+=xinc;
	xr+=xinc;
    }
    XDestroyImage(I_in);
    
    if(this->magnify!=1.) {
	this->cols_in=old_cols_in;
	this->rows_in=old_rows_in;
    }


#ifdef CACHE_BITMAPS

    /* create a bitmap to hold rotated text */
    this->bitmap=XCreatePixmap(dpy, DefaultRootWindow(dpy),
			       this->cols_out, this->rows_out, 1);
    
    /* make the text bitmap from XImage */
    XPutImage(dpy, this->bitmap, font_gc, this->ximage, 0, 0, 0, 0,
	      this->cols_out, this->rows_out);

    XDestroyImage(this->ximage);

#endif /*CACHE_BITMAPS*/

    XFreeGC(dpy, font_gc);
    XFreePixmap(dpy, canvas);

    return 1;
}



int
Rottext::DrawString(Display *dpy,XFontStruct *font,
                    double angle,Drawable drawable,
                    GC gc, int x, int y,
                    char *str)
  /* 
     dpy is from MotP
     font from MotP
     angle == input angle
     x, y == position
     str == string to print (only one line allowed)
     gc == MotP gc 
   */
{
  this->align = NONE;
  int bg=0;
  
  int i;
  GC my_gc;
  int xp, yp;
  float hot_x, hot_y;
  float hot_xp, hot_yp;
  float sin_angle, cos_angle;
  Pixmap bitmap_to_paint;
  
  /* return early for NULL/empty strings */
  if(!text)
    return 0;
    
  if(strlen(text)==0)
    return 0;

  /* manipulate angle to 0<=angle<360 degrees */
  while(angle<0)
    angle+=360;
    
    while(angle>=360)
        angle-=360;
    
    angle*=PI/180;   //radians
    
    /* horizontal text made easy */

    //    if(angle==0 && style.magnify==1.) 
    //  return(XRotDrawHorizontalString(dpy, font, drawable, gc, x, y,
    //					text));
    
    /* get a rotated bitmap */

    item=RetrieveFromCache(dpy, font, angle, text, align);
    if(!item)
	return 0;
    
    /* this gc has similar properties to the user's gc */
    my_gc=XCreateGC(dpy, drawable, 0, 0);
    XCopyGC(dpy, gc, GCForeground|GCBackground|GCFunction|GCPlaneMask,
	    my_gc);

    /* alignment : which point (hot_x, hot_y) relative to bitmap centre
       coincides with user's specified point? */
    
    /* y position */
    if(align==TLEFT || align==TCENTRE || align==TRIGHT)
        hot_y=(float)item->rows_in/2*style.magnify;
    else if(align==MLEFT || align==MCENTRE || align==MRIGHT)
	hot_y=0;
    else if(align==BLEFT || align==BCENTRE || align==BRIGHT)
	hot_y=-(float)item->rows_in/2*style.magnify;
    else
	hot_y=-((float)item->rows_in/2-(float)font->descent)*style.magnify;
    
    /* x position */
    if(align==TLEFT || align==MLEFT || align==BLEFT || align==NONE)
	hot_x=-(float)item->max_width/2*style.magnify;
    else if(align==TCENTRE || align==MCENTRE || align==BCENTRE)
	hot_x=0;
    else
        hot_x=(float)item->max_width/2*style.magnify;
    
    /* pre-calculate sin and cos */
    sin_angle=sin(angle);
    cos_angle=cos(angle);
    
    /* rotate hot_x and hot_y around bitmap centre */
    hot_xp= hot_x*cos_angle - hot_y*sin_angle;
    hot_yp= hot_x*sin_angle + hot_y*cos_angle;
    
    /* text background will be drawn using XFillPolygon */
    if(bg) {
	GC depth_one_gc;
	XPoint *xpoints;
	Pixmap empty_stipple;
	
	/* reserve space for XPoints */
	xpoints=(XPoint *)malloc((unsigned)(4*item->nl*sizeof(XPoint)));
	if(!xpoints)
	    return 1;
	
	/* rotate corner positions */
	for(i=0; i<4*item->nl; i++) {
	    xpoints[i].x=(float)x + ( (item->corners_x[i]-hot_x)*cos_angle + 
				      (item->corners_y[i]+hot_y)*sin_angle);
	    xpoints[i].y=(float)y + (-(item->corners_x[i]-hot_x)*sin_angle + 
				      (item->corners_y[i]+hot_y)*cos_angle);
	}
	
	/* we want to swap foreground and background colors here;
	   XGetGCValues() is only available in R4+ */
	
	empty_stipple=XCreatePixmap(dpy, drawable, 1, 1, 1);
	
	depth_one_gc=XCreateGC(dpy, empty_stipple, 0, 0);
	XSetForeground(dpy, depth_one_gc, 0);
	XFillRectangle(dpy, empty_stipple, depth_one_gc, 0, 0, 2, 2);

	XSetStipple(dpy, my_gc, empty_stipple);
	XSetFillStyle(dpy, my_gc, FillOpaqueStippled);
	
	XFillPolygon(dpy, drawable, my_gc, xpoints, 4*item->nl, Nonconvex,
		     CoordModeOrigin);
	
	/* free our resources */
	free((char *)xpoints);
	XFreeGC(dpy, depth_one_gc);
	XFreePixmap(dpy, empty_stipple);
    }
    
    /* where should top left corner of bitmap go ? */
    xp=(float)x-((float)item->cols_out/2 +hot_xp);
    yp=(float)y-((float)item->rows_out/2 -hot_yp);
    
    /* by default we draw the rotated bitmap, solid */
    bitmap_to_paint=item->bitmap;

    /* handle user stippling */
#ifndef X11R3
    {
	GC depth_one_gc;
	XGCValues values;
	Pixmap new_bitmap, inverse;
	
	/* try and get some GC properties */
	if(XGetGCValues(dpy, gc, 
			GCStipple|GCFillStyle|GCForeground|GCBackground|
			GCTileStipXOrigin|GCTileStipYOrigin,
			&values)) {

	    /* only do this if stippling requested */
	    if((values.fill_style==FillStippled ||
		values.fill_style==FillOpaqueStippled) && !bg) {

		/* opaque stipple: draw rotated text in background colour */
		if(values.fill_style==FillOpaqueStippled) {
		    XSetForeground(dpy, my_gc, values.background);
		    XSetFillStyle(dpy, my_gc, FillStippled);
		    XSetStipple(dpy, my_gc, item->bitmap);
		    XSetTSOrigin(dpy, my_gc, xp, yp);
		    XFillRectangle(dpy, drawable, my_gc, xp, yp,
				   item->cols_out, item->rows_out);
		    XSetForeground(dpy, my_gc, values.foreground);
		}

		/* this will merge the rotated text and the user's stipple */
		new_bitmap=XCreatePixmap(dpy, drawable,
					 item->cols_out, item->rows_out, 1);

		/* create a GC */
		depth_one_gc=XCreateGC(dpy, new_bitmap, 0, 0);
		XSetForeground(dpy, depth_one_gc, 1);
		XSetBackground(dpy, depth_one_gc, 0);

		/* set the relative stipple origin */
		XSetTSOrigin(dpy, depth_one_gc, 
			     values.ts_x_origin-xp, values.ts_y_origin-yp);

		/* fill the whole bitmap with the user's stipple */
		XSetStipple(dpy, depth_one_gc, values.stipple);
		XSetFillStyle(dpy, depth_one_gc, FillOpaqueStippled);
		XFillRectangle(dpy, new_bitmap, depth_one_gc,
			       0, 0, item->cols_out, item->rows_out);

		/* set stipple origin back to normal */
		XSetTSOrigin(dpy, depth_one_gc, 0, 0);

		/* this will contain an inverse copy of the rotated text */
		inverse=XCreatePixmap(dpy, drawable,
				      item->cols_out, item->rows_out, 1);

		/* invert text */
		XSetFillStyle(dpy, depth_one_gc, FillSolid);
		XSetFunction(dpy, depth_one_gc, GXcopyInverted);
		XCopyArea(dpy, item->bitmap, inverse, depth_one_gc,
			  0, 0, item->cols_out, item->rows_out, 0, 0);

		/* now delete user's stipple everywhere EXCEPT on text */
                XSetForeground(dpy, depth_one_gc, 0);
                XSetBackground(dpy, depth_one_gc, 1);
		XSetStipple(dpy, depth_one_gc, inverse);
		XSetFillStyle(dpy, depth_one_gc, FillStippled);
		XSetFunction(dpy, depth_one_gc, GXcopy);
		XFillRectangle(dpy, new_bitmap, depth_one_gc,
                               0, 0, item->cols_out, item->rows_out);

		/* free resources */
		XFreePixmap(dpy, inverse);
		XFreeGC(dpy, depth_one_gc);

		/* this is the new bitmap */
		bitmap_to_paint=new_bitmap;
	    }
	}
    }
#endif /*X11R3*/

    /* paint text using stipple technique */
    XSetFillStyle(dpy, my_gc, FillStippled);
    XSetStipple(dpy, my_gc, bitmap_to_paint);
    XSetTSOrigin(dpy, my_gc, xp, yp);
    XFillRectangle(dpy, drawable, my_gc, xp, yp, 
		   item->cols_out, item->rows_out);
    
    /* free our resources */
    XFreeGC(dpy, my_gc);

    /* stippled bitmap no longer needed */
    if(bitmap_to_paint!=item->bitmap)
	XFreePixmap(dpy, bitmap_to_paint);

#ifdef CACHE_XIMAGES
    XFreePixmap(dpy, item->bitmap);
#endif /*CACHE_XIMAGES*/

    /* if item isn't cached, destroy it completely */
    if(!item->cached) 
	XRotFreeTextItem(dpy,item);

    /* we got to the end OK! */
    return 0;
}


