#ifndef npic_h
#define npic_h

#define NONE             0
#define TLEFT            1
#define TCENTRE          2
#define TRIGHT           3
#define MLEFT            4
#define MCENTRE          5
#define MRIGHT           6
#define BLEFT            7
#define BCENTRE          8
#define BRIGHT           9
#define PI 3.141592

class Rottext
{
  Pixmap bitmap;
  XImage *ximage;
  
  char *text;
  char *font_name;
  Font fid;
  double angle;
  int align;
  double magnify;
  
  int cols_in;
  int rows_in;
  int cols_out;
  int rows_out;
  //number of lines 1 only
  int max_width;
  float corners_x[2];
  float corners_y[2];
  
  int bbx_pad;  

  void no_n_str(char *) const;
  int MakeCache(Display *,XFontStruct *,double,double,char *);
  XImage* MakeXImage(Display* dpy,int w,int h) const;
  XImage* XRotMagnifyImage(Display*,XImage*);

public :
    
  int CreateTextItem(Display *,XFontStruct *,double,char *);
  void SetMagnification(const double);
  int DrawString(Display *, XFontStruct *, double, Drawable, 
		 GC, int, int, char *);
};

class MotP
{
private:

  int made_win;
  int width,height;
  

  GC gc;          //Xlib graphic context
  XGCValues gcv;

  Display* display;
  Screen* screen;
  Window pic_win;
  Pixmap pixmap;  //mirror copy
  XFontStruct* font; //place for fonts

  Widget Wshell;
  Widget drawA;

  // callbacks

  static void Xcurs_in_pic(Widget,XtPointer,XtPointer);
  static void resize(Widget,XtPointer,XtPointer);

  //Helper functions to interact with Xlib interface.

  void resize_pixmap();
  void clear_pic() const;

protected:
  
  double xfmin,xfmax,yfmin,yfmax;  //view coordinates 0-1
  double xmin,xmax,ymin,ymax;      //actual values
  double xfdiff,yfdiff;
  double xdiff,ydiff;              //differences of others

  void setlinewidth(const int);
  void setlinestyle(const int);
  
public:

  MotP();
  ~MotP();

  void line(const double,const double,const double,const double);
  void place_text(const double,const double,char *);
  void make_wind();
  void draw_frame(const double *);
  void draw_frame(const double,const double,const double,const double);

};

class Axis : public MotP
{
private:

  int linewidth;
  int xmajor,xminor;  //number of ticks
  int ymajor,yminor;  //nubmer of ticks
  int boxtype;        //type of box to draw

  double rnd_num(const double,int &) const;
  void CalcAxisX(const int,const int,const int,const int);
  void CalcAxisY(const int,const int,const int,const int);
  
public:

  Axis::Axis();
  Axis::~Axis();
  void DrawAxis();
  

};

class Picture :  public Axis
{
private:

  int colour;
  int gline_width;
  int gline_style;

public:


  Picture();
  ~Picture();
  

  void linespectra(const int,const int,const int,const double);
  void Draw();
  void setline_style(const int =0);
  void setline_width(const int =0);
  void line(const int,const double*,const double*); //pgline()
}; 

#endif










