#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "npic.h"
#include "cmd.h"


#include <Xm/DrawingA.h>

/* Stuff to do our new graphic window */

extern Widget main_w;

Picture::Picture()
{}

Picture::~Picture()
{}


void
Picture::Draw()
{
  make_wind();
  return;
}

MotP::MotP() : made_win(0),width(400),height(300),
               xfmin(0.15),xfmax(0.85),yfmin(0.15),yfmax(0.85),
               xmin(0.0),xmax(500.0),ymin(0.0),ymax(500.0),
               xfdiff(xfmax-xfmin),yfdiff(yfmax-yfmin),
               xdiff(xmax-xmin),ydiff(ymax-ymin)
{}


void
MotP::place_text(const double x,const double y,char *ss)
{
  int x1=int ((width-1) * (xfmin+xfdiff*(x-xmin)/xdiff));
  int y1=int ((height-1) * (yfmax-yfdiff*(y-ymin)/ydiff));
  XSetFont(display,gc,font->fid);
  XDrawString(display,pic_win,gc,x1,y1,ss,strlen(ss));
  XDrawString(display,pixmap,gc,x1,y1,ss,strlen(ss));
  return;
}

void
MotP::Xcurs_in_pic(Widget w,XtPointer client_data,XtPointer call_data)
{
  MotP *THIS=(MotP *) client_data;
  XmDrawingAreaCallbackStruct *cbs =
    (XmDrawingAreaCallbackStruct *) call_data;
  XEvent *event = cbs->event;
  if (cbs->reason == XmCR_INPUT)
    {
      char ss[256];
      sprintf(ss,"Position is %d %d",event->xbutton.x,event->xbutton.y);
      l_c(ss,1);
      Axis* Apt=static_cast<Axis*>(THIS);
      Apt->DrawAxis();
    }
  else if (cbs->reason == XmCR_EXPOSE)
    {
      XCopyArea(THIS->display,THIS->pixmap,THIS->pic_win,
		THIS->gc,0,0,THIS->width,THIS->height,0,0);
    }
  return;
}

void
MotP::resize_pixmap()
{
  XFreePixmap(display,pixmap);
  pixmap = XCreatePixmap(display,RootWindowOfScreen(screen),
			 width,height,
			 DefaultDepthOfScreen(screen));
  gcv.foreground = WhitePixelOfScreen(screen);
  XChangeGC(display,gc,GCForeground,&gcv);
  XFillRectangle(display,pixmap,gc,0,0,width,height);
  gcv.foreground = BlackPixelOfScreen(screen);
  XChangeGC(display,gc,GCForeground,&gcv);
  return;
}

void
MotP::resize(Widget w,XtPointer client_data,XtPointer call_data)
{
  MotP* THIS= (MotP*) client_data;
  XtVaGetValues(w,XmNwidth,&THIS->width,
  		      XmNheight,&THIS->height,NULL);
  THIS->clear_pic(); 
  THIS->resize_pixmap();
  return;
}

void
MotP::draw_frame(const double xs,const double xe,
		 const double ys,const double ye)
{
  Position x=int (xs*width);
  Position y=int (ys*height);
  int w= int((xe-xs) * width);
  int h= int((ye-ys) * height);
  XDrawRectangle(display,pic_win,gc,x,y,w,h);
  XDrawLine(display,pic_win,gc,x,y,w,h);
  XDrawRectangle(display,pixmap,gc,x,y,w,h);
  XDrawLine(display,pixmap,gc,x,y,w,h);

  return;
}                


void
MotP::setlinewidth(const int nsize)
{
  gcv.line_width= nsize>0 ? nsize : 0;
  XChangeGC(display,gc,GCLineWidth,&gcv);
  return;
}

void
MotP::setlinestyle(const int nstyle)
{
  gcv.line_style = nstyle>0 ? nstyle : 0;
  XChangeGC(display,gc,GCLineStyle,&gcv);
  return;
}

void
MotP::line(const double xsp,const double ysp,
           const double xep,const double yep)
{
  int x1=int ((width-1) * (xfmin+xfdiff*(xsp-xmin)/xdiff));
  int x2=int ((width-1) * (xfmin+xfdiff*(xep-xmin)/xdiff));
  int y1=int ((height-1) * (yfmax-yfdiff*(ysp-ymin)/ydiff));
  int y2=int ((height-1) * (yfmax-yfdiff*(yep-ymin)/ydiff));
  XDrawLine(display,pic_win,gc,x1,y1,x2,y2);
  XDrawLine(display,pixmap,gc,x1,y1,x2,y2);
  return;
}

void
MotP::draw_frame(const double *Cnrs)
{
  int x=int (Cnrs[0]*width);
  int y=int (Cnrs[1]*height);
  int w= int((Cnrs[2]-Cnrs[0]) * width);
  int h= int((Cnrs[3]-Cnrs[1]) * height);
  XDrawRectangle(display,pic_win,gc,x,y,w,h);
  return;
}                

void
MotP::clear_pic() const 
{
  XClearWindow(XtDisplay(drawA),XtWindow(drawA));
  return;
}


void 
MotP::make_wind()
{
  if (made_win) return;
  Wshell=XtVaCreatePopupShell("wshell",
			      topLevelShellWidgetClass,main_w,
			      XtNtitle, "Graphic Window",
			      XmNdeleteResponse, XmDESTROY,
			      NULL);
  
  drawA = XtVaCreateManagedWidget("Mainpic",
		               xmDrawingAreaWidgetClass, Wshell,
			       XtNtitle, "Graphics Window",
      			       XmNbackground,get_pixel(main_w,"white"),
   			       XmNforeground,get_pixel(main_w,"black"),
			       XmNheight,height,
			       XmNwidth,width,
			       XmNresizePolicy,XmRESIZE_ANY,
			       NULL);

  XtAddCallback(drawA,XmNinputCallback,Xcurs_in_pic,(XtPointer) this);
  XtAddCallback(drawA,XmNexposeCallback,Xcurs_in_pic,(XtPointer) this);
  XtAddCallback(drawA,XmNresizeCallback,resize,(XtPointer) this);

  display=XtDisplay(drawA);
  font= XLoadQueryFont(display,"fixed");
  screen=XtScreen(drawA);
  gc = XCreateGC(display,RootWindowOfScreen(screen),
		 GCForeground,&gcv);

  XtVaSetValues(drawA,XmNuserData,gc,NULL);

  gcv.foreground = WhitePixelOfScreen(XtScreen(drawA));
  XChangeGC(display,gc,GCForeground,&gcv);


  pixmap = XCreatePixmap(display,RootWindowOfScreen(screen),
			 width,height,
			 DefaultDepthOfScreen(screen));
  XFillRectangle(display,pixmap,gc,0,0,width,height);
  gcv.foreground = BlackPixelOfScreen(screen);
  XChangeGC(display,gc,GCForeground,&gcv);

  

  XtManageChild(drawA);
  XtManageChild(Wshell);
  XtRealizeWidget(Wshell);
  pic_win=XtWindow(drawA);
  made_win=1;
  return;
}

MotP::~MotP()
{
  //  if (made_win)
  //  XtDestroyWidget(Wshell);
}


Axis::Axis() : MotP(),linewidth(0),
               xmajor(0),xminor(0),ymajor(0),yminor(0),
               boxtype(4095)
{}

Axis::~Axis() 
{}  


double
Axis::rnd_num(const double x,int &nsub) const
  /* returns multiple number of 1,2,5 power of 10.
    8.7 == 10, -0.4 == -0.5 etc....
    nsub == subdivisions that work
  */
{
  if (x==0.0)
    {
      nsub=2;
      return 0.0;
    }
  double xx=fabs(x);
  double xlog=log10(xx);
  int ilog=(int) xlog;
  if (xlog<0.0) ilog--;
  double pwr=pow(10.0,ilog);
  double frac=xx/pwr;

  if (frac<2.0)
    {
      nsub=2;
      return (x>0.0) ? 2.0*pwr : -2.0*pwr;
    }
  else if (frac<=5.0) 
    {
      nsub=5;
      return (x>0.0) ? 5.0*pwr : -5.0*pwr;
    }
  else 
    {
      nsub=5;
      return (x>0.0) ? 10.0*pwr : -10.0 * pwr;
    }
}

  
void
Axis::CalcAxisX(const int lower_mjr,const int lower_mnr,
		const int higher_mjr,const int higher_mnr)
{
  double frac;
  if (xmajor>0)
    frac=1.0/xmajor;
  else
    frac=0.2;
  int nsubt;
  double dvmaj=rnd_num(fabs(xmax-xmin),nsubt);
  //  cout<<"Dvmaj "<<dvmaj<<endl;
  double dvmin=frac*dvmaj/nsubt;
  //  int npow= int(log10(fabs(dvmin)))-4;
  //  int nv=int( 0.5+dvmin/pow(10.0,npow));  //for actual number
  int npow=int(log10(dvmaj));
  double dv;
  if (npow<=3 && npow>=-1)
    {
      dv=1.0;
      npow=0;
    }
  else
    dv=pow(10.0,npow);

  int k1= (int) (xmin/dvmin);
  int k2= (int) (xmax/dvmin);
  if (dvmin*k1<xmin) k1--;  
  if (dvmin*k2>xmax) k2++;
  double v;
  char ss[256];
  for(int k=k1;k<=k2;k++)
    {
      v=k*dvmin;
      if (!xminor && !(k % nsubt))
	{
	  sprintf(ss,"%4.4g",v/dv);
	  MotP::place_text(v,ymin,ss);
	  if (lower_mjr)
	    line(v,ymin,v,ymin+0.025*ydiff);   //bigger line
	  if (higher_mjr)
	    line(v,ymax,v,ymax-0.025*ydiff);   //bigger line
	}
      else
	{
	  if (lower_mnr)
	    line(v,ymin,v,ymin+0.0125*ydiff);    //smaller line
	  if (higher_mnr)
	    line(v,ymax,v,ymax-0.0125*ydiff);    //smaller line
	}
    }

  return;
}
  
void
Axis::CalcAxisY(const int lower_mjr,const int lower_mnr,
		const int higher_mjr,const int higher_mnr)
{
  double frac;
  if (xmajor>0)
    frac=1.0/ymajor;
  else
    frac=0.2;
  int nsubt;
  double dvmaj=rnd_num(fabs(ymax-ymin),nsubt);
  double dvmin=frac*dvmaj/nsubt;
  int npow= int(log10(fabs(dvmin)))-4;
  int nv=int( 0.5+dvmin/pow(10.0,npow));  //for actual number
  
  int k1= (int) (ymin/dvmin);
  int k2= (int) (ymax/dvmin);
  if (dvmin*k1<ymin) k1--;  
  if (dvmin*k2>ymax) k2++;
  double v;
  for(int k=k1;k<=k2;k++)
    {
      v=k*dvmin;
      if (!(k % nsubt))
	{
	  if (lower_mjr)
	    line(xmin,v,xmin+0.025*xdiff,v);   //bigger line
	  if (higher_mjr)
	    line(xmax,v,xmax-0.025*xdiff,v);   //bigger line
	}
      else
	{
	  if (lower_mnr)
	    line(xmin,v,xmin+0.0125*xdiff,v);    //smaller line
	  if (higher_mnr)
	    line(xmax,v,xmax-0.0125*xdiff,v);    //smaller line
	}
    }
  return;
}


void
Axis::DrawAxis()
  /* Draw a box using 1,2,4,8  = lines
                      16-128   = major ticks
                      256-2048 = minor ticks
                      4096-8192 = numbers printed
  */
{
  MotP::setlinewidth(linewidth);
  MotP::setlinewidth(0);
  if (boxtype & 1)
    {
      line(xmin,ymin,xmax,ymin);
      CalcAxisX(boxtype & 16,boxtype & 256,boxtype & 64,boxtype & 1024);
    }
  if (boxtype & 2)
    {
      line(xmin,ymin,xmin,ymax);
      CalcAxisY(boxtype & 32,boxtype & 512,boxtype & 128,boxtype & 2048);
    }
  if (boxtype & 4)
    {
      line(xmin,ymax,xmax,ymax);
    }
  if (boxtype & 8)
    {
      line(xmax,ymin,xmax,ymax);
    }
  return;
}

void
Picture::setline_width(const int W)  //pgslw
{
  gline_width=W;
  MotP::setlinewidth(W);
}

void
Picture::setline_style(const int S)  //pgsls
{
  gline_style=S;
  MotP::setlinewidth(S);
}


void 
Picture::linespectra(const int grp,const int color,const int linetype,
                     const double size)
{
  
  extern Spec_In storage_;
  if (grp>tg-1 || grp<0) return;
  int npts=storage_.stpnt[grp];
  if (!npts) return;

  setlinewidth(gline_width);
  setlinestyle(gline_style);
  
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  int inside=0;
  double xstart= X[0];
  double ystart= Y[0];
  if (xstart>=xmin && xstart<=xmax &&
      ystart>=ymin && ystart<=ymax)
    inside=1;
  for(int i=1;i<npts;i++)
    {
      if (!inside)
	{
	  if (X[i]>=xmin && X[i]<=xmax &&
              Y[i]>=ymin && Y[i]<=ymax )
	    {
	      inside=1;
	      // Do last to current point solving for xmin/ymin intercept
	    }
	}
      else
	{
	  if (X[i]>=xmin && X[i]<=xmax &&
              Y[i]>=ymin && Y[i]<=ymax )

	    {
	      MotP::line(X[i-1],Y[i-1],X[i],Y[i]);
	    }
	  else
	    inside=0;
	}
    }
  return;
}

void 
Picture::line(const int count,const double* X,const double* Y)
  /* 
     This take array size, x,y points
     Mimic of pgline 
  */
{
  if (count<2) return;
  int inside=0;
  double xstart= X[0];
  double ystart= Y[0];
  if (xstart>=xmin && xstart<=xmax &&
      ystart>=ymin && ystart<=ymax)
    inside=1;
  for(int i=1;i<count;i++)
    {
      if (!inside)
	{
	  if (X[i]>=xmin && X[i]<=xmax &&
              Y[i]>=ymin && Y[i]<=ymax )
	    {
	      inside=1;
	      // Do last to current point solving for xmin/ymin intercept
	    }
	}
      else
	{
	  if (X[i]>=xmin && X[i]<=xmax &&
              Y[i]>=ymin && Y[i]<=ymax )

	    {
	      MotP::line(X[i-1],Y[i-1],X[i],Y[i]);
	    }
	  else
	    inside=0;
	}
    }
  return;
}



