#ifndef new_read_h
#define new_read_h


extern "C" void bin_xray__(int *,int*,int*);
extern "C" void xtalplot_(float*,int*,float*,int*,float*,int*,int*,float*);

class Curs_Screen;
class space_correct; 
class space_box; 

class XrayMaps
{
private:

  int n_pts;
  int n_hp;
  int n_vp;
  float** values;
  void move_x(const double);
  void move_y(const double);
  void changeXYsize(const int,const int);

public:
 
  int verify_cord(char *,int *) const;   // check coords are in box
  int setmaxmin(float&,float&,const int) const;

  int read_data(const int,const int,char*,const int,const int=0);  
  int read_ascii(const char* =0,const int =0,const int=0);  
  int read_fit2d(const char* =0,const int =0,const int=0);  
  int read_esrf(char* =0,const int=1,const int = -1,const int = -1,
                   const int =1,const int=1);  
  int read_norm(char*,const int);
  int write_data(ofstream &);
  int write_esrf(ofstream &);
  void handle(int &,int&,float** &) const;
  void makespace(const int,const int);
  void polar(const double,const double,const float,const float);
  double average(const int) const; // returns the mean values of an area.
  double average(const int,const int,const int,const int,const int) const; 
  void logofV();
  void expofV();
  void power(const double pwer);
  int pts() const;
  int xpt() const;
  int ypt() const;
  void self(const double,const double);
  void re_centre(const double,const double);
  void flip_x(const double);
  void flip_y(const double);
  void smooth(const int =1);
  void enhance(const int =1);
  void rollx(const int);
  void rolly(const int);
  void rotate();
  void diag();
  void rebin(const int,const int,const double,const double,const double
	      ,const double);
  double itop(const double,const double) const;    //interpolation 
  void setminimum();    //subtract lowest values

  int intXvalues(const double,const double,double *);
  int intYvalues(const double,const double,double *);
  int intArcValues(const double,const double,double *);

  XrayMaps();
  XrayMaps(const XrayMaps&);
  XrayMaps& operator=(const XrayMaps&);
  virtual ~XrayMaps();
};  


class bin_file : public Curs_Screen, public space_correct
{ 

  friend class space_correct;  //is this absolutely necessary??

private:


  const int n_angles; //number of angles that ring ints have
  const int rsteps;   //number of rsteps to use in integration

  ofstream *otf;    //if we have an output stream.
  double lambda;    // wavelength (Anstrom)
  double det_dist;  //needed to calculate angle
  double det_width; // width of detector
  double ang_max;   //calculated form det_dist
  int Norm_I;       //to auto norm or not
  int Zero_out;     //to remove zeros or not.
  int trans_grp;    //group to put to output
  int normArea;     //normalise against area in integrations

  const int N_cols;  //number of colours that can be supported
  int reload;        //have we changed the picture.

  int cmin,cmax;     // max min colour values
  int colrep;        //0= linear, 1=log
  int n_hp;         // npts in actual picture ??? 
  int n_vp;
  float **values;    //values of plot
  float xyr[4];       //range of plot

  int c_type;           //color pallet type
  float bright;         // brightness
  float contrast;       // contrast !
  int sign;             // sign of contrast
  int set_col;          // have values been set
  int colbin;          // col bin type 
  float us_max,us_min;  // values given by user

  float cen_x,cen_y;  //centre of circles
  double ang_1,ang_2;  //angles to integrate round
  float rad1,rad2;    //radii of circles for integration

  void getmax(float&,float&);   //getmax of plot.
  static void get_pt(Widget,XtPointer,XtPointer);  

  void setrange(float,float,float,float,char); //set ranges
  void setrangex(float,float,char);       
  void setrangey(float,float,char);
  const int max_Maps;     //max Maps (how many input data sets)
  int current_Map;        //Displayed in the data set
  XrayMaps *DD;           //allocate several maps

  void col_control(const char,const float,const float);
  void palett(const int,int,float,float) const;
  void intsq(const float,const float,const float,const float) const;

  void intarv(const char,const double,const double);  //integrates arc.
  void new_intarv(const int,const char,const double,
		  const double);  //TEST STUFF
  double get_intercepts(const double,const double,const int, 
                        const int,const double,const double) const;

  void setmaxaxis(const int,const float,const float);


public:

  void display_pt(const char,float,float);
  void arm_v_cursor(const int=0);
  void dearm_v_cursor();

  bin_file();
  virtual ~bin_file();

  void selfop(const char&,const int,const int,const int);
  void ops(const int,const int,const int,const int);
  void spec_ops(const char*,const int);
  void square();                    // make the bax square.
  void intensity();
  void keep();
  
  void set_trans(const int=0);      // set trans_grp
  void polar(const int);
  void set_intregion();    //set integrate region parameters
  void set_intarc();    //set integrate region parameters
  void new_set_intarv(const int=0);    //TEST STUFF for perfect area
  void intregion();    //integrate region
  void intarc(const char);    //integrate arc
  void new_intarc(const char);    //TEST STUFF for new AreaInt
  void set_intblock(const int);
  void intblock(const int,const double,const double,int =-1);   //integrate arc
  void renorm(const char a,int,int);
  void copy(int,int); 
  void set_values(const char c);
  void re_centre(const char a,int);
  void flip(char,int);
  void smooth(const int,const int=0);
  void enhance(const int,const int=0);
  void roll(char);
  void rotate();
  void twoaxis(const char);    //set axis for plot out
  int rebin(const char);
  void give_axis(float *) const;
  
  int read_data(int,char* =0,const int =1,const int = 512,const int =512);
  int read_ascii(const char*,int,int = 512,int =512);
  int read_esrf(int,char* =0,const int =1,const int = 512,
		const int =512,const int =1);
  int read_fit2d(int,const char*,const int = -1,const int =-1,const int =1);
  int read_gadds(int,char* =0);
  void write_data(const char,int,const int,const int);
  void close();
  void rearm_curs();
  int draw_picture(const int= -2,const int =0,const int =0);
  int draw_three(const int= -2,const int =0,const int =0);
  void corr_space(const char);
  
};

class dars_data {

private:
  
  char filename[256];
  
public:
  
  dars_data() { filename[0]=0;}
  ~dars_data() {}
  int read_init(char*,int,int,int);
  
};

#endif
