#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "cmd.h"
#include "extract.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "spacebox.h"
#include "space.h"
#include "new_read.h"
#include "areaInt.h"
#include "readfunc.h"

const double PI(3.141592653589);

void
bin_file::corr_space(const char ans)
  /* controls the correction space */
{ 
  extern wback hold_;
  char ss[256];
  int grp;
  int flag=cmdnumber(hold_.is,grp);

  if (ans=='C') //Cursor addition
    {
      space_correct::complete_draw();   //let us have a quick look!
      space_correct::cursor_addition(grp);
      return;
    }

  while(!flag || grp>max_Maps || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp containing grid pattern  ->");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  grp--;
  
  space_correct::init_search(grp);
  space_correct::complete_draw();   //let us have a quick look!
  return;
}

int
bin_file::read_gadds(int grp,char *s)
{
  int offset=1;
  grp--;
  if (grp<0 || grp>=max_Maps) return 1;
   if (DD[grp].read_data(512,512,s,offset,1))
     {
       char ss[255];
       strcpy(ss,"Error opening file");
       l_c(ss,1);
       return 1;
     }
    if (grp == current_Map)
      reload=1;
    return 0;
}

int
bin_file::read_data(int grp,char* s,const int offset,const int M,
		    const int N)
{

   while (grp<1 || grp>max_Maps)
     {
       char ss[256];
       sprintf(ss,"Area grp for input =>"); 
       l_c(ss,0);
       if (!cmdnumber(ss,grp,255)) return 1;
     }
   grp--;
   if (DD[grp].read_data(M,N,s,offset))
      {
         char ss[255];
	 strcpy(ss,"Error opening file");
	 l_c(ss,1);
         return 1;
      }
    if (Norm_I)
      {
        int kk;

	for(kk=strlen(s)-1;kk>1 && s[kk]!='.';kk--);
	s[kk-1]='2';
	if (DD[grp].read_norm(s,offset))
	  l_c("Failed to read normalisation file",1);
	else
	  l_c("Successfully renormed file",1);
      }
    if (grp == current_Map)
      reload=1;
    return 0;
}

int 
bin_file::read_ascii(const char *s,int grp,int xcord,int ycord)
{
  char ss[256];
  while (grp<1 || grp>max_Maps)
    {
      sprintf(ss,"Area grp for input =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return 1;
     }
  grp--;
  int flag=1;
  while (!flag || xcord<1 || ycord<1 
	 || xcord*ycord>10000000)
    {
      sprintf(ss,"Enter number of x-y coordinates to read =>");
      l_c(ss,0);
      if (!cmdnumber(ss,xcord,255)) return 1;
      flag=cmdnumber(ss,ycord,255); 
    }
  if (DD[grp].read_ascii(s,xcord,ycord))
    {
      strcpy(ss,"Error opening file");
      l_c(ss,1);
      return 1;
    }
  return 0;
}

int
bin_file::read_esrf(int grp,char* s,const int offset,
		    const int M,const int N,const int Big_I)
{
  char ss[256];
  while (grp<1 || grp>max_Maps)
    {
      sprintf(ss,"Area grp for input =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return 1;
     }
  grp--;
  if (DD[grp].read_esrf(s,Norm_I,M,N,offset,Big_I))
    {
      strcpy(ss,"Error opening file");
      l_c(ss,1);
      return 1;
    }
  if (grp == current_Map)
    reload=1;
  return 0;
}

int
bin_file::read_fit2d(int grp,const char* s,const int offset,
		    const int M,const int N)  
  /* 
     Read data from fit2d plot -- M == horrizontal point
                                  N == vertical
                                  offset for future use ? 
  */
{
  char ss[256];
  while (grp<1 || grp>max_Maps)
    {
      sprintf(ss,"Area grp for input =>"); 
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return 1;
     }
  grp--;
  if (DD[grp].read_fit2d(s,M,N))
    {
      strcpy(ss,"Error opening file");
      l_c(ss,1);
      return 1;
    }
  if (grp == current_Map)
    reload=1;
  return 0;
}



void
bin_file::close()
{
  if (!otf)
    l_c("No file to close",1);
  else
    {
      l_c("Closing 2d file",1);
      otf->close();
      delete otf; 
      otf=0;
    }
  return;
}

void
bin_file::write_data(const char ans,int a,const int b,const int c)
{
  char ss[256],of[256];
  if (!otf || !(*otf) )
    {
      strcpy(ss,"Output file name =>");
      l_c(ss,0);
      s_line();
      extractfile(of,ss,254);

      otf=new ofstream(of,ios::out);
      if (!(*otf)) 
	{
	  if (otf) delete otf;
	  l_c("File could not be created",1);
	  return;
	}
    }
  while (a<1 || a>max_Maps)
    {
      strcpy(ss,"Grp to output =>");
      l_c(ss,0);
      s_line();
      if (!cmdnumber(ss,a)) return;
    }
    
  int count;
  if (ans=='E') 
    count=DD[a-1].write_esrf(*otf);
  else
    count=DD[a-1].write_data(*otf);
  sprintf(ss,"Output %d of grp %d",count,a);
  l_c(ss,1);

  if (b>0 && b<=max_Maps)
    {
      count=DD[b-1].write_data(*otf);
      sprintf(ss,"Output %d of grp %d",count,a);
      l_c(ss,1);
      if (c>1 && c<max_Maps)
	{
	  count=DD[c-1].write_data(*otf);
	  sprintf(ss,"Output %d of grp %d",count,a);
	  l_c(ss,1);
	}
    }
  if (ans=='E')
    {
      otf->close();
      delete otf;
      otf=0;
    }
  return;

}


/*
Copy constructor some time?

bin_file::bin_file(const bin_file& A)
{

*/

bin_file::bin_file() : Curs_Screen(),space_correct(),
  n_angles(3600),rsteps(100),otf(0),lambda(1.41),
  det_dist(1.5),det_width(0.1),ang_max((180.0/PI)*atan(det_width/det_dist)),
  Norm_I(1),Zero_out(1),trans_grp(0),normArea(0),
  N_cols(80),reload(0),cmin(0),cmax(0),
  colrep(0),n_hp(0),n_vp(0),values(0),c_type(1),bright(1.0),
  contrast(0.5),sign(1),set_col(0),us_max(1.0),us_min(0.0),
  cen_x(0.0f),cen_y(0.0f),ang_1(0.0f),ang_2(0.0f),
  max_Maps(10),DD(new XrayMaps[max_Maps])
{
  xyr[0]=xyr[2]=0.0;
  xyr[1]=xyr[3]=511.0;     // initally square. //no data
}

bin_file::~bin_file()
{
  delete [] DD;
}


void
bin_file::give_axis(float *A) const
  /* returns the plotting axis */
{
  if (!A) return;
  for(int i=0;i<4;i++)
    A[i]=xyr[i];
  return;
}


void
bin_file::polar(const int grp)
{
  /* 
     Needs to be expained to take a fraction of the polorization
     correction and have a call back on error.
  */
  if (grp>max_Maps || grp<1) return;
  DD[grp-1].polar(det_dist,det_width,cen_x,cen_y);
  return;
}


void
bin_file::getmax(float& amn,float& amx)
  /* 
     Find the maximium value in the displayed region   
  */

{
  int epx = (int) (xyr[1]) + 1; 
  epx = (epx >= n_hp || epx<0) ? n_hp-1 : epx;
  int epy = (int) (xyr[3]) + 1; 
  epy = (epy >= n_vp || epy<0) ? n_vp-1 : epy;
  int spx = (int) (xyr[0]); 
  spx = (spx >= n_hp || spx<0) ? n_hp-1 : spx;
  int spy = (int) (xyr[2]); 
  spy = (spy >= n_vp || spy<0) ? n_vp-1 : spy;

  amn=amx=values[spy][spx];
  for(int i=spy;i<epy;i++)
    for(int j=spx;j<epx;j++)
      if (amn>values[i][j])
        amn=values[i][j];
      else if(amx<values[i][j])
        amx=values[i][j];
  return;
}

void
bin_file::flip(char a,int grp)
/* job is to flip the group about a line */ 
{
  extern wback hold_;
  char ss[256];
  double disp;
  int flag=0;
  cmdnumber(hold_.is,grp);

  while(grp>max_Maps || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to flip  ->");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  
  if (a!='X' && a!='Y')
    {
      int ii;
      do 
	{
	  sprintf(ss,
	    "Input either X or Y axis to flip around  or Q to quit =>");
	  l_c(ss,0);
	  for(ii=0;ii<256 && ss[ii]==' ';ii++);
	  if  (ss[ii]=='Q' || ss[ii]=='q') return;
        } while(ss[ii]!='X' && ss[ii]!='x' && ss[ii]!='y' && ss[ii]!='Y');
      a=ss[ii];
      if (a=='y') a='Y';
    }
  
  int pth=DD[grp-1].xpt();
  int ptv=DD[grp-1].ypt();
  if(flag || !cmdnumber(hold_.is,disp))
    disp= ((a!='Y') ? pth/2.0 : ptv/2.0);
  while(disp<0.0 || (a=='Y' && disp>pth-1) || (a!='Y' && disp>ptv-1))
    {
      sprintf(ss,"Input the line to flip round =>");
      l_c(ss,0);
      if (!cmdnumber(ss,disp)) return;
    }
  
  double pt= disp;
  if (a!='Y')  
    DD[grp-1].flip_y(pt);
  else
    DD[grp-1].flip_x(pt);    
  return;
}

int
bin_file::rebin(const char a)
  /* The rebin command, takes 7 (!) parameters new X,Y pts, and the 
     two corners of the rebin. 
  */
{
  extern wback hold_;
  int all;
  int grp,nxpt,nypt;
  double fcx,fcy,scx,scy;
  int flag=cmdnumber(hold_.is,grp);
  if (flag)
    flag+=cmdnumber(hold_.is,nxpt);
  if (flag==2)
    flag+=cmdnumber(hold_.is,nypt);
  if (flag==3)
    flag+=cmdnumber(hold_.is,fcx);
  if (flag==4)
    flag+=cmdnumber(hold_.is,fcy);
  if (flag==5)
    flag+=cmdnumber(hold_.is,scx);
  if (flag==6)
    flag+=cmdnumber(hold_.is,scy);
  if (flag==3) 
    all=1;
  else
    all=0;

  char ss[256];
  while(!flag || grp>max_Maps || grp<1)
    {
      flag=1;
      sprintf(ss,"Which area grp to rebin =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp,255)) return 1;
    }
  grp--;
  int max_x=DD[grp].xpt();
  int max_y=DD[grp].ypt();
  if (max_x<1 || max_y<1)
    {
      l_c("Selected Area group has zero points!!",1);
      return 1;
    }

  flag--;
  while(!flag || nxpt>10000 || nxpt<1)
    {
      flag=1;
      sprintf(ss,"How many new X pts =>");
      l_c(ss,0);
      if (!cmdnumber(ss,nxpt,255)) return 1;
    }
  flag--;
  while(!flag || nypt>10000 || nypt<1)
    {
      flag=1;
      sprintf(ss,"How many new Y pts =>");
      l_c(ss,0);
      if (!cmdnumber(ss,nypt,255)) return 1;
    }
  
  if (all)
    {
      fcy=0;
      fcx=0;
      scx=max_x;
      scy=max_y;
    }
  flag-=2;
  int pts_write=0;
  while(!flag || fcx>3 * max_x || fcx< -2 * max_x 
	      || fcy> 3 * max_y || fcy< -2 * max_y)
    {
      flag=1;
      sprintf(ss,"Using %d x %d rebin",nxpt,nypt);
      l_c(ss,1);
      pts_write++;
      sprintf(ss,"Select first corner of rebin range (x,y) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,fcx,255) || !cmdnumber(ss,fcy,255)) 
	return 1;
    }
  flag-=2;

  while(flag<1 || scx>(3 * max_x) || scx<= fcx 
	       || scy>(3 * max_y) || scy<= fcy)
    {
      if (!pts_write)
	{
	  sprintf(ss,"Using %d x %d rebin",nxpt,nypt);
	  l_c(ss,1);
	}
      sprintf(ss,"First corner at %12.6f %12.6f",scx,scy);
      l_c(ss,1);
      pts_write=2;
      flag=1;
      sprintf(ss,"Select second corner of rebin range (x,y) =>");
      l_c(ss,0);
      if (!cmdnumber(ss,scx,255) || !cmdnumber(ss,scy,255)) 
	return 1;
    }

  DD[grp].rebin(nxpt,nypt,fcx,fcy,scx,scy);
  return 0;
}

void
bin_file::re_centre(const char a,int grp)
/* 
    job is to replace the group 
    RC == use centre set by the cursor
    RX RY and R set a centre from the command line
 */ 
{
  extern wback hold_;
  char ss[256];
  double xdisp,ydisp;
  if (a=='C') 
    {
      sprintf(ss,"Centre at %f : %f",cen_x,cen_y);
      l_c(ss,1);
      xdisp=cen_x;
      ydisp=cen_y;
    }
  if (a=='Y')
    xdisp=(n_hp-1)/2.0;
  if (a=='X')
    ydisp=(n_vp-1)/2.0;
  int flag=0;
  cmdnumber(hold_.is,grp);

  while(grp>max_Maps || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to recentre  ->");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  
  int ptmax;
  if (a!='Y')
    {
      ptmax = DD[grp-1].xpt();
      if(a!='C' && (flag || !cmdnumber(hold_.is,xdisp)))
	{
	  flag=1;
	  xdisp= 4 * ptmax + 4;      //quick way to ensure that it is 
	}                            // out of range
      

      int flagx=0;
      while(xdisp>ptmax*2.0 || xdisp< -ptmax)
        {
	  if (!flagx)
	    {
	      sprintf(ss,"Max horizontal points in picture %d",ptmax);
	      l_c(ss,1);
	      flagx=1;
	    }
	  sprintf(ss,"Input the new X-centre line");
	  l_c(ss,0);
          if (!cmdnumber(ss,xdisp)) return;
	}
    }
  
  if (a!='X')
    {
      ptmax = DD[grp-1].xpt();
      if(a!='C' && (flag || !cmdnumber(hold_.is,ydisp)))
        ydisp= 4 * ptmax + 4;
	  

      int flagy=0;
      while(ydisp>ptmax*2.0 || ydisp< -ptmax)
        {
	  if (!flagy)
	    {
	      sprintf(ss,"Max vertical points in picture %d",ptmax);
	      l_c(ss,1);
	      flagy=1;
	    }
	  sprintf(ss,"Input the new Y-centre line");
	  l_c(ss,0);
          if (!cmdnumber(ss,ydisp)) return;
	}
    }  
  double ptx=(int) xdisp;  
  double pty=(int) ydisp;
  DD[grp-1].re_centre(ptx,pty);
  return;

}


void
bin_file::renorm(const char a,int grp,int grp2)
{
  extern wback hold_;
  int xp[4];
  char ss[256];
  int flag=0;
  static double rnv=1.0;          //incase of other group renorm
  
  if (a=='S')
    {
      double vla;
      flag=cmdnumber(hold_.is,vla);
      while(!flag || vla==0.0)
	{
	  sprintf(ss,"Enter the new norm value =>");
	  l_c(ss,0);
	  if (!(flag=cmdnumber(ss,vla))) return;
	}
      rnv=vla;
      return;
    }
  while((grp>max_Maps || grp<1))
    {
      flag=1;
      strcpy(ss,"Grp to normalise from (unchanged) ->");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    

  while((grp2>max_Maps || grp2<1 || grp2==grp))
    {
      flag=1;
      strcpy(ss,"Grp to normalise ->");
      l_c(ss,0);
      if(!cmdnumber(ss,grp2))  return;
    }    
  if (a=='N')    //use the old value to renorm by
    {
      DD[grp2-1].self(0.0,rnv);
      return;
    }

  int pt=DD[grp-1].pts();
  if (pt!=DD[grp2-1].pts())
    {
      l_c("Number of data points different: No renormalisation",1);
      return;
    }
  if (flag || DD[grp-1].verify_cord(hold_.is,xp))
    {
      xp[0]=xp[2]=0;
      xp[1]=xp[3]=pt;
    }
  double rn1=DD[grp-1].average(Zero_out,xp[0],xp[1],xp[2],xp[3]);
  double rn2=DD[grp2-1].average(Zero_out,xp[0],xp[1],xp[2],xp[3]);
  if (rn1<=0.0 || rn2<=0.0)  return;
  sprintf(ss,"Renorm values : %10g : %10g",rn1,rn2);
  l_c(ss,1);
  rn1/=rn2;
  rnv=rn1;
  if (a!='V')
    DD[grp2-1].self(0.0,rn1);
  return;
}
  
void
bin_file::set_values(const char c)
{
  extern wback hold_;
  char ss[255];
  double vl,vh;
  int tl;
  strncpy(ss,hold_.is,80);
  switch(c) 
    {
    case 'A': 
       Norm_I=1-Norm_I;
       if (Norm_I)
	 l_c("Auto normalisation ON",1);
       else
	 l_c("Auto normalisation OFF",1);
       return;
    case 'C':
      if (!cmdnumber(ss,vl) || !cmdnumber(ss,vh) || 
          vh>n_hp-1 || vl>n_vp-1 || vl<0 || vh<0)
	{
	  strcpy(ss,"Center x,y ==>");
	  l_c(ss,0);
	  if  (!cmdnumber(ss,vl) || !cmdnumber(ss,vh) || 
               vh>n_hp-1 || vl>n_vp-1 || vl<0 || vh<0)
            return;
	}
      cen_x=vl;
      cen_y=vh;
      return;
    case 'D':
      if (!cmdnumber(ss,vl) || vl<0.0 || vl>50.0)
	{
	  strcpy(ss,"Detector Distance (meters) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,vl) || vl<0.0 || vl>50.0) return;
	}
      det_dist=vl;
      ang_max=atan(det_width/det_dist);
      sprintf(ss,"Detector Distance (meters) => %10g",det_dist);
      l_c(ss,1);
      return;
    case 'L':
      if (!cmdnumber(ss,vl) || vl<0.0 || vl>5.0)
	{
	  strcpy(ss,"Wavelength =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,vl) || vl<0.0 || vl>1.0) return;
	}
      lambda=vl; 
      sprintf(ss,"Wavelength (Anstroms) %10g",lambda);
      l_c(ss,1);
      return;
    case 'N':
      normArea=1-normArea;
      if (normArea)
	l_c("Area normalisation ON",1);
      else
	l_c("Area normalisation OFF",1);
      return;
    case 'T':
      if (!cmdnumber(ss,tl) || tl>40 || tl<1)
	{  
	  strcpy(ss,"Transfer group =>");
          l_c(ss,0);
          if (!cmdnumber(ss,tl) || tl<1 || tl>40) return;
        }
      trans_grp=tl-1;
      sprintf(ss,"Transfer group : %d",trans_grp+1);	  
      l_c(ss,1);
      return;
    case 'W':
      if (!cmdnumber(ss,vl) || vl<0.0 || vl>1.0)
	{
	  strcpy(ss,"Detector half width (meters) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,vl) || vl<0.0 || vl>1.0) return;
	}
      det_width=vl;
      ang_max=atan(det_width/det_dist);
      sprintf(ss,"Detector Width (meters) => %10g",det_dist);
      return;
    case 'Z' :
      Zero_out=1-Zero_out;
      if (Zero_out)
	l_c("Zero point removal ON",1);
      else
	l_c("Zero point removal OFF",1);
      return;
      
    default:
      l_c("X-ray data are ::",1);
      if (Norm_I)
	l_c("Auto normalisation ON",1);
      else
	l_c("Auto normalisation OFF",1);
      if (normArea)
	l_c("Area normalisation ON",1);
      else
	l_c("Area normalisation OFF",1);
      if (Zero_out)
	l_c("Zero point removal ON",1);
      else
	l_c("Zero point removal OFF",1);
      l_c(" ",1);
      sprintf(ss," Wavelength         :: %f",lambda);
      l_c(ss,1);
      sprintf(ss," Detector distance  :: %f",det_dist);
      l_c(ss,1);
      sprintf(ss," Detector width     :: %f",det_width);
      l_c(ss,1);
      sprintf(ss," Max angle          :: %f",ang_max);
      l_c(ss,1);
      sprintf(ss," Center             :: %f  %f",cen_x,cen_y);
      l_c(ss,1);
      sprintf(ss," Radii              :: :%f  %f",rad1,rad2);
      l_c(ss,1);
      sprintf(ss," Transfer group          :: %d",trans_grp);
      l_c(ss,1);
    }
  return;
}



void    
bin_file::selfop(const char& b,const int grp,const int aa,const int bb)
{
  extern wback hold_;

  char ss[255];
  int gp;
  double add=0;
  double mult=0;
  strncpy(ss,hold_.is,80);
  ss[80]=0;
  char third;
  get_first_nonumb(third,hold_.is,80);  
  third=toupper(third);

  int flag=cmdnumber(hold_.is,gp);          //remove group from chain.

  while(!flag || (gp>max_Maps || gp<1))
    {
      flag=1;
      strcpy(ss,"2d Grp to selfwork =>");
      l_c(ss,0);
      if(!cmdnumber(ss,gp))  return;
    }    

  if (b=='A') 
    {
      int tpts=DD[gp-1].pts();
      int a[4];
      for(int i=0;i<4;i++)
	{
	  a[i]=(int) xyr[i];
          if (a[i]>tpts-1) a[i]=tpts-1;
          if (a[i]<0) a[i]=0;
	}
      double ave =  DD[gp-1].average(Zero_out,a[0],a[1],a[2],a[3]);
      if (Zero_out) 
	l_c("Zero Flag on",1);
      else
	l_c("Zero Flag off",1);
      sprintf(ss,"Mean Value Displayed :: %15g",ave);
      l_c(ss,3);
      strncpy(ss,hold_.is,80);
      if (cmdnumber(ss,a[0]))
	{
	  ave =  DD[gp-1].average(Zero_out);
	  sprintf(ss,"Total Mean Value :: %15g",ave);
	  l_c(ss,1);
	}
      return;
    }
  if (b=='P')
    {
      double pw;
      if (flag)
	flag = cmdnumber(hold_.is,pw);
      
      while (!flag || pw < -20 || pw > -20)
	{
	  strcpy(ss,"Power to take values =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,pw))  return;
	}
      DD[gp-1].power(pw);
      return;
    }
  if (b=='L')
    {
      DD[gp-1].logofV();
      return;
    }
  if (b=='N')
    {
      DD[gp-1].setminimum();
      return;
    }
  if (b=='X')
    {
      DD[gp-1].expofV();
      return;
    }

  float **v;
  int hpt,vpt;

  if (b=='W')  //Wash ie remove all points below or above value
    {
      if (!cmdnumber(hold_.is,add))          //get add if it exists
	{
	  strcpy(ss,"Value to wash against and direction");
	  l_c(ss,0);
       	  s_line();
          if (!cmdnumber(ss,add)) return;      
          strncpy(hold_.is,ss,80);
	}
      cmdnumber(hold_.is,mult); 
      DD[grp-1].handle(hpt,vpt,v);
      if (hpt<1 || vpt<1) return;
      if (mult<0.0)
	{
	  for(int i=0;i<vpt;i++)
	    for(int j=0;j<hpt;j++)
	      if (v[i][j] > add) v[i][j]=add;
	}	  
      else
	{  
	  for(int i=0;i<vpt;i++)
	    for(int j=0;j<hpt;j++)
	      if (v[i][j] < add) v[i][j]=add;
	}
      return;
    }
  if(!cmdnumber(hold_.is,add) || !cmdnumber(hold_.is,mult))
    {
      strcpy(ss,"Enter addition and multiply terms =>");
      l_c(ss,0);
      if(!cmdnumber(ss,add) || !cmdnumber(ss,mult) || mult==0.0)
	return;
    }
  char chk;
  get_next_char(chk,ss,80);
  if (chk=='\\' || chk=='D' || chk=='d')
    mult=1.0/mult;

  DD[grp-1].self(add,mult);
  return;    
}


void
bin_file::intarc(const char a)
{ 
  /* Integration of an arc in a 2d plot from a cursor input.
     If cursor = D then this is a max plot
     else if cursor =X then the excluded angle between the two
     points 
    */ 
  extern Spec_In storage_;
  if (current_Map>=max_Maps || current_Map<0) return;
  dearm_v_cursor();
  char ss[255];
  sprintf(ss,"Centre: %f,%f Angles::  %f,%f \n",
	  cen_x,cen_y,180.0 * ang_1/pi,180.0*ang_2/pi);
  l_c(ss,1);
  while(trans_grp<0 && trans_grp>39)
    {
      strcpy(ss,"Default output group ==> ");
      l_c(ss,0);
      if(!cmdnumber(ss,trans_grp))
	return;
      trans_grp--;
    }
  double radd;
  int idiva;
  double diva,II;
             //make distance across diagonal!
  radd=n_vp * n_vp+n_hp * n_hp;
  radd=sqrt(radd) / n_angles;          //deg + length 
  double rdi= -radd;
  int inum=1;        //number of included points
  double subang=ang_2 - ang_1;                   //radians
  if (subang>pi)
    {
      subang=2.0*pi-subang;
      ang_1=ang_2;
    }
  if (a=='X') 
    subang=2.0*pi-subang;

  double angle,max_v;
  for(int i=0;i<n_angles;i++)
    {
      inum=0;
      II=0.0;
      idiva=(i/20 + 10);
      diva=(double) idiva;
      rdi+=radd;
      for(int j=0;j<idiva;j++)
	{
          angle = ang_1+(double) j*(subang/diva);
	  x = cen_x+cos(-angle)*rdi;          //angles are reversed
          y = cen_y+sin(-angle)*rdi; 
          if (x<= n_hp-1 && x>=0 && 
	      y<= n_vp-1 && y>=0 )
	    {		  
              inum++;
              if (a=='D')
		{
                  max_v=DD[current_Map].itop(x,y);
		  if (max_v>II) II=max_v;
		}
              else
		{
		  II+=DD[current_Map].itop(x,y);
		}	 
	    }
	}
      if (inum && a!='D')
	II*=4.0 * pi * pi * radd * rdi / (inum * subang);
      else if (a!='D')
	II=0.0;
      storage_.storx[trans_grp][i]= rdi;
      storage_.story[trans_grp][i]= II;
      storage_.store[trans_grp][i]= sqrt(II);
    }
  storage_.stpnt[trans_grp]=n_angles;
  trans_grp++;
  sprintf(ss,"Output written to grp %d",trans_grp);
  l_c(ss,1);
  return;
}


void
bin_file::set_intblock(const int type)
  /* get either an x,y or both zone from command line
     and integrate placing the result in the trans_grp
  */
{
  //  if (current_Map>=max_Maps || current_Map<0) return;
  
  extern wback hold_;
  char ss[256];
  double cx[4];
  int grp;
  int flag=cmdnumber(hold_.is,grp);
  for(int i=0;i<flag;i++)
    flag+=cmdnumber(hold_.is,cx[i]);
  while (!flag || grp>max_Maps || grp<1)
    {
      flag=1;
      sprintf(ss,"Enter the map number to integrate =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;

  int max_h=DD[grp].xpt();
  int max_v=DD[grp].ypt();
  if (!max_h || !max_v)
    {
      l_c("No points in selected group",1);
      return;
    }

  if (type!=1)     //type 1 == y values only
    {
      
      if (flag<3 || cx[0]>max_h || cx[0]<0 
                 || cx[1]>max_h || cx[1]<0)
	{
	  sprintf(ss,"Enter the x-strip coordinates for integration => ");
	  l_c(ss,0);
	  if (!cmdnumber(ss,cx[0]) || !cmdnumber(ss,cx[1]))
	    return;
	}
      if (cx[0]>cx[1]) 
	{
	  double temp=cx[0];
	  cx[0]=cx[1];
	  cx[1]=temp;
	}
    }

  if (type)     //type 1 == y values only
    {
      
      if (flag<3 || cx[2]>max_h || cx[2]<0 
                 || cx[3]>max_h || cx[3]<0)
	{
	  sprintf(ss,"Enter the y-strip coordinates for integration : ");
	  l_c(ss,0);
	  if (!cmdnumber(ss,cx[2]) || !cmdnumber(ss,cx[3]))
	    return;
	}
      if (cx[2]>cx[3]) 
	{
	  double temp=cx[2];
	  cx[2]=cx[3];
	  cx[3]=temp;
	}
    }
  if (type<2)
    intblock(type,cx[2*type],cx[2*type+1],grp);

  return; 
}


void
bin_file::set_intregion()
{
  /* carries out circular integration on the current map */

  if (current_Map>=max_Maps || current_Map<0) return;
  extern wback hold_;
  char ss[256];
  float cx,cy;
  if (cmdnumber(hold_.is,cx))
    {
      if (cx>= 0 && cx<= n_hp-1 &&
	  cmdnumber(hold_.is,cy) && cy>0 && cy<n_vp-1)
	{
	  rad1= (cy>cx) ? cx : cy;
          rad2= (cy>cx) ? cy : cx;
	}
      else
	{
          do
	    {
	      sprintf(ss,"Enter the radi for integration : ");
	      l_c(ss,0);
	      if (!cmdnumber(ss,cx) || !cmdnumber(ss,cy))
		return;
	    } while (cy<0 || cy>n_vp-1 || 
		cx< 0 || cx>n_hp-1);
	  rad1= (cy>cx) ? cx : cy;
	  rad2= (cy>cx) ? cy : cx;
	}
    }
  intregion();
  return; 
}


void
bin_file::set_intarc()
{
  /* integrate and arc like the cv command */


  if (current_Map>=max_Maps || current_Map<0) return;
  extern wback hold_;
  char ss[256];
  double angx,angy;
  int flag=cmdnumber(hold_.is,angx);
  if (flag) flag+=cmdnumber(hold_.is,angy);
  while (flag<2 || angx>360.0 || angx<0.0 ||
      angy>360.0 || angy<0.0 || angy==angx )
    {
      flag=2;
      sprintf(ss,"Angles for integration  (0.0 -- 360.0) : ");
      l_c(ss,0);
      if (!cmdnumber(ss,angx) || !cmdnumber(ss,angy))
	return;
    }
  angx*= pi/180.0;          
  angy*= pi/180.0;
  intarv('A',angx,angy);
  return;
}

void
bin_file::new_set_intarv(const int nmap)      //this will call 
{
  /* integrate and arc like the cv command */

  extern wback hold_;
  char ss[256];
  int grp;
  int flag;
  if (!nmap)
    {
      flag=cmdnumber(hold_.is,grp);
    }
  else
    {
      grp=nmap;
      flag=1;
    }

  while (!flag || grp>max_Maps || grp<1)
    {
      flag=1;
      sprintf(ss,"Enter the map number to integrate =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;

  float angx,angy;
  flag=cmdnumber(hold_.is,angx);
  if (flag) flag+=cmdnumber(hold_.is,angy);
  while (flag<2 || angx>360.0 || angx<0.0 ||
      angy>360.0 || angy<0.0 || angy==angx )
    {
      flag=2;
      sprintf(ss,"Angles for integration  (0.0 -- 360.0) : ");
      l_c(ss,0);
      if (!cmdnumber(ss,angx) || !cmdnumber(ss,angy))
	return;
    }
  angx*= pi/180.0;          
  angy*= pi/180.0;

  new_intarv(grp,'A',angx,angy);
  return;
}


void
bin_file::intblock(const int type,const double spt,
                   const double fpt,int Imap) 
{
  /* job is to calculate the integration in the strip
     if type != 0 then vertical integration else horrizonal
     integration */

  extern Spec_In storage_;
  if (Imap== -1) Imap=current_Map;
  if (Imap>=max_Maps || Imap<0) return;
  while(trans_grp<0 && trans_grp>tg-1)
    {
      char mc[80]={"Default output group ==> "};
      l_c(mc,0);
      if(!cmdnumber(mc,trans_grp))
	return;
      trans_grp--;
    }
  double* yp=storage_.story[trans_grp];
  int pts;
  if (type==0)
    {
      pts=DD[Imap].intXvalues(spt,fpt,yp);
      if (pts<1) 
	{
	  l_c("No data in map ",1);
	  return;
	}
    }
  else if (type==1)
    {
      pts=DD[Imap].intYvalues(spt,fpt,yp);
      if (pts<1) 
	{
	  l_c("No data in map ",1);
	  return;
	}
    }	
  for(int i=0;i<pts;i++)
    {
      storage_.storx[trans_grp][i]=i;
      storage_.store[trans_grp][i]=sqrt(fabs(*yp));
      yp++;
    }

  storage_.stpnt[trans_grp]=pts;
  trans_grp++;
  char ss[256];
  sprintf(ss,"Output written to grp %d",trans_grp);
  l_c(ss,1);
  return;
}

/*
void
bin_file::intarv(cons
(const char ans,const double fa,const double sa) 
{
  / * job is to calculate the integration in the arc * /

  extern Spec_In storage_;

  if (current_Map>=max_Maps || current_Map<0) return;
  while(trans_grp<0 && trans_grp>39)
    {
      char mc[80]={"Default output group ==> "};
      l_c(mc,0);
      if(!cmdnumber(mc,trans_grp))
	return;
      trans_grp--;
    }
  int  sdx1,sdy1,sdx2,sdy2;  // dx,dy operators
  double ca1,sa1,ca2,sa2;  // cos / sin of the angles
  double Rx,Ry,Rxx,Ryy;    // Rvalues of solutions
  const double subang((sa - fa)/n_angles);
  double angA,angB,radius;
  int radpt;
  double ix1,iy1,ex1,ey1;
  double ix2,iy2,ex2,ey2;
  int px1,py1;
  int px2,py2;

  for(int i=0;i<n_angles-1;i++)
    {
      radpt=0;         //start in centre
      angA=i*subang+fa;
      angB=angA+subang;
      ca1=cos(angA); sa1=sin(angA);
      ca2=cos(angB); sa2=sin(angB);
      sdx1 = (ca1>=0.0) ? 1 : -1;
      sdy1 = (sa1>=0.0) ? 1 : -1; 
      sdx2 = (ca2>=0.0) ? 1 : -1;
      sdy2 = (sa2>=0.0) ? 1 : -1; 

      //First point
      
      ix1=cen_x; iy1=cen_y;
      ix2=cen_x; iy2=cen_y;
      px1=static_cast<int>cen_x;
      py1=static_cast<int>cen_y;
      px2=px1; py2=py1;
      Ra=get_intercepts(px1,py1,px1+sdx1,py1+sdy1,ca1,sa1);
      Rb=get_intercepts(px2,py2,px2+sdx2,py2+sdy2,ca2,sa2);
      if (Ra>1.0) Ra=1.0;
      if (Rb>1.0) Ra=1.0;
      
      //      for(int j=1;j<
	    
      
    }
}
*/

double
bin_file::get_intercepts(const double x,const double y,const int xp,
			const int yp,const double dx,const double dy) const
{
  double r1,r2;
  r1=static_cast<double>(xp);
  r1=(r1-x)/dx;
  r2=static_cast<double>(yp);
  r2=(r2-y)/dy;
  return (r2>r1) ? r1 : r2;
}

void
bin_file::intarv(const char ans,const double fa,const double sa) 
{
  /* job is to calculate the integration in the arc */

  extern Spec_In storage_;

  if (current_Map>=max_Maps || current_Map<0) return;
  char ss[256];
  while(trans_grp<0 && trans_grp>39)
    {
      strcpy(ss,"Default output group ==> ");
      l_c(ss,0);
      if(!cmdnumber(ss,trans_grp))
	return;
      trans_grp--;
    }
  double angle,radd;

                                       //make distance across diagonal!
  radd=n_vp * n_vp+n_hp * n_hp;
  radd=sqrt(radd) / n_angles;          //deg + length 
  double rdi= -radd;

  double subang= sa - fa;                   //radians
  double max_v;
  for(int i=0;i<n_angles;i++)
    {
      int inum=0;
      double II=0.0;
      int idiva=(i/20 + 10);
      double diva=(double) idiva;
      rdi+=radd;
      for(int j=0;j<idiva;j++)
	{
          angle = fa+(double) j*(subang/diva);
	  x = cen_x+cos(-angle)*rdi;          //angles are reversed
          y = cen_y+sin(-angle)*rdi; 
          if (x<n_hp-1 && x> 0 && 
	      y<n_vp-1 && y> 0)
	    {		  
              inum++;
              if (ans=='D')
		{
                  max_v=DD[current_Map].itop(x,y);
		  if (max_v>II) II=max_v;
		}
              else
		{
		  II+=DD[current_Map].itop(x,y);
		}	 
	    }
	}
      if (inum && ans!='D')
	II*= subang * rdi * radd / diva ;
      else if (ans!='D')
	II=0.0;
      storage_.storx[trans_grp][i]= rdi;
      storage_.story[trans_grp][i]= II;
      storage_.store[trans_grp][i]= sqrt(II);
    }
  storage_.stpnt[trans_grp]=n_angles;
  trans_grp++;
  sprintf(ss,"Output written to grp %d",trans_grp);
  l_c(ss,1);
  return;
}

void
bin_file::new_intarv(const int grp,const char ans,
		     const double fa,const double sa) 
{
  /* job is to calculate the integration in the arc 
   grp == map to work with, ans = 'A,D,X' depending upon
   mouse button, andn fa,sa are the start and finish angles*/

  extern Spec_In storage_;

  char ss[256];
  while(trans_grp<0 && trans_grp>=tg)
    {
      strcpy(ss,"Default output group ==> ");
      l_c(ss,0);
      if(!cmdnumber(ss,trans_grp))
	return;
      trans_grp--;
    }
  if(grp>max_Maps || grp<0)  return;
  DD[grp].intArcValues(fa,sa,storage_.story[trans_grp]);
  
  trans_grp++;
  sprintf(ss,"Output written to grp %d",trans_grp);
  l_c(ss,1);
  return;
}


void
bin_file::intregion()
  /* to do radial circular integration */
{
  extern Spec_In storage_;
  extern wback hold_;

  if (current_Map>=max_Maps || current_Map<0) return;
  char ss[255];
  sprintf(ss,"Centre: %f,%f Radii::  %f,%f \n",cen_x,cen_y,rad1,rad2);
  l_c(ss,1);
  
  while(trans_grp<0 && trans_grp>39)
    {
      strcpy(ss,"Default output group ==> ");
      l_c(ss,0);
      if(!cmdnumber(ss,trans_grp))
	return;
      trans_grp--;
    } 

  double vda= 2.0 * det_width * rad1/n_hp;
  double vdb= 2.0 * det_width * rad2/n_hp;   //BIG BUG!
 
  vda=atan(vda/det_dist);
  vdb=atan(vdb/det_dist);
  double Qa=4.0 * PI * sin(vda/2.0) / lambda;
  double Qb=4.0 * PI * sin(vdb/2.0) / lambda;
  double Qstp=(Qb-Qa)/rsteps;
 
  double angle,rd,rdx,rdy,II;
  int rcount;

  Qb=Qa;
  double rd_dif= (rad2-rad1)/rsteps;
  double Eff_area=8.0*PI*rd_dif;
  for(int i=0;i<n_angles;i++)
    {
      rcount=0;
      II=0.0;
      angle = (2.0 * pi *  (i+0.5)) / n_angles;      //radians
      Qa=Qb;
      double s_ang=sin(angle);
      double c_ang=cos(angle);

      for(int j=0;j<rsteps;j++)
	{
          Qa+=Qstp;
	  rd = rad1+ j * rd_dif;
	  rdx= cen_x + (rd * s_ang); 
	  rdy= cen_y + (rd * c_ang);
          if (rdx<n_hp-1 && rdx>0 && 
	      rdy>0 && rdy< n_vp-1)
	    {
              rcount++;
 //	      II+=2.0 * rd_dif * rd * DD[current_Map].itop(rdx,rdy);
	      II+=rd*DD[current_Map].itop(rdx,rdy);
	    }
	}

     if (rcount)
       II*=Eff_area / rcount;
     else
       II=0.0;
     double Area = (normArea) ?  4*PI*(rad2-rad1)*(rad2+rad1) : 1.0; 
     storage_.storx[trans_grp][i]= (360.0 * (i+0.5)) / n_angles;
     storage_.story[trans_grp][i]= II/Area;
     storage_.store[trans_grp][i]= sqrt(II);
    }
  storage_.stpnt[trans_grp]=n_angles;
  trans_grp++;
  sprintf(ss,"Output written to grp %d",trans_grp);
  l_c(ss,1);
  return;
}


void
bin_file::intsq(const float x1,const float y1,
		const float x2,const float y2) const 
  /* integrage over a rectangle */

{
  int ptsx,ptex,ptsy,ptey;
  if (x2>x1)
    {
      ptsx=(int) x1;
      ptex=(int) x2;
    }
  else
    {
      ptsx=(int) x2;
      ptex=(int) x1;
    } 
  if (y2>y1)
    {
      ptsy=(int) y1;
      ptey=(int) y2;
    }
  else
    {
      ptsy=(int) y2;
      ptey=(int) y1;
    }   
  double val=0.0;
  for(int j=ptsy;j<=ptey;j++)
    for(int i=ptsx;i<=ptex;i++)
      val+=values[j][i];
  ptsx=(1+ptey-ptsy) * (1+ptex-ptsx);

  char ss[256];
  sprintf(ss,"Integrated value %f : average %f",val,val/ptsx);
  l_c(ss,1);
  return;
}


void 
bin_file::display_pt(const char av,float ax,float ay)
{
  /* display point from standard cursor */
  double rx,ry,alg,alg2,Q;
   
  rx= det_width * (ax-cen_x)/n_hp;
  ry= det_width * (ay-cen_y)/n_vp;

  if (av=='X')
    {
      cen_y= ay;
      cen_x= ax;
    }
  
  alg = atan2(ay,ax);
  alg *= 180.0 / PI;
  
  alg2 = sqrt(rx*rx + ry*ry);
  alg2 = atan(alg2/det_dist);
  Q=4.0 * PI * sin(alg2/2.0) / lambda;
  alg2 *= 180.0 / pi;
  if (alg<0) alg*= -1.0; 
  if (alg2<0) alg2*= -1.0;
  char ss[80];
  int a= (int) ax;
  int b= (int) ay;
  if (a>-1 && a<n_hp && b>-1 && b<n_vp)
    {
      float I = values[b][a];
      sprintf(ss,"theta = %f, phi = %f, I = %f",alg2,alg,I);
      l_c(ss,1);
      sprintf(ss,"Q = %f , Coords : %d : %d",Q,a,b);
      l_c(ss,1);
    }
  return;
}

void
bin_file::smooth(int grp,int grp2)  
  /* Smooths data : input is group and number of interations of
     an inplace smoothing : inner point 0.5 all 8 outer points
      contribute 0.125 
  */
{
  char ss[256];
  strcpy(ss,"Group to smooth =>");
  while((grp>max_Maps || grp<1))
    {
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }      
  if (DD[grp-1].pts()<1)
    {
      l_c("No points in source group",1);
      return;
    }
  while(grp2>500 || grp2<0)
    {
      strcpy(ss,"Number of interations =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp2)) return;
    }      
  if (grp2>0) grp2++;
    DD[grp-1].smooth(grp2);
  return;
}

void
bin_file::enhance(int grp,int grp2)  
  /* Peak enhances data : input is group and number of interations of
     an inplace emhance : inner point (8*inter/outer-0.5) * outer + 0.5 
      inner
  */
{
  char ss[256];
  strcpy(ss,"Group to enhance =>");
  while((grp>max_Maps || grp<1))
    {
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }      
  if (DD[grp-1].pts()<1)
    {
      l_c("No points in source group",1);
      return;
    }
  while(grp2>50 || grp2<0)
    {
      strcpy(ss,"Number of interations =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp2)) return;
    }      
  if (grp2==0) grp2++;
    DD[grp-1].enhance(grp2);
  return;
}

void
bin_file::copy(int grp,int grp2)
{
  char ss[256];
  strcpy(ss,"Group to copy from (unchanged) =>");
  while((grp>max_Maps || grp<1))
    {
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }      
  if (DD[grp-1].pts()<1)
    {
      l_c("No points in source group",1);
      return;
    }
  while((grp2>max_Maps || grp2<1 || grp2==grp))
    {
      strcpy(ss,"Group to copy too (overwritten) =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp2)) return;
    }      
  DD[grp2-1]=DD[grp-1];
  return;
}

void
bin_file::set_trans(const int grp)
{
  char s[80];
  if (grp>0)
    trans_grp=grp-1;
  else if(trans_grp)
    trans_grp--;
  
  sprintf(s,"Transform group : %d",trans_grp+1);
  l_c(s,1);
  return;
}

void 
bin_file::setrangex(float xa,float xb,char a)
{
  if (a=='X')
    {
    xyr[0]=0;
    xyr[1]=n_hp;
    }
  else
    {
      float temp;
      if (xa>xb)
	{
	  temp=xb;    xb=xa;    xa=temp; 
	}
      xyr[0]=xa;
      xyr[1]=xb;
    }
  char ss[255];
  sprintf(ss,"Axis: %f,%f :: %f,%f \n",xyr[0],xyr[1],xyr[2],xyr[3]);
  l_c(ss,1);
  draw_picture();
  return;
}

void
bin_file::setrangey(float ya,float yb,char a)
{
  if (a=='X')
    {
    xyr[2]= 0;
    xyr[3]= n_vp;
    }
  else
    {
      float temp;
      if (ya>yb)
	{
	  temp=yb;    yb=ya;    ya=temp;
	}
      xyr[2]=ya;
      xyr[3]=yb;
    }
  char ss[255];
  sprintf(ss,"Axis: %f,%f :: %f,%f \n",xyr[0],xyr[1],xyr[2],xyr[3]);
  l_c(ss,1);
  draw_picture();
  return;
}

void
bin_file::setrange(float xa,float ya,float xb,float yb,char a)
{
  if (a=='X')
    {
    xyr[0]=xyr[2]= 0;
    xyr[1]= n_hp-1;
    xyr[3]= n_vp-1;
    }
  else
    {
      float temp;
      if (ya>yb)
	{
	  temp=yb;    yb=ya;    ya=temp;
	}
      if (xa>xb)
	{
	  temp=xb;    xb=xa;    xa=temp; 
	}
      xyr[0]=xa;
      xyr[1]=xb;
      xyr[2]=ya;
      xyr[3]=yb;
    }
  char ss[255];
  sprintf(ss,"Axis: %f,%f :: %f,%f \n",xyr[0],xyr[1],xyr[2],xyr[3]);
  l_c(ss,1);
  draw_picture();
  return;
}

void
bin_file::rotate()
{
  /* 
     Rotates the data around 90 degrees.
   */
  int grp;
  extern wback hold_;
  char ss[256];

  if (!cmdnumber(hold_.is,grp) || grp<1 || grp>max_Maps)
    {
      do {
	sprintf(ss,"Enter the area group to rotate 90 degrees =>");
	l_c(ss,0);
	if (!cmdnumber(ss,grp)) return;
      } while (grp<1 && grp>max_Maps);
    }
  grp--;
  DD[grp].rotate();
  return;
}

void
bin_file::roll(char direct)
{
  /* 
     Rolls the file around the x or y direction 
     DOES THIS need sline calls before the returns ???
   */
  extern wback hold_;

  char ss[256];
  int i;
  int flag=0;
  while ((direct!='Y' && direct!='X'))
    {
      if (!flag)
	{
	  sprintf(ss,"Direction for rolling (X,Y) => ");
	  l_c(ss,0);
	  for(i=0;i<255 && !(ss[i]>='a' && ss[i]<='z') 
		&& !(ss[i]>='A' && ss[i]<='Z'); i++);
	  if (i<255) 
	    direct= (ss[i]>='a' && ss[i]<='z') ? ss[i]-('a'-'A') : ss[i];
	  flag=1;
	}
      else
	{
	  return;
	}
    }
	
  int grp,rolnum;
  flag=0;
  if (!cmdnumber(hold_.is,grp) || grp<1 || grp>max_Maps)
    {
      flag=1;
      do {
	sprintf(ss,"Enter the area group to roll =>");
	l_c(ss,0);
	if (!cmdnumber(ss,grp)) return;
      } while (grp<1 && grp>max_Maps);
    }
  grp--;

  const int maxrol = (direct=='Y') ? DD[grp].ypt() : DD[grp].xpt();
  if (maxrol<2)
    {
      l_c("Too few point in group to roll",1);
      return;
    }

  if (flag || !cmdnumber(hold_.is,rolnum) ||
        rolnum<0 && rolnum>maxrol)
    {
      do 
	{
	  sprintf(ss,"Max roll value : %d",maxrol);
	  l_c(ss,1);
	  sprintf(ss,"Enter the line to roll about =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,rolnum)) return;
	} while (rolnum<0 || rolnum>maxrol);
    }

  rolnum--;
  if (direct=='Y')
    DD[grp].rolly(rolnum);
  else
    DD[grp].rollx(rolnum);
  return;
}
	
void
bin_file::spec_ops(const char *A,const int type)
{
  /* 
     If the data sets are dissimilar, it carries out operations 
     between different data sets. eg +,- etc.
     The function uses the lower left corner as the place to move.
  */
  extern wback hold_;
  
  int grps[5];
  int nhps[3],nvps[3];
  float **v[3];
  int flag,Tn;
  char s[256];
  

  if (type>3 || type<0) 
    {
      l_c("Stange operator",1);
      return;
    }

  for(Tn=0;Tn<5 && 
        cmdnumber(hold_.is,grps[Tn]); Tn++);   //get up to five numbers
  
  flag=Tn;
  while(!flag || (grps[0]>max_Maps || grps[0]<0))
    {
      sprintf(s,"Enter first input area group =>");
      l_c(s,0);
      flag=cmdnumber(s,grps[0]);
      if (!flag) return;
    }
  
  flag=Tn-1;  
  while(!flag || (grps[1]>max_Maps || grps[1]<0))
    {
      sprintf(s,"Enter second input area group =>");
      l_c(s,0);
      flag=cmdnumber(s,grps[1]);
      if (!flag) return;
    }

  flag=Tn-2;
  while(!flag || (grps[2]>max_Maps || grps[2]<0) || 
           grps[2]==grps[1] || grps[2]==grps[0])
    {
      sprintf(s,"Enter output area group =>");
      l_c(s,0);
      flag=cmdnumber(s,grps[3]);
      if (!flag) return;
    }

  grps[0]--;
  grps[1]--;
  grps[2]--;


  //Now we have the groups, get the information.

  for(int i=0;i<3;i++)
    DD[grps[i]].handle(nhps[i],nvps[i],v[i]);

  if (Tn<4 && (nhps[0]==nhps[1]) && (nvps[0]==nvps[1]))
    {
      Tn=5;
      grps[3]=0;
      grps[4]=0;
    }

  int max_xm(nhps[0]+nhps[1]);
  int max_ym(nvps[0]+nvps[1]);

  while (Tn<5 || grps[3]>max_xm || grps[3] < -max_xm 
           || grps[4]>max_ym || grps[4] < -max_ym)
    {
      Tn=5;
      sprintf(s,"Grp 1 : %d Grp 2 : %d xpts",nhps[0],nvps[1]);
      l_c(s,1);
      sprintf(s,"Grp 1 : %d Grp 2 : %d ypts",nhps[0],nvps[1]);
      l_c(s,1);
      sprintf(s,"Enter offsets for second grp =>");
      l_c(s,0);
      if (!cmdnumber(s,grps[3]) || !cmdnumber(s,grps[4])) return;
    }
  
  int maxx=(nhps[0]>=nhps[1]+grps[3]) ? nhps[0] : nhps[1]+grps[3];
  int maxy=(nvps[0]>=nhps[1]+grps[4]) ? nvps[0] : nvps[1]+grps[4];

  int minx=(grps[3]>=0) ? 0 : grps[3];
  int miny=(grps[4]>=0) ? 0 : grps[4];
  
  int stAx,stAy,stBx,stBy; //start and end points.

  int finX,finY;  //range for final box
  finX=maxx-minx;
  finY=maxy-miny;
  DD[grps[2]].makespace(finX,finY);
  DD[grps[2]].handle(nhps[2],nvps[2],v[2]);

  stAx= (minx<0) ? minx* -1 : 0;
  stBx= (minx<0) ? 0 : grps[3];  
  stAy= (miny<0) ? miny* -1 : 0;
  stBy= (miny<0) ? 0 : grps[4];

  int j,k;  
  switch (type) 
    {
    case 0:
      for(j=0;j<finY;j++)
	for(k=0;k<finX;k++)
	  v[2][j][k]=0.0;
      for(j=0;j<nvps[0];j++)
	for(k=0;k<nhps[0];k++) 
	  v[2][j+stAy][k+stAx]=v[0][j][k];
      for(j=0;j<nvps[1];j++)
	for(k=0;k<nhps[1];k++) 
	  v[2][j+stBy][k+stBx]+=v[1][j][k];
      break;

    case 1:
      for(j=0;j<finY;j++)
	for(k=0;k<finX;k++)
	  v[2][j][k]=0.0;
      for(j=0;j<nvps[0];j++)
	for(k=0;k<nhps[0];k++) 
	  v[2][j+stAy][k+stAx]=v[0][j][k];
      for(j=0;j<nvps[1];j++)
	for(k=0;k<nhps[1];k++) 
	  v[2][j+stBy][k+stBx]-=v[1][j][k];
       break;

     case 2:
      for(j=0;j<finY;j++)
	for(k=0;k<finX;k++)
	  v[2][j][k]=0.0;
      for(j=0;j<nvps[0];j++)
	for(k=0;k<nhps[0];k++) 
	  v[2][j+stAy][k+stAx]=v[0][j][k];
      for(j=0;j<nvps[1];j++)
	for(k=0;k<nhps[1];k++) 
	  v[2][j+stBy][k+stBx]*=v[1][j][k];
       break;

     case 3:
      for(j=0;j<finY;j++)
	for(k=0;k<finX;k++)
	  v[2][j][k]=0.0;
      for(j=0;j<nvps[0];j++)
	for(k=0;k<nhps[0];k++) 
	  v[2][j+stAy][k+stAx]=v[0][j][k];
      for(j=0;j<nvps[1];j++)
	for(k=0;k<nhps[1];k++)
	  if (v[1][j][k])
	    v[2][j+stBy][k+stBx]/=v[1][j][k];
       break;
     }

   return;
}

void
bin_file::ops(const int type,const int a,const int b,const int c)
{
  /* 
     If the data sets are similar, it carries out operations 
     between different data sets. eg +,- etc. (Maybe redundent after
     the new spec_ops function.
  */

  int grps[3];
  int nhps[3],nvps[3];
  float **v[3];
  grps[0]=a-1;
  grps[1]=b-1;
  grps[2]=c-1;
  if (type>3 || type<0) 
    {
      l_c("Stange operator",1);
      return;
    }
  for(int i=0;i<3;i++)
    {
    if (grps[i]>=max_Maps || grps[i]<0)
      {
	l_c("Inconsistent groups to work with",1);
	return;
      }
    }
  if ((a==b) && (b==c))
    {
      l_c("Inconsistent groups to work with",1);
      return;
    }
  for(int i=0;i<3;i++)
    DD[grps[i]].handle(nhps[i],nvps[i],v[i]);

  if ((nhps[0]!=nhps[1]) || (nvps[0]!=nvps[1]))
    {
      l_c("Data sets have different numbers of points!",1);
      return;
    }
  if(nhps[2]!=nhps[0] || nvps[2]!=nvps[0])
    {
      DD[grps[2]].makespace(nhps[0],nvps[0]);
      DD[grps[2]].handle(nhps[2],nvps[2],v[2]);
    }

   int j,k;
   switch (type) 
     {
     case 0:
       for(j=0;j<nvps[0];j++)
	 for(k=0;k<nhps[0];k++)
	     v[2][j][k]=v[0][j][k]+v[1][j][k];
       break;
     case 1:
       for(j=0;j<nvps[0];j++)
	 for(k=0;k<nhps[0];k++)
	     v[2][j][k]=v[0][j][k]-v[1][j][k];
       break;
     case 2:
       for(j=0;j<nvps[0];j++)
	 for(k=0;k<nhps[0];k++)
	     v[2][j][k]=v[1][j][k]*v[0][j][k];
       break;
     case 3:
       for(j=0;j<nvps[0];j++)
	 for(k=0;k<nhps[0];k++)
            if (v[1][j][k])
	      v[2][j][k]=v[0][j][k]/v[1][j][k];
            else
	      v[2][j][k]=0.0;
       break;
     }
   return;
}



int 
dars_data::read_init(char* file,int start,int leng,int offset)
  {

/* need file to be the parameter file, startpt, endpt, and grp to
  be set in class before this stage 
*/

  extern Spec_In storage_; 
 
  char ss[256];
  char title[256];
  ifstream op_fil;
  if (file && ((strlen(file) > 2) || !(*filename))  ) 
    {
    if (file)
      op_fil.open(file,ios::in);
    if (!op_fil) 
      {
      strcpy(ss,"Enter file => ");
      l_c(ss,0);
      extractfile(title,ss,80);
      op_fil.open(title,ios::in);
      if (!op_fil)
        return 0;
      strcpy(filename,title);
      }
    else
      strcpy(filename,file);
    }
  else if (filename) 
    {
    op_fil.open(filename,ios::in);
    if (!op_fil)
      {
      l_c("Bad pre-defined file name ",1);
      return 0;
      }
    }
  else
    {
    l_c("No defined file",1);
    return 0;
    }

  op_fil.getline(title,255,'\n');
  op_fil.getline(ss,255,'\n');
  int a[10];
  a[0]=a[1]=0;
  int fc=0;
  int rct=0; 
  do 
    {
    rct+= a[1] * a[0];
    op_fil>>a[0]>>a[1]>>a[2]
          >>a[3]>>a[4]>>a[5]>>a[6]>>a[7]
          >>a[8]>>a[9];
    fc+=a[1];

    } while (a[9]==1 && fc<offset);
  

  if (fc<offset)
    {
    l_c("Bad number of frames requested ",1);
    return 0;
    }
  if (fc-(offset-1)<leng) leng=fc-(offset-1);
  fc-=(a[1]-1);
  rct+=(offset-fc) * a[0];
  int sect=(a[0] > 4000 ? 4000 : a[0] );   // maxpts * 2 
  while(a[9]==1)
    {
    op_fil>>a[2]>>a[3]>>a[4]>>a[5]>>a[6]>>a[7]
          >>a[2]>>a[3]>>a[4]>>a[9];
    }

  op_fil.getline(ss,255,'\n');   //>>a does not clear last return
  op_fil.getline(ss,255,'\n');
  op_fil.close();


  op_fil.open(ss,ios::in);  
  if (!op_fil)
    {
    for(int k=((int) strlen(ss))-1;k>=0;k--)
      {
      if (ss[k]>='A' && ss[k]<='Z') 
        {       
        ss[k]-= (int('A')-int('a'));
        }
      else if (ss[k]>='a' && ss[k]<='z')
        {
        ss[k]+= (int('A')-int('a'));
        }
      }
    } 
  op_fil.open(ss,ios::in);  
  if (!op_fil)
    {
    cout<<"ss is "<<ss<<endl;
    l_c("No secondary data file",1);
    return 0;
    }
  float *d_in = new float[sect]; 

  double tdv=1.0;
  if (sect>0.05) tdv = 360.0 / sect; 
  Uns A;
  for(int j=0;j<leng;j++)
    {
    op_fil.seekg((rct * 4) + (4 * a[0]*j),ios::beg);   //assumin y floats

    for(int jj=0;jj<sect;jj++)
      {
        op_fil.get(A.c[3]);
        op_fil.get(A.c[2]);         
        op_fil.get(A.c[1]);
        op_fil.get(A.c[0]);
        d_in[jj]=A.f;
      }
    //    op_fil.read((unsigned char*) d_in, 4 * sect);
    for(int k=0;k<sect;k++)
      {
      storage_.storx[start+j][k]=(double) tdv * k;
      storage_.story[start+j][k]=(double) d_in[k];
      storage_.store[start+j][k]=(double) 1.0;
      }
    storage_.stpnt[start+j]=sect;
    }
  op_fil.close();

  delete [] d_in;
  return 1;
  } 

void
bin_pic__(int *type)  //obsolete
{
  bin_pic(*type);
}

void
bin_gadds__(int *grp,int* offset,int *pts)
{
  bin_gadds(grp,offset,pts);
}

void
bin_xray__(int *ga,int* gb,int *gc)
{
  bin_xray(ga,gb,gc);
}

void
bin_xray(int *grp,int *grp2,int* grp3)
{
  extern wback hold_;
  extern titls about_;

  static dars_data dx;
  char ss[256];
  char name[81];
  int st= *grp;
  int len= *grp2;
  int off= *grp3;

  int flag(0);
  while(st>tg || st<1)
    {
      strcpy(ss,"First grp to input data =>");
      l_c(ss,0);
      s_line();
      if (!cmdnumber(ss,st)) return;
      flag=1;
    }
  st--;
  if (!len && !flag) len=(tg-st)+1;
  while(len<1 || len>(tg-st)+1)
    {
      strcpy(ss,"Number of data groups =>");
      l_c(ss,0);
      s_line();
      if (!cmdnumber(ss,len)) return;
      flag=1;
    }

  if (!off && !flag) off=1;
  while(off<1)
    {
      strcpy(ss,"Offset (in file points) =>");
      l_c(ss,0);
      s_line();
      if (!cmdnumber(ss,off)) return;
    }
  extractfile(name,hold_.is,80);
  int temp;
  if (dx.read_init(name,st,len,off))
    {
      for(int k=0;k<len;k++)
          {
            for(int jj=0;jj<40;jj++)
              about_.hd[k+st][jj]=' ';
            temp=(off+k);    
            about_.hd[k+st][2]=int('0') + (temp % 10);
            temp/=10;
            about_.hd[k+st][1]=int('0') + (temp % 10);
            temp/=10;
            about_.hd[k+st][0]=int('0') + (temp % 10);
          }
    }
  return;
} 

void
bin_gadds(int *grp,int *offset,int *pts)
{
    extern  bin_file sd;
    extern wback hold_;
    char name[81];        //hold_ does not exceed 80 char.
    extractfile(name,hold_.is,80);
    if (*offset<1)
      *offset=1; 
      
    int count;
    count=sd.read_gadds(*grp,name);
    return;

}

void
ascii_pic()
  /* reads data from an ascii file */
{
  extern  bin_file sd;
  extern wback hold_;
  char name[81];        //hold_ does not exceed 80 char.
  int inp[3];           //place to put info
  int i;
  zerofile(name,hold_.is,80,' ');
  for(i=0;i<3;i++)
    inp[i]=0;
  for(i=0;i<3 && cmdnumber(hold_.is,inp[i]);i++);   
  sd.read_ascii(name,inp[0],inp[1],inp[2]);   
  return;
}


void 
fit2d_pic()
{
  extern  bin_file sd;
  extern wback hold_;
  char name[81];        //hold_ does not exceed 80 char.

  int grp(-1),nhorr(-1),nvert(-1);
  int offset(1);

  zerofile(name,hold_.is,80);  //gets file name..
  int flag=cmdnumber(hold_.is,grp);  
  if (flag) 
    flag=cmdnumber(hold_.is,nhorr);
  if (flag) 
    flag=cmdnumber(hold_.is,nvert);
  if (flag) 
    flag=cmdnumber(hold_.is,offset);
  sd.read_fit2d(grp,name,offset,nhorr,nvert);   
  return;
}

void
esrf_pic(const int indian) 
{
  extern  bin_file sd;
  extern wback hold_;
  char name[81];        //hold_ does not exceed 80 char.
  int grp(0),nhorr(-1),nvert(-1),offset(1);

  zerofile(name,hold_.is,80);  //gets file name..
  int flag=cmdnumber(hold_.is,grp);  
  if (flag) 
    flag=cmdnumber(hold_.is,nhorr);
  if (flag) 
    flag=cmdnumber(hold_.is,nvert);
  if (flag) 
    flag=cmdnumber(hold_.is,offset);
  if (!indian)
    sd.read_esrf(grp,name,offset,nhorr,nvert,0);   
  else
    sd.read_esrf(grp,name,offset,nhorr,nvert,1);   
    
  return;
}

void
bin_pic(const int type,const int indian)
{
  extern  bin_file sd;
  extern wback hold_;
  char name[81];        //hold_ does not exceed 80 char.
  int inp[4];           //place to put info
  int i;
  zerofile(name,hold_.is,80);  //gets file name..
  for(i=0;i<4;i++)
    inp[i]=0;
  for(i=0;i<4 && cmdnumber(hold_.is,inp[i]) ;i++);   // may read number 
                                                     // in error  
  int count;
  if (!type)
    {
      if (!i) inp[0]=0;       //no number read.
      inp[1]=(i>0 && inp[1]>0 ? inp[1] : 1);
      if ((i==4 && inp[3]<1 && inp[2]>0) || (i==3 && inp[2]>1)) 
	inp[3]=inp[2];
      else if (i<3 || (i>2 && inp[2]<1))
	if (!indian)
	  inp[3]=inp[2]=512;
	else
	  inp[3]=inp[2]= -1;
      if (!indian)
	count=sd.read_data(inp[0],name,inp[1],inp[2],inp[3]);   
      else
	count=sd.read_data(inp[0],name,inp[1],inp[2],inp[3]);   
      return;
    }
  else
    {
      inp[3]=(i>3 && inp[3]>0 ? inp[3] : 1);	
      if ((i>=3 && inp[2]<1 && inp[1]>0) || (i==2 && inp[1]>0)) 
	inp[2]=inp[1];
      else if (i<2 || (i>1 && inp[1]<1))
	if (!indian)
	  inp[1]=inp[2]=512;
	else
	  inp[1]=inp[2]= -1;
      if (!indian)
	count=sd.read_data(inp[0],name,inp[3],inp[1],inp[2]);   
      else
	count=sd.read_data(inp[0],name,inp[3],inp[1],inp[2]);
      return;
    }
  return;
}



void 
read_bin(int *sgrp,int *lent,int *offset)
  {
  extern titls about_;
  extern wback hold_;

  static dars_data dx;

  int s,l,o;
  s= *sgrp-1;
  l= *lent;
  o= *offset;

  char ss[255];
  if (hold_.is[0]) 
    strcpy(ss,hold_.is);
  else 
    ss[0]=0;

  int  temp;  
  if(dx.read_init(ss,s,l,o))
   {
   for(int k=0;k<l;k++)
     {
     for(int jj=0;jj<40;jj++)
       about_.hd[k+s][jj]=' ';
     temp=(o+k);    
     about_.hd[k+s][2]=int('0') + (temp % 10);
     temp/=10;
     about_.hd[k+s][1]=int('0') + (temp % 10);
     temp/=10;
     about_.hd[k+s][0]=int('0') + (temp % 10);
     }
   }

  return;
  } 

void special_()
{
  special();
}

void special()
  /* Creates a random 512x512 dat set and places it into test.dat */
{
  Uns A;
  ofstream temp;
  temp.open("test.dat");
  for(int i=0;i<512;i++)  
    for(int j=0;j<512;j++)
      {
        A.f = ran() * 10.0;
	temp.put(A.c[3]);
	temp.put(A.c[2]);
	temp.put(A.c[1]);
	temp.put(A.c[0]);
      }
   temp.close();
}
