#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "wshare.h"


/* Pulldown menus are built from cascade buttons, so this function
 * also includes pullright menus.  Create the menu, the cascade button
 * that owns the menu, and then the submenu items.
 * Modified to accept Widget *out = array of widget to place the 
 * menu item in.
 */


Widget
BuildPulldownMenu(Widget parent,char* menu_title,char menu_mnemonic,
                  int tear_off,men_item* items,Widget* out)

{
    Widget PullDown, cascade, widget;
    int i;
    XmString str;

    PullDown = XmCreatePulldownMenu (parent, "_pulldown", NULL, 0);
    if (tear_off)
        XtVaSetValues (PullDown, XmNtearOffModel, XmTEAR_OFF_ENABLED, NULL);
    str = XmStringCreateLocalized (menu_title);
    cascade = XtVaCreateManagedWidget (menu_title,
        xmCascadeButtonGadgetClass, parent,
        XmNsubMenuId,   PullDown,
        XmNlabelString, str,
        XmNmnemonic,    menu_mnemonic,
        NULL);
    XmStringFree (str);

    /* Now add the menu items */
    for (i = 0; items[i].label != NULL; i++) {
        /* If subitems exist, create the pull-right menu by calling this
          function recursively.  Since the function returns a cascade
          button, the widget returned is used..
         */
        if (items[i].subitems)
            widget = BuildPulldownMenu (PullDown, items[i].label, 
                items[i].mnemonic, tear_off, items[i].subitems,0);
        else
            widget = XtVaCreateManagedWidget (items[i].label,
                *items[i].cls, PullDown,
                NULL);
        /* Whether the item is a real item or a cascade button with a
         * menu, it can still have a mnemonic.
         */
        if (items[i].mnemonic)
            XtVaSetValues (widget, XmNmnemonic, items[i].mnemonic, NULL);
        /* any item can have an accelerator, except cascade menus. But,
         * we don't worry about that; we know better in our declarations.
         */
        if (items[i].accelerator) {
            str = XmStringCreateLocalized (items[i].accel_text);
            XtVaSetValues (widget,
                XmNaccelerator, items[i].accelerator,
                XmNacceleratorText, str,
                NULL);
            XmStringFree (str);
        }
        if (items[i].callback)
            XtAddCallback(widget,
                (items[i].cls == &xmToggleButtonWidgetClass ||
                items[i].cls == &xmToggleButtonGadgetClass) ?
                    XmNvalueChangedCallback : /* ToggleButton class */
                    XmNactivateCallback,      /* PushButton class */
                items[i].callback, items[i].callback_data);

        if (out)
          {
          *out=widget;
          out++;
          }
    }
    return cascade;
}

Widget
BuildOptionMenu(Widget parent,char* menu_title,char menu_mnemonic,
                  int tear_off,men_item* items,Widget* out)

{
    Widget PullDown, cascade, widget;
    int i;
    XmString str;

    PullDown = XmCreatePulldownMenu (parent, "_pulldown", NULL, 0);
    if (tear_off)
        XtVaSetValues (PullDown, XmNtearOffModel, XmTEAR_OFF_ENABLED, NULL);
    str = XmStringCreateLocalized (menu_title);
    Arg args[10];
    int n(0);
    XtSetArg(args[n],XmNsubMenuId,PullDown); n++;
    XtSetArg(args[n],XmNlabelString,str); n++;

    cascade=XmCreateOptionMenu(parent,"option_rc",args,n);
    
    XmStringFree (str);

    /* Now add the menu items */
    for (i = 0; items[i].label != NULL; i++) {
        /* If subitems exist, create the pull-right menu by calling this
          function recursively.  Since the function returns a cascade
          button, the widget returned is used..
         */
        if (items[i].subitems)
            widget = BuildPulldownMenu (PullDown, items[i].label, 
                items[i].mnemonic, tear_off, items[i].subitems,0);
        else
            widget = XtVaCreateManagedWidget (items[i].label,
                *items[i].cls, PullDown,
		XmNmarginHeight,(Dimension) 0,
	        XmNheight,(Dimension) 0,
                NULL);
        /* Whether the item is a real item or a cascade button with a
         * menu, it can still have a mnemonic.
         */
        if (items[i].mnemonic)
            XtVaSetValues (widget, XmNmnemonic, items[i].mnemonic, NULL);
        /* any item can have an accelerator, except cascade menus. But,
         * we don't worry about that; we know better in our declarations.
         */
        if (items[i].accelerator) {
            str = XmStringCreateLocalized (items[i].accel_text);
            XtVaSetValues (widget,
                XmNaccelerator, items[i].accelerator,
                XmNacceleratorText, str,
                NULL);
            XmStringFree (str);
        }
        if (items[i].callback)
            XtAddCallback(widget,
                (items[i].cls == &xmToggleButtonWidgetClass ||
                items[i].cls == &xmToggleButtonGadgetClass) ?
                    XmNvalueChangedCallback : /* ToggleButton class */
                    XmNactivateCallback,      /* PushButton class */
                items[i].callback, items[i].callback_data);

        if (out)
          {
          *out=widget;
          out++;
          }
    }
    return cascade;
}

 
Widget
BuildMenu(Widget parent,int menu_type,char* menu_title,char menu_mnemonic,
                  int tear_off,men_item* items,Widget* out)

{
    Widget menu, cascade, widget;
    int i;
    XmString str;

    if (menu_type == XmMENU_PULLDOWN)
      menu=XmCreatePulldownMenu(parent,"_pulldown",NULL,0);
    else
      menu=XmCreatePopupMenu(parent,"_popup",NULL,0);
 
    if (tear_off)
      XtVaSetValues (menu, XmNtearOffModel, XmTEAR_OFF_ENABLED, NULL);
   
    if (menu_type == XmMENU_PULLDOWN)
      {

	str = XmStringCreateLocalized (menu_title);
	cascade = XtVaCreateManagedWidget (menu_title,
	  xmCascadeButtonGadgetClass, parent,
          XmNsubMenuId,   menu,
          XmNlabelString, str,
          XmNmnemonic,    menu_mnemonic,
          NULL);
        XmStringFree (str);
      }

    /* Now add the menu items */
    for (i = 0; items[i].label != NULL; i++) {
        /* If subitems exist, create the pull-right menu by calling this
          function recursively.  Since the function returns a cascade
          button, the widget returned is used..
         */
        if (items[i].subitems)
            widget = BuildPulldownMenu (menu, items[i].label, 
                items[i].mnemonic, tear_off, items[i].subitems,0);
        else
            widget = XtVaCreateManagedWidget (items[i].label,
                *items[i].cls, menu,
                NULL);
        /* Whether the item is a real item or a cascade button with a
         * menu, it can still have a mnemonic.
         */
        if (items[i].mnemonic)
            XtVaSetValues (widget, XmNmnemonic, items[i].mnemonic, NULL);
        /* any item can have an accelerator, except cascade menus. But,
         * we don't worry about that; we know better in our declarations.
         */
        if (items[i].accelerator) {
            str = XmStringCreateLocalized (items[i].accel_text);
            XtVaSetValues (widget,
                XmNaccelerator, items[i].accelerator,
                XmNacceleratorText, str,
                NULL);
            XmStringFree (str);
        }
        if (items[i].callback)
            XtAddCallback(widget,
                (items[i].cls == &xmToggleButtonWidgetClass ||
                items[i].cls == &xmToggleButtonGadgetClass) ?
                    XmNvalueChangedCallback : /* ToggleButton class */
                    XmNactivateCallback,      /* PushButton class */
                items[i].callback, items[i].callback_data);

        if (out)
          {
          *out=widget;
          out++;
          }
    }
    return menu_type == XmMENU_POPUP ? menu : cascade;
}


Pixel
get_pixel(Widget w, const char *resource_value)
{
  Colormap colormap;
  Boolean status;
  XColor exact, color;

  colormap = DefaultColormapOfScreen(DefaultScreenOfDisplay(XtDisplay(w)));
  status = XAllocNamedColor( XtDisplay(w), colormap, resource_value, 
			     &color, &exact);

  if (status == 0){
    fprintf(stderr, "Unknown color: %s", resource_value);
    color.pixel = BlackPixelOfScreen( DefaultScreenOfDisplay(XtDisplay(w)) );
  };
  return (color.pixel);
}
