#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "svd.h"
#include "cmd.h"
#include "linfit.h"
#include "fglobal.h"


linfit::linfit() : X(0),Y(0),E(0),
		   Fixed(0),Parm(0),useSigma(0),minX(-1),maxX(-1)
{}

linfit::~linfit()
{
  delete [] Fixed;
  delete [] Parm;
}

void
linfit::setNvar(const int NV)
  /* Set number of variables */
{
  if (NV!=nvar)
    {
      if (A)
	{
	  freematrix(A);
	  A=0;
	}
    }
  nvar=NV;
  if (!A)
    A=matrix(nvar,nvar); //make matrix for fit.
  return;
}


void
linfit::setgrp(const int grp)
  /* set X,Y,E to storage_.grp */
{
  extern Spec_In storage_; 
  if (grp<tg && grp>=0 &&
      storage_.stpnt[grp]>0)
    {
      X=storage_.storx[grp];
      Y=storage_.story[grp];
      E=storage_.store[grp];
    }
  Ndat=storage_.stpnt[grp];
  if (minX<0) 
    minX=0;
  if (maxX<0 || maxX>Ndat)
    maxX=Ndat;
  return;
}


void 
linfit::setSig(const int A)
  /* Turns on/off error fitting */
{
  useSigma = (A) ? 1 : 0;
  return;
}


int
linfit::LFit()
  /* Return numbers -1 == No variables , 
     -2 no unfixed var */
{
  if (!A) //If no matrix 
    return -1;
  int mfit=0;  //number of non-fixed variables
  for(int i=0;i<nvar;i++)
    {
      if (Fixed[i]) 
	mfit++;
    }
  if (mfit==0)
    return -2;        // no fixed variables.

  double* beta= new double[nvar];

  for(int j=0;j<mfit;j++)  //zero matrixes
    {
      beta[j]=0.0;
      for(int k=0;k<mfit;k++)
	A[j][k]=0.0;
    }
  double* Avals=new double[nvar];

  for(int i=minX;i<maxX;i++)  //loop over points 
    {
      (fitfun)(X[i],Avals);  //set Avals matrix.
      double ym=Y[i];
      if (nvar>mfit)
	for(int j=0;j<nvar;j++)
	  if (Fixed[j])
	    ym-=Parm[j]*Avals[j];
    
      double sig2 = (useSigma) ? E[i] : 1.0;
  
      for(int j(0),l(0);l<nvar;l++)
	if (!Fixed[l])
	  { 
	    double wt=Avals[l] / sig2;
	    for(int m(0),k(0);m<l;m++)
	      {
		if (!Fixed[m])
		  {
		    A[j][k]+=wt*Avals[m];
		    k++;
		  }
		beta[j++]+= ym*wt;
	      }
	  }
    }
  for(int j=1;j<mfit;j++) //make mirror matrix.
    for(int k=0;k<j;k++)
      A[k][j]=A[j][k];
  
  gaussj(A,beta,nvar);


  delete [] Avals;
  delete [] beta;
  return 0;
}








