#include <fstream.h>
#include <strstream.h>
#include <math.h> 
#include <string>
#include <vector>
#include "wshare.h"
#include "fit_param.h"
#include "poly2.h"
#include "splx_fit.h"
#include "cmd.h"

using namespace std;    // otherwise need std:: before all string ops.


static intep test;
double make_fit();

void wind_fit(const int grp,const int grp2)
{
  test.cnt.set_grp(grp,grp2);
  test.cnt.make_wind();
  return;
}

void do_fit(Widget w,XtPointer client_data,XtPointer call_data)
{
  XtVaSetValues(w,XmNsensitive,0,NULL);
  CheckForInterrupt();
  char s[255];
  ostrstream lss(s,255,ios::out);
  test.cnt.num_all();
  lss.setf(ios::scientific,ios::floatfield);
  lss.precision(10);
  lss<<"Fit chi ="<<make_fit()<<'\0';
  l_c(s,3);  
  test.cnt.set_text_field();
  test.set_points();
  XtVaSetValues(w,XmNsensitive,1,NULL);
  return;
}

double make_fit()
{
  const double downforce(1.2);
  const double movebit(0.50);
  if (!test.cnt.valid())
    return 0.0; 
  if (!test.made()) 
    new_string(0,0,0);  //this still force a keyboard string update.
  if (!test.made()) 
     return 0.0;
  double qft=test.chi(); 
  test.cnt.qft=qft;
  double old_par,old_qft;
  
  fit_param best(test.cnt);    // get data from the group
  fit sweep;
  if (best.qft==0.0) return 0.0; 
  int imove(0),emove(0),iter(0),nsucc(0);
  double temp(qft/10.0);
  int kc;        //  count of loop
  int nlow(0);   //  total number of lowerings.
  int nparas(0); // number of parameters that change
  char s[255];
  ostrstream lss(s,255,ios::out);
  for (int i=0;i<best.n_par;i++)
    nparas+=best.flag[i];
  if (nparas<1) 
    {
      sprintf(s,"No free parameters!!");
      l_c(s,1);
      return qft;
    }
  if (test.cnt.f_method==5)
    {
      sweep.do_mrq(test,nparas,best.n_par);
      return test.cnt.qft;
    }
  else if (test.cnt.f_method>1)
    {
      sweep.reinit(test,nparas,best.n_par); 
      if (test.cnt.f_method==2) sweep.badfit(0);
      if (test.cnt.f_method==3) sweep.badfit(100);
      if (test.cnt.f_method==4) sweep.powell();
      return test.cnt.qft;
    } 
  sweep.set_total(best.n_par);
 
  double hqft=1e20;
  while(hqft-best.qft>1e-20)
    {
      if (!(iter % 10) && iter>0) hqft=best.qft;
      kc=0;
      nsucc=0;
      iter++;
      while(kc<(10*nparas))
	{
	  for(int j=0;j<best.n_par;j++)
        {
	  if (best.flag[j])
	    {
	      old_par=test.cnt.v[j];
	      old_qft=test.cnt.qft;
	      if (ran()>double(kc)/10.0)
		test.cnt.v[j]*=(1.0+movebit) * (0.5-ran()) * 2.0; //big move
	      else
		test.cnt.v[j]*=1.0+(movebit * (0.5-ran()) * 2.0/double(iter));
                                               //small move
	
	      double *vl=test.cnt.vl;
	      double *vav=test.cnt.v;

	      while ((vav[j]<vl[2*j]) || (vav[j]>vl[2*j+1]))
		{
		  if (vav[j]>vl[2*j+1]) vav[j]= (2.0 * vl[2*j+1]) - vav[j];
		  if (vav[j]<vl[2*j]) vav[j]= (2.0 * vl[2*j]) - vav[j];
		}

	      qft=test.chi();
	      kc++;
	      if (qft<old_qft)
		{
		  imove++;
		  if (qft<best.qft)
		    {
		      best=test.cnt;
		      nsucc++;
		      if (nsucc>8) kc=10*nparas;
		      nlow++;
		    }
		}
	      else
		{
		  if (exp((old_qft-qft)/temp)>ran())
		    emove++;
		  else
		    {
		      test.cnt.v[j]=old_par;
		      test.cnt.qft=old_qft;
		    }
		}
	    }
        }
	}
      temp/=downforce;
    }
  test.cnt=best;  
  sprintf(s,"QFT low is %f ",best.qft);
  l_c(s,1);
  return test.cnt.qft;
}



void 
new_string(Widget w,XtPointer client_data,XtPointer call_data)
  /*
    Aquires new string from system and passes to make_list for
    intepretation
  */
{ 
  char s[255];  
  string rs;

  strcpy(s,"Input the function =>");
  int count;
  do 
    {
      l_c(s);
      rs+=s;
      while((count=rs.find(" "))>0)
	rs.replace(rs.begin()+count,rs.begin()+count+1,"");
      count=rs.find("\\");
      if (count>0) rs.replace(rs.begin()+count,rs.end(),"");
      strcpy(s,"Input the continuation of the function =>");
    } while (count<255 && count>0);
  strncpy(s,rs.c_str(),255);
  s[254]='\000';
  test.makeList(s);
  if (!test.made())
    {
      rs="Non-understood string";
      strncpy(s,rs.c_str(),255);
      l_c(s,1);
      s_line();
      return;
    }
  test.cnt.make_wind();
  s_line();
  return;
}
 
void 
inteprate(int* grp,int* grp2,int* type)
{
/*   type is the sub call, this function is necessary as it is not allowed
     to have a second global name area. */
    
  extern wback hold_;
 
  int& gp= *grp;
  int& gp2 = *grp2;
  int i;
  for(i=0;i<80 && hold_.is[i] && 
	!isalnum(hold_.is[i]);i++);
  char third=hold_.is[i];
  if (third=='L' || third=='l')
    {
      hold_.is[i]=' ';
      test.cnt.Kset_limits();
      return;
    }
  if (third=='C' || third=='c')
    {
      hold_.is[i]=' ';
      test.cnt.Kset_const();
      return;
    }
  if (third=='V' || third=='v')
    {
      hold_.is[i]=' ';
      test.cnt.Kwrite_values();
      return;
    }

  char s[255];   //place to put input strings 
  string rs;
  
  if (*type==0 || !test.made())
    {
      int count;
      strcpy(s,"Input the string function to use =>");
      do
	{
	  l_c(s);
	  rs+=s;
	  while((count=rs.find(" "))>0)
	    rs.replace(rs.begin()+count,rs.begin()+count+1,"");
	  count=rs.find("\\");
	  if (count>0) rs.replace(rs.begin()+count,rs.end(),"");
	  strcpy(s,"Input the continuation of the function =>");
	} while (rs.length()<300 && count>0);
      strncpy(s,rs.c_str(),255);
      s[254]='\000';
      test.makeList(s);
      if (!test.made())
	{
	  l_c("Non-understood string",1);
	  return;
	} 
    }
  test.cnt.make_wind();
  while(gp<1 || gp>tg)
    {
      strcpy(s,"Which group to fit from =>");
      l_c(s);
      gp=atoi(s);
      if (!gp) return;
   }
  
  while(gp2<1 || gp2>tg)
    {
      strcpy(s,"Which group to place fit =>");
      l_c(s);
      gp2=atoi(s);
      if (!gp2) return;
    }
  test.set_points(gp,gp2);
  test.cnt.set_text_field();
  s_line();
  return;
}  

 









