#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "cmd.h"      
#include "wshare.h"
#include "fit_param.h"
#include "poly2.h"
#include "fglobal.h"

       
intep_box::intep_box(const intep_box* a,const intep_box* b,const int code) : 
  a_type(0),K(0.0),op_code(code), A(a), B(b),C(0)
{ }
     
intep_box::intep_box(const int type,const int grp,const int minus)  : 
  a_type(type),K((minus ? -1.0 : 1.0)),op_code(grp), A(0), B(0),C(0)
{ }

      
intep_box::intep_box(const double ct) :
  a_type(3),K(ct),op_code(0), A(0),B(0),C(0) 
{ }
             
intep_box::intep_box(const int grp,const fit_param* c,const int minus) :
  a_type(6),K((minus ? -1.0 : 1.0)),op_code(grp), A(0), B(0),C(c)
{ }
      
intep_box::intep_box(const intep_box* a,const int code) : 
  a_type(0),K(0.0),op_code(code), A(a), B(0),C(0)
{ }
     
intep_box::~intep_box()
{ }

double 
intep_box::intepY(const double Xv,const int grp,const int pt) const
  /* dx is the displacement vector of the X point
     pt is the point in storage_ that is notionally fitted.
     grp -- grp to take data from 
  */
{
  extern Spec_In storage_;

  double Rv;
  const int Tp=storage_.stpnt[grp];
  double *XA=storage_.storx[grp];
  if (*XA>Xv || XA[Tp-1]<Xv)
    return 0.0;
  int Xt=xpos(Xv,XA,Tp);  //assume returns low
  double *YA=storage_.story[grp];
  Rv=(YA[Xt+1]-YA[Xt])/(XA[Xt+1]-XA[Xt]);
  Rv*=Xv-XA[Xt];
  return Rv+YA[Xt];
}

 
double 
intep_box::value(const int type,const int grp) const
  /* 
     Type is the value of the x point in the array if needed.
     The default group : grp 
  */
{
  extern Spec_In storage_;           

  double temp_l,temp2_l,temp2,temp,xp;     
  int tvi;

  if (type<0) return 0.0;             //type ==0 ... stpnt(grp)-1 
  switch (a_type)                     
    {
    case 6:
      return ((op_code<=C->n_par) ? K*C->v[op_code-1] : 0.0);
    case 4:
      if (storage_.stpnt[grp-1]<=type) return 0.0;
      return K*storage_.storx[grp-1][type];
    case 5:
      if (storage_.stpnt[grp-1]<=type) return 0.0;
      return K*storage_.story[grp-1][type];
    case 3:
      return K;
    case 1:
      if (storage_.stpnt[op_code-1]<=type) return 0.0;
      return K*storage_.storx[op_code-1][type];
    case 2: 
      if (storage_.stpnt[op_code-1]<=type) return 0.0;
      return K*storage_.story[op_code-1][type];
    default:   //zero case
      switch (op_code) 
	{
	case 1:
	  return A->value(type,grp) + B->value(type,grp);
	case 2:
	  return A->value(type,grp) - B->value(type,grp);
	case 3:
	  return A->value(type,grp) * B->value(type,grp);
	case 4:
	  temp = B->value(type,grp);
	  temp2= A->value(type,grp);
	  if (!temp2) return 0.0;
	  if (!temp) temp=1e-90;
	  temp2_l=fabs(temp2);
	  if ((temp_l=fabs(temp))<1e-40 || temp2_l>1e40)
	    {
	      temp_l=log(temp_l);
	      temp2_l=log(temp2_l);
	      temp2_l-=temp_l;
	      if(temp2_l>87.5) temp2_l=87.5;
	      if(temp2_l<-85.1) temp2_l=-85.1; 
	      return sign(temp)*sign(temp2)*exp(temp2_l);
	    }
	  else
	    {
	      return temp2/temp;
	    }  
	case 5:
	  return pow(A->value(type,grp),B->value(type,grp));
	case -1:
	  return sin(A->value(type,grp));
	case -2:                      //Area for some reduction in theta.
	  return cos(A->value(type,grp));
	case -3:
	  return tan(A->value(type,grp));
	case -4:
	  temp=A->value(type,grp);         //Area for some -ve trap;
	  return ((temp>0.0) ? log(temp) : 0.0); 
	case -5:
	  temp=A->value(type,grp);       //Area for some overflow;
	  return ((temp<87.5) ? exp(temp) : exp(87.5));
	case -6: 
	  return asin(A->value(type,grp));            
	case -7:
	  return acos(A->value(type,grp));            
	case -8:
	  return atan(A->value(type,grp));            
	case -9:
	  return sinh(A->value(type,grp));
	case -10:
	  return cosh(A->value(type,grp)); 
	case -11:
	  return tanh(A->value(type,grp));
	case -12:
	  xp=storage_.storx[grp-1][type];
	  return intepY(A->value(type,grp)+xp,grp-1,type);
	default:
	  tvi= -(op_code+13);
	  if (tvi>=tg || tvi<0)
	    {
	      l_c("Have encontered an unknown function returning 1.0",1);
	      return 1.0;
	    }
	  else
	    {
	      xp=storage_.storx[grp-1][type];
	      return intepY(A->value(type,grp)+xp,tvi,type);
	    }
	}
    }
} 
 
intep::intep() : cnt(this), //initialise fit_param(this) 
  vc(0),chain(0)
{
  con_dep=0;
}     

intep::~intep() 
{
  clean_boxes();
}
         
int 
intep::print_flag()
{
  if (!con_dep)
    { 
      l_c("No parameters to fit",1);
      return 0;
    }
  double d;
  int f;
  char s='t';
  int i;
  do {
    for(i=0;i<con_dep;i++)
      {
	cout<<endl;
	cout<<"Parm "<<setw(0)<<i+1<<" "<<
	  setw(0)<<cnt.flag[i]<<" "<<
	  setw(0)<<cnt.v[i]<<endl;
      }
    i=userdint("Which line to change",con_dep+1,1);
    if (i>0) 
      {
	i--;
	d=userdbl("Const value:",1e300,-1e300);
	f=userint("Flag state:",2,-1);
      }
    else
      {
	cout<<"Quit y/n"<<endl;
	cin>>s;
	cin.ignore(255,'\n');
      }   
  } while(s!='y' || s!='S');
  return 1;
}
      
double 
intep::chi(const double *sig2)
  /* Calculate the chi2 assuming that an error term has been given
     as sig2 :: There are no checks for division by zero.
  */
{
  extern Spec_In storage_;              // class item.
     
  int x1=cnt.s_pt();
  int x2=cnt.e_pt();
  if (x1==x2) 
    {
      l_c("Note :: No points in fit",1);
      return 0.0;
    }
  int fgrp=cnt.i_grp();
  double hold=0.0;
  double tem;
  if (!made()) return 0.0;
  double *yvp = storage_.story[fgrp-1];
  for (int i=x1;i<x2;i++)
      {
	tem= yvp[i] - chain->value(i,fgrp);
	hold += tem * tem * sig2[i];
      }
  hold/= (x2-x1);
  cnt.qft=hold;
  return hold;
}
      
double intep::chi() 
{
  // #pragma extern_model common_block    // need to define it here as can't be
  extern Spec_In storage_;              // class item.
     
  int x1=cnt.s_pt();
  int x2=cnt.e_pt();
  int fgrp=cnt.i_grp();
  double hold=0.0;
  double tem;
  if (!made()) return 0.0;
  double spl2;
  for (int i=x1;i<x2;i++)
    {
      spl2=storage_.store[fgrp-1][i];
      if (spl2<=0.0) 
	spl2=1.0;
      else
	spl2*=spl2;
      tem=storage_.story[fgrp-1][i] - chain->value(i,fgrp);
      hold+= tem* tem / spl2;
    }
  hold/=(x2-x1);
  cnt.qft=hold;
  return hold;
}

int 
fit_param::valid()
{
  //   #pragma extern_model common_block    // need to define it here as can't be
  extern Spec_In storage_;             // class item.
  
  if (in_grp==out_grp) return 0;
  if (storage_.stpnt[in_grp-1]<1) return 0;
  if (storage_.stpnt[in_grp-1]<end)
    {
      end=storage_.stpnt[in_grp-1];
      if (start>end)
	{
	  set_pts(end,end);
	  return 0;
	}
    }
  return 1;
}

void 
intep::set_const(double *A,const int n)
{
  
  if (n<0) return;   //no const to set.
  int nn=((n>con_dep) ? n : con_dep);
  cnt.resize(nn);
  int i;
  for(i=0;i<n;i++)
    {
      cnt.v[i]=A[i];
      cnt.flag[i]=1;
    }
  for(;i<nn;i++)
    {
      cnt.v[i]=0.0;
      cnt.flag[i]=0;
    }
  return;
}

void 
intep::set_points(int grp,int grp2) const
  /* 
     Job is to place the fitted data into the new group defined
     by the function
  */
{
  extern Spec_In storage_;              // class item. 
  if (grp==-1) grp=cnt.i_grp();
  if (grp2==-1) grp2=cnt.o_grp();
  if (grp>tg || grp<1 || grp2>tg || grp2<1) return;
  if (!made()) return;  //use function because it is chain is subject to change.  
  int pt=storage_.stpnt[grp-1];
  if (pt<1) return;
  for (int i=0;i<pt;i++)
    {
      storage_.storx[grp2-1][i]=storage_.storx[grp-1][i];     
      storage_.story[grp2-1][i]=chain->value(i,grp);
    }
  storage_.stpnt[grp2-1]=pt;
  return;
}


intep_box* 
intep::eval_unit(string& Sect)
  /* This is a unit section, only allowed symbols are +/- on leading
     character 
  */
{           //Take string WITHOUT ( ) however *(s-1)==(
  intep_box *pp,*pp2,*pp3; 
  int minus(0);

  if (Sect[0]=='+')
    Sect.erase(0,1);   //dump beginning +
  else if (Sect[0]=='-')
    {
      minus=1;
      Sect.erase(0,1);   //dump beginning - but set flag.
    }
  unsigned int last=Sect.length()-1;
  if (last<0)   //to short...
    throw str_make("Part :: To short");
  
  std::string::size_type pos;

  //SECTION 
  pos = Sect.find('V');
  if (pos!=std::string::npos)
    {
      if(last-pos<=0)   //no further information.
	throw str_make();
      unsigned int itemN=static_cast<unsigned int>(Sect[pos+1])-1;
      if (itemN>=list_items.size())  //itemN to big cant be right.
	throw str_make(); 
      if (minus)
	{
	  pp=list_items[itemN];
          pp2=new intep_box(-1.0);
          list_items.push_back(pp2);
	  vc++;
          pp3=new intep_box(pp2,pp,3);  // (-1*pp)
          list_items.push_back(pp3);
	  vc++;
          return pp3;
	}
      return list_items[itemN];
    }

  if (Sect[0]=='c' || Sect[0]=='y' || Sect[0]=='x')
    {
      if (!last) //simple case.
	{
	  if (Sect[0]=='c') //c must be point defined.
	    throw str_make();
	  if (Sect[0]=='x')
	    pp=new intep_box(4,0,minus);
	  else  // if (Sect[0]=='y')  TEST NOT NECESSARY YET
	    pp=new intep_box(5,0,minus);
	  list_items.push_back(pp);
	  vc++;
	  return pp;
	}
      // X[ ] type section
      if (Sect[1]!='[' || Sect[last]!=']')
	throw str_make();
      int ii(2),grp(0);
      while(isdigit(Sect[ii]))
	{
	  grp*=10;
	  grp+=static_cast<int>(Sect[ii]-'0');
	  ii++;
	}
      if (grp>tg || grp<1)  // number out of range.
	throw str_make();  
      if (Sect[0]=='c')
	{
	  con_dep=((con_dep<grp) ? grp : con_dep); // check space
	  pp=new intep_box(grp,&cnt,minus);
	}
      else if (Sect[0]=='x')
	pp=new intep_box(1,grp,minus);
      else // if (Sect[0]=='y') NOT NEEDED YET
	pp=new intep_box(2,grp,minus);
      list_items.push_back(pp);
      vc++;
      return pp;
    }
  //NUMBERS.
  //Must be a number if no a pre-made section or x,y,c.

  pos=Sect.find('e');
  if (pos!=std::string::npos && pos!=last)   //have 1e-5 type number
    {
     if (Sect[pos+1]=='m')
       Sect[pos+1]='-';
     else if (Sect[pos+1]=='p')
       Sect[pos+1]='+';
    }
  char** endptr=new char*;
  const char* spt = Sect.c_str();
  double nmb = strtod(Sect.c_str(),endptr); 
  if (*endptr != spt+last+1)
    {
      delete endptr;
      throw str_make();
    }
  if (minus)
    nmb*=-1;
  pp=new intep_box(nmb);
  list_items.push_back(pp);
  vc++;
  return pp;
}


     
void 
intep::clean_boxes()
{
  std::vector<intep_box*>::iterator Lp;
  for(Lp=list_items.begin();Lp!=list_items.end();Lp++)
    delete (*Lp);
  list_items.clear();  // Make sure we don't accidentally call this twice.
  vc=0;
  chain=0;
  con_dep=0;
}

int 
intep::prep_string(char* S,int len)
  /* Job: do general things to string, make all lowercase, reset +-* and /
     to be ABCD and remove all space. Returns length of string else 0
  */
{
  int spc=0;  //current number of spaces found
  for(int i=0;i<len;i++)
    {
      switch (S[i]) {
      case ' ':
      case '\t':
	spc++;
	break;
      case '+':
	S[i-spc]='A';
	break;
      case '-':
	S[i-spc]='B';
	break;
      case '*':
	S[i-spc]='C';
	break;
      case '/':
	S[i-spc]='D';
	break;
      case '^':
	S[i-spc]='E';
	break;
      case 'e':  //must be before +/-  
	if (i+1!=len && S[i+1]=='-') 
	  S[i+1]='m';
	else if (i+1!=len && S[i+1]=='+')
	  S[i+1]='p';  //continue to default.....
	break;
      default:
	if (S[i]>='A' && S[i]<='Z')
	  S[i-spc]=S[i]-(int('A')-int('a'));
	else
	  S[i-spc]=S[i];
      }
    }
  for(int i=0;i<len-spc;i++)  //check for modifiers.
    if (S[i]=='A' || S[i]=='B')
      {
	if (i==0 ||          // First postion MUST be modifier
	    S[i-1]=='(' ||   // All (-etc must be)
	    (S[i-1]>='A' && S[i-1]<='E'))  //All x*-y
	  {
	    S[i]=(S[i]=='A') ? '+' : '-';
	  }
      }
  return len-spc;
}


int 
intep::isfunc(const string& Sv,int& size) const
  /* Checks the string for a function name */
{
  size=4;
  if (Sv.find("asin")!=std::string::npos) return -6;
  if (Sv.find("acos")!=std::string::npos) return -7;
  if (Sv.find("atan")!=std::string::npos) return -8;
  if (Sv.find("sinh")!=std::string::npos) return -9;
  if (Sv.find("cosh")!=std::string::npos) return -10;
  if (Sv.find("tanh")!=std::string::npos) return -11;
  if (Sv.find("itpy")!=std::string::npos) return -12;
  size=3;
  if (Sv.find("sin")!=std::string::npos) return -1;
  if (Sv.find("cos")!=std::string::npos) return -2;
  if (Sv.find("tan")!=std::string::npos) return -3;
  if (Sv.find("log")!=std::string::npos) return -4;
  if (Sv.find("exp")!=std::string::npos) return -5;
  size=0;
  return 0;
}
                



double intep::point(const int pt,const int grp) const
{
  if (!chain) return 0.0;
  return chain->value(pt,grp);
}
         
intep_box* 
intep::subbrack(const string& sS)
  /* 
     Interperate a close bracket unit 
     using a string formalism 
  */
{
  if (sS.size()<1)
    throw str_make();  
  //First bracket check;
  int bl(0);
  for (unsigned int i=0;i<sS.size();i++)     
    {
      if (sS[i]=='[')
	bl=1;
      else if (sS[i]==']')
	{
	  if (!bl) throw str_make();
	  bl=0;
	}
    }

  //Now make string.
  
  string Line(sS);
  string rpart;
  string lpart;

  intep_box* pp(0);  //zero so we can check we made a box.
  std::string::size_type pos;
  char mfunc('F');
  for(int i=0;i<5;i++)   //deal with ^ / *
    {
      mfunc--;  //start with E == ( ^ ) 
      unsigned int last=Line.length()-1;
      pos=Line.find(mfunc);
      if (!pos && (mfunc=='A' || mfunc=='B'))
	pos=Line.find(mfunc,1);

      while(pos!=string::npos)
	{
	  //Check simple error conditions 
	  if (!pos || pos==last)   // end/beginning with symbol forbidden
	    throw str_make();

	  std::string::size_type lpos;
	  std::string::size_type rpos;
	  std::string::size_type rExtpos=0;
	  rpos=Line.find_first_of("ABCDE",pos+1);
	  lpos=Line.find_last_of("ABCDE",pos-1);
	  if (rpos==pos+1 &&  
	      Line[rpos]=='A' || Line[rpos]=='B') 
	    {
	      rExtpos=Line.find_first_of("ABCDE",rpos+1);
	      if (rExtpos==rpos+1)  //can't have +- etc...
		throw str_make();
	    }
	  //make rpos,lpos point to length of string.
	  //Another error check (Not possible to have -^ so must be error)
	  if (lpos!=std::string::npos && pos-lpos<2) 
	    throw str_make();

	  rpos= (rpos==std::string::npos) ? last : rpos-1;
	  lpos= (lpos==std::string::npos) ? 0 : lpos+1;

	  if (lpos==1 && (Line[0]!='A' || Line[0]!='B'))
	    throw str_make();  //only +X or -X permisable at beginning.
	  else if (lpos==1)  //catch extra bit. 
	    lpos=0;
	  
	  //Start with the left side.
	  intep_box* left(0);    
	  intep_box* right(0);
	  intep_box* pp(0);

	  lpart=Line.substr(lpos,pos-lpos);
	  rpart=Line.substr(pos+1,rpos-pos);
	  left=eval_unit(lpart);
	  right=eval_unit(rpart);
	  pp=new intep_box(left,right,5-i);
	  list_items.push_back(pp);
	  vc++;
	  char tpt[3];
	  tpt[0]='V';
	  tpt[1]=static_cast<char>(vc);
	  tpt[2]=0;
	  Line.replace(lpos,1+rpos-lpos,tpt);
	  //Reset positions.
	  last=Line.length()-1;
	  pos=Line.find(mfunc);
	  if (!pos && (mfunc=='A' || mfunc=='B'))

	    pos=Line.find(mfunc,1);
	}
    }
  if (!pp)  //have a (-value) group
    pp=eval_unit(Line);
  return pp;
}        


int
intep::grpString(const string& Unit) const
  /* Helper function for the situation to calculating 
     [grpnumber] or ,grpnumb) 
  */
{
  if (Unit.size()<1)
    throw str_make();
  int grpN(0);
  unsigned int i(0);
  while(isdigit(Unit[i]) && i<Unit.size())
    {
      grpN*=10;
      grpN+=static_cast<int>(Unit[i]-'0');
      i++;
    }
  if (Unit.size()!=i ||
      grpN<1 || grpN>tg)
    throw str_make();
  return grpN;
}

int 
intep::makeList(const char* ss)
  /* Attempt to deconvolute ss into objects. */
{
  char S[512];
  if (!ss) 
    return 1;                  //string doesn't exists
  int s_len=strlen(ss);
  if (s_len>255)   //error since we only can call 255 char. 
    return 3;
  strcpy(S+1,ss);  //quick copy to avoid constant change 
  int len=prep_string(S+1,strlen(S+1));  //Make presentable
  if (len<1)
    return 2;  //No real a string to process.
  S[0]='(';           //Termination brackets
  S[len+1]=')';        
  S[len+2]=0;  //plus termination
  len+=2;

  int lbrack(0),rbrack(0); //count brackets.
  for(int i=0;i<len;i++)
    if (S[i]=='(')
      lbrack++;
    else if (S[i]==')')
      rbrack++;
  if (lbrack!=rbrack) 
    return 4;

  string FullLine(S);
  //First remove functions that contain ,
  std::string::size_type rpos;
  std::string::size_type lpos;
  std::string::size_type cpos;
  intep_box* tmpbox;
  int comma;

  clean_boxes();         //Start by removing everything....
  string rplstr("V?");  //replacement string; ? changed later.

  while((rpos=FullLine.find(')'))!=std::string::npos)
    {
      lpos=(FullLine.rfind('(',rpos));
      if (lpos==std::string::npos || rpos-lpos<2) //can't have () as a string.
	{
	  clean_boxes();
	  return 6;
	}
      comma=0;
      //Remove commas.
      try 
	{
	  cpos=FullLine.rfind(",",rpos);
	  if (cpos!=std::string::npos && cpos>lpos)
	    {
	      comma=grpString(FullLine.substr(cpos+1,rpos-cpos-1));
	      tmpbox=subbrack(FullLine.substr(lpos+1,cpos-lpos-1));
	    }
	  else
	    tmpbox=subbrack(FullLine.substr(lpos+1,rpos-lpos-1));

	  int neg_op(0),size(0);
	  if (lpos>3)        //can't have 2 letter function.
	    neg_op=isfunc(FullLine.substr(lpos-4,4),size);
	  else if (lpos==3)
	    neg_op=isfunc(FullLine.substr(0,3),size);
	  if (comma)  
	    {
	      if (neg_op!= -12) //comma without itpy function.
		throw str_make();
	      chain=new intep_box(tmpbox,neg_op-comma);
	      list_items.push_back(chain);
	      vc++;
	      lpos-=size;
	    }
	  else if (neg_op)  //process function
	    {
	      chain=new intep_box(tmpbox,neg_op);
	      list_items.push_back(chain);
	      vc++;
	      lpos-=size;
	    }
	  else
	    chain=tmpbox;
	  //Correct string.
	  rplstr[1]=static_cast<char>(vc);
	  FullLine.replace(lpos,1+rpos-lpos,rplstr);
	}
      catch(str_make)
	{
	  clean_boxes();
	  return 4;
	}
    }
  cnt.set_zero(con_dep);  //set variable to zero if not alread in existance
  strcpy(cnt.strng,ss);
  return 0;
}











