#include <iostream.h>
#include <iomanip.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fglobal.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"


ostream& 
operator<<(ostream& s,const Graphs& GO)
{
   if (GO.GItems)
    {
      s<<"# Graphs"<<endl;
      s<<" "<<GO.GItems<<endl;
      std::vector<GraphItem>::const_iterator gc; 
      for(gc=GO.GI.begin();gc<GO.GI.end();gc++)
	{
	  (gc)->write_gph(s);
	}
    }
  return s;
}

istream& 
operator>>(istream& s,Graphs& GO)
{
  int itcount;
  //  int sitem=GO.GItems;
  s>>itcount;
  while (!s.fail() && itcount)
    {
      itcount--;
      try
	{
	  GraphItem A(s);
	  GO.GI.push_back(A);
	  GO.GItems++;
	}
      catch(Invalid_par AA)
	{
	  return s;
	}
    }
  return s;
}

GraphItem::GraphItem() : grp(-1),colour(0),type(0),ltype(0),size(1.0)
{}

GraphItem::GraphItem(const int tp,const int gp,const int col,
                     const int line,const float width) 
{
  if (gp<=tg && gp>0)
    {
      type=(tp>0 && tp<4) ? tp : 0;
      size=(width>20.0 || width<0.1) ? 1.0 : width;
      colour= (col>=0) ? col : 1;
      grp=gp-1;
      ltype= (line!=0) ? line : 1;
    }
  else
    throw Invalid_par();
  return;
}

GraphItem::GraphItem(istream& s) 
{
  s>>grp;
  s>>colour>>type>>ltype;
  s>>size;
  if (!s || grp>=tg || grp<0 ||
      type<=0 || type>2 ||
      colour<0 ||
      ltype==0  ||
      size>20.0 || size<0.1)
    throw Invalid_par();
}

GraphItem&
GraphItem::operator=(const GraphItem& A)
{
  if (&A == this) 
    return *this;
  grp=A.grp;
  colour=A.colour;
  type=A.type;
  ltype=A.ltype;
  size=A.size;
  return *this;
}

GraphItem::GraphItem(const GraphItem& A)
{
  grp=A.grp;
  colour=A.colour;
  type=A.type;
  ltype=A.ltype;
  size=A.size;
}

void
GraphItem::write_data(ostream &s) const
{
  extern Spec_In storage_;
  extern titls about_;
  s<<"# Data "<<grp<<endl;
  s<<" 3 "<<storage_.stpnt[grp]<<" "<<endl;
  for(int i=0;i<40;i++)
    s<<about_.hd[grp][i];
  s<<endl;
  s.precision(12);
  s.setf(ios::scientific,ios::floatfield);
  for(int i=0;i<storage_.stpnt[grp];i++)
    {
     s<<storage_.storx[grp][i]<<" "
      <<storage_.story[grp][i]<<" " 
      <<storage_.store[grp][i]<<endl;
     }	
  return;
} 


int
GraphItem::isPlotted(const int A) const
{
  return (A==grp && type<3) ? 0 : 1;
}

void
GraphItem::write_gph(ostream &s) const
{
  s<<grp<<endl;
  s<<colour<<" "<<type<<" "<<ltype<<" ";
  s<<size<<endl;
  return;
}


GraphItem::~GraphItem() 
{}


Graphs::Graphs() : Draw_Method(),GItems(0)
{
}

Graphs::~Graphs() 
{}

void
Graphs::plot_col(const int grp,const int grp2,
		 const int lty,const float size)
{
  try
    {
      GraphItem A(1,grp,grp2,lty,size);
      A.type=1;
      GI.push_back(A);
      line_draw(A);
      GItems++;
    }
  catch(Invalid_par AA)
    {
      return;
    }
  
  return;
}

void
Graphs::plot_header(const int hgrp,const int col,const float size,
		    const int fnt)
{
  if (GItems)
    {
      std::vector<GraphItem>::iterator gc; 
      for(gc=GI.begin();gc<GI.end() &&
	    (gc)->type!=3;gc++);
      if (gc!=GI.end())
	{
	  (gc)->colour=0;
	  header_draw(*(gc));
	  try
	    {
	      GraphItem A(3,hgrp,col,fnt,size); 
	      *(gc)=A;
	      header_draw(A);
	      return;
	    }
	  catch(Invalid_par AA)
	    {
	      return;
	    }
	}
    }
  try
    {
      GraphItem A(3,hgrp,col,fnt,size); 
      GI.push_back(A);
      header_draw(A);
      GItems++;
    }
  catch(Invalid_par AA)
    {
      return;
    }
}


void
Graphs::plot_err(const int grp,const int grp2,
		 const int lty,const float size)
{
  try
    {
      GraphItem A(2,grp,grp2,lty,size);
      GI.push_back(A);
      error_draw(A);
      GItems++;
    }
  catch(Invalid_par AA)
    {
      return;
    }
  
  return;
}

void 
Graphs::clear_graphs()
{
  GI.clear();
  GItems=0;
  return;
}

void
Graphs::remove_graph(const int grp)
{
  if (grp>GItems || grp<0 || !GItems) return;
  if (!grp || grp==1)
    {
      GI.pop_back();
      GItems--;
      return;
    }
  GI.erase(GI.end()-grp,GI.end()+1-grp);
  GItems--;
  return;
}

int
Graphs::isPlotted(const int grp) const
  /* 
     takes a 0-tg grp and checks it against list. 
     return 1 on failure 
  */
{
  if (!GItems) return 1;
  if (grp<0 || grp>=tg) return 1;
  std::vector<GraphItem>::const_iterator gc; 
  for(gc=GI.begin();gc<GI.end();gc++)
    {
      if (!(gc)->isPlotted(grp)) return 0;
    }
  return 1;  //failed.
}

int 
Graphs::Gph_pt(const float x,const float y,int &grp,int &pt)
  /*
    Given a particular x,y, find the close point
    and grp
  */
{
  extern Spec_In storage_;
  int cgrp;
  double *X,*Y;
  double b_diff= -1;
  double diffa;
  int gp = -1;
  int cp;
  for(int i=0;i<GItems;i++)
    {
      cgrp=GI[i].grp;
      X=storage_.storx[cgrp];
      Y=storage_.story[cgrp];
      for(int j=0;j<storage_.stpnt[cgrp];j++)
	{
	  if (*X>=aval[0] && *X<=aval[1] &&
              *Y>=aval[2] && *Y<=aval[3] )
	    {
	      diffa = fabs(*X-x)+fabs(*Y-y);
	      if (diffa<b_diff || b_diff<0)
		{
		  gp=cgrp;
		  cp=j;
		  b_diff=diffa;
		}
	    }
	  X++;
	  Y++;
	}
    }
  if (gp<0) return 1;
  grp=gp;
  pt=cp;
  return 0;
}

void 
Graphs::write_datapts(ostream& s) const
{
  if (GItems)
    {
      std::vector<GraphItem>::const_iterator gc; 
      for(gc=GI.begin();gc<GI.end();gc++)
	{
	  (gc)->write_data(s);
	}
    }
  return;
}

void
Graphs::all_gph()
  /* Job is to print all graphs to current graphics screen */
{
  for(int i=0;i<GItems;i++)
    {
      switch (GI[i].type)
	{
	case 1:
	  line_draw(GI[i]);
	  break;
	case 2:
	  error_draw(GI[i]);
	  break;
	case 3:
	  header_draw(GI[i]);
	  break;
	default:
	  break;
	}
    }
  return;
}


