#include <vector>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "fglobal.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"



ostream& 
operator<<(ostream& s,const Graph_Data& GD)
{
  s<<"# Axis"<<endl;
  for(int i=0;i<4;i++)
    s<<GD.aval[i]<<" ";
  s<<endl;
  for(int i=0;i<4;i++)
    s<<GD.O_aval[i]<<" ";
  s<<endl;
  for(int i=0;i<4;i++)
    s<<GD.bord[i]<<" ";
  s<<endl;
  for(int i=0;i<4;i++)
    s<<GD.atick[i]<<" ";
  s<<endl;
  
  s<<GD.num_size[0]<<" "<<GD.num_size[1]<<endl;
  s<<GD.O_num_size[0]<<" "<<GD.O_num_size[1]<<endl;
  s<<GD.log_flag[0]<<" "<<GD.log_flag[1]<<endl;
  s<<GD.O_log_flag[0]<<" "<<GD.O_log_flag[1]<<endl;
  s<<GD.aflag[0]<<" "<<GD.aflag[1]<<endl;
  s<<GD.O_aflag[0]<<" "<<GD.O_aflag[1]<<endl;
  return s;
}


istream& 
operator>>(istream& s,Graph_Data& GD)
{
  if (!s) return s;
  for(int i=0;i<4;i++)
    s>>GD.aval[i];
  for(int i=0;i<4;i++)
    s>>GD.O_aval[i];
  for(int i=0;i<4;i++)
    s>>GD.bord[i];
  for(int i=0;i<4;i++)
    s>>GD.atick[i];
  s>>GD.num_size[0]>>GD.num_size[1];
  s>>GD.O_num_size[0]>>GD.O_num_size[1];
  s>>GD.log_flag[0]>>GD.log_flag[1];
  s>>GD.O_log_flag[0]>>GD.O_log_flag[1];
  s>>GD.aflag[0]>>GD.aflag[1];
  s>>GD.O_aflag[0]>>GD.O_aflag[1];
  return s;
}


Graph_Data::Graph_Data() : made_window(0)
{
  bord[0]=bord[2]=0.12;
  bord[1]=bord[3]=0.95;
  aval[0]=aval[2]=0.0;
  aval[1]=aval[3]=1.0;
  O_aval[0]=O_aval[2]=0.0;
  O_aval[1]=O_aval[3]=1.0;
  aflag[0]=182;
  aflag[1]=246;
  for (int i=0;i<4;i++)
    atick[i]=0;
  num_size[0]=num_size[1]=1.2;
  O_num_size[0]=O_num_size[1]=1.2;
  log_flag[0]=log_flag[1]=0;
  O_log_flag[0]=O_log_flag[1]=0;
}

Graph_Data::~Graph_Data()
{}

int 
Graph_Data::check_window() const
{
  return made_window;
}

void 
Graph_Data::getaxis(double &xmin,double &xmax,
		    double &ymin,double &ymax) const
{
  xmin=aval[0];
  xmax=aval[1];
  ymin=aval[2];
  ymax=aval[3];
  return;
}

void 
Graph_Data::getaxisO(double &xmin,double &xmax,
		    double &ymin,double &ymax) const
{
  xmin=O_aval[0];
  xmax=O_aval[1];
  ymin=O_aval[2];
  ymax=O_aval[3];
  return;
}

void 
Graph_Data::getsize(double &xsize,double &ysize) const 
{
  xsize=num_size[0];
  ysize=num_size[1];
  return;
}

void 
Graph_Data::getsizeO(double &xsize,double &ysize) const 
{
  xsize=O_num_size[0];
  ysize=O_num_size[1];
  return;
}
