#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "gaussbox.h"
#include "cmd.h"
#include "fglobal.h"

gfit::gfit() 
  : npts(0),xstr(0), ystr(0),estr(0),
    st(0),ed(0),ntrue_param(0),ndim(0),nfunk(0),
    plo(0),phi(0),chisq(0),ochisq(0),alamda(0),A(0),
    used(0),type(0),atry(0),beta(0),covar(0),alpha(0),da(0),oneda(0),
    lowset(0)
{}
  
void 
gfit::set_total(const int A)
{
  ntrue_param=A;
  return;
}

int 
gfit::init_mrqmin(double* V,int* flag)
  /* 
     starts the process of fitting 
     V is the array of variables
     flag is the ones that can be fitted.
   */

{ 
  if (covar)
    cleanup_mrqmin(1);
  covar=matrix(ntrue_param,ntrue_param);
  alpha=matrix(ntrue_param,ntrue_param);
  oneda=matrix(ntrue_param,1);

  atry=new double[ntrue_param];
  beta=new double[ntrue_param];
  da=new double[ntrue_param];
  used=new int[ntrue_param];
  A=new double[ntrue_param];

  int j=0;
  for(int i=0;i<ntrue_param;i++)
    {
      A[i]=atry[i]=V[i];
      if (flag[i])
	{
	  j++;
	  used[i]=flag[i];    //2= free 1=range + 3 == 0..1
	}
      else
	used[i]=0;            //fixed
    }

  if (j<1) return 1;       //no variables to fit.
  ndim=j;

  if (plo)
    {
      delete [] plo;
      delete [] phi;
      plo=phi=0;
    }

  lowset=0;
  try 
    {
      plo=new double[ndim];
      phi=new double[ndim];
    }
  catch (...)
    {
      cout<<"Memory allocation probs"<<endl;
      return 1;
    }
  set_limits();
  alamda=0.001;
  mrqcof(atry,alpha,beta);
  ochisq=chisq;
  return 0;
}

void 
gfit::cleanup_mrqmin(const int full)
  /*
    Job is to return the best results
     or to clean up the fitting process.
  */
{
  if (!full)
    {
      covsrt(covar,ntrue_param,used,ndim);
      l_c("Covar matrix :",1);
      char ss[256];
      int add;
      for(int j=0;j<ntrue_param;j++)
	{
	  add=0;
	  for(int i=0;i<ntrue_param;i++)
	    {
	      sprintf(ss+add," %6g",covar[j][i]);
	      add+=11;
	    }
	  ss[add]=0;
	  l_c(ss,1);
	}
      return;
    }

  if (covar)
    freematrix(covar);
  if (alpha)
    freematrix(alpha);
  if (oneda)
    freematrix(oneda);
  covar=alpha=oneda=0;
  if (atry)
    {
      delete [] atry;
      delete [] beta; 
      delete [] used; 
      delete [] type;
      delete [] da;
      delete [] A;
      A=atry=beta=da=0;
      type=used=0;     
    }
  delete [] estr;
  estr=0;
  npts=0;
  return;
}

void
gfit::set_limits()
{
  int count=0;
  for(int i=0;i<ntrue_param;i++)
    {
      if (used[i])
	{
	  switch (used[i])
	    {
	    case 1:
	    case 2:
	      if (atry[i]>=0.0)
		{
		  plo[count]= -1.0+0.7 * atry[i];
		  phi[count]= 1.0+1.3 * atry[i];
		}
	      else
		{
		  phi[count]= 1.0+0.7 * atry[i];
		  plo[count]= -1.0+1.3 * atry[i];
		}
	      count++;
	      break;
	    case 3:
	      plo[count]= 0.0;
	      phi[count]= 1.0;
	      count++;
	      break;
	    }
	}
    }
  return;
}

int
gfit::set_type(const int ng,const int *tp)
  /* Sets fitting process type either lorentz or gaussian. */
{
  if (ng<1) return 1;
  if (type)
    delete [] type;
  type=new int[ng];
  int count=0;
  for(int i=0;i<ng;i++)
    {
      if (tp[i]) count++;
      type[i]=tp[i];
    }
  if (!count) return 1;
  return 0;
}

int
gfit::setpts(const int stp,const int edp)
  /* 
     set the range of points to fit over 
   */
{
  if (stp==edp || stp<0 || edp<0) return 1;
  if (stp>edp)
    {
      st=edp;
      ed=stp;
    }
  else
    {
      st=stp;
      ed=edp;
    }
  return 0;
}

int 
gfit::setup_mrq(const int igrp,const int ogrp,const int Nt,
		     int* active,double *V,int* type)
{
  if (Nt<3) return 1;
  ntrue_param=Nt;
  if (newdat(igrp,ogrp)) return 2;   //set the new data.
  if (set_type(ng_func,type)) return 3;
  return (init_mrqmin(V,active)*4);
}

void 
gfit::do_mrq(double *V)
{
  for(int i=0;i<20;i++)
    mrqmin();
  alamda=0.0;
  mrqmin();
  for(int i=0;i<ntrue_param;i++)
    V[i]=A[i];
  return;
}

int 
gfit::newdat(const int pts,double *xpts,double *ypts,double *epts)
  /* 
     If a new group selected then copy the data into the fitting 
     code section  Note:: xstr and ystr are pointer copies!!
  */
{
  if (!xpts || !ypts || pts<1) return 1;
  out_grp= -1;
  if (pts!=npts)
    {
      npts=pts;
      delete [] estr;
      estr=new double[pts]; 
      if (!estr) error("Can't get space for gfit::newdat.estr");
    }       
  xstr=xpts;
  ystr=ypts;
  if (epts)
    for(int i=0;i<pts;i++)
      {
	estr[i]=epts[i];
	if (estr[i]<=0.0) estr[i]=1.0;
	estr[i] = 1.0/(estr[i]*estr[i]);
      }
  else
    for(int i=0;i<pts;i++)
      estr[i]=1.0;
  return 0;
}

int
gfit::newdat(const int grp,const int ogrp)
  /* 
     Assuming a gropu from xstr and ystr are given 
     Set interal gfit data input space. 
   */
{
  if (grp>=tg || grp<0) return 1;  // make throw 
  if (ogrp>=tg || ogrp<0 || ogrp==grp) return 1;  // make throw 
  extern Spec_In storage_;

  int pts = storage_.stpnt[grp];
  if (pts<10) return 1;
  if (pts!=npts)
    {
      npts=pts;
      delete [] estr;
      estr=new double[pts]; 
      if (!estr) error("Can't get space for gfit::newdat.estr");
    }       
  xstr=storage_.storx[grp];
  ystr=storage_.story[grp];
  for(int i=0;i<pts;i++)
    {
      estr[i]=storage_.store[grp][i];
      if (estr[i]<=0.0) estr[i]=1.0;
      estr[i] = 1.0/(estr[i]*estr[i]);
    }
  in_grp=grp;
  out_grp=ogrp;
  return 0;
}

void 
gfit::mrqcof(const double *AA,double **alpha,double *beta) 
{
  double ymod,dy,wt;
  
  double *dyda=new double[ntrue_param];
  for(int j=0;j<ndim;j++)
    {
      for(int k=0;k<=j;k++)
	alpha[j][k]=0.0;
      beta[j]=0.0;
    }
  chisq=0.0;
  double Tpts=1.0 * (ed-st);

  for(int i=st;i<ed;i++)
    {      
      ymod=gaulorfd(AA,i,dyda,type);   // Get y and tye array dy/da
      dy=ystr[i]-ymod;            // Get dy 
      int j(0);
      for(int l=0;l<ntrue_param;l++)
	{
	  if (used[l])
	    {
	      wt=dyda[l]*estr[i];  // Weight by error.
	      int k(0);
	      for(int m=0;m<=l;m++)  
		if (used[m]) alpha[j][k++] += wt*dyda[m];
	      beta[j] += dy*wt;
	      j++;                 
	    }
	}
      chisq +=dy*dy*estr[i];
    }
  chisq/=Tpts;
  for(int j=0;j<ndim;j++)
    {
      beta[j]/=Tpts;
      alpha[j][j]/=Tpts;
    }
  for(int j=1;j<ndim;j++)
    for(int k=0;k<j;k++)
      {
	alpha[j][k]/=Tpts;
	alpha[k][j]=alpha[j][k];
      }
  delete [] dyda;
  return;
}

void gfit::mrqmin()
  /* from 685 NR.
     x=xstr,y=ystr,sig=estr,ndata=npts,a=pb,covar=covar,
     atry=
   Note initialisation is carried out by init_mrqmin()
  */
{ 
  for(int j=0;j<ndim;j++)
    {
      for(int k=0;k<ndim;k++)
	covar[j][k]=alpha[j][k];
      covar[j][j]=alpha[j][j] * (1.0+alamda);
      oneda[j][0]=beta[j];
    }
  gaussj(covar,ndim,oneda,1);
  for(int j=0;j<ndim;j++)
    da[j]=oneda[j][0];
   
  int j,l;
  for(j=0,l=0;l<ntrue_param;l++)
    {
      if (used[l])
	{
	  atry[l]=A[l]+da[j];
	  if (used[l]==1 || used[l]==3)
	    {
	      if (atry[l]<plo[j])
		atry[l]=plo[j];
	      else if (atry[l]>phi[j])
		atry[l]=phi[j];
	    }
	  j++;
	}
    }
  mrqcof(atry,covar,da);
  if (chisq < ochisq)
    {
      alamda *= 0.1;
      ochisq=chisq;
      for(int j=0;j<ndim;j++)
	{
	  for(int k=0;k<ndim;k++)
	    alpha[j][k]=covar[j][k];
	  beta[j]=da[j];
	}
      for(int l=0;l<ntrue_param;l++)
	A[l]=atry[l];
    }
  else
    {
      alamda *= 10.0;
      chisq=ochisq;
    }
  return;
}

void 
gfit::glvalues(const int *tv,const double *V,
               const int pts,const double *X,double *Y) const
{

  const double sqrpi(1.77245385090552);
  double arg,ex,exg,exl,vr,vi,u,v;
  int flag;
  for(int j=0;j<pts;j++)
    {
      Y[j]=V[ng_lev]+V[ng_slope]*X[j];
      for(int i=0;i<ng_lev;i+=ng_opt)
	{
	  if (tv[(i / ng_opt)]==1)      //gauss fit
	    {
	      if (fabs(V[i+2])>1e-50)
		{
		  arg=(X[j]-V[i+1])/V[i+2];
		  ex=exp(-arg*arg);
		  Y[j]+= V[i]*ex;
		}
	    }
	  else if (tv[(i / ng_opt)]==2)   ///lorentz fit
	    {
	      if (fabs(V[i+2])>1e-50)
		{
		  arg=(X[j]-V[i+1])/V[i+2];
		  ex=1+(arg * arg);
		  Y[j]+= V[i]/ex;
		}
	    }
	  else if (tv[(i / ng_opt)]==3)   ///pseudo voigt
	    {
	      if (fabs(V[i+2])>1e-50)
		{
		  arg=(X[j]-V[i+1])/V[i+2];
		  exl=1.0+4.0*(arg*arg);
		  exg=exp(-fln2 * arg*arg);
		  ex=V[i+3]*exg+(1.0-V[i+3])/exl;
		  Y[j]+=V[i]*ex;
		}
	    }
	  else if (tv[(i / ng_opt)]==4)   //Real voigt
	    {
	      arg=(X[j]-V[i+1]);
	      vr=arg*sqrpi/V[i+2];
	      vi=V[i+3]/(sqrpi*V[i+2]);
	      wofz_(&vr,&vi,&u,&v,&flag);
	      ex=1.0/V[i+2]*u;
	      Y[j]+=V[i]*ex;
	    }
	}
    }
  return;
}

double 
gfit::rgvalue(const int tp,const int pt,const double *V) const
  /* 
     return the value for a given type and paramters.
  */
{
  
  double arg,ex;
  double x=xstr[pt];

  if (tp==1)
    {
      arg=(x-V[1])/V[2];
      ex=exp(-arg*arg);
      return  V[0]*ex;
    }
  else if (tp==2)
    {
      arg=(x-V[1])/V[2];
      ex=1.0+(arg * arg);
      return V[0]/ex;
    }
  return 0.0;
}

double 
gfit::gaulorfd(const double *A,const int pt,double *dyda,
	       const int *T) const
{
  double arg,ex,fac,exg,exl,vr,vi,exp2,xyang;
  double u,v;
  int flag;
  double x=xstr[pt];
  double yv=0;
  const double sqrpi(1.77245385090552);
  for(int i=0;i<ng_param-2;i+=ng_opt)  //loop over options
    {
      if (T[(i / ng_opt)]==1)   //gauss 
	{
	  arg=(x-A[i+1])/A[i+2];
	  ex=exp(-arg*arg);
	  fac=A[i]*ex*2.0*arg/A[i+2];
	  yv+= A[i]*ex;
	  dyda[i]=ex;
	  dyda[i+1]=fac;
	  dyda[i+2]=fac * arg;
	}  
      else if (T[(i / ng_opt)]==2)
	{
	  arg=(x-A[i+1])/A[i+2];
	  ex=1+(arg * arg);
	  yv+= A[i]/ex;
	  dyda[i]=1.0/ex;
	  dyda[i+1]=2.0*A[i]*arg/(ex*ex*A[i+2]);  //arg = x/h
	  dyda[i+2]= 2.0*A[i]*arg*arg/(A[i+2]* ex * ex);
	}
      else if (T[i / ng_opt]==3)
	{
	  arg=(x-A[i+1])/A[i+2];
	  exl=1.0+4.0*(arg*arg);
	  exg=exp(-fln2 * arg*arg);
	  ex=A[i+3]*exg+(1.0-A[i+3])/exl;
	  yv+=A[i]*ex;
	  fac=arg*arg/A[i+2];
	  dyda[i]=ex;
	  dyda[i+3]=A[i]*(exg-1.0/exl);

	  dyda[i+2]=A[i]*((1.0-A[i+3])*(8.0*fac/(exl*exl))+
			  A[i+3]*2.0*fln2*exg*fac);
	  dyda[i+1]=A[i]*((1.0-A[i+3])*8.0*arg/(A[i+2]*exl*exl)+
			   A[i+3]*exg*2.0*fln2*arg/A[i+2]);
	  
	}
      else if(T[i/ng_opt]==4)
	{
	  arg=(x-A[i+1]);
	  vr=arg*sqrpi/A[i+2];
	  vi=A[i+3]/(sqrpi*A[i+2]);
	  wofz_(&vr,&vi,&u,&v,&flag);
	  ex=1.0/A[i+2]*u;
	  yv+=A[i]*ex;
	  dyda[i]=ex;
	  exp2=exp(vi*vi-vr*vr);
	  xyang=2*vi*vr;
	  dyda[i+2]= -A[i]*ex/(A[i+2]*A[i+2])-
	    2.0*A[i]/(A[i+2]*A[i+2])*exp2*
	    (arg*cos(xyang)-A[i+3]*sin(xyang)/pi);
	  dyda[i+3]=A[i]/(A[i+2]*A[i+2]*pi)*
	    (2*exp2*sin(xyang));
	  dyda[i+1]= (-2.0/A[i+2])*exp2*cos(xyang);
	}
    }
  dyda[ng_lev]=1.0;
  dyda[ng_slope]=x;
  return yv+A[ng_lev]+A[ng_slope]*x;
}

void
gfit::set_spread_yout(const double *V,const int *T)
  /* To write the data into several groups 
     V == variables from the fits 
     T == type information 
  */
{
  extern Spec_In storage_;
  extern titls about_;

  int ogr=out_grp;
  if (out_grp<0 || in_grp<0 || in_grp>=tg || out_grp>=tg
      || storage_.stpnt[in_grp]<1)
    return;
  int Tp[ng_type];

  double *xpt=storage_.storx[in_grp];
  double *xv=storage_.storx[ogr];
  double *yv=storage_.story[ogr];
  double *ev=storage_.store[ogr];
  for(int i=0;i<ng_type;i++) //zero all to start
    Tp[i]=0;

  int npts=storage_.stpnt[in_grp];
  double dyda[ng_param]; //dummy variable
  for(int i=0;i<ng_type;i++)
    {
      if (T[i])
	{
	  Tp[i]=T[i];
	  for(int j=0;j<npts;j++)
	    {
	      *xv++ = xpt[j];
	      *yv++ = gaulorfd(V,j,dyda,Tp);
	      *ev=0.0;
	    }
	  storage_.stpnt[ogr]=npts;
	  strncpy(about_.hd[ogr],"PG:",3);
	  strncpy(about_.hd[ogr]+4,about_.hd[in_grp],37);
	  Tp[i]=0; //reset variable
	  ogr++;
	  if (ogr>=tg || ogr==in_grp) 
	    break;
	  xv=storage_.storx[ogr];
	  yv=storage_.story[ogr];
	  ev=storage_.store[ogr];
	}
      
    }

  return;
} 
  
void 
gfit::set_yout(const double *V)
{
  extern Spec_In storage_;
  if (out_grp<0 || out_grp>tg) return;
  double *dyda=new double[ntrue_param];
  double *yout=storage_.story[out_grp];
  double *xout=storage_.storx[out_grp];
  double *err=storage_.store[out_grp];
  for(int i=0;i<storage_.stpnt[in_grp];i++)
    {
      xout[i]=xstr[i];
      yout[i]=gaulorfd(V,i,dyda,type);
      err[i]=1.0;
    }
  storage_.stpnt[out_grp]=storage_.stpnt[in_grp];
  delete [] dyda;
  return;
}

gfit::~gfit()
{
  cleanup_mrqmin(1);
}











