#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "gaussbox.h"
#include "fortran.h"
#include "fglobal.h"
#include "cmd.h"

extern gauss gauss_box;
#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr

void
gaussfit(const char *a)
  /* this needs fixing for third char etc */
{
  extern wback hold_;
  extern Spec_In storage_;

  static double nrfit=1.0;
  static int ngh=0;
  static double rmin=0.0;
  static double rmax=100.0;
  static int in_grp=0;
  static int out_grp=0;
  char third;
  get_first_nonumb(third,hold_.is,80);  

  if (third=='D')   //display
    {
      gauss_box.display_box();
      return;
    }
  if (third=='U')      //LOAD NEW VALUES
    {
      gauss_box.load_values();
      return;
    }
  if (third=='X')
    {
      gauss_box.save_values();
      return;
    }
  if (third=='T')         // TYPES  
    {
      if (gauss_box.set_types())
	{
	  if (!gauss_box.made_box())
	    gauss_box.display_box();    //update info in box.
	}
      return;
    }
  if (third=='E')   //Do an estimate
    {
      gauss_box.outer_estimate();
      if (!gauss_box.made_box())
	gauss_box.display_box();    //update info in box.
      return;
    }

  char ss[256];
  if (third=='L')  // Change LEVEL
    {
      double level;
      int flag=cmdnumber(hold_.is,level);
      while (!flag)
	{
	  flag=2;
	  sprintf(ss,"Enter inital level offset =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,level)) return;
	}
      int cf;
      flag=(flag<2 ? cmdnumber(hold_.is,cf) : 0);
      while (!flag || cf>=ng_type || cf<0)
	{
	  flag=1;
	  sprintf(ss,"Enter fitting range (0:%d)",ng_type-1);
	  l_c(ss,0);
	  if (!cmdnumber(ss,cf)) return;
	}
      gauss_box.setlevel(level,cf);
	  if (!gauss_box.made_box())
	    gauss_box.display_box();    //update info in box.
      return;
    }

  if (third=='S')   //Full set of all the line information
    {
      if (!gauss_box.made_box())
	gauss_box.display_box();    //update info in box.

      int line;
      int tpg[ng_opt];
      double vpt[ng_opt];
      int flag=cmdnumber(hold_.is,line);
      for(int i=0;i<ng_opt && flag>i;i++)
	flag+=cmdnumber(hold_.is,vpt[i]);
      for(int i=0;i<ng_opt && flag>i+ng_opt;i++)
	flag+=cmdnumber(hold_.is,tpg[i]);
      if (!flag) 
	flag=1;
      while (flag!=0 )
	{
	  if (flag==1+2*ng_opt)
	    {
	      if (gauss_box.setline(line,vpt,tpg))
		{
		  l_c("Parameters out of specification",1);
		}
	      else
		{
		  if (!gauss_box.made_box())
		    gauss_box.display_box();
		}		  
	    }
	  else if (flag==3) 
	    {
	      int tg1=(int) vpt[0];
	      int errN;
	      if ((errN=gauss_box.setpoint(line,tg1,vpt[1])))
		{
		  if (errN==1)
		    l_c("Parameters out of specification",1);
		  else if(errN==2)
		    l_c("Parameters out of specification",1);
		}
	      else
		{
		  if (!gauss_box.made_box())
		    gauss_box.display_box();
		}		  
	      return;
	    }
	  sprintf(ss,"Enter change line (Q to exit)=>");
	  l_c(ss,0);
	  flag=cmdnumber(hold_.is,line);
	  for(int i=0;i<ng_opt && flag>i;i++)
	    flag+=cmdnumber(hold_.is,vpt[i]);
	  for(int i=0;i<ng_opt && flag>i+ng_opt;i++)
	    flag+=cmdnumber(hold_.is,tpg[i]);
	}
      return;
    }

  int grp,grp2;

  if (*a=='N') 
    {
      double tmp;
      if (!cmdnumber(hold_.is,tmp))
	nrfit= (tmp>1) ? tmp : 1;
      else
	{
	  sprintf(ss,"Enter the power of the peak reflection (>=1) =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,tmp))
	    nrfit= (tmp>1) ? tmp : 1;
	}
      return;
    }
  
  /*  if (*a=='B') 
    {
      strncpy(ss,hold_.is,80);
      grp=grp2=0;
      cmdnumber(ss,grp);
      cmdnumber(ss,grp2);
      capbarrior_(&grp,&grp2);     //this has not been properly corrected
      return;
    }
  */

  if (*a!=' ' && *a!='R' && *a!='M' 
      && *a!='P') return;

  int flag=cmdnumber(hold_.is,grp);
  flag+=cmdnumber(hold_.is,grp2);
  if (*a=='R' && flag<1)
    {
      gauss_box.repeat_gauss(in_grp,out_grp);
      return;
    }

  while (flag<1 || grp>tg || grp<1) 
    {
      flag=1;
      sprintf(ss,"Enter grp containing raw data =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  

  while (flag<2 || grp2>tg || grp2<1 || grp2==grp) 
    {
      flag=2;
      sprintf(ss,"Enter grp to place fit =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2)) return;
    }
  in_grp=grp;
  out_grp=grp2;
  if (*a=='R')
    {
      gauss_box.repeat_gauss(in_grp,out_grp);
      return;
    }

  if (*a=='P') 
    {
      peak(nrfit);
      //      peak_(&grp,&grp2,&irf);
      return;
    }
  if (*a=='M')
    {
      gauss_box.spread_out(grp,grp2);     //uses 1-40
      return;
    }

  if (*a==' ')
    {
      int ngauss;
      flag=cmdnumber(hold_.is,ngauss);
      
      while (!flag || ngauss>ng_func || ngauss<1)
	{
	  flag=1;
	  sprintf(ss,"Number of curves to fit =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,ngauss)) return;
	}
      ngh=ngauss;
      grp--;
      grp2--;
      flag=cmdnumber(hold_.is,rmin);
      flag+=cmdnumber(hold_.is,rmax);
      int rrmin,rrmax;
      double tempr;
      if (rmin>rmax)
	{	
	  SWAP(rmin,rmax); 
	}
      rrmax=xpos(rmax,storage_.storx[grp],storage_.stpnt[grp]);
      rrmin=xpos(rmin,storage_.storx[grp],storage_.stpnt[grp]);

      if (storage_.stpnt[grp]<2)
	{
	  l_c("Insufficient data in input grp",1);
	  return;
	}
      
      while(flag<2 || rrmin==rrmax)
	{
	  flag=2;
	  sprintf(ss,"Enter rmin and rmax =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,rmin) || !cmdnumber(ss,rmax)) return;
	  if (rmin>rmax)
	    { SWAP(rmin,rmax); }
	  rrmin=xpos(rmin,storage_.storx[grp],storage_.stpnt[grp]);
	  rrmax=xpos(rmax,storage_.storx[grp],storage_.stpnt[grp]);
	}

      double del=(storage_.storx[grp][rrmax]-
                  storage_.storx[grp][rrmin])/float(ngh);

      if (del<=0.0) 
	{
	  l_c("Inconsistent ordering of data  ",1);
	  return;
	}

      double level;
      flag=cmdnumber(hold_.is,level);
      if (!flag)
	level=0.0;
      else
	{
	  sprintf(ss,"Enter inital level offset =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,level)) return;
	}

      //     set up start values

      int ptsep=(rrmax-rrmin)/(ngh+1);
      double xpar[ng_param];
      for(int i=0;i<ngh;i++)
	{
	  xpar[3*i]=storage_.story[grp][rrmin+(i*ptsep)]-level;
	  xpar[3*i+1]=rmin+del*(i+0.5);
	  xpar[3*i+2]=del*0.4;
	}
      if (flag) xpar[ng_lev]=level;
      gauss_box.control_start(ngauss,grp,grp2,rmin,rmax,level,xpar);
      return;
    }
  return;
}

