 #ifndef gauss_h
#define gauss_h
#include "wshare.h"
//#include "poly2.h"

#define ng_param 22
//max of ng_func*ng_type & n_opt*ng_func 
#define ng_typefnc 25 
//Number of different function 
#define ng_func 5   
//Max number of options.
#define ng_opt 4
#define ng_type 5
//  ng_lev = ng_opt*ng_func;
#define ng_lev 20
#define ng_slope 21
// 4* ln(2)
#define fln2 2.77258872 

extern "C" void wofz_(double*,double*,double*,double*,int*);

class gfit {

 private:
  
  int npts;     //number of points in xstr,ystr etc....
  double *xstr; // made: 
  double *ystr;
  double *estr;

  int st;       //start and 
  int ed;       // end points (inclusive)
  
  int ntrue_param;   //Total possible parameters
  
  int ndim;  //number of parameters. (That can change)
  int nfunk; //number of calls to the function.
  
  double *plo;  //Array of lowest value the parameters can go
  // made: (reinit) set: (reinit)
  double *phi;  //Array of highest value the parameters can go 
  // made:(reinit) set: (reinit)

  //  double (*fkdR)(const int,double *);

  double fkd(const int,double*);
  int makefit(); 
   
 protected:

  double chisq;  //chi current
  double ochisq; //best previous attempt
  double alamda;

  double *A;      //variables
  int *used;      //number used.
  int *type;

 private:

  double *atry;
  double *beta;
  double **covar;
  double **alpha;
  double *da;
  double **oneda;

  int lowset;
  int in_grp;    //input group
  int out_grp;   //output group

  void mrqcof(const double *,double **,double *);
  void setparam(const double *);
  int set_type(const int,const int *);
  double gaulorfd(const double *,const int,double *,
		  const int*) const;
  double rgvalue(const int,const int, const double *) const;
  void set_limits();

 public:

  void rlvalues(const int *,const double *,
               const int,const double *,double *) const;

  void do_mrq(double *);
  void mrqmin();
  int init_mrqmin(double *,int *);
  int setup_mrq(const int,const int,const int,int*,double *,int *);
  void cleanup_mrqmin(const int =0);
  int setpts(const int,const int);
  void set_yout(const double *);
  void set_spread_yout(const double *,const int *);

  gfit();

  int newdat(const int,const int);    // grp-1 This adds data to the fit class
  int newdat(const int,double *,double *,double * =0); 

  void reinit(const int,const int);
  void set_total(const int);
  void glvalues(const int*,const double*,const int,
                const double*,double *) const;

  ~gfit();
};


class gauss; 

struct temp_gauss
{
  gauss* THIS;
  int count;
};


class gauss
{

 private:
    
  int ngauss;         //number of gaussians to fit.
  int gcount;         //number mapped
  int type[ng_func];        //various types each range [0-ng_type];
  
  
  Widget gbox;        //place to put outside box.
  int madebox;        //Is the box realised yet.

  static void gl_menu(Widget,XtPointer,XtPointer);   // load menu
  static void gs_menu(Widget,XtPointer,XtPointer);   // save menu
  static void gaussbutton_handler(Widget,XtPointer,XtPointer); //buttonhander
  static void gausstoggle_handler(Widget,XtPointer,XtPointer); //togglehander


  Widget wtype[ng_func];      // Widgets for for button of G/L type
  Widget c1w[ng_func];        // Widgets for the position of peak
  Widget c2w[ng_func];        // Widgets for the height of the peak
  Widget c3w[ng_func];        // Widgets for the width of the peak
  Widget c4w[ng_func];        // Widgets for the width of the peak
  Widget t1w[ng_func];        // Toggle button for fixed/variable 
  Widget t2w[ng_func];
  Widget t3w[ng_func];
  Widget t4w[ng_func];
  Widget clev;          //level text
  Widget tlev;          //level toggle
  Widget cslope;          //level text
  Widget tslope;          //level toggle

  Widget str_fnc;      // function that has the label  (used ?)
  Widget text[2];      //for the groups
  Widget limit[2];     //for the xmin and xmax values
  Widget sel_func[ng_func][ng_func];     //buttons to select

  //  temp_hold* tp_fit;
  temp_gauss tp_gauss[ng_typefnc]; 
  int flg;            //0=no wind,1=ended window,2==
  int start,end;
  int in_grp,out_grp;
  
  Position xx;
  Position yy;

  void test_fn();

  static void help_gauss(Widget,XtPointer,XtPointer);
  static void cancel_gauss(Widget,XtPointer,XtPointer);
  static void cancel_gwind(Widget,XtPointer,XtPointer);
  static void do_gauss(Widget,XtPointer,XtPointer);
  static void spread_gauss(Widget,XtPointer,XtPointer);
  static void estimate_gauss(Widget,XtPointer,XtPointer);
  static void fit_menu(Widget,XtPointer,XtPointer);
  static void spfit_menu(Widget,XtPointer,XtPointer);
  static void ogrp_entry(Widget,XtPointer,XtPointer);
  static void igrp_entry(Widget,XtPointer,XtPointer);

  void settextfield(Widget,double);
  int set_xpts(const int);
  void initialise_buttons();
  void init_types();
  char flagconvert(const int) const;  //convert flag number to F,R,U etc


  int type_used[ng_type];
  gfit Afit;


 public:

  int n_par;   //number in v and flag.
  int flag[ng_param];   //change_able flag.
  double v[ng_param];   //variables.
  double vl[ng_param];  //limits (currently at +/-10% , 30% and 30%)
  double vh[ng_param];  //higher limits 

  double xmin,xmax;  //range for fitting over
  
  void getvalues();
  void setvalues();
  int setline(const int,const double*,const int*);
  int setpoint(const int,const int,const double);
  void setlevel(const double,const int,const double=0.0,const int= -1);
  void load_values();
  void save_values();
  void nofit(const double*);

  gauss();
  virtual ~gauss();

  void make_wind();               
  int made_box() const
    { return madebox; }

  // Stuff for fitting without a window.

  void control_start(const int,const int,const int,
		     const double,const double,
                     const double,const double *);
  void repeat_gauss(const int,const int);    // in_grp= 1--40

  void spread_out(const int,const int);
  void outer_do_gauss();          //text version of do_gauss
  void execute_save() const;
  void execute_load(const char * =0);
  void outer_estimate();         //do a estimate from keycontrol

  int set_types();
  int set_types(const int*);
  void display_box() const;        //text display function

};


#endif







