#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include <map>
#include <algorithm>
#include "wshare.h"
#include "gaussbox.h"
#include "cmd.h"
#include "extract.h"
#include "fglobal.h"

extern XtAppContext  app;
extern Widget top,text_w,main_w;


int info_width(const int grp,const int npeak,
	       const double rmin,const double rmax,
               double *Hgh,double *Wid,
               double *Cent,double &level)
  /*
    Job is to calculate the peaks within a given group 
    within the range 
    Returns :: Wid = FWHM from the peak
               Hgh = Max Y value of the peak
               Cent = Central position. 
	       level = minimum values
  */
{
  extern Spec_In storage_;
  
  if (grp>tg || grp<0) 
    return 0;
  int tps=storage_.stpnt[grp];
  int stp,etp;
  double *xv=storage_.storx[grp];
  for(stp=0;stp<tps && xv[stp]<rmin;stp++);
  for(etp=stp;etp<tps && xv[etp]<rmax;etp++);
  if ((tps=etp-stp)<3)
    return 0;
  std::vector<int> lpts;
  std::vector<int> rpts;
  std::vector<double> cent;
  std::vector<int> pos_cent;
  std::vector<std::pair<double,int> > score;

  double *yv=storage_.story[grp]+stp;
  xv+=stp;
  double minV= *yv;
  double maxV= *yv++;
  int mxpt=0;
  int mnpt=0;
  for(int i=1;i<tps;yv++,i++)
    {
      if (*yv > maxV)
	{
	  mxpt=i;
	  maxV= *yv;
	}
      else if (*yv<minV)
	{
	  mnpt=i;
	  minV = *yv;
	}
    }
  const double tenpc((maxV-minV)*0.1 + minV);
  yv=storage_.story[grp]+stp;
  double btv= *yv;              //best value
  double half= 0.5*(btv+minV);  //half value for min
  int cbp = 0;
  int updir= yv[2]>yv[1];
  int start_peakrise=0;
  int rhh;
  double tsc;
  for(int i=1;i<tps-1;i++)
    {
      if (updir)
	{
	  if (yv[i]>btv)
	    {
	      cbp=i;
	      btv=yv[i];
	      half=0.5*(btv+minV);
	    }
	  else if (yv[i]<half && yv[i+1]<half && btv>tenpc)
	    {
	      rhh=i;
	      for(int j=cbp;j>start_peakrise;j--)
		if(yv[j]<half && yv[j-1]<half)
		  {
		    tsc=(btv-minV)*(xv[j]-xv[rhh]);
		    score.push_back(std::pair<double,int>
				    (tsc,(int) cent.size())); 
		    cent.push_back(btv);
                    pos_cent.push_back(cbp);
		    lpts.push_back(j);
		    rpts.push_back(rhh);
		    break;
		  }
	      updir=0;
	    }
	}
      else if (yv[i]<yv[i+1]) 
	{
	  updir=1;
	  half=0.5*(yv[i]+minV);
	  start_peakrise=i;
	  btv=yv[i+1];
	}
    }	  
  sort(score.begin(),score.end());
  int ssec;
  int i;
  for(i=0;i<(int) cent.size() && i<npeak;i++)
    {
      ssec=score[i].second;
      Wid[i]=xv[rpts[ssec]]-xv[lpts[ssec]];
      Cent[i]=(xv[rpts[ssec]]+xv[lpts[ssec]])/2.0;
      Hgh[i]=score[i].first/(xv[lpts[ssec]]-xv[rpts[ssec]]);
    }
  level=minV;
  return i;
}


void find_width()
{
  extern wback hold_;
  extern Spec_In storage_;

  int grp;
  int npeak=1;  //how many peaks to find
  char ss[256];

  int flag=0;
  if (!cmdnumber(hold_.is,grp))
    grp=0;
  
  while (grp<1 || grp>tg) 
    {
      flag=1;
      sprintf(ss,"Which group to be converted =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }
  grp--;

  if (!flag)
    cmdnumber(hold_.is,npeak);

  while (npeak<1 || npeak>40) 
    {
      sprintf(ss,"How many peak to try to find =>");
      l_c(ss,0);
      if(!cmdnumber(ss,npeak)) return;
    }
  
  int tps=storage_.stpnt[grp];
  if (tps<3)
    {
      l_c("Insufficient points in grp",1);
      return;
    }
  std::vector<int> lpts;
  std::vector<int> rpts;
  std::vector<double> cent;
  std::vector<int> pos_cent;
  std::vector<std::pair<double,int> > score;

  double *xv=storage_.storx[grp];
  double *yv=storage_.story[grp];
  double minV= *yv;
  double maxV= *yv++;
  int mxpt=0;
  int mnpt=0;
  for(int i=1;i<tps;yv++,i++)
    {
      if (*yv > maxV)
	{
	  mxpt=i;
	  maxV= *yv;
	}
      else if (*yv<minV)
	{
	  mnpt=i;
	  minV = *yv;
	}
    }
  const double tenpc((maxV-minV)*0.1 + minV);
  yv=storage_.story[grp];
  double btv= *yv;              //best value
  double half= 0.5*(btv+minV);  //half value for min
  int cbp = 0;
  int updir= yv[2]>yv[1];
  int start_peakrise=0;
  int rhh;
  double tsc;
  for(int i=1;i<tps-1;i++)
    {
      if (updir)
	{
	  if (yv[i]>btv)
	    {
	      cbp=i;
	      btv=yv[i];
	      half=0.5*(btv+minV);
	    }
	  else if (yv[i]<half && yv[i+1]<half && btv>tenpc)
	    {
	      rhh=i;
	      for(int j=cbp;j>start_peakrise;j--)
		if(yv[j]<half && yv[j-1]<half)
		  {
		    tsc=(btv-minV)*(xv[j]-xv[rhh]);
		    score.push_back(std::pair<double,int>
				    (tsc,(int) cent.size())); 
		    //		    score[]=(int) cent.size();
		    cent.push_back(btv);
                    pos_cent.push_back(cbp);
		    lpts.push_back(j);
		    rpts.push_back(rhh);
		    break;
		  }
	      updir=0;
	    }
	}
      else if (yv[i]<yv[i+1]) 
	{
	  updir=1;
	  half=0.5*(yv[i]+minV);
	  start_peakrise=i;
	  btv=yv[i+1];
	}
    }	  
  sort(score.begin(),score.end());
  sprintf(ss,"# Cent : Max pt : Pow : FWHM ");
  l_c(ss,3);
  for(int i=0;i<(int) cent.size() && i<npeak;i++)
    {
      sprintf(ss,"%14.7g %14.7g %14.7g %14.7g",
	      (xv[rpts[score[i].second]]+xv[lpts[score[i].second]])/2.0,
	      xv[pos_cent[score[i].second]],
	      cent[score[i].second],
	      xv[rpts[score[i].second]]-xv[lpts[score[i].second]]);
      l_c(ss,3);
    }

  return;
}

gauss::gauss() :
  ngauss(0),gcount(0),madebox(0),
  flg(0),start(0),end(0),in_grp(1),out_grp(2),
  xx(0),yy(0)
{ 
  type_used[0]=0;  //none
  type_used[1]=3;  //gaussian
  type_used[2]=3;  //lorentz
  type_used[3]=4;  //pseudo voigt
  type_used[4]=4;  //real voigt

  for(int i=0;i<ng_func;i++)
    type[i]=0;
  for(int i=0;i<ng_param;i++)
    flag[i]=0;
  gbox=0;
}

void 
gauss::cancel_gwind(Widget w,XtPointer client_data,XtPointer call_data)
{
  gauss *THIS=(gauss *) client_data;
  THIS->madebox=0;
  return;
}

void 
gauss::cancel_gauss(Widget w,XtPointer client_data,XtPointer call_data)
{
  gauss *THIS=(gauss *) client_data;
  //  XtVaGetValues(THIS->gbox,XmNx,THIS->xx,XmNy,THIS->yy,NULL);
  Widget shell = THIS->gbox;
  if (shell)
    {
      XtDestroyWidget(shell);
    }
  
}

void 
gauss::make_wind()
{
    
  /*  for all of this see example pg 223 of book A */
   

  static ActionAreaItem gact[]={
    {"Fit", do_gauss,  (XtPointer) this, 1},
    {"Estimate", estimate_gauss, (XtPointer) this, 1},
    {"Spread", spread_gauss, (XtPointer) this, 1},
    {"Quit", cancel_gauss, (XtPointer) this, 1},
    {"Help", do_gauss,  (XtPointer) this, 1},
  };

  if (madebox)
    {
      XtPopup(gbox,XtGrabNone);
      return;
    }  

  gbox=
    XtVaCreatePopupShell("GaussBox",
			 topLevelShellWidgetClass,main_w,
			 XtNtitle, "Gauss Fit Parameters",
			 XmNdeleteResponse,XmDESTROY,
			 NULL);
    
  Widget mwind = 
    XtVaCreateManagedWidget("GaussInner",
			    xmMainWindowWidgetClass,gbox,
			    XtNtitle, "Gauss Fit Parameter",
			    NULL);

  men_item Load_menu[] = {
    { "Load fit", &xmPushButtonGadgetClass, 'L', 0,0,
      gl_menu, (XtPointer) this,  (men_item*) 0 },
    { "Save fit", &xmPushButtonGadgetClass, 'S', 0,0,
      gs_menu, (XtPointer) this, (men_item*) 0 },
    { "Hardcopy", &xmPushButtonGadgetClass, 'H', 0,0,
      change_graphics, (XtPointer) this, (men_item*) 0 },
    {0,}
  }; 
 

  Widget menu_bar=XmCreateMenuBar(mwind,"menubar",NULL,0);
  BuildPulldownMenu(menu_bar,"File",'F',0,Load_menu,0);
  XtManageChild(menu_bar);
  Widget rowtwo=
    XtVaCreateWidget("aform",xmFormWidgetClass,mwind,
		     NULL);                           
  
  XmString fstr[9];
  fstr[0]=XmStringCreateLocalized(" Type ");
  Widget strw[9];
  
  char sn[6]="name0";
  strw[0]=XtVaCreateManagedWidget(sn,xmLabelWidgetClass,rowtwo,
				  XmNlabelString, fstr[0],  
				  XmNmarginHeight,(Dimension) 1,
				  XmNtopAttachment,XmATTACH_FORM,
				  XmNleftAttachment,XmATTACH_FORM,
				  NULL);
  XmStringFree(fstr[0]);
  sn[5]++;
  
  
  sn[5]='0';
  char sp[]="Gaussian 0 ";
  //  XmString null_string=XmStringCreateLocalized("test");
  ngauss=0;
  
  for(int ii=0;ii<ng_typefnc;ii++)  //extra for flag decisions..
    {
      tp_gauss[ii].THIS=this;
      tp_gauss[ii].count=ii;
    }
  
  men_item gauss_decide[]= {
    { "None",&xmPushButtonGadgetClass, 'N', NULL, NULL,
      gaussbutton_handler, (XtPointer) (tp_gauss), (men_item*) NULL },
    { "Gaussian",&xmPushButtonGadgetClass, 'G', NULL, NULL,
      gaussbutton_handler, (XtPointer) (tp_gauss+1), (men_item*) NULL },
    { "Lorentzian",&xmPushButtonGadgetClass, 'L', NULL, NULL,
      gaussbutton_handler, (XtPointer) (tp_gauss+2), (men_item*) NULL },
    { "Psuedo Voigt",&xmPushButtonGadgetClass, 'P', NULL, NULL,
      gaussbutton_handler, (XtPointer) (tp_gauss+3), (men_item*) NULL },
    { "Voigt",&xmPushButtonGadgetClass, 'V', NULL, NULL,
      gaussbutton_handler, (XtPointer) (tp_gauss+4), (men_item*) NULL },
    {0,}
  };
  
  for(int i=0;i<ng_func;i++)
    {
      gauss_decide[0].callback_data=(XtPointer) (tp_gauss+ng_type*i);
      gauss_decide[1].callback_data=(XtPointer) (tp_gauss+1+ng_type*i);
      gauss_decide[2].callback_data=(XtPointer) (tp_gauss+2+ng_type*i);
      gauss_decide[3].callback_data=(XtPointer) (tp_gauss+3+ng_type*i);
      gauss_decide[4].callback_data=(XtPointer) (tp_gauss+4+ng_type*i);
      sp[9]++;
      sp[10]=' ';     //First layer
      if (!i)
	{
	  wtype[i]=BuildOptionMenu(rowtwo,"",'G',0,gauss_decide,sel_func[0]);
	  XtVaSetValues(wtype[i],XmNdefaultButtonShadowThickness, 1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,strw[0],
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	  
	  XtManageChild(wtype[i]);
	  sp[10]='b';    //first layer
	  c1w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNvalue, "1.0",
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,wtype[i],
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='c';       // first layer
	  c2w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c1w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='d';     // first layer
	  c3w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c2w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  c4w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c3w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='e';     //first layer
	  t1w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c4w[i],
				    XmNset,True,
	 //				    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    XmNfillOnSelect,True,
				    NULL);
	  sp[10]='f';      //first layer 
	  t2w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t1w[i],
	       //		    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNset,True,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);
	  sp[10]='g';         //first layer
	  t3w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t2w[i],
				    XmNset,True,
		    //		    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);
	  t4w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t3w[i],
				    XmNrightAttachment,XmATTACH_FORM,
				    XmNset,True,
		    //		    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);


	}
      else if (i!=ng_func)
	{
	  wtype[i]=BuildOptionMenu(rowtwo,"",'G',0,gauss_decide,sel_func[i]);
	  XtVaSetValues(wtype[i],XmNdefaultButtonShadowThickness, 1,
			XmNdefaultButtonShadowThickness, 1,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,wtype[i-1],
			XmNleftAttachment,XmATTACH_FORM,
			NULL);

	  XtManageChild(wtype[i]);

	  sp[10]='b';  // middle of form
	  c1w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNvalue, "1.0",
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,wtype[i],
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='c';   //middle of form
	  c2w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c1w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='d';    //middle of form 
	  c3w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c2w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  c4w[i]=
	    XtVaCreateManagedWidget(sp,xmTextFieldWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c3w[i],
				    XmNvalue, "1.0",
				    XmNmarginHeight,(Dimension) 0,
				    XmNcolumns,10,
				    NULL);
	  sp[10]='e';    //middle of form
	  t1w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,c4w[i],
   //				    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNset,True,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);
	  sp[10]='f';      //middle of form
	  t2w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t1w[i],
				    XmNset,True,
 //				    XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);
	  sp[10]='g';        //middle of form
	  t3w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t2w[i],
				    XmNset,True,
				    // XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);
	  t4w[i]=
	    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,rowtwo,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,wtype[i],
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,t3w[i],
				    XmNrightAttachment,XmATTACH_FORM,
				    XmNset,True,
				    // XmNindicatorOn,XmINDICATOR_NONE,
				    XmNmarginWidth,(Dimension) 0,
				    XmNmarginHeight,(Dimension) 0,
				    NULL);

	}
      XtAddCallback(t1w[i],XmNvalueChangedCallback,
		    gausstoggle_handler,&tp_gauss[ng_opt*i]);
      XtAddCallback(t2w[i],XmNvalueChangedCallback,
		    gausstoggle_handler,&tp_gauss[ng_opt*i+1]);
      XtAddCallback(t3w[i],XmNvalueChangedCallback,
		    gausstoggle_handler,&tp_gauss[ng_opt*i+2]);
      XtAddCallback(t4w[i],XmNvalueChangedCallback,
		    gausstoggle_handler,&tp_gauss[ng_opt*i+3]);
    }
  Widget *attch[9]={&wtype[0],&c1w[0],&c2w[0],&c3w[0],&c4w[0],&t1w[0],
                    &t2w[0],&t3w[0],&t4w[0]};

  fstr[1]=XmStringCreateLocalized(" C1 ");
  fstr[2]=XmStringCreateLocalized(" C2 ");
  fstr[3]=XmStringCreateLocalized(" C3 ");
  fstr[4]=XmStringCreateLocalized(" C4 ");
  fstr[5]=XmStringCreateLocalized(" Lock1 ");
  fstr[6]=XmStringCreateLocalized(" Lock2 ");
  fstr[7]=XmStringCreateLocalized(" Lock3 ");
  fstr[8]=XmStringCreateLocalized(" Lock4 ");
  
  
  sn[5]++;
  
   
  for(int i=1;i<9;i++)
    {
      if(i!=8)
	{
	  	  strw[i]=XtVaCreateManagedWidget(sn,xmLabelWidgetClass,rowtwo,
		  XmNlabelString, fstr[i],  
		  XmNmarginHeight,(Dimension) 1,
		  XmNtopAttachment,XmATTACH_FORM,
		  XmNleftAttachment,XmATTACH_WIDGET,
		  XmNleftWidget,*attch[i-1],
		  NULL);
	}
      else
	{
	    strw[i]=XtVaCreateManagedWidget(sn,xmLabelWidgetClass,rowtwo,
	    XmNlabelString, fstr[i],  
	    XmNmarginHeight,(Dimension) 1,
	    XmNtopAttachment,XmATTACH_FORM,
	    XmNleftAttachment,XmATTACH_WIDGET,
	    XmNleftWidget,strw[i-1],
	    XmNrightAttachment,XmATTACH_FORM,
	    NULL);
	}
      XmStringFree(fstr[i]);
    }

  Widget
    row_level=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,3,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
			      NULL); 
  XmString str;
  
  str=XmStringCreateLocalized("Level :");
  Widget label_lev=
    XtVaCreateManagedWidget("levnam",xmLabelWidgetClass,row_level,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 
  clev=
    XtVaCreateManagedWidget("clevel",xmTextFieldWidgetClass,row_level,
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,wtype[4],
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,label_lev,
			    XmNvalue, "0.0",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,10,
			    NULL);

  tlev=
    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,row_level,
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,wtype[4],
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,clev,
			    //   XmNindicatorOn,XmINDICATOR_NONE,
			    XmNset,True,
			    XmNmarginWidth,(Dimension) 0,
			    XmNmarginHeight,(Dimension) 0,
			    NULL);
 
  str=XmStringCreateLocalized("Slope :");
  Widget label_slope=
    XtVaCreateManagedWidget("levnam",xmLabelWidgetClass,row_level,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 
  cslope=
    XtVaCreateManagedWidget("cslope",xmTextFieldWidgetClass,row_level,
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,wtype[4],
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,label_slope,
			    XmNvalue, "0.0",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,10,
			    NULL);

  tslope=
    XtVaCreateManagedWidget("Ctrl",xmToggleButtonWidgetClass,row_level,
			    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			    XmNtopWidget,wtype[4],
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,cslope,
			    //   XmNindicatorOn,XmINDICATOR_NONE,
			    XmNset,True,
			    XmNmarginWidth,(Dimension) 0,
			    XmNmarginHeight,(Dimension) 0,
			    NULL);
 
  XtManageChild(row_level);
  XtVaSetValues(row_level,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wtype[ng_func-1],
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);

  XtAddCallback(tlev,XmNvalueChangedCallback,
		gausstoggle_handler,&tp_gauss[ng_lev]);

  XtAddCallback(tslope,XmNvalueChangedCallback,
		gausstoggle_handler,&tp_gauss[ng_slope]);
  
  Widget 
    row_lim=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,4,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
			      NULL); 
                                 
  str=XmStringCreateLocalized("Start Pt:");
  Widget label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,row_lim,
				       XmNlabelString, str,  
				       XmNmarginHeight,(Dimension) 0,    
				       NULL);
  XmStringFree(str); 
  
  limit[0]=
    XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,row_lim,
			    XmNvalue, "1",
			    XmNmaxLength,8,
			    XmNcolumns,8,
			    XmNmarginHeight,(Dimension) 0,
			    NULL);     
  
  str=XmStringCreateLocalized("End Pt:");
  label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,row_lim,
				XmNlabelString, str,  
				XmNmarginHeight,(Dimension) 0,    
				NULL);
  XmStringFree(str); 
  limit[1]=
    XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,row_lim,
			    XmNvalue, "1",
			    XmNmaxLength,8,
			    XmNcolumns,8,
			    XmNvalue, "10",
			    XmNmarginHeight,(Dimension) 0,
			    NULL);
  XtManageChild(row_lim);
  XtVaSetValues(row_lim,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,row_level,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);



  // Input Output groups : 

  Widget 
    rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,4,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
                              NULL);
                                
      str=XmStringCreateLocalized("Input Grp:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
				    XmNmarginHeight,(Dimension) 0,    
				    NULL);
      XmStringFree(str);   
      text[0]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "0",
				XmNmaxLength,3,
				XmNcolumns,3,
				XmNmarginHeight,(Dimension) 0,
				NULL);     

      str=XmStringCreateLocalized("Output Grp:");
      label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				    XmNlabelString, str,  
                                    XmNmarginHeight,(Dimension) 0,    
                                    NULL);
      XmStringFree(str); 
                                 
      text[1]=
	XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				XmNvalue, "1",
				XmNmaxLength,3,
				XmNcolumns,3,
				XmNvalue, "0",
				XmNmarginHeight,(Dimension) 0,
				NULL);

           
      XtVaSetValues(rowcol,
		    XmNtopAttachment,XmATTACH_WIDGET,
		    XmNtopWidget,row_lim,
		    XmNleftAttachment,XmATTACH_FORM,
		    XmNrightAttachment,XmATTACH_FORM,
		    NULL);

      XtAddCallback(text[0],XmNactivateCallback,igrp_entry,
		    (XtPointer) this);
      XtAddCallback(text[1],XmNactivateCallback,ogrp_entry,
		    (XtPointer) this);

          
      XtManageChild(rowcol);
      
      


  Widget pane =
    XtVaCreateWidget("paneG",xmPanedWindowWidgetClass,rowtwo,
		     XmNsashWidth,1,
		     XmNsashHeight,1,
		     NULL);
  


  CreateActionArea(pane,gact,5);
  XtVaSetValues(pane,XmNbottomAttachment,XmATTACH_FORM,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,rowcol,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
  
  
  XtManageChild(pane);
  XtManageChild(rowtwo);
  
  
  XmMainWindowSetAreas(mwind,menu_bar,NULL,NULL,NULL,
		       rowtwo);
  XtManageChild(mwind);
  
  XtAddCallback(gbox,XmNdestroyCallback,cancel_gwind,
		(XtPointer) this);

  if (xx && yy)
    XtVaSetValues(gbox,XmNx,xx,XmNy,yy,NULL);
  madebox=1;
  XtPopup(gbox,XtGrabNone);
  init_types();       
  initialise_buttons();
  setvalues();
  
  return;
}

void
gauss::control_start(const int ngs,const int igrp,const int ogrp,
                     const double rmin,const double rmax,
                     const double level,const double *xpar)
  /* this function replicates the old gg and g options so called if
     only gaussians are to be fitted */
{
  in_grp=igrp+1;
  out_grp=ogrp+1;
  xmin=rmin;
  xmax=rmax;
  v[ng_lev]=level;
  ngauss=ngs;
  int ct;
  for(int i=0;i<ngauss*3 && i<ng_func*3;i++)
    {
      ct= (i/3) * ng_opt + i % 3;
      v[ct]=xpar[i];
      flag[ct]=1;
    }
  int j;
  for(j=0;j<ngauss && j<ng_func;j++)
    type[j]=1;
  for(;j<ng_func;j++)
    type[j]=0;
  if (madebox)
    setvalues();
  
  outer_do_gauss();
  display_box();
  return;
}

void
gauss::nofit(const double *maskV)
  /* calc the fit in the case of no actual fit required 
   */
{

  extern Spec_In storage_;
  
  int pts=storage_.stpnt[in_grp-1];
  if (out_grp>tg || out_grp<1 || pts<1) return;

  if (maskV)
    Afit.glvalues(type,maskV,pts,storage_.storx[in_grp-1],
		  storage_.story[out_grp-1]);
  else
    Afit.glvalues(type,v,pts,storage_.storx[in_grp-1],
		  storage_.story[out_grp-1]);
    
  for(int i=0;i<pts;i++)
    {
      storage_.storx[out_grp-1]=storage_.storx[in_grp-1];
      storage_.store[out_grp-1][i]=0.0;
    }
  storage_.stpnt[out_grp-1]=pts;
  return;
}
  
void 
gauss::repeat_gauss(const int igrp,const int ogrp)    
{
  if (madebox)
    setvalues();
  in_grp=igrp;
  out_grp=ogrp;
  outer_do_gauss();
  display_box();
  return;
}

char 
gauss::flagconvert(const int A) const
{
  if (A<ng_param)
    {
      switch (flag[A])
	{
	case 0:
	  return 'F';
	case 1:
	  return 'R';
	case 2:
	  return 'U';
	case 3:
	  return 'O';
	default:
	  return '?';
	}
    }
  return '?';
}

  
void
gauss::display_box() const
{
  char ss[255];
  char st[30];
  l_c("               Gaussian Fits",1);
  l_c("               -------------",1);
  int adpt;
  for(int i=0;i<ng_func;i++)
    {
      adpt=2;
      if (type[i]==0) ss[0]='N';
      if (type[i]==1) ss[0]='G';
      if (type[i]==2) ss[0]='L';
      if (type[i]==3) ss[0]='P';
      if (type[i]==4) ss[0]='V';
      ss[1]=':';
      char cv[ng_opt];
      for(int k=0;k<ng_opt;k++)
	cv[k]=flagconvert(ng_opt*i+k);
      for(int k=0;k<ng_opt;k++)
	{
	  sprintf(st,"%14.7f ",v[ng_opt*i+k]);
	  strcpy(ss+adpt,st);
	  adpt+=strlen(st);
	}
      for(int k=0;k<ng_opt;k++)
	{
	  sprintf(ss+adpt," %c",cv[k]);
	  adpt+=2;
	}
      //      sprintf(ss+adpt,"\n");
      l_c(ss,3);
    }

  sprintf(ss,"Level : %14.7f %c",v[ng_lev],flagconvert(ng_lev));
  l_c(ss,3);
  sprintf(ss,"Slope : %14.7f %c",v[ng_slope],flagconvert(ng_slope));
  l_c(ss,3);
  sprintf(ss,"Range : %14.7f :: %14.7f",xmin,xmax);
  l_c(ss,3);
  sprintf(ss,"In grp : %d :: Out grp : %d ",in_grp,out_grp);
  l_c(ss,3);
  return;
}
  
      
void
gauss::initialise_buttons()
  /* Job is to set the button colours using the routine
     gausstoggle_handler()   NOT GENERAL */
{
  temp_gauss pass;
  pass.THIS= this;
  for(int i=0;i<ng_func;i++)
    {
      pass.count= ng_opt*i;
      flag[ng_opt*i]--;
      flag[ng_opt*i+1]--;
      flag[ng_opt*i+2]--;
      flag[ng_opt*i+3]--;
      gausstoggle_handler(t1w[i],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t2w[i],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t3w[i],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t4w[i],(XtPointer) &pass,(XtPointer) 0);
    }
  pass.count++;
  flag[ng_lev]--;
  gausstoggle_handler(tlev,(XtPointer) &pass,(XtPointer) 0);

  pass.count++;
  flag[ng_slope]--;
  gausstoggle_handler(tslope,(XtPointer) &pass,(XtPointer) 0);
}

void 
gauss::igrp_entry(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle changing the fitting of the gauss/none/lorentz*/
{
  extern Spec_In storage_;
  
  gauss* THIS= (gauss*) client_data;
  THIS->getvalues();
  int grp=THIS->in_grp-1;
  if (THIS->xmin==THIS->xmax &&
      storage_.stpnt[grp]>0)
    {
      THIS->xmin=storage_.storx[grp][0];
      THIS->xmax=storage_.storx[grp][storage_.stpnt[grp]-1];
      double temp;
      if (THIS->xmin>THIS->xmax)
	{
	  temp=THIS->xmin;
	  THIS->xmin=THIS->xmax;
	  THIS->xmax=temp;
	}
    }

  THIS->setvalues();
  return;
}

void 
gauss::ogrp_entry(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle changing the fitting of the gauss/none/lorentz*/
{
  gauss* THIS= (gauss*) client_data;
  THIS->getvalues();
  THIS->setvalues();
  return;
}


void 
gauss::gaussbutton_handler(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle changing the fitting of the gauss/none/lorentz*/
{
  gauss* THIS= ((temp_gauss*) client_data)->THIS;
  int val = ((temp_gauss*) client_data)->count;
  int index = val / ng_type;
  int type = val % ng_type;
  if (THIS->type[index] && !type)
    THIS->ngauss--;
  else if (!THIS->type[index] && type)
    THIS->ngauss++;
  THIS->type[index]=type;
  return;
}

void 
gauss::gausstoggle_handler(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle changing in toggling of control */
{
  gauss* THIS= ((temp_gauss*) client_data)->THIS;
  int val = ((temp_gauss*) client_data)->count;
  
  int styp= (THIS->type[val/ng_opt]==3 && !((val+1)%ng_opt) ) ? 4 : 3;
  THIS->flag[val]= (THIS->flag[val]+1) % styp;   //this is colour number
  XColor colour;
  colour.flags = DoRed | DoGreen | DoBlue;
  Colormap cmap=DefaultColormapOfScreen(XtScreen(top));
  XAllocColor(XtDisplay(top),cmap, &colour);
   
  if (!THIS->flag[val])           // Fixed (hence green)
    {

      colour.red=00000;
      colour.green = 50000;
      colour.blue = 00000;
      if (!XAllocColor(XtDisplay(top),cmap,&colour))
	cout<<"Can't allocate color here!"<<endl;
      
      XtVaSetValues(w,
		    XmNfillOnSelect,True,
		    XmNindicatorSize,10,
		    XmNset,True,
		    NULL);
      XmChangeColor(w,colour.pixel);
    }
  else if(THIS->flag[val]==1)       // Variable to 10% (hence blue) 
    {
      colour.red=00000;
      colour.green = 00000;
      colour.blue = 50000;
      if (!XAllocColor(XtDisplay(top),cmap,&colour))
	cout<<"Can't allocate color here!"<<endl;

      XtVaSetValues(w,
                      XmNfillOnSelect,True,
		      XmNset,True,
		      NULL);
      XmChangeColor(w,colour.pixel);
    }
  else if (THIS->flag[val]==2)            //free hence red
    {
      colour.red= 50000;
      colour.green = 00000;
      colour.blue = 00000;
      if (!XAllocColor(XtDisplay(top),cmap,&colour))
	cout<<"Can't allocate color here!"<<endl;

      XtVaSetValues(w, //XmNindicatorOn,XmINDICATOR_NONE,
                      XmNfillOnSelect,True,
		      XmNset,True,
		      NULL);
      XmChangeColor(w,colour.pixel);
    }
  else           //free hence red
    {
      colour.red= 50000;
      colour.green = 50000;
      colour.blue = 20000;
      if (!XAllocColor(XtDisplay(top),cmap,&colour))
	cout<<"Can't allocate color here!"<<endl;

      XtVaSetValues(w, //XmNindicatorOn,XmINDICATOR_NONE,
                      XmNfillOnSelect,True,
		      XmNset,True,
		      NULL);
      XmChangeColor(w,colour.pixel);
    }
  return;
}

void
gauss::spread_out(const int igrp,const int ogrp)
{
  if (igrp>0 && igrp<tg &&
      ogrp>0 && ogrp<tg && ogrp != igrp)
    {
      in_grp= igrp-1;
      out_grp= ogrp-1;
    }
  
  if (madebox)
    {
      getvalues();
      setvalues();
    }
  Afit.newdat(in_grp,out_grp);
  Afit.set_spread_yout(v,type);
  
}

void
gauss::outer_estimate()
  /*
    Does the same as estimate_gauss, but this time uses key input
   */
{
  extern Spec_In storage_;
  if (madebox)
    getvalues();
  int grp=in_grp-1;
  if (grp>=0 && grp<tg) 
    {
      int npts=storage_.stpnt[grp];
      if (npts<1) 
	return;
      double gxmin=storage_.storx[grp][0];
      double gxmax=storage_.storx[grp][npts-1];
      double rmax=(xmax > gxmax) ? gxmax : xmax ;
      double rmin=(xmin < gxmin) ? gxmin : xmin ;
      if (rmax<rmin)
	{
	  l_c("Range selected does not match the data set",1);
	  return;
	}

      double step=(rmax-rmin)/(ngauss+1);
      double W[ng_func],H[ng_func],C[ng_func];
      double level;
      int nstart=info_width(grp,ngauss,rmin,rmax,H,W,C,level);
      v[ng_slope]=0.0;
      if (nstart && flag[ng_lev])      
	v[ng_lev]=level;
      else if (flag)
	{
	  v[ng_lev]=0.0;
	}
      else if (!nstart)
	H[0]=1.0;
      
      if (nstart<1)
	l_c("No estimate -- Unable to find any sensible peaks",1);

      int ct=0;
      for(int i=0;i<ng_func;i++)
	{
	  if (type[i])  //gaussian 
	    {
              if (nstart>0)
		{
		  v[ng_opt*i]=W[ct]*H[ct]*1.064467919;
		  v[ng_opt*i+1]=C[ct];
		  v[ng_opt*i+2]=W[ct];
		  ct++;
		  nstart--;
		}
	      else
		{
		  v[ng_opt*i]=H[0];
		  v[ng_opt*i+1]=rmin+(i+1)*step;
		  v[ng_opt*i+2]=1.0/step;
		}
	    }
	  else if (type[i]==2)  //lorentz
	    {
	      if (nstart>0)
		{
		  v[ng_opt*i]=W[ct]*H[ct]*1.570796327;
		  v[ng_opt*i+1]=C[ct];
		  v[ng_opt*i+2]=W[ct];  //fwhm
		  ct++;
		  nstart--;
		}
	      else
		{
		  v[ng_opt*i]=C[0];
		  v[ng_opt*i+1]=rmin+(i+1)*step;
		  v[ng_opt*i+2]=1.0/step;
		}
	    }
	  else if (type[i]==3)  //psuedo voigt.
	    {
	      if (nstart>0)
		{
		  v[ng_opt*i+1]=C[ct];  //centre
		  v[ng_opt*i+2]=W[ct]/2.0;  
		  //voigt == sqrt(ln2) =x at hwhm *2/sqrt(pi)
		  v[ng_opt*i]=H[ct];
		  v[ng_opt*i+3]=0.5;
		  ct++;
		  nstart--;
		}
	    }
	  else if (type[i]==4)
	    {
	      if (nstart>0)
		{
		  v[ng_opt*i+1]=C[ct];  //centre
		  v[ng_opt*i+2]=1.064467*W[ct];  
		  //voigt == sqrt(ln2) =x at hwhm *2/sqrt(pi)
		  v[ng_opt*i]=H[ct]*v[ng_opt*i+2];
		  v[ng_opt*i+3]=0.4697*v[ng_opt*i];
		  ct++;
		  nstart--;
		}
	    }
	}
    }
  if (madebox)
    setvalues();
  return;
}


void 
gauss::estimate_gauss(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle changing the fitting of the gauss/none/lorentz*/
{
  gauss* THIS= (gauss*) client_data;
  THIS->outer_estimate();
  return;
}

void 
gauss::spread_gauss(Widget w,XtPointer client_data,XtPointer call_data)
  /* Handle putting each fit into a different block */
{
  gauss* THIS= (gauss*) client_data;
  THIS->getvalues();
  THIS->setvalues();
  THIS->Afit.newdat(THIS->in_grp-1,THIS->out_grp-1);
  THIS->Afit.set_spread_yout(THIS->v,THIS->type);
  return;
}

int
gauss::setpoint(const int lp,const int pt,const double value) 
  /* Sets a given point to the correct value 
   return values 
    lp  out of range  ==1 
     */
{
  if (lp>ng_func+1 || lp<1) return 1;
  if (pt>6 || pt<1) return 2;
  if (lp>ng_func && pt>4) return 2;  // seting of levels out of range
  int line=lp-1;
  if (line==5)   //specfically deal with  levels
    { 
      int vp=(int) value;
      if (vp>2 || vp<0) return 3;
      if (!(pt % 2))
	{
	  flag[ng_lev+pt/4]=vp;
	  if (madebox)
	    {
	      temp_gauss pass;
	      pass.THIS=this;
	      pass.count=ng_lev+pt/4;
	      flag[ng_lev+pt/4]--;
	      if (pt==4)
		gausstoggle_handler(tslope,(XtPointer) &pass,(XtPointer) 0);
	      else
		gausstoggle_handler(tlev,(XtPointer) &pass,(XtPointer) 0);		
	    }
	}
      else
	{
	  v[ng_lev+pt/3] = value;
	  if (madebox)
	    {
	      if (pt/3)
		settextfield(cslope,value);
	      else
		settextfield(clev,value);
	    }
	}
    }
  else if (pt>ng_opt)  //case for flag change
    {
      int vp=(int) value;
      if (vp>3 || vp<0) return 3;  // value out of range
      if (vp==3 && 
	  (type[line]!=3 || pt!=(2*ng_opt-1)))
	return 3;
      flag[ng_opt*line+pt-(ng_opt+1)]=vp;
      if (madebox)
	{
	  temp_gauss pass;
	  pass.THIS=this;
	  pass.count=ng_opt*line+pt-(ng_opt+1);
	  flag[ng_opt*line+pt-(ng_opt+1)]--;;
	  switch (pt)
	    {
	    case 4:
	      gausstoggle_handler(t1w[line],(XtPointer) &pass,(XtPointer) 0);
	      break;
	    case 5:
	      gausstoggle_handler(t2w[line],(XtPointer) &pass,(XtPointer) 0);
	      break;
	    case 6:
	      gausstoggle_handler(t3w[line],(XtPointer) &pass,(XtPointer) 0);
	      break;
	    case 7:
	      gausstoggle_handler(t4w[line],(XtPointer) &pass,(XtPointer) 0);
	      break;
	    }
	}
    }
  else            //find
    {
      v[ng_opt*line+pt-(ng_opt+1)]=value;
      if (madebox)
	{
	  switch (pt)
	    {
	    case 1:
	      settextfield(c1w[line],value);
	      break;
	    case 2:
	      settextfield(c2w[line],value);
	      break;
	    case 3:
	      settextfield(c3w[line],value);
	      break;
	    case 4:
	      settextfield(c4w[line],value);
	      break;
	    }
	}
    }
  return 0;
}

int
gauss::setline(const int lp,const double* vpt,const int* tpt)
  /* Sets a line of a function fit to the values given in vpt and
     the control values in tpt */
{
  if (lp>ng_func || lp<1) return 1;
  for(int cpt=0;cpt<ng_opt;cpt++)
    {
      if (tpt[cpt]<=0 || tpt[cpt]>4 ||
	  tpt[cpt]>3 && cpt!=ng_opt-1)
	return 1;
    }
  int line=lp-1;
  for(int i=0;i<ng_opt;i++)
    {
      v[ng_opt*line+i]=vpt[i];
      flag[ng_opt*line+i]=tpt[i];
    }
 
  if (madebox)
    {
      temp_gauss pass;
      pass.THIS=this;
      pass.count=ng_opt*line;
      settextfield(c1w[line],vpt[0]);
      settextfield(c2w[line],vpt[1]);
      settextfield(c3w[line],vpt[2]);
      settextfield(c4w[line],vpt[3]);
      for(int i=0;i<ng_opt;i++)
	flag[ng_opt*line+i]--;
      gausstoggle_handler(t1w[line],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t2w[line],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t3w[line],(XtPointer) &pass,(XtPointer) 0);
      pass.count++;
      gausstoggle_handler(t4w[line],(XtPointer) &pass,(XtPointer) 0);
    }
  return 0;
}

void
gauss::setlevel(const double lv,const int cf,
		const double slp,const int sf)
  /* Set level given txt input information */
{
  if (cf>2 || cf<0) return;
  v[ng_lev]=lv;
  flag[ng_lev]=cf; 
  if (sf<3 && sf>=0)
    {
      v[ng_slope]=slp;
      flag[ng_slope]=sf;
    }
  if (madebox) 
    {
      temp_gauss pass;
      pass.THIS=this; 
      pass.count= ng_lev;  
      settextfield(clev,lv);
      flag[ng_lev]--;
      gausstoggle_handler(tlev,(XtPointer) &pass,(XtPointer) 0);
      if (sf<3 && sf>=0)
	{
	  pass.count= ng_slope;  //Get slope
	  settextfield(cslope,slp);
	  flag[ng_slope]--;
	  gausstoggle_handler(tslope,(XtPointer) &pass,(XtPointer) 0);
	}	  
    }
  return;
}

void 
gauss::settextfield(Widget w,double value)
{
  char s[255];
  sprintf(s,"%20g",value);
  int k;
  for(k=0;k<250 && s[k]==' ';k++);
  XmTextPosition j=strlen(s+k);
  XmTextSetString(w,s+k);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}


void 
gauss::setvalues()
  /* initialise value for the system, NOT general!! */
{
  if (!madebox) return;
  for(int i=0;i<ng_func;i++)
    {
      settextfield(c1w[i],v[ng_opt*i]);
      settextfield(c2w[i],v[ng_opt*i+1]);
      settextfield(c3w[i],v[ng_opt*i+2]);
      settextfield(c4w[i],v[ng_opt*i+3]);
    }
  settextfield(clev,v[ng_lev]);
  settextfield(cslope,v[ng_slope]);
  settextfield(limit[0],xmin);
  settextfield(limit[1],xmax);
  settextfield(text[0],(double) in_grp);
  settextfield(text[1],(double) out_grp);
  return;
}

void 
gauss::getvalues()
  /* Reads all of the gauss widget and records the values */
{
  if (!madebox) return;
  char out[256];
  //Start with the fit and outgoing group 

  strncpy(out,XmTextFieldGetString(text[0]),255);  //strncpy to avoid overrun
  in_grp=atoi(out);
  strncpy(out,XmTextFieldGetString(text[1]),255);
  out_grp=atoi(out);
  if (in_grp<1 || in_grp>tg) 
    in_grp=1;
  if (out_grp<1 || out_grp>tg) 
    out_grp= (in_grp==tg) ? 1 : in_grp+1;
  strncpy(out,XmTextFieldGetString(limit[0]),255);
  xmin=atof(out);
  strncpy(out,XmTextFieldGetString(limit[1]),255);
  xmax=atof(out);
  double temp;
  if (xmin>xmax)
    {
      temp=xmin;
      xmin=xmax;
      xmax=temp;
    }
  
  for(int i=0;i<ng_func;i++)
    {
      strcpy(out,XmTextFieldGetString(c1w[i]));
      v[ng_opt*i]=atof(out);
      strcpy(out,XmTextFieldGetString(c2w[i]));
      v[ng_opt*i+1]=atof(out);
      strcpy(out,XmTextFieldGetString(c3w[i]));
      v[ng_opt*i+2]=atof(out);
      strcpy(out,XmTextFieldGetString(c4w[i]));
      v[ng_opt*i+3]=atof(out);
    }
  strcpy(out,XmTextFieldGetString(clev)); //level
  v[ng_lev]=atof(out);

  strcpy(out,XmTextFieldGetString(cslope)); //slope
  v[ng_slope]=atof(out);

  return;
} 

int
gauss::set_xpts(const int igrp)
  /*
    Assuming an ordered xpts find the start and end points 
    consistent with the range
  */
{
  extern Spec_In storage_;
  if (igrp>=tg || igrp<0) return 1;
  double *xpt=storage_.storx[igrp];
  for(int i=0;i<storage_.stpnt[igrp];i++)
    {
      if (*xpt>=xmin) 
	{
	  start=i;
	  break;
	}
      xpt++;
    }
  xpt=storage_.storx[igrp]+storage_.stpnt[igrp]-1;
  for(int i=storage_.stpnt[igrp]-1;i>start;i--)
    {
      if (*xpt<=xmax) 
	{
	  end=i;
	  return 0;;
	}
      xpt--;
    }
  return 1;
      
}


void
gauss::load_values()
  /* Job is to load a gaussian information file into the gauss window */
{
  extern wback hold_;
  char fname[81];
  extractfile(fname,hold_.is,80);
  execute_load(fname);
  if (madebox)
    setvalues();
  return;
}

void 
gauss::gl_menu(Widget w,XtPointer client_data,XtPointer call_data)  
  /* the Load menu item is called */
{
  gauss* THIS=(gauss*) client_data;
  THIS->execute_load();
  THIS->setvalues();        //update current values
  return;
}


void
gauss::save_values()
  /* function to handle text call to save data */
{
  if (madebox)
    {
      getvalues();
      setvalues();
    }
  execute_save();
}

void 
gauss::gs_menu(Widget w,XtPointer client_data,XtPointer call_data)  
  /* the save menu item is called */
{
  gauss* THIS=(gauss*) client_data;
  THIS->getvalues();
  THIS->setvalues();        //update current values
  THIS->execute_save();
  return;
}


void 
gauss::execute_save() const 
  /* Writes the information held about the gauss param
     to a file Now made more general to ng_opt
  */
{
  char ss[256];
  strcpy(ss,"Enter the filename for the gaussfit =>");
  l_c(ss,0);
  if (strlen(ss)<3) 
    return;
  char filename[255];
  extractfile(filename,ss,256);
  ofstream outgauss;
  outgauss.open(filename,ios::out);
  if (outgauss.fail()) 
    {
      l_c("Failed to save data",1);
      return;
    }

  outgauss.setf(ios::scientific,ios::floatfield);
  outgauss.precision(12);
  outgauss<<"# Gauss fit output"<<endl;
  for(int i=0;i<ng_func;i++)
    {
      outgauss<<type[i];
      for(int j=0;j<ng_opt;j++)
	outgauss<<" "<<v[ng_opt*i+j];
      outgauss<<endl;\
      for(int j=0;j<ng_opt;j++)
	outgauss<<" "<<flag[ng_opt*i+j];
    }
  outgauss<<v[ng_lev]<<flag[ng_lev]<<endl;
  outgauss<<v[ng_slope]<<flag[ng_slope]<<endl;
  outgauss<<xmin<<" "<<xmax<<endl;
  outgauss.close();
  return;
}

void
gauss::init_types()
  /* initiase the types when a new window is created */
{
  if (!madebox) 
    return;
  ngauss=0;
  for(int i=0;i<ng_func;i++)
    {
      if (type[i]) 
	ngauss++;
      XtVaSetValues(wtype[i],XmNmenuHistory,sel_func[i][type[i]],NULL);
    }
  return;
}

int
gauss::set_types(const int * tlist)
  /* Allows the Gauss,Lorentx etc to be set from a list */
{
  for(int i=0;i<ng_func;i++)
    {
      if (tlist[i]<ng_type && tlist>=0)
	{
	  type[i]=tlist[i];
	}
    }
  init_types();    //made box test included.
  return 0; 
}

int
gauss::set_types()
  /* 
     sets the types by line number, type (0,1,2..,ng_opt-1) 
   */
{
  extern wback hold_;

  int line,flag;
  flag=cmdnumber(hold_.is,line);

  char ss[255];
  while(!flag || line<1 || line>ng_func)
    {
      flag=2;
      sprintf(ss,"Which function to set =>");
      l_c(ss,0);
      if (!cmdnumber(ss,line,255)) return 1;
    }

  int in_type;
  if (flag!=1 || !cmdnumber(hold_.is,in_type))
    in_type= -1;
  while(in_type>=ng_type || in_type <0)
    {
      sprintf(ss,"What sort of function (0--%d) =>",ng_type-1);
      l_c(ss,0);
      if (!cmdnumber(ss,in_type,255)) return 1;
    }
  type[line-1]=in_type;
  init_types();
  return 0; 
}
  


void 
gauss::execute_load(const char *fname)  
{
  ifstream ingauss;
  if (fname)
    ingauss.open(fname,ios::in);
  char ss[256];
  if (!fname || ingauss.fail())
    {
      strcpy(ss,"Enter the filename for the gaussfit =>");
      l_c(ss,0);
      ingauss.open(ss,ios::in);
      if (ingauss.fail()) 
	{
	  l_c("Failed to find input file",1);
	  return;
	}
    }
  ingauss.getline(ss,255,'\n');
  double v_in[ng_param];
  int in_type[ng_param];
  int in_flag[ng_param];
  double in_xmin,in_xmax;
  for(int i=0;i<ng_func;i++)
    {
      ingauss>>in_type[i];
      for(int j=0;j<ng_opt;j++)
	ingauss>>v_in[ng_opt*i+j];
      for(int j=0;j<ng_opt;j++)
	ingauss>>in_flag[ng_opt*i+j];
    }

  ingauss>>v_in[ng_lev]>>in_flag[ng_lev];
  ingauss>>v_in[ng_slope]>>in_flag[ng_slope];
  ingauss>>in_xmin>>in_xmax;
  if (!ingauss)
    {
      l_c("Error with input file",1);
      return;
    }
  for(int i=0;i<ng_func;i++)
    {
      if (in_flag[i]<0 || in_flag[i]>3 ||   //flag are 0-3
	  in_type[i]<0 || in_type[i]>=ng_type)
	{
	  l_c("Problem with gauss input file",1);
	  return;
	}
      flag[i]=in_flag[i];
      type[i]=in_type[i];
    }

  for(int i=0;i<ng_param;i++)
    v[i]=v_in[i];
  if (in_xmin<in_xmax)
    {
      xmin=in_xmin;
      xmax=in_xmax;
    }
  else
    {
      xmax=in_xmin;
      xmin=in_xmax;
    }
  if(madebox)
    {
      setvalues();
      initialise_buttons();
      init_types();
    }
  return;
}



void 
gauss::outer_do_gauss()       
  /* For running gauss without a window */
{
  double maskV[ng_param];
  int vc=0;
  int Eff_flag[ng_param];
  for(int i=0;i<ng_param;i++)
    Eff_flag[i]=0;
  for(int i=0;i<ng_func;i++)
    {
      if (type[i])  //ie we will fit
	{
	  for(int j=0;j<type_used[type[i]];j++)
	    {
	      if (flag[ng_opt*i+j])
		{
		  vc++;
		  Eff_flag[ng_opt*i+j]=flag[ng_opt*i+j];
		}
	    }
	}
    }
  double *Vp = v;
  for(int i=0;i<ng_func;i++)
    {
      if (type[i]==1)   //gauss
	{
	  maskV[i*ng_opt+1]=Vp[i*ng_opt+1];
	  maskV[i*ng_opt+2]=Vp[i*ng_opt+2]/1.665109222;  //sqrt(4*ln2)
	  if (maskV[i*ng_opt+2]!=0.0)
	    maskV[i*ng_opt]=0.93943728*Vp[i*ng_opt]
	      /Vp[i*ng_opt+2];  //sqrt(4*ln(2)/pi)
	  else
	    maskV[i*ng_opt]=Vp[i*ng_opt];
	  maskV[i*ng_opt+3]=Vp[i*ng_opt+3];
	}
      else if(type[i]==2) //lorentz
	{
	  maskV[i*ng_opt+1]=Vp[i*ng_opt+1];
	  maskV[i*ng_opt+2]=Vp[i*ng_opt+2]/2.0;
	  maskV[i*ng_opt]=0.63661977*Vp[i*ng_opt]/Vp[i*ng_opt+2];
	  maskV[i*ng_opt+3]=Vp[i*ng_opt+3];
	}
      else
	for(int j=0;j<ng_opt;j++)
	  maskV[i*ng_opt+j]=Vp[i*ng_opt+j];
    }
  maskV[ng_lev]=Vp[ng_lev];
  //end of mask stuff
  
  if (flag[ng_lev])
    {
      Eff_flag[ng_lev]=flag[ng_lev];
      vc++;
    }

  if (!vc) 
    {
      l_c("Setting values (no fit to do)",1);
      nofit(maskV);
      return;
    }
  if (set_xpts(in_grp-1)) return;
  if (Afit.setpts(start,end)) return;
  int chk=Afit.setup_mrq(in_grp-1,out_grp-1,ng_param,
			       Eff_flag,maskV,type);

  if(chk==1 || chk==3) 
    l_c("Insufficient curves to fit",1);
  else if (chk==4)
    {
      l_c("Insufficient parameters to fit",1);
      Afit.set_yout(maskV);
    }
  if (chk) return;
  Afit.do_mrq(maskV);
  Afit.set_yout(maskV);
  //Replace mask...
  
  for(int i=0;i<ng_func;i++)
    {
      if (type[i]==1)   //gauss
	{
	  Vp[i*ng_opt+1]=maskV[i*ng_opt+1];
	  Vp[i*ng_opt+2]=maskV[i*ng_opt+2]*1.665109222;  //sqrt(4*ln2)
	  Vp[i*ng_opt]=maskV[i*ng_opt]*fabs(Vp[i*ng_opt+2])/0.93943728;
	  Vp[i*ng_opt+3]=maskV[i*ng_opt+3];
	}
      else if(type[i]==2) //lorentz
	{
	  Vp[i*ng_opt+1]=maskV[i*ng_opt+1];
	  Vp[i*ng_opt+2]=maskV[i*ng_opt+2]*2.0;
	  Vp[i*ng_opt]=maskV[i*ng_opt]*fabs(Vp[i*ng_opt+2])
	    /0.63661977;
	  Vp[i*ng_opt+3]=maskV[i*ng_opt+3];
	}
      else
	for(int j=0;j<ng_opt;j++)
	  Vp[i*ng_opt+j]=maskV[i*ng_opt+j];
    }
  Vp[ng_lev]=maskV[ng_lev];

  if (madebox)
    setvalues();
  Afit.cleanup_mrqmin(1);
  return;

  Afit.set_yout(v);
  Afit.cleanup_mrqmin(1);
  if (madebox)
    {
      setvalues();
    }
  return;

}

void
gauss::do_gauss(Widget w,XtPointer client_data,XtPointer call_data)
{
  double maskV[ng_param];
  gauss* THIS=(gauss*) client_data;
  THIS->getvalues();
  THIS->setvalues();
  
  int vc=0;
  int Eff_flag[ng_param];
  for(int i=0;i<ng_param;i++)
    Eff_flag[i]=0;
  for(int i=0;i<ng_func;i++)
    {
      if (THIS->type[i])
	{
	  for(int j=0;j<THIS->type_used[THIS->type[i]];j++)
	    {
	      if (THIS->flag[ng_opt*i+j])
		{
		  vc++;
		  Eff_flag[ng_opt*i+j]=THIS->flag[ng_opt*i+j];
		}
	    }
	}
    }
  //Deal with mask variables .... 
  double *Vp = THIS->v;
  for(int i=0;i<ng_func;i++)
    {
      if (THIS->type[i]==1)   //gauss
	{
	  maskV[i*ng_opt+1]=Vp[i*ng_opt+1];
	  maskV[i*ng_opt+2]=Vp[i*ng_opt+2]/1.665109222;  //sqrt(4*ln2)
	  if (maskV[i*ng_opt+2]!=0.0)
	    maskV[i*ng_opt]=0.93943728*Vp[i*ng_opt]
	      /Vp[i*ng_opt+2];  //sqrt(4*ln(2)/pi)
	  else
	    maskV[i*ng_opt]=Vp[i*ng_opt];
	  maskV[i*ng_opt+3]=Vp[i*ng_opt+3];
	}
      else if(THIS->type[i]==2) //lorentz
	{
	  maskV[i*ng_opt+1]=Vp[i*ng_opt+1];
	  maskV[i*ng_opt+2]=Vp[i*ng_opt+2]/2.0;  //sqrt(4*ln2)
	  maskV[i*ng_opt]=0.63661977*Vp[i*ng_opt]/Vp[i*ng_opt+2];
	  maskV[i*ng_opt+3]=Vp[i*ng_opt+3];
	}
      else
	for(int j=0;j<ng_opt;j++)
	  maskV[i*ng_opt+j]=Vp[i*ng_opt+j];
    }
  maskV[ng_lev]=Vp[ng_lev];
  maskV[ng_slope]=Vp[ng_slope];
  //end of mask stuff
  
  if (THIS->flag[ng_lev])
    {
      Eff_flag[ng_lev]=THIS->flag[ng_lev];
      vc++;
    }
  if (THIS->flag[ng_slope])
    {
      Eff_flag[ng_slope]=THIS->flag[ng_slope];
      vc++;
    }
  if (!vc) 
    {
      l_c("Setting values (no fit to do)",1);
      THIS->nofit(maskV);
      return;
    }
	
  if (THIS->set_xpts(THIS->in_grp-1)) return;
  if (THIS->Afit.setpts(THIS->start,THIS->end)) return;
  int chk=THIS->Afit.setup_mrq(THIS->in_grp-1,THIS->out_grp-1,ng_param,
			       Eff_flag,maskV,THIS->type);

  if(chk==1 || chk==3) 
    l_c("Insufficient curves to fit",1);
  else if (chk==4)
    {
      l_c("Insufficient parameters to fit",1);
      THIS->Afit.set_yout(maskV);
    }
  if (chk) return;
  THIS->Afit.do_mrq(maskV);
  THIS->Afit.set_yout(maskV);
  //Replace mask...
  
  for(int i=0;i<ng_func;i++)
    {
      if (THIS->type[i]==1)   //gauss
	{
	  Vp[i*ng_opt+1]=maskV[i*ng_opt+1];
	  Vp[i*ng_opt+2]=maskV[i*ng_opt+2]*1.665109222;  //sqrt(4*ln2)
	  Vp[i*ng_opt]=maskV[i*ng_opt]*fabs(Vp[i*ng_opt+2])/0.93943728;
	  Vp[i*ng_opt+3]=maskV[i*ng_opt+3];
	  //sqrt(4*ln(2)/pi)
	}
      else if(THIS->type[i]==2) //lorentz
	{
	  Vp[i*ng_opt+1]=maskV[i*ng_opt+1];
	  Vp[i*ng_opt+2]=maskV[i*ng_opt+2]*2.0;
	  Vp[i*ng_opt]=maskV[i*ng_opt]*fabs(Vp[i*ng_opt+2])
	    /0.63661977;
	  Vp[i*ng_opt+3]=maskV[i*ng_opt+3];
	}
      else
	for(int j=0;j<ng_opt;j++)
	  Vp[i*ng_opt+j]=maskV[i*ng_opt+j];
    }
  Vp[ng_lev]=maskV[ng_lev];
  Vp[ng_slope]=maskV[ng_slope];

  THIS->setvalues();
  THIS->Afit.cleanup_mrqmin(1);
  return;
}

gauss::~gauss()
{
  if (madebox)
    {
      XtDestroyWidget(gbox);
    }
} 












