#ifndef frame_h
#define frame_h
/* This defines the frame class, it is the interface class to the 
drawing package. */

int motif_pgplot();
extern "C" int motif_pgplot__();
extern "C" void frame_setax__(char *);
extern "C" void frame_keep__();
extern "C" void frame_cursor__();

class axis_param;
class Frame;
class ObjItem;
class Obox;
class Otext;
class Oline;
class Osym;
class Graphs;
class GraphItem;

/* ostream& operator<<(ostream&,const Obox&);
istream& operator>>(istream&,Obox&);
ostream& operator<<(ostream&,const Otext&);
istream& operator>>(istream&,Otext&);
*/

class Invalid_par
{
 private:  
  int value;
 public:
  Invalid_par(const int =0) : value(0) {}
};

class ObjItem
{
 protected:

  int colour;
  int abs;
  float x1,y1;  //position

 public:
  
  ObjItem();
  ObjItem(const ObjItem&);
  ObjItem(const int,const float=0.0,const float=0.0);
  virtual ~ObjItem();

  virtual void draw(const Frame *,const int =0) const=0;
  virtual int obj_type() const { return 0; } //returns type
  virtual double distance(const float,const float,
			  const float,const float) const;
  virtual int getcurrent(int &,float *) const;
  virtual float* makecurrent(int &,int&) const;
  virtual void set_pos(const Frame*,const float,const float);
  virtual void move_pos(const Frame*,const float,const float);
  virtual void reset_pos(const Frame*,const int,const float*);
  virtual void write_obj(ostream &) const=0;
  virtual void read_obj(istream &)=0;
  virtual void make_abs(const Frame*);
  virtual void make_rel(const Frame*); 
  virtual void Lcdisplay() const { return; }
  virtual int update(char*) { return 1; }
};


class Graphs : public virtual Draw_Method
{
  friend ostream& operator<<(ostream &,const Graphs &);
  friend istream& operator>>(istream &,Graphs &);

 private:

  std::vector<GraphItem> GI;
  int GItems;
  void write_gph(ostream &s) const;
  void read_gph(istream &s);

 public:

  Graphs();
  virtual ~Graphs();

  int isPlotted(const int) const;

  void clear_graphs();
  void remove_graph(const int =0);
  void all_gph();   //draw all graphs
  void plot_col(const int,const int,const int,const float);
  void plot_err(const int,const int,const int,const float);
  void plot_header(const int,const int =1,const float=1.5,const int= 2);
  int Gph_pt(const float,const float,int &,int &);
  void write_datapts(ostream& s) const;
};

class Objects : public virtual Graph_Data
{
  friend ostream& operator<<(ostream &,const Objects &);
  friend istream& operator>>(istream &,Objects &);

 private:

  std::vector<ObjItem*> OI;
  int OItem;

  int eliminate(const int,const int=1);
  int gettype(const char) const;
  char my_getchar(const int) const;
  int count_item(const int) const;
  

 public:

  Objects();
  virtual ~Objects();
  void all_obj();  //draw all objects
  void do_box(const char);
  void do_text(const char);
  void do_line(const char);
  void do_sym(const char);
  void move(const char);
  void edit_item(const char);
  int eliminate_all(const int =0);
  int item_total() const { return OItem; }
  void include_item(ObjItem *); 
  void clear_obj(const char);

  ObjItem* select(const int,const char*,const char*) const;
};


class Osym : public ObjItem 
{

 private:
  
  float Tsize;     //size 
  int item;

 public:
  
  Osym();
  Osym(const int,const int,const float);
  virtual ~Osym();
  void draw(const Frame *,const int =0) const;
  int obj_type() const { return 4; }
  void getvalues(int &,int &,float&) const;
  void write_obj(ostream &) const;
  void read_obj(istream &);
};

class Otext : public ObjItem 
{

 private:
  
  float Tsize;     //size 
  float angle;   //0 deg = horrizontal
  float format;   //left,centre right justification
  std::string str;

 public:
  
  Otext();
  Otext(const int,const float,const float,const float,const char* =0);
  virtual ~Otext();
  void draw(const Frame *,const int =0) const;
  int obj_type() const { return 2; }
  void getvalues(int &,float&,float&,float&) const;
  void write_obj(ostream &) const;
  void read_obj(istream &);
  void Lcdisplay() const;
  int update(char*);
};


class Oline : public ObjItem 
{
 private:
  
  int lstyle;
  int lsize;
  Oline* next_pt;  //if == 0 thisis the end !
  Oline* prev_pt;  //if == 0 then this is the start !
  
  void Next(Oline* C) {next_pt=C;}  //are these necessary!!!!!
  void Prev(Oline* C) {prev_pt=C;}
  void drawline(const Frame*,const float,const float) const;
  int count_line() const;
  int count_forward() const;
  int count_back() const;
  int set_array(float*) const;

 public:
  
  Oline();
  Oline(const int,const int,const int,Oline*,Oline*);
  Oline(const Oline&);
  virtual ~Oline();
  
  Oline const* get_first() const
    { return (prev_pt) ? prev_pt->get_first() : this; } 
  Oline* give_first()
    { return (prev_pt) ? prev_pt->give_first() : this; } 

  Oline* Prev() const { return prev_pt; } 
  Oline* Next() const { return next_pt; } 
  int isFirst() const { return (prev_pt) ? 1 : 0; }
  int vector_current(int&,std::vector<float>&) const;
  void vector_reset_pos(const std::vector<float>&);

  void draw(const Frame*, const int =0) const;
  void move_line(const Frame*,float,float);
  int obj_type() const { return  5; } 
  void getvalues(int &,int &,int &) const;
  int getcurrent(int &,float *) const;
  float* makecurrent(int &,int &) const;
  // void move_pos(const Frame*,const float,const float);
  void reset_pos(const Frame*,const int,const float*);
  void write_obj(ostream &) const;
  Oline* write_line(ostream &) const;

  void read_obj(istream &);

  int drawforward(const Frame*,const int =0) const;
  int drawbackward(const Frame*,const int =0) const;

  void Lcdisplay() const;
  int update(char*);
};


class Obox : public ObjItem 
{
 private:
  
  int line_style;
  int line_size;
  int fill_style;
  float x2,y2;

 public:
  
  Obox();
  Obox(const int,const int,const int,const int =2);
  virtual ~Obox();
  void make_abs(const Frame*);
  void make_rel(const Frame*);
  void draw(const Frame*, const int =0) const;
  void set_pos(const Frame*,const float,const float,const float,const float);
  int obj_type() const { return 1; }
  void getvalues(int &,int &,int &,int &) const;
  int getcurrent(int &,float *) const;
  float* makecurrent(int &,int &) const;
  void move_pos(const Frame*,const float,const float);
  void reset_pos(const Frame*,const int,const float*);
  void write_obj(ostream &) const;
  void read_obj(istream &);
  void Lcdisplay() const;
  int update(char*);
};


class Frame : public Objects , public Graphs, public axis_param
{
 private:
  
  int grpmax(const int,double&,double&,double&,double&);  //could go higher
  void give_axis() const;
  void parse_file(istream &,const int =255);

 public:


  Frame();
  ~Frame();
  int abscoord(float &x,float &y) const;
  int relcoord(float &x,float &y) const;
  void plotfn(char *);   //someone wants to plot a graph.
  void redraw(const int =0);  //draw picture (decide if printer/window)
  void setaxis(char *ans);
  void Hand_Curs(float,float,float,float,char);
  void Curs_pt(const float,const float);
  void cursor(char);
  int read(const char =' ');
  void write(const char =' ') const;
  void read_data(const int,istream &) const;
};


#endif











