#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include "cmd.h"
#include "fglobal.h"
#include "extract.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"

Frame::Frame() : Objects(),Graphs()
{}

Frame::~Frame()
{}

int
Frame::abscoord(float &x,float &y) const
  /* make the coordinates into the 0-1 axis frame */
{
  float sepx=aval[1]-aval[0];
  float sepy=aval[3]-aval[2];
  if (!sepx || !sepy) return 1;
  x=(x-aval[0])/sepx;
  y=(y-aval[2])/sepy;
  return 0;
}

int
Frame::relcoord(float &x,float &y) const
  /* make the coordinates into the xmin-xmax axis frame */
{
  float sepx=aval[1]-aval[0];
  float sepy=aval[3]-aval[2];
  if (!sepx || !sepy) return 1;
  x = x*sepx+aval[0];
  y = y*sepy+aval[2];
  return 0;
}

void
Frame::Hand_Curs(float x1,float y1,float x2,
		 float y2  ,const char ans) 
{
  extern Motif_Pts motpt_;
  float xp,yp;
  float xh,yh;
  if (ans=='M')
    {
      xp=x1;
      yp=y1;
      xh=(aval[1]+aval[0])/2.0;
      yh=(aval[3]+aval[2])/2.0;
      x1=aval[0]-(xh-xp);
      x2=aval[1]+(xh-xp);
      y1=aval[2]-(yh-yp);
      y2=aval[3]+(yh-yp);
    }
  else if (ans=='X')
    {
      xp=(x2+x1)/2.0;
      yp=(y2+y1)/2.0;
      xh=(aval[1]-aval[0])/(x2-x1);
      yh=(aval[3]-aval[2])/(y2-y1);
      x1=xp-xh*(xp-aval[0]);
      x2=xh*(aval[1]-xp)+xp;
      y1=yp-yh*(yp-aval[2]);
      y2=yh*(aval[3]-yp)+yp;
    }
  if (motpt_.mode!=4) 
    {
      if (x1>x2)
	{
	  aval[0]=x2;
	  aval[1]=x1;
	}
      else
	{
	  aval[0]=x1;
	  aval[1]=x2;
	}
    }
  if (motpt_.mode!=3)
    {
      if (y1>y2)
	{
	  aval[2]=y2;
	  aval[3]=y1;
	}
      else
	{
	  aval[2]=y1;
	  aval[3]=y2;
	}
    }
  set_axis_wind();
  redraw();
  return;
}

void
Frame::Curs_pt(float x,float y)
  /*
    Given a single point x,y find the closes
     point displayed on the graph
  */
{
  int pt,grp;
  char ss[256];
  if (!Gph_pt(x,y,grp,pt))
    {
      sprintf(ss," %14.8g %14.8g Grp: %d pt %d",x,y,grp+1,pt+1);
      l_c(ss,1);
    }
  else
    l_c("No Points in graph",1);
  return;
}

void
Frame::cursor(char ans2)
{
  extern Motif_Pts motpt_;
  int a,b,c;
  char ans='C';
  switch(ans2)
    {
    case 'A':
      motpt_.mode=2;
      return;
    case 'X':
      motpt_.mode=3;
      return;
    case 'Y':
      motpt_.mode=4;
      return;
    case 'C':
      motpt_.mode=5;
      return;
    case 'E':
      arm_e_cursor();
      motpt_.mode=7;
      return;
    case 'V':
      twodplots(ans,ans2,a,b,c);
      return;
    case 'M':
      twodplots(ans,ans2,a,b,c);
    default:
      if (motpt_.mode==7)
	{
	  motpt_.mode=1;
	  reset_c_mode();
	}
      else
	{
	  remake_c_mode();
	}
      return;
    }
  return;
}

int
Frame::read(const char ans)
  /*
    reads files into the system. Options A appends the graphics 
    to the object file otherwize replace. 
  */
{
  extern wback hold_;
  char ss[256];
  char fname[256];
  ifstream infle;
  extractfile(fname,hold_.is,80);
  infle.open(fname,ios::in);
  if (!infle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      infle.open(fname,ios::in);
      if (!infle) 
	{
	  l_c("Unable to open file",1);
	  return 1;
	}
    }
  int flag;  
  //options axis,box,lines,symb,text,data,graphinfo
  switch (ans)
    {
    case 'A':   //axis  000001
      flag=1;
      break;
    case 'B':    //box  000010
      flag=2;
      break;
    case 'D':    //data 010000
      flag=32;
      break;
    case 'G':    //graphs 0100000
      flag=64;
      break;
    case 'L':   //lines  00100
      flag=4;
      break;
    case 'O':   //overlay  011110
      flag=30;
      break;
    case 'P':   //plot 01100001
      flag=97;
      break;
    case 'S':   //symbols 001000
      flag=8;
      break;
    case 'T':   //text  010000
      flag=16;
      break;
    default:    //Everything!   111111
      flag=255;
    }

  if (flag & 128)
    eliminate_all();
  
  //  Objects* oj=static_cast<Objects*>(this);
  parse_file(infle,flag);
  infle.close();
  redraw();
  return 0;
}

void
Frame::read_data(const int grp,istream &s) const
{
  extern Spec_In storage_;
  extern titls about_;
  char ss[256];
  if (grp<0 || grp>=tg) return;
  if (!s) return;
  s.getline(ss,255,'\n');
  int type,npts;
  if (!cmdnumber(ss,type) || !cmdnumber(ss,npts)) 
    {
      l_c("Error reading data header",1);
      return;
    }
  if (npts<0 || npts>maxpts) 
    {
      l_c("Error with number of points in data file",1);
      return;
    }

  s.getline(ss,255,'\n');
  strncpy(about_.hd[grp],ss,40);
  int i=0;
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  double *E=storage_.store[grp];
  while(!s.fail() && i<npts)
    {
      s>>X[i]>>Y[i]>>E[i];
      i++;
    }
  if (!s) i--;
  storage_.stpnt[grp]=i;
  return;
}

void
Frame::parse_file(istream &s,const int flags)
  /* flag switch works by overlaying the parg */
{
  std::string check;
  int outgrp=0;
  int grp;
  std::string::size_type pos;
  while(!s.fail())
    {
      getline(s,check,'\n');
      if ((flags & 64) && check.find("Graph")!=std::string::npos)       //graphs
	{
	  Graphs* gi=static_cast<Graphs*>(this);
	  s >> *gi;
	}
      else if ((flags & 1) && check.find("Axis")!=std::string::npos)
	{
	  axis_param *ap= static_cast<axis_param*>(this);
	  s>> *ap;
	}
      else if ((flags & 32) && (pos=check.find("Data"))!=std::string::npos)  
	{
	  char ss[256];
	  (check.substr(pos+4)).copy(ss,256);
	  if ((flags & 64) && cmdnumber(ss,grp))
	    {
	      read_data(grp,s);
	      outgrp=grp+1;
	    }
	  else
	    {
	      read_data(outgrp,s);
	      outgrp++;
	    }
	}
      else if ((flags & 16) && check.find("Text")!=std::string::npos)   
	{
	  Otext *ot=new Otext();
	  ot->read_obj(s);
	  include_item(ot);
	}
      else if ((flags & 2) && check.find("Box")!=std::string::npos)
	{
	  Obox *ob=new Obox();
	  ob->read_obj(s);
	  include_item(ob);
	}
      else if ((flags & 4) && check.find("Line")!=std::string::npos)
	{
	  Oline *ol=new Oline();
	  ol->read_obj(s);   //now will read whole of aline!
	  include_item(ol);
	}
      else if ((flags & 8) && check.find("Symb")!=std::string::npos)
	{
	  /*	  Osym *os=new Osym();
	  os->read_obj(s);
	  include_item(os); */
	}
      else if (check.find("End")!=std::string::npos)
	{
	  return;
	}
    }
  return;
}


void
Frame::write(const char ans) const
{
  extern wback hold_;
  char ss[256];
  char fname[256];
  ofstream outfle;
  extractfile(fname,hold_.is,80);
  outfle.open(fname,ios::out);
  if (!outfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      outfle.open(fname,ios::out);
      if (!outfle) 
	{
	  l_c("Unable to create file",1);
	  return;
	}
    }
  if (ans!='O')
    {
      const axis_param* ao=static_cast<axis_param const*>(this);
      outfle<< *ao;
    }
  if (ans!='A' && ans!='P')
    {
      const Objects* oj=static_cast<Objects const*>(this);
      outfle<< *oj;
    }
  if (ans!='O' && ans!='A')
    {
      const Graphs* gp=static_cast<Graphs const*>(this);
      outfle<< *gp;
    }
  if (ans=='S')
    {
      sprintf(ss,"Name of seperate file: ");
      l_c(ss,0);
      extractfile(fname,ss,250);
      outfle.close();
      outfle.open(fname,ios::out);
      if (!outfle) 
	{
	  l_c("Unable to create file",1);
	  return;
	}
    }
  else
  if (ans!='O' && ans!='A')
    {
      this->write_datapts(outfle);
    }
  outfle.close();
  return;
}

void
Frame::redraw(const int pnt)
{

  if (pnt)
    open_print();
  else if (select_window())
    return;
  clear_picture();
  realise_axis();
  all_gph();
  all_obj();
  if (pnt)
    close_print();
  return;
}

void
Frame::give_axis() const
{
  char ss[256];
  l_c("Current Axes are :",1);
  sprintf(ss,"Prim:: %12.6f %12.6f ::  %12.6f %12.6f",
	  aval[0],aval[1],aval[2],aval[3]);
  l_c(ss,1);
  sprintf(ss,"Scnd: %12.6f %12.6f ::  %12.6f %12.6f",
	  O_aval[0],O_aval[1],O_aval[2],O_aval[3]);
  l_c(ss,1);
  return;
}

void
Frame::setaxis(char *ans)   //text input to set axis
{
  extern wback hold_;
  char ss[256];
  int flag;
  if (*ans=='C')
    {
      char ans2;
      float xtemp=0.0;
      float ytemp=0.0;
      get_first_nonumb(ans2,hold_.is);
      flag=cmdnumber(hold_.is,xtemp);
      if (flag) flag+=cmdnumber(hold_.is,ytemp);
      if (flag<2)
	ytemp=xtemp;

      if (ans2!='Y') 
	{
	  while(flag<1 || xtemp<0.2 || xtemp>5.0)
	    {
	      sprintf(ss,"Enter x axis number scale =>");
	      l_c(ss,0);
	      flag=cmdnumber(ss,xtemp);
	      if (!flag) return;
	    }
	}
      if (ans2!='X')
	{
	  while(ytemp<0.2 || ytemp>5.0)
	    {
	      sprintf(ss,"Enter y axis number scale =>");
	      l_c(ss,0);
	      if (!cmdnumber(ss,ytemp)) return;
	    }
	}
      num_entry(xtemp,ytemp);
      return;
    }
  if (*ans=='N')
    {
      char ans2;
      int mtk= -1;
      int Mtk= -1;
      get_first_nonumb(ans2,hold_.is);
      if (ans2!='Y') 
	{
	  flag=cmdnumber(hold_.is,Mtk);
	  if (flag) flag+=cmdnumber(hold_.is,mtk);
	  sprintf(ss,"Old X-Major %d Minor %d",atick[0],atick[1]);
	  l_c(ss,1);
          while(flag<2 || Mtk<0 || mtk<0 || Mtk>15 || mtk>15)
	    {
	      flag=2;
	      sprintf(ss,"Enter major and minor x axis ticks");
	      l_c(ss,0);
	      if (!cmdnumber(ss,Mtk) || !cmdnumber(ss,mtk))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  atick[0]=Mtk;
	  atick[1]=mtk;
        }
      if (ans2!='X') 
	{
	  flag=cmdnumber(hold_.is,Mtk);
	  if (flag) flag+=cmdnumber(hold_.is,mtk);
	  sprintf(ss,"Old Y-Major %d Minor %d",atick[2],atick[3]);
	  l_c(ss,1);
          while(flag<2 || Mtk<0 || mtk<0 || Mtk>15 || mtk>15)
	    {
	      flag=2;
	      sprintf(ss,"Enter major and minor y axis ticks");
	      l_c(ss,0);
	      if (!cmdnumber(ss,Mtk) || !cmdnumber(ss,mtk))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  atick[2]=Mtk;
	  atick[3]=mtk;
        }
      set_axis_wind();
      return;
    }
  if (*ans=='V')
    {
      double xmin,xmax,ymin,ymax;
      char ans2;
      get_first_nonumb(ans2,hold_.is);
      if (ans2!='Y') 
	{
	  flag=cmdnumber(hold_.is,xmin);
	  if (flag) flag+=cmdnumber(hold_.is,xmax);
	  sprintf(ss,"Old viewport Xmin %8.6f Xmax %8.6f",bord[0],bord[1]);
	  l_c(ss,1);
          while(flag<2 || xmin<0.0 || xmax<0.0 || xmax>1.0 || xmin>1.0)
	    {
	      flag=2;
	      sprintf(ss,"Enter xmin,xmax viewport cords => ");
	      l_c(ss,0);
	      if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  if (xmin>xmax)
	    {
	      bord[0]=xmax;
	      bord[1]=xmin;
	    }
	  else
	    {
	      bord[0]=xmin;
	      bord[1]=xmax;
	    }
        }
      if (ans2!='X') 
	{
	  flag=cmdnumber(hold_.is,ymin);
	  if (flag) flag+=cmdnumber(hold_.is,ymax);
	  sprintf(ss,"Old Y-Viewport ymin %8.6f ymax %8.6f",bord[2],bord[3]);
	  l_c(ss,1);
          while(flag<2 || ymin<0.0 || ymax<0.0 || ymax>1.0 || ymin>1.0)
	    {
	      flag=2;
	      sprintf(ss,"Enter ymin,ymax viewport cords => ");
	      l_c(ss,0);
	      if (!cmdnumber(ss,ymin) || !cmdnumber(ss,ymax))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  if (ymin>ymax)
	    {
	      bord[2]=ymax;
	      bord[3]=ymin;
	    }
	  else
	    {
	      bord[2]=ymin;
	      bord[3]=ymax;
	    }
        }
      set_axis_wind();
      return;
    }
  int tpc=0;      //twenty percent addition
  char ans2;
  get_first_nonumb(ans2,hold_.is);
  if(*ans=='T')
    {
      tpc=1;
      *ans=ans2;
    }
  else if(ans2=='T')
    {
      tpc=1;
    }

  double xmin,xmax,ymin,ymax;
  strncpy(ss,hold_.is,80);
  ss[81]=0;
  int grp;
  if (cmdnumber(ss,xmin) && !cmdnumber(ss,xmax))   //points by grp
    {
      grp=(int) (xmin+0.1);
      if (grp<tg && grp>0 && 
	  !grpmax(grp-1,xmin,xmax,ymin,ymax))
	{
	  if (xmin==xmax) xmax+=1.0;
	  if (ymin==ymax) ymax+=1.0;
	  if (tpc && *ans!='Y')
	    {
	      double tmp=(xmax-xmin);
	      xmin-=0.1*tmp;
	      xmax+=0.1*tmp;
	    }
	  if (tpc && *ans!='X')
	    {
	      double tmp=(ymax-ymin);
	      ymin-=0.1*tmp;
	      ymax+=0.1*tmp;
	    }
	  if (*ans!='Y')
	    {
	      aval[0]=xmin;
	      aval[1]=xmax;
	    }
	  if (*ans!='X')
	    {
	      aval[2]=ymin;
	      aval[3]=ymax;
	    }
	  give_axis();
	  set_axis_wind();
	  return;
	}
    }
  flag=2;
  if (*ans!='Y') 
    {
      flag=cmdnumber(hold_.is,xmin);
      if (flag) flag+=cmdnumber(hold_.is,xmax);
      sprintf(ss,"Old Xaxis %8.6f : %8.6f",aval[0],aval[1]);
      l_c(ss,1);
      if ((flag) || !tpc)  //deal with simple ayx entry
	{
	  while(flag<2 || xmin==xmax)
	    {
	      flag=3;
	      sprintf(ss,"Enter xmin,xmax cords => ");
	      l_c(ss,0);
	      if (!cmdnumber(ss,xmin) || !cmdnumber(ss,xmax))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  if (xmin>xmax)
	    {
	      aval[0]=xmax;
	      aval[1]=xmin;
	    }
	  else
	    {
	      aval[0]=xmin;
	      aval[1]=xmax;
	    }
	}
      if (tpc) 
	{
	  xmin=0.1*(aval[1]-aval[0]);
	  aval[0]-=xmin;
	  aval[1]+=xmin;
	}
    }
  if (*ans!='X') 
    {
      flag=(flag==2) ? cmdnumber(hold_.is,ymin) : 0;
      if (flag) flag+=cmdnumber(hold_.is,ymax);
      sprintf(ss,"Old Yaxis %8.6f : %8.6f",aval[2],aval[3]);
      l_c(ss,1);
      if ((flag) || !tpc)  //deal with simple ayt entry
	{
	  while(flag<2 || ymin==ymax)
	    {
	      flag=2;
	      sprintf(ss,"Enter ymin,ymax cords => ");
	      l_c(ss,0);
	      if (!cmdnumber(ss,ymin) || !cmdnumber(ss,ymax))
		{
		  set_axis_wind();
		  return;
		}
	    }
	  if (ymin>ymax)
	    {
	      aval[2]=ymax;
	      aval[3]=ymin;
	    }
	  else
	    {
	      aval[2]=ymin;
	      aval[3]=ymax;
	    }
	}
      if (tpc) 
	{
	  ymin=0.1*(aval[3]-aval[2]);
	  aval[2]-=ymin;
	  aval[3]+=ymin;
	}
    }
  set_axis_wind();
  return;
}




int
Frame::grpmax(const int grp,double &xmin,double &xmax,
	      double &ymin,double &ymax)
{      
  extern Spec_In storage_;
  if (grp<0 || grp>=tg ||  storage_.stpnt[grp]<1)
    {
      xmin=xmin=0.0;
      ymin=ymin=0.0;
      return 1;
    }
  const int npts=storage_.stpnt[grp]; 
  double *X=storage_.storx[grp];
  double *Y=storage_.story[grp];
  xmin=xmax= *X;
  ymin=ymax= *Y;
  X++;
  Y++;
  for(int i=1;i<npts;i++)
    {
      if (*X>xmax)
	xmax= *X;
      else if(*X<xmin)
	xmin= *X;
      if (*Y>ymax)
	ymax= *Y;
      else if(*Y<ymin)
	ymin= *Y;
      X++;
      Y++;
    }
  if (log_flag[0]) 
    {
      xmin=fabs(xmin)>1e-100 ? log10(fabs(xmin)) : -100;
      xmax=fabs(xmax)>1e-100 ? log10(fabs(xmax)) : -100;
    }
  if (log_flag[1]) 
    {
      ymin=fabs(ymin)>1e-100 ? log10(fabs(ymin)) : -100;
      ymax=fabs(ymax)>1e-100 ? log10(fabs(ymax)) : -100;
    }
  return 0;
}


void
Frame::plotfn(char *ans)
{
  extern wback hold_;

  int grp=0;
  int grp2=1;
  int flag;
  flag=cmdnumber(hold_.is,grp);
  if (flag) 
    flag+=cmdnumber(hold_.is,grp2);
  
  if (*ans=='M')
    {
      draw2d(&grp,&grp2);
      return;
    }
  else if(*ans=='T')
    {
      draw3d(&grp,&grp2);
      return;
    }
  else if (*ans=='R')
    {
      drawrmc(grp,grp2);
      return;
    }

  if (Draw_Method::select_window())    //check that we have opened a window.
   return;
  
  if (*ans=='P')
    {
      redraw();
      return;
    }
  else if (*ans=='D')    //delete graph
    {
      if(flag) 
	remove_graph(grp);
      else
	remove_graph();
      redraw();
      return;
    } 
  else if (*ans=='C')
    {
      int lty=0;
      double size=1.0;
      if (flag>1)
	flag+=cmdnumber(hold_.is,lty);
      if (flag>2)
	flag+=cmdnumber(hold_.is,size);
      plot_col(grp,grp2,lty,size);
    }
  else if (*ans=='E')
    {  //not complete pe == plot error
      int lty=0;
      double size=1.0;
      if (flag>1)
	flag+=cmdnumber(hold_.is,lty);
      if (flag>2)
	flag+=cmdnumber(hold_.is,size);
      plot_err(grp,grp2,lty,size);
    }
  else if (*ans=='H')
    {  //not complete pe == plot error
      double size=1.5;
      int fnt(2);
      if (flag>1)
	flag+=cmdnumber(hold_.is,size);
      if (flag>2)
	flag+=cmdnumber(hold_.is,fnt);
      plot_header(grp,grp2,size,fnt);
    }
  else
    {
      clear_graphs();
      clear_picture();
      realise_axis();
      int lty=0;
      double size=1.0;
      if (flag>1)
	flag+=cmdnumber(hold_.is,lty);
      if (flag>2)
	flag+=cmdnumber(hold_.is,size);
      plot_col(grp,grp2,lty,size);
    }
  return;
}





