#ifndef fit_param_h
#define fit_param_h

class fit_param;
class intep;

struct fit_hold
{
  fit_param* THIS;
  Widget W;
};

struct temp_hold
{
  fit_param* THIS;
  int i;
};

class fit_param
{
  
 private:

  int madeWindow;
  intep* cnt_fnc;
  Widget str_fnc;      // function that has the label 
  Widget* text;        //arrays for text, buttons and limits
  Widget* Pbutton;
  Widget* limit;
  Widget old_fittype;
  Widget dlog;
  temp_hold* tp_fit;
  temp_hold menu_tp[5]; 

  int flg;            //0=no wind,1=ended window,2==
  int start,end;
  int in_grp,out_grp;
  
  void test_fn();
  static void num_entry(Widget,XtPointer,XtPointer); 
  static void help_fit(Widget,XtPointer,XtPointer);
  static void cancel_fit(Widget,XtPointer,XtPointer);
  static void cancel_dlog(Widget,XtPointer,XtPointer);
  static void flag_change(Widget,XtPointer,XtPointer);
  static void fit_menu(Widget,XtPointer,XtPointer);
  static void spfit_menu(Widget,XtPointer,XtPointer);
  
 public:
  
  char strng[255];    // Y string
  double qft;  //Quality factor of the fits.
  int n_par;   //number in v and flag.
  int* flag;   //change_able flag.
  double* v;   //variables.
  double* vl;  //limit variables 
  int f_method;  //Method to use in fitting rand,L-M etc.   

  fit_param(intep*);
  fit_param(const fit_param&);
  fit_param&  operator=(const fit_param&);
  void set_const(double *,int);
  int get_flag(int i) {return ((i<n_par && i>=0) ? flag[i] : -1);}
  void update_flag();
  ~fit_param();
  void set_zero(const int);
  void resize(const int);
  void make_wind();               
  void set_text_field();
  void set_str();
  void set_pts(int=0,int=0);
  void set_grp(int=0,int=0);
  void check_consistency();
  int s_pt() const {return start-1;} 
  int e_pt() const {return end-1;} 
  int i_grp() const {return in_grp;} 
  int o_grp() const {return out_grp;} 
  int valid();
  void num_all();
  void load_fit(const char* =0);
  void save_fit();

  //keybouard stuff...

  void Kset_limits();
  void Kset_const();
  void Kwrite_values() const;
};



#endif
