#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <Xm/FileSB.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "fileselect.h"
#include "readfunc.h"
#include "cmd.h"
#include "extract.h"
#include "fglobal.h"

XmStringCharSet char_set=XmSTRING_DEFAULT_CHARSET;


fselect::fselect() :inp_m(2), madefile(0)
{}

fselect::~fselect()
{
  if (madefile)
    {
      Widget shell=FBox;
      XtUnmanageChild(shell);
      madefile=0;
    }
}

void
fselect::loadfile(const char* fname)
{

  ifstream imfle;
  imfle.open(fname,ios::in);
  switch (inp_m) 
    {
    case 1: //readin
      if (readinFunc(imfle,' ',grpV-1,1,1))
	l_c("Read failed",1);
      else
	{ 
	  if (grpV<tg) 
	    grpV++;
	  settextfield(grpdata,grpV); 
	}
      return;
    case 2: //fourbris
      if (FourBFunc(imfle,grpV-1,Ncont))
	return;
      if (grpV<tg) 
	grpV++;
      settextfield(grpdata,grpV); 
      return;
    case 6:  
      for(int i=0;i<Ncont-1;i++)
	do {
	  imfle.clear();
	  imfle.ignore(256,'\n');
	} while(imfle.fail() && imfle.gcount()>=255);

      if (select_colFunc(imfle,grpV-1,1,2,4,0))
	{
	  l_c("Read failed",1);
	  return;
	}
      grpV++;
      settextfield(grpdata,grpV); 
      return;
    case 9:  //col read
      if (select_colFunc(imfle,grpV-1,colV[0],colV[1],colV[2],0))
	{
	  l_c("Read failed",1);
	  return;
	}
      if (grpV<tg) 
	grpV++;
      settextfield(grpdata,grpV); 
      return;
    default:
      imfle.close();
      return;
    }
  
}
  
void
fselect::set_func(const int tp)
  /* called to set the input method */
{
  const int sel(11);  //max number of different parameters.
  if(tp>0 && tp<=sel)
    inp_m=tp;
  setTitle();
  return;
}

void
fselect::setTitle()
  /*
    This has to tell the user the given title of the data read
    method 
  */

{
  if (!madefile) 
    return;
  /* Following are Main titles (Tnames)
                    First input (Ig)
                    Second input (Og)
                    xyz line (Xyline)  0 ==false
  */
  char* Tnames[11]={"Stream XY","Fourbris","DSC","Genie","V. Head xyz",
		    "WA -Xray","Mulit-scan","X6B Data","Column Selection",
		    "Bin Xray","ESRF Scan Data :"};
  char* Ig[11]={"Input Grp ::","Input Grp ::","Input Grp ::","Input Grp ::",
		"Input Grp ::","Input Grp ::","Input Grp ::","Input Grp ::",
		"Input Grp ::","Input Grp ::","Input Grp ::"};
  char* Og[11]={"Cont for..","Cont Grp","Cont Grp",
		"Offset ::","Cont Grps","Continue Grps",
		"Cont Grps","Cont Grps","Cont Grps",
		"Cont Grps","Scan Num ::"};
  char* Offg[11]={"Cont for..","Cont Grp","Cont Grp",
		"Offset ::","Cont Grps","Continue Grps",
		"Cont Grps","Cont Grps","Cont Grps",
		"Cont Grps","Scan Num ::"};
  char* Xtrg[11]={"Cont for..","Cont Grp","Cont Grp",
		"Offset ::","Cont Grps","Continue Grps",
		"Cont Grps","Cont Grps","Cont Grps",
		"Cont Grps","Scan Num ::"};
  int Xyline[11]={0,0,0,0,
		  0,0,0,0,
		  1,0,1};
  int Xtra[11]={1,1,1,1,
		  0,0,0,0,
		  1,0,1};

  
 
  Widget Tlabel_D=Tlabel;
  XtDestroyWidget(Tlabel_D);  //was unmanagechild

  XmString strT=
    XmStringCreate(Tnames[inp_m-1],XmSTRING_DEFAULT_CHARSET);
  Tlabel=
    XtVaCreateManagedWidget("Tlabel1",xmLabelWidgetClass,title,
			    XmNlabelString, strT,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(strT); 
  XtVaSetValues(Tlabel,XmNfontList,Tfontlist,NULL);

  XmString strIg=
    XmStringCreateLocalized(Ig[inp_m-1]);
  XmString strCg=
    XmStringCreateLocalized(Og[inp_m-1]);
  XmString strOg=
    XmStringCreateLocalized(Offg[inp_m-1]);
  XmString strXg=
    XmStringCreateLocalized(Xtrg[inp_m-1]);
  
  XtUnmanageChild(infoLine);  //first line of info
  XtUnmanageChild(addLine);   //second line of info
  Widget glabel_D=glabel;     //grp (infoline)
  Widget alabel_D=alabel;     //cont (infoline)
  Widget grpdata_D=grpdata;   //grp data (infoline)
  Widget contdata_D=contdata; //cont data (infoline)

  Widget extradata_D=extraData;  //extradata (addline)
  Widget offdata_D=offData;
  Widget extratxt_D=extra_label;  //extra text (addline)
  Widget offtxt_D=off_label;

  XtDestroyWidget(alabel_D);
  XtDestroyWidget(glabel_D);
  XtDestroyWidget(grpdata_D);
  XtDestroyWidget(contdata_D);
  XtDestroyWidget(extradata_D);
  XtDestroyWidget(offdata_D);
  XtDestroyWidget(offtxt_D);
  XtDestroyWidget(extratxt_D);

  glabel=
    XtVaCreateManagedWidget("InpGrp",xmLabelWidgetClass,infoLine,
			    XmNlabelString, strIg,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  grpdata=
    XtVaCreateManagedWidget("GrpData",xmTextFieldWidgetClass,infoLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);
  alabel=
    XtVaCreateManagedWidget("ContGrp",xmLabelWidgetClass,infoLine,
			    XmNlabelString, strCg,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  contdata=
    XtVaCreateManagedWidget("ContData",xmTextFieldWidgetClass,infoLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);

  XtManageChild(infoLine);
  off_label=
    XtVaCreateManagedWidget("OffLabel",xmLabelWidgetClass,addLine,
			    XmNlabelString, strOg,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  offData=
    XtVaCreateManagedWidget("offData",xmTextFieldWidgetClass,addLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);
  extra_label=
    XtVaCreateManagedWidget("Extra",xmLabelWidgetClass,addLine,
			    XmNlabelString, strXg,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  extraData=
    XtVaCreateManagedWidget("ExtraData",xmTextFieldWidgetClass,addLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);

  XtManageChild(addLine);

  XmStringFree(strCg);
  XmStringFree(strIg);
  XmStringFree(strOg);
  XmStringFree(strXg);

  if (Xtra[inp_m-1])
    XtManageChild(addLine);

  if (Xyline[inp_m-1])
    XtManageChild(ColRow);
  else
    XtUnmanageChild(ColRow);
  

}
      
  
void
fselect::makebox()
{
  extern Widget main_w;
  if (madefile)
    {
      XtPopup(FBox,XtGrabNone);
      return;
    }
  FBox=
    XtVaCreatePopupShell("FselectBox",
			 topLevelShellWidgetClass,main_w,
			 XtNtitle, "Load data file",
			 XmNdeleteResponse,XmDESTROY,
			 NULL);
  
  Widget fwind = 
    XtVaCreateManagedWidget("FselInner",
			    xmMainWindowWidgetClass,FBox,
			    XtNtitle, "Load data file",
			    NULL);

  Widget frow=
    XtVaCreateWidget("aform",xmFormWidgetClass,fwind,
		     NULL);                           

  title=
    XtVaCreateWidget("titlerow",xmRowColumnWidgetClass,frow,
		     XmNpacking,XmPACK_TIGHT,
		     XmNisAligned, True,
		     XmNnumColumns,1,
		     XmNentryVerticalAlignment,XmALIGNMENT_END,
		     XmNorientation, XmHORIZONTAL,
		     NULL); 
  
  XmString strT=
    XmStringCreate("Title of input : ",XmSTRING_DEFAULT_CHARSET);

  Tlabel=
    XtVaCreateManagedWidget("Tlabel",xmLabelWidgetClass,title,
			    XmNlabelString, strT,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(strT); 
  XtManageChild(title);

  Tfont=NULL;
  Tfontlist=NULL;
  char *namestring="*times-bold-r-normal-*-24*";
  Tfont=XLoadQueryFont(XtDisplay(title),namestring);
  Tfontlist=XmFontListCreate(Tfont,XmSTRING_DEFAULT_CHARSET);
  XtVaSetValues(Tlabel,XmNfontList,Tfontlist,NULL);

  infoLine=
    XtVaCreateWidget("fboxrow",xmRowColumnWidgetClass,frow,
		     XmNpacking,XmPACK_TIGHT,
		     XmNisAligned, True,
		     XmNnumColumns,4,
		     XmNtopAttachment,XmATTACH_WIDGET,
		     XmNtopWidget,title,
		     XmNentryVerticalAlignment,XmALIGNMENT_END,
		     XmNorientation, XmHORIZONTAL,
		     NULL); 

  XmString 
    str=XmStringCreateLocalized("Input group :");
  glabel=
    XtVaCreateManagedWidget("InpGrp",xmLabelWidgetClass,infoLine,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 
  grpdata=
    XtVaCreateManagedWidget("GrpData",xmTextFieldWidgetClass,infoLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);


  str=XmStringCreateLocalized("Continue Grps:");
  alabel=
    XtVaCreateManagedWidget("ContGrp",xmLabelWidgetClass,infoLine,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 

  contdata=
    XtVaCreateManagedWidget("ContData",xmTextFieldWidgetClass,infoLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);
  XtManageChild(infoLine);


  addLine=
    XtVaCreateWidget("fboxrow",xmRowColumnWidgetClass,frow,
		     XmNpacking,XmPACK_TIGHT,
		     XmNisAligned, True,
		     XmNnumColumns,4,
		     XmNtopAttachment,XmATTACH_WIDGET,
		     XmNtopWidget,infoLine,
		     XmNentryVerticalAlignment,XmALIGNMENT_END,
		     XmNorientation, XmHORIZONTAL,
		     NULL); 

  str=XmStringCreateLocalized("Offset :");
  off_label=
    XtVaCreateManagedWidget("OffLabel",xmLabelWidgetClass,addLine,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 
  offData=
    XtVaCreateManagedWidget("offData",xmTextFieldWidgetClass,addLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);

  str=XmStringCreateLocalized("Extra Info :");
  extra_label=
    XtVaCreateManagedWidget("Extra",xmLabelWidgetClass,addLine,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 

  extraData=
    XtVaCreateManagedWidget("ExtraData",xmTextFieldWidgetClass,addLine,
			    XmNvalue, "1",
			    XmNmarginHeight,(Dimension) 0,
			    XmNcolumns,5,
			    NULL);
  XtManageChild(addLine);

  //Third layer....
  ColRow=
    XtVaCreateWidget("fboxrow",xmRowColumnWidgetClass,frow,
		     XmNpacking,XmPACK_TIGHT,
		     XmNtopAttachment,XmATTACH_WIDGET,
		     XmNtopWidget,addLine,
		     XmNisAligned, True,
		     XmNnumColumns,4,
		     XmNentryVerticalAlignment,XmALIGNMENT_END,
		     XmNorientation, XmHORIZONTAL,
		     NULL); 


  str=XmStringCreateLocalized("X,Y (E) Columns :");
  clabel=
    XtVaCreateManagedWidget("Option",xmLabelWidgetClass,ColRow,
			    XmNlabelString, str,  
			    XmNmarginHeight,(Dimension) 0,    
			    NULL);
  XmStringFree(str); 

  ColData[0]=XtVaCreateManagedWidget("Xcol",xmTextFieldWidgetClass,ColRow,
				     XmNvalue, "1",
				     XmNmarginHeight,(Dimension) 0,
				     XmNcolumns,5,
				     NULL);

  ColData[1]=XtVaCreateManagedWidget("Ycol",xmTextFieldWidgetClass,ColRow,
				     XmNvalue, "2",
				     XmNmarginHeight,(Dimension) 0,
				     XmNcolumns,5,
				     NULL);

  ColData[2]=XtVaCreateManagedWidget("Ecol",xmTextFieldWidgetClass,ColRow,
				     XmNvalue, "0",
				     XmNmarginHeight,(Dimension) 0,
				     XmNcolumns,5,
				     NULL);

  for(int i=0;i<3;i++)
    XtAddCallback (ColData[i],XmNactivateCallback,
		   PrcAddData, (void*) this);
  XtAddCallback (grpdata,XmNactivateCallback,
		 PrcAddData, (void*) this);
  XtAddCallback (contdata,XmNactivateCallback,
		 PrcAddData, (void*) this);
  


  XtManageChild(ColRow);




  int ac=0;
  Arg al[10];
  XtSetArg(al[ac],XmNmustMatch,True); ac++;
  XtSetArg(al[ac],XmNautoUnmanage,False); ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM); ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM); ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM); ac++;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac],XmNtopWidget,ColRow); ac++;

  FSel=XmCreateFileSelectionBox(frow,"open_dialog",al,ac);
  XtAddCallback (FSel, XmNokCallback,
		 openFsel, (void*) this);
  XtAddCallback (FSel, XmNcancelCallback,
		 cancelFsel, (void*) this);
  
  XtManageChild(FSel);
  XtManageChild(frow);
  XtManageChild(FBox);
  madefile=1;
  setTitle();
  return;
}

void 
fselect::settextfield(Widget w,const double value)
{
  char s[255];
  sprintf(s,"%20g",value);
  int k;
  for(k=0;k<250 && s[k]==' ';k++);
  XmTextPosition j=strlen(s+k);
  XmTextSetString(w,s+k);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}

void 
fselect::settextfield(Widget w,const int value) 
  /* allows the setting of a given widget */
{
  char s[255];
  sprintf(s,"%20d",value);
  int k;
  for(k=0;k<250 && s[k]==' ';k++);
  XmTextPosition j=strlen(s+k);
  XmTextSetString(w,s+k);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}

void 
fselect::settextfield(Widget w,const char* value)
  /* allows the setting of a given widget */
{
  char s[255];
  int k;
  for(k=0;k<250 && value[k]==' ';k++);
  XmTextPosition j=strlen(value+k);
  strncpy(s,value+k,255);
  s[255]=0;
  XmTextSetString(w,s);
  XmTextFieldSetInsertionPosition(w,j);
  return;
}

void
fselect::set_inputs()
{
  if (!madefile) return;  //this should not be possible
  settextfield(grpdata,grpV);
  settextfield(contdata,Ncont);
  if (colV[0]<=0)
    settextfield(ColData[0],"Index");
  else
    settextfield(ColData[0],colV[0]);
  settextfield(ColData[1],colV[1]);
  if (colV[2]<=0)
    settextfield(ColData[2],"None");
  else
    settextfield(ColData[2],colV[2]);
  return;
}

void
fselect::check_inputs()
{
  if (!madefile) return;  //this should not be possible
  char out[256];
  //Start with the fit and outgoing group 

  strncpy(out,XmTextFieldGetString(grpdata),255);  //strncpy to avoid overrun
  grpV=atoi(out);
  strncpy(out,XmTextFieldGetString(contdata),255);
  Ncont=atoi(out);
    
    
  for(int i=0;i<3;i++)
    {
      strncpy(out,XmTextFieldGetString(ColData[i]),255);
      colV[i]=atoi(out);
      int ichk;
      for(ichk=strlen(out)-1;ichk>=0 && !isdigit(out[ichk]);ichk--);
      if (ichk<0)
	colV[i]=-1;
    }
  //Now the checks.....
  if (grpV>tg || grpV<1)
    grpV=1;
  if (Ncont>tg-grpV)
    Ncont=tg-grpV;
  else if(Ncont<1)
    Ncont=1;
  if (colV[0]==0 || colV[0]>500)
    colV[0]=1;
  if (colV[1]<1 || colV[1]>500)
    colV[1]=(colV[0]>0) ? colV[0]+1 : 1;
  if (colV[2]<=0 || colV[2]>500)
    colV[2]= -1;
  return;
}


void 
fselect::cancelFsel(Widget w,XtPointer client_data,XtPointer call_data)
{

  fselect *THIS=(fselect *) client_data;
  //  XtVaGetValues(THIS->gbox,XmNx,THIS->xx,XmNy,THIS->yy,NULL);
  Widget shell = THIS->FBox;
  THIS->madefile=0;
  if (shell)
    {
      XtDestroyWidget(shell);
    }
  return;
}

void
fselect::PrcAddData(Widget w,XtPointer client_d,XtPointer call_data)
  /* Assume that the person has pressed a return in a grp box */
{
  fselect* THIS = static_cast<fselect*>(client_d);
  THIS->check_inputs();
  THIS->set_inputs();
  return;
}

void 
fselect::openFsel(Widget w,XtPointer client_d,XtPointer call_data)
  /* handles the file selection box callback. */
{
  extern int inprocess_flg;
  fselect* THIS = static_cast<fselect*>(client_d);
  XmFileSelectionBoxCallbackStruct *s =
    (XmFileSelectionBoxCallbackStruct *) call_data;
  /* get the filename from the file selection box */
  char *filename;  //place to put string MUST be cleared!!!

  XmStringGetLtoR(s->value, XmSTRING_DEFAULT_CHARSET, &filename);
  
  /* open and read the file. */
  THIS->check_inputs();
  if (inprocess_flg)
    place_cmd(filename);
  else
    THIS->loadfile(filename);

  XtFree(filename);
  
  return;
}

