#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <vector>
#include <string>
#include "cmd.h"
#include "fglobal.h"
#include "extract.h"
#include "file_rec.h"

void history_(char *ans)
{ 
  history(ans);
}

void starthistory_()
{ 
  starthistory();
}

void readhistory_()
{ 
  readhistory();
}


void endhistory_()
{ 
  endhistory();
}

template class std::vector<std::string>;

file_rec::file_rec() : 
  work(0),outlist(0),workcount(0),nloop(0),wr_out(0),
  active(0),querry(0)
{ 
  worklist=std::vector<std::string>(1,"");     //null string 
}

file_rec::~file_rec()
{
  if (work)
    delete work;
  if (outlist)
    delete outlist;
  work=0;
  outlist=0;
}

int 
file_rec::open(const char *s)
{
  char ss[81];
  if(!s) return 0; 
  extractfile(ss,s,80);
  if (work)
    {
      work->close();
      work->open(ss,ios::in);
      if (work->fail()) 
	{
	  delete work;
          work=0;
	  return 0;
	}
    }
  else
    {
      work=new ifstream(ss,ios::in);
      if (work->fail() )  
	{
	  delete work;
          work=0;
	  return 0;
	}
    }
  plc=1;     //now from a file
  return 1;
}

int 
file_rec::wopen(const char *s)
{
  char ss[81];
  if(!s) return 0; 
  extractfile(ss,s,80);
  if (outlist)
    {
      outlist->close();
      outlist->open(ss,ios::out);
      if (outlist->fail()) 
	{
	  delete outlist;
          outlist=0;
	  return 0;
	}
    }
  else
    {
      outlist=new ofstream(ss,ios::out);
      if (outlist->fail() )  
	{
	  delete outlist;
          outlist=0;
	  return 0;
	}
    }
  wr_out=1;
  return 1;
}

void 
file_rec::wclose()
{
  if (outlist)
    {
      outlist->close();
      delete outlist;
      outlist=0;
      l_c("Closed output file",1);
    }
  wr_out=0;
  return;
}

void
file_rec::str_exec(const char *s) 
  /* string from exec_cmd 
     if in loop check for end loop
     if out of loop check for start of loop
     if flg=1 then forbidden to start a loop
  */

  // plc = 0 or 1, 2, pfile = 1 or 0  
{
  if (nloop)           // are we in a loop
    {
      workcount++;
      worklist.push_back(s);
      totcount++;
      if (!loopend(s))       //is the the end of the loop
        loopstart(s);       //or the beginning of a new loop
    }
  else 
    if (loopstart(s))    //record string if so. Querries don't matter
      {         
	worklist.push_back(s);
      } 
  return;
}
    

void
file_rec::updatelist(const char *s,const int cforward)
{
  workcount++;
  worklist.push_back(s+cforward);
}


int
file_rec::loopstart(const char *s)
{
  
  if(!s || querry) return 0;   //can't start a loop in a querry
  int i;
  for(i=0;(s[i]==' ' || s[i]=='\t') && i<256;i++);
  if (strncmp(s+i,"&do",3)) return 0;   //not the start of a do loop
  int tlp;
  char ss[256];
  strncpy(ss,s+i,256-i);
  if (!cmdnumber(ss+3,tlp) ||
      tlp>1000000 || tlp<1) 
    {
      l_c("Invalid loop form ",1);
      return 0;  //no valid form
    }
  if (!nloop)  //simple initialization
    {
      makeactive();
      workcount=0;
      totcount=0;
    }
  nloop++;
  lcount.push_back(tlp-1);     // push number of times
  l_spt.push_back(workcount);  // place in the file that we come backto
                               // workcount already +1 
  l_ept.push_back(-1);         // haven't read were we are yet.
  // plc unchanged
  return 1;
}

int 
file_rec::loopend(const char *s)
{
  if (!nloop) return 0;
  if (!s || strncmp(s,"&enddo",6)) return 0;
  if (workcount==l_spt[nloop-1])   //empty loop
    {
      l_spt.pop_back(); 
      l_ept.pop_back();
      lcount.pop_back();
      nloop--;
    }
  else
    {
      lcount[nloop-1]--;
      l_ept[nloop-1]=workcount;
      workcount=l_spt[nloop-1];
      if (plc<2)
	plc+=2;     //now reading from string
    }
  return 1;
}

int 
file_rec::question(const char *s)
  /* 
     returns 1 if a quesiton else 0
  */
{
  extern wback hold_;              // class item.
  int i;
  for(i=strlen(s)-1;i>0;i--)
    if(s[i]!=' ' || s[i]!='\n')
      break;
  if (i<1) return 0;
  if ((s[i]=='Q' || s[i]=='q') && s[i-1]=='&') 
    {      
      int j=0;
      int plus=0;
      for(int ii=0;ii<i-1 && s[ii] && j<79;ii++)
	{
	  if (!plus && s[ii]==' ') 
	    continue;
	  plus=1;
	  hold_.is[j]=s[ii];
	  j++;
	}    
      hold_.is[j]=0;
      querry=1;
      //      updatelist(hold_.is);   // increase the list 
      return 1;
    }
  return 0;
}

void
file_rec::write_elem(const char* cmdin) const
{
  if( (*outlist) )
      (*outlist) << cmdin <<endl;
  return;
}

int 
file_rec::needloop()
{
  if (active && !querry && plc) return 1;
  return 0;
}
				  

int
file_rec::getnextvalue(string& retstr)
  /*
    return 3 if part of a loop construct
    returns 2 as bank line
    returns 1 if no question
    returns 0 end of file / string
  */
{
  char s[256];
  if  (!nloop && !work)   //no loops no work!
    { 
      deactive();
      return 0;
    }

  // Two option : reading from string plc = 2,3
  //            : reading from file plc = 1
  // Output     : still reading from string
  //            : back to reading from file 
  //            : back to reading from cmdline
 
  workcount++;       // increase point in loop file must write or read from
  while (nloop && workcount == l_ept[nloop-1]) 
    {
      if (--lcount[nloop-1]<0)    //finishecd loop 
	{
	  lcount.pop_back();      //remove items from loop
	  l_spt.pop_back();
	  l_ept.pop_back();
	  nloop--;
	  workcount++;
	}
      else
	workcount=l_spt[nloop-1];  //set next start point
    }
  
  if (!nloop)
    {
      if (plc==2 || plc==3)
	plc-=2;
      if (!work || ! (*work) )  //file not active
	{
	  if (plc==1)
	    l_c("Finished Record File",1);
	  plc=0;
	  deactive();  // going out of scope
	  return 0;
	}
    }

  if (plc==2 || plc==3) //string stuff !!!!
    {
      //      const char *cc =(char *) worklist[workcount].c_str();
      retstr=worklist[workcount];  //return string in the worklist (copy of)
      if (question(worklist[workcount].c_str()))
	return 2;
      else
	return 1;
    }
  if (plc==1)  //read from file.
    {
      if (!work || ! (*work)) //file dead
	{
	  if (plc==1)
	    l_c("Finished Record File",1);
	  plc=0;
	  if (!nloop) 
	    deactive();  // going out of scope
	}
      else
	{
	  work->getline(s,256,'\n');  //read up to 256 char
      	  int inch=work->gcount();    //count + set 
	  if (inch<1)
	    return 3; //empty string
	  if (inch<255) 
	    s[inch]=0;
	  else
	    s[255]=0;

	  retstr=s;
	  unsigned int pos=retstr.find_first_not_of(" \t");
	  if (pos==std::string::npos)
	    return 3;  //empty string
	  if (pos)
	    retstr.erase(0,pos);  //remove leading junk...
	  if (nloop)
	    {
	      worklist.push_back(retstr);
	      totcount++;
	    }
	  if (question(retstr.c_str()))
	    return 2;
	  if (loopstart(retstr.c_str()))
	    return 3;     
	  else if (loopend(retstr.c_str()))
	    return 3;

	  return 1; 
	}
    }
  return 0;   //dead string
}   

void 
file_rec::deassign_loop()
{
  worklist=std::vector<std::string>(1,"");
  worklist.pop_back();   //ensure that the list is clear
  nloop=0;
  l_spt=std::vector<int>(1,0);
  l_ept=std::vector<int>(1,0);
  l_spt.pop_back();
  l_ept.pop_back();
  workcount=0;
  return;
}


void file_rec::deactive()
{
  active=0;
  worklist=std::vector<std::string>(1,"");   //give back the memory to worklist
  worklist.pop_back();   //ensure that the list is clear
  plc=0;
  
  return;
}

void file_rec::makeactive()
{
  active=1;
  worklist=std::vector<std::string>(1,"");
  worklist.pop_back();   //ensure that the list is clear
  nloop=0;
  l_spt=std::vector<int>(1,0);
  l_ept=std::vector<int>(1,0);
  l_spt.pop_back();
  l_ept.pop_back();
  if (plc>1) cout<<"Error initalising loops from string info"<<endl;
  totcount=0;
  workcount=0;
  return;
}















