#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream.h>
//#include <string.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "cmd.h"

// My Global functions, very un-C++ like but useful.

#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr
#define DSQR(a) ((tempr=(a)) == 0.0 ? 0.0 : tempr * tempr)

// Now need the foo__ functions for the g77 name mangler!

float ran_()
{  return ran(); }
float rani_(int *A)
{  return rani(A); }

void smosavg_(int* a,int* b,int *c,int *d,int *e)
{ smo_savg(*a,*b,*c,*d,*e); }

void find_width__()
{ find_width(); }

void sinft(double yy[],int *n)
{
  double *y= yy-1;
  int j,n2= *n+2;
  double sum,y1,y2;
  double theta,wi=0.0,wr=1.0,wpi,wpr,wtemp;
  theta=pi/(double) *n;
  wtemp=sin(0.5*theta);
  wpr= -2.0*wtemp*wtemp;
  wpi=sin(theta);
  y[1]=0.0;
  for (j=2;j<=(*n>>1)+1;j++)
    {
      wr=(wtemp=wr)*wpr-wi*wpi+wr;
      wi=wi*wpr+wtemp*wpi+wi;
      y1=wi*(y[j]+y[n2-j]);
      y2=0.5*(y[j]-y[n2-j]);
      y[j]=y1+y2;
      y[n2-j]=y1-y2;
    }
  realft(y, *n, 1);
  y[1]*=0.5;
  sum=y[2]=0.0;
  for(j=1;j< *n;j+=2)
    {
      sum+=y[j];
      y[j]=y[j+1];
      y[j+1]=sum;
    }
}


void realft(double data[],int n, int isign)
{
  int i,i1,i2,i3,i4,np3;
  double c1,c2,h1r,h1i,h2r,h2i;
  double wr,wi,wpr,wpi,wtemp,theta;
  c1=0.5;
  theta=pi/(double) (n >> 1);
  if (isign == 1)
    {
      c2= -0.5;
      four1(data,n>>1,1);
    }
  else
    {
      c2=0.5;
      theta = -theta;
    }
  wtemp=sin(0.5*theta);
  wpr= -2.0*wtemp*wtemp;
  wpi=sin(theta);
  wr=1.0+wpr;
  wi=wpi;
  np3=n+3;
  for (i=2;i<=(n>>2);i++)
    {
      i4=1+(i3=np3-(i2=1+(i1=i+i-1)));
      h1r=c1*(data[i1]+data[i3]);
      h1i=c1*(data[i2]-data[i4]);
      h2r= -c2*(data[i2]+data[i4]);
      h2i= c2*(data[i1]-data[i3]);
      data[i1]=h1r+wr*h2r-wi*h2i;
      data[i2]=h1i+wr*h2i+wi*h2r;
      data[i3]=h1r-wr*h2r+wi*h2i;
      data[i4]= -h1i+wr*h2i+wi*h2r;
      wr=(wtemp=wr)*wpr-wi*wpi+wr;
      wi=wi*wpr+wtemp*wpi+wi;
    }
  if (isign==1)
    {
      data[1]=(h1r=data[1])+data[2];
      data[2]=h1r-data[2];
    }
  else
    {
      data[1]=c1*((h1r=data[1])+data[2]);
      data[2]=c1*(h1r-data[2]);
      four1(data,n>>1,-1);
    }
}
     


void 
four1(double data[],int nn,int isign)
{
  double tempr,tempi;
  int m,mmax;
  int n= nn<<1;
  int j=1;
  for (int i=1;i<n;i+=2)
    {
      if (j>i)
	{
          SWAP(data[j],data[i]);
          SWAP(data[j+1],data[i+1]);
	}
      m=n>>1;
      while (m>=2 && j>m)
	{
          j-=m;
          m>>=1;
	}
      j+=m;
    }
  mmax=2;
  while (n>mmax) 
    {
      int istep=mmax << 1;
      double theta= isign * (6.28318530717959/mmax);
      double wtemp=sin(0.5*theta);
      double wpr = -2.0*wtemp*wtemp;
      double wpi=sin(theta);
      double wr=1.0;
      double wi=0.0;
      for (m=1;m<mmax;m+=2)
	{
          for(int i=m;i<=n;i+=istep)
            {
	      j=i+mmax;
	      tempr=wr*data[j]-wi*data[j+1];
	      tempi=wr*data[j+1]+wi*data[j];
	      data[j]=data[i]-tempr;
	      data[j+1]=data[i+1]-tempi;
	      data[i]+=tempr;
	      data[i+1]+=tempi;
            }
          wr=(wtemp=wr)*wpr-wi*wpi+wr;
          wi=wi*wpr+wtemp*wpi+wi;
	}
      mmax=istep;
    }
}


void
period(const int grp,const int grp2,int &topval,double &prob)
  /* Carries out a Laud transform on data 
     topval == max frequency value 
     prob == max likelyhood of a given value 
  */
{
  /* as in NR in C but ofac = 8 and hifac set to equal Np=4000
     hifac= 2 * maxpts / (ofac * stpnt) 
  */
  int ofac(8);
  const double two_pi(6.2831853071795865);
  const int mxpts(4000);
  double tempr;     //for use with DSQR
  extern Spec_In storage_;
  extern titls about_;

  double c,s,wtau;      //sin,cos, and T
  double sumsy,sumcy,sums,sumc;   //sums of cos and sin
  double cwtau,swtau;             // cos and sin of 2T
  double yy,cc,ss,sumsh;   //y^2,cos^2,sin^2
  double wtemp,expy,effm;

  int n = storage_.stpnt[grp];
  double *wi=new double[n];
  double *wpi=new double[n];
  double *wpr=new double[n];
  double *wr=new double[n];
  

  int nout = (int) (2.0 * mxpts / (ofac * n));
  while(ofac>0 && !nout)
    {
      ofac/=2;
      nout = (int) (2.0 * mxpts / (ofac * n));
    }
	
  nout *= n * (ofac / 2); // Does this give the correct reduce number

  double *px=new double[nout];
  double *py=new double[nout];      //place to put output

  if (n<2) return;
  double ave,var;
  avevar(n,storage_.story[grp],ave,var);  //get average and mean of variable.
  double xmin,xmax,xdif,xave;  //x values.
  xmin=xmax=storage_.storx[grp][0];
  for(int j=0;j<n;j++)
    {
      if (storage_.storx[grp][j] > xmax) xmax=storage_.storx[grp][j];
      if (storage_.storx[grp][j] < xmax) xmin=storage_.storx[grp][j];
    }
  xdif=xmax-xmin;
  xave=0.5*(xmax+xmin);
  
  double pymax = 0.0;
  double pnow  = 1.0/(xdif * ofac);
  double arg;
  for(int j=0;j<n;j++)
    {
      arg=two_pi * ((storage_.storx[grp][j]-xave)* pnow);
      wpr[j]= -2.0 * DSQR(sin(0.5*arg));
      wpi[j]=sin(arg);
      wr[j]=cos(arg);
      wi[j]=wpi[j];
    }
  for(int i=0;i<nout;i++)
    {
      px[i]=pnow;
      sumsh=sumc=0.0;
      for(int j =0;j<n;j++)
        {
          c=wr[j];
          s=wi[j];
          sumsh += s * c;
          sumc += (c-s) * (c+s);     //get tan(2t) 
        }
      wtau=0.5 * atan2(2.0*sumsh,sumc);
      swtau=sin(wtau);
      cwtau=cos(wtau);
      sums=sumc=sumsy=sumcy=0.0;
      for(int j=0;j<n;j++)
        {
          s=wi[j];
          c=wr[j];
          ss=s * cwtau- c * swtau;
          cc=c * cwtau+ s * swtau;
          sums += ss * ss;
          sumc += cc * cc;
          yy=storage_.story[grp][j]-ave;
          sumsy += yy * ss;
          sumcy += yy * cc;
          wr[j]=((wtemp=wr[j]) * wpr[j]- wi[j] * wpi[j])+wr[j];
          wi[j]= (wi[j]*wpr[j]+wtemp* wpi[j])+wi[j];
        }
      py[i]=0.5 * (sumcy * sumcy/sumc+sumsy * sumsy/sums)/var;
      if (py[i] >= pymax) pymax=py[i];
      pnow += 1.0/(ofac * xdif);
    }
  expy=exp(-pymax);
  effm=2.0*nout/ofac;
  prob=effm*expy;
  if (prob > 0.01) prob=1.0-pow(1.0-expy,effm);
  int k=nout-1;
  for(int i=0;i<nout;k--,i++)
    {
      storage_.storx[grp2][i]=1.0/px[k];
      storage_.story[grp2][i]=py[k];
      expy=exp(-py[k]);
      effm= 2.0* nout/ofac;
      prob= effm * expy;
      if (prob > 0.01) prob=1.0-pow(1.0-expy,effm);
      storage_.store[grp2][i]=prob;
    }
  storage_.stpnt[grp2]=nout;
  strcpy(about_.hd[grp2],"Laud ");
  strncpy(about_.hd[grp2]+5,about_.hd[grp],35);

  delete [] py;
  delete [] px;
  delete [] wr;
  delete [] wpr;
  delete [] wpi;
  delete [] wi;
  return;

}


void
avevar(const int n,double *data,double &ave,double &var)
  /* Gets the mean and the variance of a data set! as SD
     mode on a casio calculator. Code checked against 
     pg 617 of NR in C 
  */
{
  double s,ep(0.0);
  ave=0.0;
  for(int j=0;j<n;j++)
    ave+=data[j];
  ave/=n;
  var=0.0;
  for(int j=0;j<n;j++)
    {
      s=data[j]-ave;
      ep+=s;
      var+=s*s;
    }
  var=(var-ep*ep/n)/(n-1);
  return;
}



int
spline(const double* x,const double* y,const int* n,double* y2)
{
  int nn= *n;
  if (nn<1 || nn > 4000) return 0;
  int k;
  double p,sig;
  double *u=new double[nn];
  y2[0]=u[0]=0.0;

  int stp;
  double xm,xx,xp;
  double ym,yy,yp;
  for(stp=0;stp<nn-1 && x[stp]==x[stp+1];stp++);
 
  if (stp==nn-1)
    {
     delete [] u; 
     return 0;
    }
      
  xm=x[stp];
  ym=y[stp];
  yy=y[stp+1];
  xx=x[stp+1];
  int cf=1;  //number of points actually found
  for(int i=stp+1;i<nn-2;i++)
    {
      xp=x[i+1];
      yp=y[i+1];
      if (xp!=xx)    //no overlap
	{
	  sig=(xx-xm)/(xp-xm);
	  p=sig * y2[cf-1]+2.0;
	  y2[cf]=(sig-1.0)/p;
	  u[cf]=(yp-yy)/(xp-xm)-(yy-ym)/(xx-xm);
	  u[cf]=(6.0 * u[cf]/(xp-xm)-sig * u[cf-1])/p;
	  
	  cf++;
	  xm=xx;
	  xx=xp;
	  ym=yy;
	  yy=yp;
	}
    }

  y2[cf]=0.0; 
  for (k=cf-1;k>=0;k--)
    y2[k]=y2[k] * y2[k+1]+u[k];
  delete [] u;
  return cf;
}

double 
splint(double xa[],double ya[],double y2a[],const int npts,const double xx)
  /* The invers of a spline fit */
{
  if (npts<1) return 0.0;
  if (xx > xa[npts-1] || xx < xa[0]) return 0.0;
      
  int klo,khi,k;    
  double h,b,a;
      
  klo=0;
  khi= npts-1;
  while (khi-klo >1)
    {
      k=(khi+klo) >> 1;    // quick division by 2
      if (xa[k]>xx)
	khi=k;
      else
	klo=k;
    } 

  h=xa[khi]-xa[klo];
  while(h==0.0)
    {
      khi++;
      if (khi>=npts) return 0.0;
      h=xa[khi]-xa[klo];
    }

  a=(xa[khi]-xx)/h;
  b=(xx-xa[klo])/h;
  return a*ya[klo]+b*ya[klo+1]+
    ((a*a*a-a)*y2a[klo]+(b*b*b-b)*y2a[klo+1])*(h*h)/6.0;
} 
         
int 
polynom(const double* xcord,double* ycord,const int pnt,const int pp)
  /* x,y coords, number of points, polynominal power */
{
  if (pp<0) return -1;
  if (pnt<0) return -1;
  poly A(xcord,ycord,pnt,pp);
  A.chebypol();
  return 0;
}


template<class T,class V>
void index_sort(T* Arry,V *ind,const int num)
{
  /* job is to sort array Arry and then put the indexes in 
    index. 
    Tested explicitly for a set of doubles. 19/8/98 
  */

  if (num<2) return; //sorting done if only one atom!

  int i,ir,j,l,rind;
  T rra;
  V* index = ind-1;
  T* list = Arry-1;

  l=(num >> 1)+1;
  ir=num;
  for (;;)
    {
    if (l>1)
      {
      rind=index[--l];
      rra=list[l];
      }
    else
      {
      rra=list[ir];
      rind=index[ir];
      list[ir]=list[1];
      index[ir]=index[1]; 
      if (--ir == 1 )
        {
        list[1]=rra;
        index[1]=rind;
        break;
        }
      }
    i=l;
    j=l+l;
    while (j<=ir) 
      {
      if (j<ir && 
          list[j] < list[j+1])
             j++;
      if (rra < list[j])
        {
        index[i]=index[j];
        list[i]=list[j];
        i=j;
        j <<= 1;
        }
      else
        j=ir+1;
      }
      list[i]=rra;
      index[i]=rind;
    }

  return;
  }    
 

template void index_sort(double*,int*,const int);
template void index_sort(float*,int*,const int);

template<class T,class V>
void rev_sort(T* Arry,V *ind,const int num)
{
  /* job is to sort array Arry and then put the indexes in 
    index. 
    Tested explicitly for a set of doubles. 19/8/98 
  */

  if (num<2) return; //sorting done if only one atom!

  int i,ir,j,l,rind;
  T rra;
  V* index = ind-1;
  T* list = Arry-1;

  l=(num >> 1)+1;
  ir=num;
  for (;;)
    {
    if (l>1)
      {
      rind=index[--l];
      rra=list[l];
      }
    else
      {
      rra=list[ir];
      rind=index[ir];
      list[ir]=list[1];
      index[ir]=index[1]; 
      if (--ir == 1 )
        {
        list[1]=rra;
        index[1]=rind;
        break;
        }
      }
    i=l;
    j=l+l;
    while (j<=ir) 
      {
      if (j<ir && 
          list[j] > list[j+1])
             j++;
      if (rra > list[j])
        {
        index[i]=index[j];
        list[i]=list[j];
        i=j;
        j <<= 1;
        }
      else
        j=ir+1;
      }
      list[i]=rra;
      index[i]=rind;
    }

  return;
  }    
 

template void rev_sort(double*,int*,const int);
template void rev_sort(float*,int*,const int);

template<class T>
int
tiger_cage(const int pt,T** V,int *lt)

  /* This is not done properly because I should sort the list in
      decreasing y order. Then start at bottom, compare the 
      point that is next on the list and so on. */ 

{
  if (pt<3) return 0;
  int mnpt=0;
  double ymn;
  ymn=V[0][1];
  
  for(int i=1;i<pt;i++)        //get the minimum points
    {
      if (ymn>V[i][1])
	{
	  ymn=V[i][1];
	  mnpt=i;
	}
    }
  lt[0]=mnpt;
  T ptx,pty;
  ptx=V[mnpt][0];
  pty=V[mnpt][1];
  double sbx,sby;
  sbx=1.0;
  sby=0.0;
  T *angl = new T[pt-1];
  T *dang = new T[pt-1];
  int *angpt = new int[pt-1];
  T ang;
  int cpt=0;
  for(int i=0;i<pt;i++)
    {
      if (i==mnpt) continue;
      ang=V[i][0]-ptx;
      angl[cpt]=ang/sqrt(ang * ang+ (V[i][1]-pty) * (V[i][1]-pty));
      angpt[cpt]=i;
      cpt++;
    }
  index_sort(angl,angpt,pt-1);
  
  ang=angl[0];
  cpt=0;
  T angs;
  for(int i=1;i<pt;i++)
    {
      if (i<pt-1 && angl[i]==ang)
	{
	  cpt++;
	  angs=V[(angpt[i])][0]-ptx;
	  dang[cpt]=sqrt(angs * angs+ (V[angpt[i]][1]-pty) 
			 * (V[angpt[i]][1]-pty));
	}
      else if (cpt)
	{
          cpt++;
	  angs=V[(angpt[i-cpt])][0]-ptx;
	  dang[0]=sqrt(angs * angs+ (V[angpt[i-cpt]][1]-pty) 
			 * (V[angpt[i-cpt]][1]-pty)); 
	  rev_sort(dang,angpt+(i-cpt),cpt);
          cpt=0;
	}
      if(i<pt-1)
	ang=angl[i];

    }
  /* the above section correctly orders the points to use the algorithm.
     checked 21-12-98 
   */
  int id0=mnpt;
  int id1=angpt[0];
  int id2;
  int added=1;
  int count=2;
  lt[1]=id1;
  double Nvx,Nvy,Cvx,Cvy,cosbt,coschk;
  while(added<pt-1)
    {
      Nvx=V[id0][0]-V[id1][0];
      Nvy=V[id0][1]-V[id1][1];
      cosbt=sqrt(Nvx*Nvx+Nvy*Nvy);
      Nvx/=cosbt;
      Nvy/=cosbt;

      cosbt=1.2;    //need to keep getting bigger angle or stop.
      coschk=1.2;
      do
	{
          cosbt=coschk;
          id2=angpt[added];
	  Cvx=V[id2][0]-V[id1][0];
	  Cvy=V[id2][1]-V[id1][1];
          coschk=Cvx * Nvx + Cvy * Nvy;
	  coschk/=sqrt(Cvx * Cvx + Cvy * Cvy);
          added++;
	}
      while(added<pt-1 && coschk<=cosbt);
    if (coschk>=cosbt) 
      {
        added--;
        id0=id1;
        id1=angpt[added-1];        
	lt[count++]=id1;
      }
    }
  lt[count]=id2;
  delete [] angl;
  delete [] dang;
  delete [] angpt;

  return count+1;
}


template int tiger_cage(const int,float **,int*);

int 
get_next_char(char &out,char *ssin,int limit)
/* 
   Takes string ssin and finds the first character 
   which is sets to ' '. If limit is set it is used
   to prevent the search going over a unended string.
*/
{
  int i;
  for(i=0;i!=limit && (ssin[i]=='\t' || ssin[i]==' ');
		       i++);
  if (i==limit || !ssin[i]) 
    {
      out=' ';
      return 1;
    }
  out=ssin[i];
  ssin[i]=' ';
  return 0;
}

int 
get_first_letter(char &out,char *ssin,int limit)
/* 
   Takes string ssin and finds the first character 
   which is sets to ' '. If limit is set it is used
   to prevent the search going over a unended string.
*/
{
  for(int i=0;ssin[i] && i!=limit;i++)
    {
      if (isalpha(ssin[i]))
	{
	  out=toupper(ssin[i]);
	  if ( out=='E' ||             //mass line to avoid 1e6 problems
               (i>0 && i<limit) ||
	       !isdigit(ssin[i-1]) ||
               ssin[i+1]=='+' || ssin[i+1]=='-' ||
               isdigit(ssin[i+1]) )
	    {
	      ssin[i]=' ';
	      return i;
	    }
	}
    }
  out=' ';
  return 0;
}

int 
get_first_nonumb(char &out,char *ssin,int limit)
/* 
   Takes string ssin and finds the first character 
   which is sets to ' '. If limit is set it is used
   to prevent the search going over a unended string.
*/
{
  char hold(0);
  int snum= -1;
  for(int i=0;ssin[i] && i!=limit;i++)
    {
      if (hold)   //special case must be followed by .
	{
          if (isdigit(ssin[i]))      //alway return 0
	    {
	      out=' ';
	      return 0;
	    }
	  if (ssin[i]!='.' || hold=='.')
	    {
	      ssin[snum]=' ';
	      out=hold;
	      return snum;
	    }
	}
      else if (isdigit(ssin[i]))
	{
	  out=' ';
	  return 0;
	}
      else if (isalpha(ssin[i]))
	{
	  out=toupper(ssin[i]);
	  ssin[i]=' ';
	  return i;
	}
      else if (ssin[i]=='+' || ssin[i]=='-'
	       || ssin[i]=='.')
	{
	  hold=ssin[i];
	  snum=i;
	}       
      else if (!(ssin[i]=='\t' || ssin[i]==' '))  //isblank extension
         {
	   out=ssin[i];
	   ssin[i]=' ';
	   return i;
	  }
    }
  if (hold)
    {
      ssin[snum]=' ';
      out=hold;
      return snum;
    }
  out=' ';
  return 0;
}


float 
ran()
{
  static int ids = 77564453;
  return ran1(ids);
}

float 
rani(int *init)
{
  return ran1(*init,1);
}

float 
ran1(int &idum,const int start)
    
#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

{
  int j,k;
  static int iy=0;
  static int iv[NTAB];
  float temp;
    
  if ( idum<=0 || !iy || start)
    {
      if (-idum < 1) idum=1;
      else idum = -idum;
      for (j=NTAB+7;j>=0;j--)
	{
	  k=idum/IQ;
	  idum=IA*(idum-k*IQ)-IR*k;
	  if (idum<0) idum += IM;
	  if (j<NTAB) iv[j]=idum;
	}
      iy=iv[0];
    }
  k=idum/IQ;
  idum=IA * (idum-k * IQ)-IR * k;
  if (idum<0) idum += IM;
  j=iy/NDIV;
  iy=iv[j];
  iv[j]= idum;
  if ((temp=AM*iy)>RNMX) return RNMX;
  else return temp;
}


double 
polint(const double *xa,const double *ya, int n, double x)
{

  /*  Polynominal extrapolation routine, the idea is to give it a section
      of array in xa and ya, then an x coordinate (float x) and then number
      of points in the array. The prog fits the data to the n-polynominal
      and returns y at x.  */

  double y;
  int ns=0;
  double den,dif,dift,ho,hp,w;

  double *c=new double[n];
  double *d=new double[n];
  if (!d) error("No room for d in polint!!");

  dif=fabs(x-xa[0]);

  for(int i=0;i<n;i++)
    {
      if ((dift=fabs(x-xa[i]))<dif)
        {
	  ns=i;
	  dif=dift;
        }
      c[i]=d[i]=ya[i];
    }

  y=ya[ns--];

  for(int m=1;m<n;m++)
    {
      for(int i=0;i<n-m;i++)
	{
	  ho=xa[i]-x;
	  hp=xa[i+m]-x;
	  w=c[i+1]-d[i];
	  if ((den=ho-hp) ==0.0)
	    {
	      cout<<
		"Extreme caution :- Fatal error with fitting routine!!"
		  <<endl;
	      den= 1E-5;
	    }
	  den=w/den;
	  d[i]=hp * den;
	  c[i]=ho * den;
	}
      y+= (2 * (ns+1) < (n-m) ? c[ns+1] : d[ns--]);
    }
  delete[] c;
  delete[] d;
  return y;
}

void
replc(const char* sub,char *inv,const int remv,const int len)
{
  /* 
     Replaces the beginning of the string in inv, with sub,
     reajusting the length. len = length of string inv 
     ( can be omitted if inv is zero terminated )  
     remv = length of area to be removed 
     Assumes that removal area is longer than insertion.
   */
  int insert=strlen(sub);
  int diff=remv-insert;  //note :: can be negative!!
  int size = (len>0) ? len : strlen(inv);

  if (diff<0)
    {
      
      for(int i=size-1;i>=insert;i--)
	inv[i]=i+diff<size ? inv[i+diff] : 0;
    }
  else if (diff>0)
    {
      for(int i=0;i<size-diff;i++)
	inv[i]=inv[i+diff];
    }	

  for(int i=0;i<insert;i++)
    inv[i]=sub[i];

  return;
}

template<class T> int
cmdnumber(char *mc,T& num,const int len)
  /* returns 1 on success and 0 on failure */
{
  if (len<1) return 0;
  int i,j;
  j=0;

  for(i=0;i<len && mc[i] && 
	(mc[i]=='\t' || mc[i]==' '  || mc[i]==',');i++);
  if(i==len || !mc[i]) return 0;
  char *ss=new char[len+1];
  for(;i<len && mc[i]!='\n' && mc[i] 
       && mc[i]!='\t' && mc[i]!=' ' && mc[i]!=',';i++)
    {
      ss[j]=mc[i];
      j++;
    }
  if (!j)
    { 
      delete [] ss;
      return 0;         //This should be impossible
    }
  ss[j]=0;
  char **endptr=new char*;
  double nmb = strtod(ss,endptr); 
  if (*endptr != ss+j)
    {
      delete endptr;
      delete [] ss;
      return 0;
    }
  num = (T) nmb;
  for(int j=0;j<i && mc[j];j++)
    mc[j]=' ';
  delete endptr;
  delete [] ss;
  return 1;
}

template<class T> int
findnumber(const char *mc,T& num,const int len)
  /* returns number of char on success and 0 on failure 
     does not zero the text field */
{
  if (len<1) return 0;

  int spt,ept;
  for(spt=0;spt<len && mc[spt] && 
	(mc[spt]=='\t' || mc[spt]==' '  || mc[spt]==',');spt++);
  if(spt==len || !mc[spt]) return 0;
  for(ept=spt;ept<len && mc[ept]!='\n' && mc[ept] 
       && mc[ept]!='\t' && mc[ept]!=' ' && mc[ept]!=',';ept++);
  int length=ept-spt;
  char *ss=new char[length+1]; 
  strncpy(ss,mc+spt,length);
  char **endptr=new char*;
  double nmb = strtod(ss,endptr); 
  if (*endptr != ss+length)
    {
      delete endptr;
      delete [] ss;
      return 0;
    }
  num = (T) nmb;
  delete endptr;
  delete [] ss;
  return ept;
}


void 
error(char* s, char* s2)
{
  cerr << s << ' ' << s2 <<'\n';
  exit(1);
  return;
}

int 
userdint(const char* wrt,const int imax,const int imin)

{
  char s[255];
  int nmb;
  do {
    cout<<wrt<<endl;
    cout.flush();
    cin.getline(s,255,'\n');
    nmb = atoi(s);
  } while(nmb!=0 && (nmb<imin || nmb>imax));

  return nmb;
}

float 
userflt(const char* wrt,const float imax,const float imin)
{
  char s[255];
  float nmb;
  do {
    cout<<wrt<<endl;
    cout.flush();
    cin.getline(s,255,'\n');
    nmb = atof(s);
  } while(nmb!=0.0 && (nmb<imin || nmb>imax));
  
  return nmb;
}

int 
userint(const char* wrt,const int imax,const int imin)

{
  char s;
  int nmb;
  do {
    cout<<wrt<<endl;
    cin>>nmb;
    while (!cin)
      {
	cin.clear();  // Changed from cin.clear(0);
	cin>>s;
	cin>>nmb;
      }
  } while(nmb>imax || nmb<imin);
  return nmb;
}

double 
userdbl(const char* wrt,const double imax,const double imin)
{
  double nmb;
  do {
    cout<<wrt<<" ";
    cout.flush();
    nmb=0;
    if (!cin)
      {
	cin.clear();  // Changed from cin.clear(0);
	cin.ignore(255,'\n');
      }
    cin>>nmb;                  // try to remove item from stream
  } while(!cin || nmb<imin || nmb>imax);
  cin.ignore(255,'\n');
  return nmb;
}

template<class T> T 
unum(const char* wrt,const T imax,const T imin)
{
  T nmb;
  do {
    cout<<wrt<<" ";
    cout.flush();
    nmb=0;
    if (!cin)
      {
	cin.clear();  // Changed from cin.clear(0);
	cin.ignore(255,'\n');
      }
    cin>>nmb;                  // try to remove item from stream
  } while(!cin || nmb<imin || nmb>imax);
  cin.ignore(255,'\n');
  return nmb;
}

double 
userddbl(const char* wrt,const double imax,const double imin)
{
  double nmb=0;;
  cout<<wrt<<" ";
  cout.flush();
  cin>>nmb;
  
  while (!cin || (nmb!=0 && (nmb<imin || nmb>imax)))
    {
      cin.clear();
      cin.ignore(255,'\n');                    
      cout<<wrt<<" ";
      cout.flush();
      nmb=0;
      cin>>nmb;                  // try to remove item from stream
    }
  cin.ignore(255,'\n');
  return nmb;
}
       

template<class T> T 
unumd(const char* wrt,const T imax,const T imin)
{
  T nmb=0;;
  cout<<wrt<<" ";
  cout.flush();
  cin>>nmb;
      
  while (!cin || (nmb!=0 && (nmb<imin || nmb>imax)))
    {
      cin.clear(0);
      cin.ignore(255,'\n');                    
      cout<<wrt<<" ";
      cout.flush();
      nmb=0;
      cin>>nmb;                  // try to remove item from stream
    }
  cin.ignore(255,'\n');
  return nmb;
}
       
int 
Soft_strlen(const char* str,const int max_len)
  /* returns length of string excluding spaces */
{
  int k=0;
  for (int i=0;i<max_len;i++)
    {
      if (str[i]>' ')
        {
	  k=i+1;
        }
      if (str[i]<13) return k;
    }
  return max_len;
}



double** 
matrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  double *pv=new double[(m*n)];
  double **pd=new double*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

float** 
fmatrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  float *pv=new float[(m*n)];
  float **pd=new float*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

int** 
imatrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  int *pv=new int[(m*n)];
  int **pd=new int*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

void 
freematrix(int **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}

void 
freematrix(float **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}

void 
freematrix(double **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}


double ***
tensor(const int m,const int n,const int o)
{
  if (m<1) return 0;
  if (n<1) return 0;
  if (o<1) return 0;
  double ***T = new double**[m];
  if (!T) error("Insufficient memory for tensor");
  T[0]= new double*[(m*n)];
  if (!(*T)) error("Insufficient memory for tensor");
  T[0][0]=new double[(m*n*o)];
  if (!T[0][0]) error("Insufficient memory for tensor");
  int i;
  for (i=1;i<n;i++)
    T[0][i]=T[0][i-1]+o;
  for (i=1;i<n;i++)
    {
      T[i]=T[i-1]+n;
      T[i][0]=T[i-1][0]+ n*o;
      for (int j=1;j<n;j++)
	T[i][j]=T[i][j-1]+o;
    }
  return T;
}
    
void freetensor(double ***pd)
{
  delete [] **pd;
  delete [] *pd;
  delete [] pd;
  return;
}

/*
     Intend to get round to this some day!

    template<class T>
 
      class Array1d {
     
        public:
         
          T& operator[](int index);
          const T& operator[](int index)  const;
     
       };

    template<class T>
    class Array2d {
   
       public: 
         
*/         
void 
covsrt(double **covar,const int Fdim,int *in_use,const int act)
{
  double tempr;
  int k;
  for (int i=act;i<Fdim;i++)
    for(int j=0;j<=i;j++)
      covar[i][j]=covar[j][i]=0.0;
  k=act-1;
  for(int j=Fdim-1;j>=0;j--)
    {
      if (in_use[j])
	{
	  for(int i=0;i<Fdim;i++)
	    {
	      SWAP(covar[i][k],covar[i][j]);
	    }
	  for(int i=0;i<Fdim;i++)
	    {
	      SWAP(covar[k][i],covar[j][i]);
	    }
	  k--;
	}
    }
  return;
}

int 
gaussj(double** a,double* b,const int n)
  /* special case gauss jourden for b == 1 vector ,
     A== [n][n] */
{
  double* B[1];
  B[0]=b;  //set B[0]==address of b
  return gaussj(a,n,B,1);
}

int 
gaussj(double **a,const int n,double **b,const int m)
  /* Do a gauss jordan elimination A[1-n][1-n] is input 
     along with b[1-n][1-m] 
     a= inverse b=solution vectors
     return 1 on failure.
  */
{
  int *indxc=new int[n];
  int *indxr=new int[n];
  int *pivited=new int[n];
  double tempr;

  for(int j=0;j<n;j++)
    pivited[j]=0;        //haven't done any piviting yet.
  double big;
  int irow(0),icol(0);
  for(int i=0;i<n;i++)
    {
      big=0.0;            //get point to pivit over
      for(int j=0;j<n;j++)
	{
	  if (pivited[j]!= 1)  //check only non-pivits
	    for(int k=0;k<n;k++)
	      if (!pivited[k])
		{
		  if (fabs(a[j][k]) >=big)
		    {
		      big=fabs(a[j][k]);
		      irow=j;
		      icol=k;
		    }
		}
	      else if (pivited[k]>1)
		{
		  l_c("Error doing G-J elem on a singular matrix",1);
		  return 1;
		}
		    
	}
      pivited[icol]++;
      if (irow != icol)
	{
	  for(int l=0;l<n;l++)
	    { 
	      SWAP(a[irow][l],a[icol][l]);
	    }
	  for(int l=0;l<m;l++)
	    {
	      SWAP(b[irow][l],b[icol][l]);
	    }
	}
      indxr[i]=irow;
      indxc[i]=icol;
      if (a[icol][icol] == 0.0)
	{
	  l_c("Error doing G-J elem on a singular matrix",1);
	  return 1;
	}
      double pivdiv= 1.0/a[icol][icol];
      a[icol][icol]=1.0;
      for(int l=0;l<n;l++) 
	a[icol][l] *=pivdiv;
      for(int l=0;l<m;l++)
	b[icol][l] *=pivdiv;
      double div_num;
      for(int ll=0;ll<n;ll++)
	if (ll!=icol)
	  {
	    div_num=a[ll][icol];
	    a[ll][icol]=0.0;
	    for(int l=0;l<n;l++) 
	      a[ll][l] -= a[icol][l]*div_num;
	    for(int l=0;l<m;l++)
	      b[ll][l] -= b[icol][l]*div_num;
	  }
    }
  for(int l=n-1;l>=0;l--)
    {
      if (indxr[l] !=indxc[l])
	for(int k=0;k<n;k++)
	  {
	    SWAP(a[k][indxr[l]],a[k][indxc[l]]);
	  }
    }
  delete [] indxr;
  delete [] indxc;
  delete [] pivited;

  return 0;  
}


float gasdev()
{
  static int iset=0;
  static float gset;
  float fac,rsq,v1,v2;
       
  if (!iset) 
    {
      do {
	v1=2.0*ran()-1.0;
	v2=2.0*ran()-1.0;
	rsq=v1*v1+v2*v2;
      } while (rsq>= 1.0 || rsq ==0.0);
      fac=sqrt(-2.0*log(rsq)/rsq);
      gset=v1*fac;
      iset=1;
      return v2*fac;
    }
  else
    {
      iset=0;
      return gset;
    }
}


template<typename T> int
maxValueE(const T* V,const int N,T A,T B)
  /* return the max outside the values A,B 
   note cant get smart as list is not ordered */
{
  if (A==B) return -1;
  if (!V || N<1) return -1;
  if (A>B)
    {
      T temp=A;
      A=B;
      B=temp;
    }
  int pt= -1;
  T maxV;
  for(int i=0;i<N;i++)
    {
      if (V[i]<A || V[i]>B)
	{
	  if (pt<0 || maxV<V[i])
	    {
	      maxV=V[i];
	      pt=i;
	    }
	}
    }
  return pt;
}


template<typename T> int
maxValue(const T* V,const int N,T A,T B)
  /* return the max between the values A,B 
   note cant get smart as list is not ordered */
{
  if (A==B) return -1;
  if (!V || N<1) return -1;
  if (A>B)
    {
      T temp=A;
      A=B;
      B=temp;
    }
  int pt= -1;
  T maxV;
  for(int i=0;i<N;i++)
    {
      if (V[i]>A && V[i]<B)
	{
	  if (pt<0 || maxV<V[i])
	    {
	      maxV=V[i];
	      pt=i;
	    }
	}
    }
  return pt;
}

template<typename T> int
maxValue(const T* V,const int N)
{
  if (!V || N<1) return -1;
  T maxV=V[0];
  int pt=0;
  for(int i=1;i<N;i++)
    {
      if (maxV<V[i])
	{
	  maxV=V[i];
	  pt=i;
	}
    }
  return pt;
}

template<typename T> int
minValue(const T* V,const int N)
{
  if (!V || N<1) return -1;
  T minV=V[0];
  int pt=0;
  for(int i=1;i<N;i++)
    {
      if (minV>V[i])
	{
	  maxV=V[i];
	  pt=i;
	}
    }
  return pt;
}


template<class T>
int
xpos(const T V,const T* Array,const int npts)
  /* Job is to find the xpos in a sorted Arry that
     is closest to V)
  */
{
  if (npts<1) return 0;
  int ju,jm,jl;
  jl=0;
  ju=npts+1;
  while(ju-jl > 1)
    {
      jm=(ju+jl) >> 1;
      if (V >= Array[jm])
	jl=jm;
      else
	ju=jm;
    }
  
  if (V <= Array[0])
    return 0;
  else if (V >= Array[npts-1])
    return  npts-1;
  else 
    return jl;
}

int 
endchar(char *ss,const int ch_count)
{
  int i;
  for(i=ch_count-1;
         ss[i]!=',' &&
         ss[i]!=' '
	 ;i--);
  return i;
}

void
locate(int *xx,int n,int x,int *at)
  /* 
     locates a number in a series of xmin -- xmax 
     x is the input value, xx==array or length n 
  */

{
  int ju,jm,jl;
  jl=0;
  ju=n+1;
  while(ju-jl > 1)
    {
      jm=(ju+jl) >> 1;
      if (x >= xx[jm])
	jl=jm;
      else
	ju=jm;
    }
  
  if (x <= xx[0])
    *at=0;
  else if (x >= xx[n-1])
    *at= n-1;
  else 
    *at= jl;
  
  return;
}

int check_string(const char* fullString,const char* testString,const int n,
		 const int m)
  /* 
      returns the poistion of the first occurance of a string short in
       string long, or it returns zero :: '?' is the wild card char.
  */
{
  if(n<=0 || m<=0 || m>n) 
    return 0;

  for(int i=0;i<=n-m;i++)
    {
      int tht=0;
      while((testString[tht]=='?' || fullString[i+tht]==testString[tht]))
	{
	  tht++;
	  if (tht==m)
	    return i;
	}
    }
  return 0;
}

template int xpos(double,const double *,const int);
template int cmdnumber(char*,int&,const int);
template int cmdnumber(char*,float&,const int);
template int cmdnumber(char*,double&,const int);
template int findnumber(const char*,float&,const int);
template int findnumber(const char*,int&,const int);
template int findnumber(const char*,double&,const int);
template int maxValue(const double *,const int);
template int maxValue(const double *,const int,const double,const double);
template int maxValue(const int *,const int);
template int maxValueE(const double *,const int,const double,const double);







