#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream.h>
#include <string.h>
#include "extract.h"


int
zerofile(char* s,char* in,const int leng,const char zspc)
{
  int spt,l;
  if (!extractname(s,in,leng,spt,l))
    {
      for(int i=spt;i<spt+l;i++)
	in[i]=zspc;
      return 0;
    }
  return 1;
}

int 
middlewords(const char* in,int& a,int& b,const int len)
{
  int i;
  for(i=0;i<len && in[i]!=0 && 
	(in[i]==' ' || in[i]=='\t');i++);
  a=i;
  b=i;
  for(;i<len && in[i]!=0;i++)
    {
      if (in[i]!='\t' || in[i]!=' ')
	b=i;
    }
  return b-a;
}

int
extractword(char* c,const char *in,const int leng,int& start,int &len,
            int max_len,const int min_len)
  /* 
     extract the first word in the string in and  passes back 
     start and length of the string. returns 1 if no suitable
     string of length >=4 is found.
  */

{
  if (leng<4) return 1;
  if (max_len<1) max_len=leng;
  int i,j;
  for(i=0;i<leng && in[i] && in[i]==' ';i++);
  if (!in[i] || i==leng) return 1;
  for(j=i;j<leng && in[j] && 
        ((in[j]>='a' && in[j]<='z') ||
         (in[j]>='A' && in[j]<='Z') ||
	  in[j]=='\\' )
         ;j++);
    
  if (j-i<min_len) return 1;      //if the word is too short return fail;
  int k;
  for(k=0;k<j-i && k<max_len;k++)
    {
      if (in[k+i]>='A' && in[k+i]<='Z') 
        c[k]=in[k+i]-('A'-'a');
      else
        c[k]=in[k+i];
    }
  for(;k<4 && k<max_len;k++)
    c[k]=0;
  start=i;
  len=j-i;
  return 0;
}



int
extractfile(char *s,const char *in,const int leng)
{
  int spt,l;  //junk variables
  return extractname(s,in,leng,spt,l);
}

int
extractname(char* s,const char* in,const int leng,int &start,int &len,
	    int max_len)
  /* s is longest string with a A-z character in it 
      and zero it to  ' ' or zspc 
  in == input string
  leng == max length
  start == coordiante the the start 
  len == length of found string
  max_len == max possible length ot return
  */
{
   if (!max_len)
     max_len=leng+1;
   int c_start=0;
   int c_len=0;
   int b_len=0;
   int b_start=0;
   int i=0;
   while (i<=leng)
     {
       if (i!=leng && !in[i])   //prevent over access
	 i=leng;   //if zero finish
       if (i!=leng && in[i] && in[i]!=' ' && in[i]!=',')  //a proper char
	 if (!c_len)           //start of new word
	   {
	     c_start=i;
	     c_len=1;
	   }
	 else
	   c_len++;            //cont of word 
       else                    //not a good char
	 {
	   int only_number=1;
	   if (c_len>b_len)
	     {
	       for(int i=c_start;only_number && i<c_start+c_len;i++)
		 if (in[i]!='.' && in[i]!='+' &&
		     in[i]!='-' && in[i]!='e' && in[i]!='E'
		     && (in[i]<'0' || in[i]>'9') )
		   only_number=0;
	       if (!only_number)
		 {
		   b_len=c_len;
		   b_start=c_start;
		 }
	     }
	   c_len=0;
	 }
       i++;
     }
   if (b_len<3)
     {
       if (max_len>0) s[0]=0;
       return 1;
     }
   if (max_len>b_len)
     {
       strncpy(s,in+b_start,b_len);
       s[b_len]=0;
     }
   else
     strncpy(s,in+b_start,max_len);
   start=b_start;
   len=b_len;
   return 0;
}





