int
errfunc(double xi,double yi,double &u double v)

  /*  GIVEN A COMPLEX NUMBER Z = (XI,YI), THIS SUBROUTINE COMPUTES
  THE VALUE OF THE FADDEEVA-FUNCTION W(Z) = EXP(-Z**2)*ERFC(-I*Z),
  WHERE ERFC IS THE COMPLEX COMPLEMENTARY ERROR-FUNCTION AND I
  MEANS SQRT(-1).
  THE ACCURACY OF THE ALGORITHM FOR Z IN THE 1ST AND 2ND QUADRANT
  IS 14 SIGNIFICANT DIGITS; IN THE 3RD AND 4TH IT IS 13 SIGNIFICANT
  DIGITS OUTSIDE A CIRCULAR REGION WITH RADIUS 0.126 AROUND A ZERO
  OF THE FUNCTION.
  ALL REAL VARIABLES IN THE PROGRAM ARE DOUBLE PRECISION.


  THE CODE CONTAINS A FEW COMPILER-DEPENDENT PARAMETERS :
     RMAXREAL = THE MAXIMUM VALUE OF RMAXREAL EQUALS THE ROOT OF
                RMAX = THE LARGEST NUMBER WHICH CAN STILL BE
                IMPLEMENTED ON THE COMPUTER IN DOUBLE PRECISION
               FLOATING-POINT ARITHMETIC
     RMAXEXP  = LN(RMAX) - LN(2)
     RMAXGONI = THE LARGEST POSSIBLE ARGUMENT OF A DOUBLE PRECISION
                GONIOMETRIC FUNCTION (DCOS, DSIN, ...)
  THE REASON WHY THESE PARAMETERS ARE NEEDED AS THEY ARE DEFINED WILL
  BE EXPLAINED IN THE CODE BY MEANS OF COMMENTS


  PARAMETER LIST
     XI     = REAL      PART OF Z
     YI     = IMAGINARY PART OF Z
     U      = REAL      PART OF W(Z)
     V      = IMAGINARY PART OF W(Z)
     return   = AN ERROR FLAG INDICATING WHETHER OVERFLOW WILL
              OCCUR OR NOT; TYPE LOGICAL;
              THE VALUES OF THIS VARIABLE HAVE THE FOLLOWING
              MEANING :
              FLAG=.FALSE. : NO ERROR CONDITION
              FLAG=.TRUE.  : OVERFLOW WILL OCCUR, THE ROUTINE
                             BECOMES INACTIVE
  XI, YI      ARE THE INPUT-PARAMETERS
  U, V, FLAG  ARE THE OUTPUT-PARAMETERS

  FURTHERMORE THE PARAMETER FACTOR EQUALS 2/SQRT(PI)

  THE ROUTINE IS NOT UNDERFLOW-PROTECTED BUT ANY VARIABLE CAN BE
  PUT TO 0 UPON UNDERFLOW;

  REFERENCE - GPM POPPE, CMJ WIJERS; MORE EFFICIENT COMPUTATION OF
  THE COMPLEX ERROR-FUNCTION, ACM TRANS. MATH. SOFTWARE.

  */
{
  int a,b,flag;
  const double factor(1.12837916709551257388);
  const double rmaxreal(0.5D+154);
  const double rmaxexp(708.503061461606D0);
  const double rmaxgoni(3.53711887601422D+15);

  flag=0;
  double xabs=fabs(xi);
  double yabs=fabs(yi);
  double x=xabs/6.3;
  dobule y=yabs/4.4;

  if (xabs>rmaxreal || yabs>rmaxreal)  //overflow protection.
    return 1;

  double qrho = x*x+y*y;
  double xabsQ=xabs*xabs;
  double xquod = xabsQ - yabs*yabs;
  double yquod = 2*xabs*yabs;

  if (qrho<0.085264)  // condition to use power expansion.
    {
      qrho  = (1-0.85*y)*sqrt(qrho);
      int n = 6 + int(0.5+72*qrho);
      int j = 2*n+1;
      double xsum  = 1.0/j;
      double ysum  = 0.0;
      double xaux;
      for(int i=n;i>=1;i--)
	{
	  xaux = (xsum*xquad - ysum*yquad)/i;
	  ysum = (xsum*yquad - ysum*xquad)/i;
	  xsum = xaux+1.0/j;
	}
      u1   = -factor*(xsum*yabs + ysum*xabs) + 1.0;
      v1   =  factor*(xsum*xabs - ysum*yabs);
      daux =  exp(-xquad);
      u2   =  daux*cos(yquad);
      v2   = -daux*sin(yquad);
      u    = u1*u2 - v1*v2;
      v    = u1*v2 + v1*u2;
      return 0;
    }
  else
    {
      



}
