#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <list>
#include <string>
#include "wshare.h"
#include "cmd.h"
#include "extract.h"
#include "fglobal.h"
#include "editbox.h"
#include <Xm/ScrollBar.h>

void
GeneralEdit(char* ans)
{
  extern wback hold_;
  extern Spec_In storage_;
  extern titls about_;

  int grp,grp2,grp3;
  int flag=cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,grp2);
  if (flag==2) flag+=cmdnumber(hold_.is,grp3);
  char ss[255];

  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      sprintf(ss,"Group to edit =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  grp--;
  flag--;
  if (*ans=='H')   //Edit headers...
    {
      sprintf(ss,"Title Grp[%d] == ",grp);
      strncpy(ss+strlen(ss),about_.hd[tg],40);
      l_c(ss,1);
      strcpy(ss,"Enter new title =>");
      l_c(ss,0);
      int a,b;
      middlewords(ss,a,b,255);
      if (b-a>40)
	strncpy(about_.hd[grp],ss+a,40);
      else
	{
	  strncpy(about_.hd[grp],ss+a,b-a);
	  about_.hd[grp][b-a]=0;
	}
      return;
    }

  while(flag<2 || grp3<=1 || 
	grp3>maxpts)
    {
      flag=2;
      sprintf(ss,"Start point + length of edit =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp2) || !cmdnumber(ss,grp3)) 
	return;
    }
  int gp_pts=storage_.stpnt[grp];  //Init number of points
  double *X=storage_.storx[grp];   //X points 
  double *Y=storage_.story[grp];   //Y points 
  double *E=storage_.store[grp];   //E points 

  double ave_step= (gp_pts>1) ? (X[gp_pts-1]-X[0])/(gp_pts-1) : 1.0;
  int cntpt=grp3;  //Number of points left

  list<double> Yv;
  if (*ans=='X')
    {}
  else
    {
      int fullexit(0);
      do 
	{
	  double x1;
	  int icount;
	  sprintf(ss,"Enter %d points =>",cntpt);
	  l_c(ss,0);
	  string line(ss);
	  int exitline(0);
	  int nprocessed(0);
	  do 
	    {
	      unsigned int stpt=line.find_first_not_of("\t*, ");
	      unsigned int EndNum=line.find_first_of("\t*, ",stpt);
	      if (EndNum==string::npos)
		EndNum=line.length()-1;
	      if (stpt==string::npos ||
		  !findnumber(line.c_str()+stpt,x1,EndNum-stpt))
		{
		  exitline=1;
		  if (!nprocessed)
		    fullexit=1;
		}
	      else  //process to find out it next part is an 
		{
		  nprocessed++;   //We now have a least a part entry
		  line.erase(0,EndNum);
		  unsigned int multpt=line.find("*");
		  unsigned int nextN=line.find_first_not_of("\t*, ");
		  if (multpt<nextN) //mult on this sector
		    {
		      EndNum=line.find_first_of("\t*, ",nextN);
		      if (EndNum==string::npos)
			EndNum=line.length()-1;
		      if (findnumber(line.c_str()+nextN,icount,EndNum-nextN))
			for(int i=0;i<icount && cntpt>0;i++)
			  {
			    cntpt--;  //total to do.
			    Yv.push_back(x1);
			  }
		      line.erase(0,EndNum);
		    }
		  else
		    {
		      Yv.push_back(x1);
		      cntpt--;
		    }
		}
	    } while(cntpt>0 && !exitline);
	} while(cntpt>0 && !fullexit);

      int npts=Yv.size();
      double *Xn=new double[maxpts];
      double *Yn=new double[maxpts];
      double *En=new double[maxpts];

      if (grp2>gp_pts)
	grp2=gp_pts;
      else if (grp2 <= -npts)
	grp2= -npts;
      else 
	grp2--;

      int index=(grp2<0) ? grp2 : 0;

      int total(0);
      npts+=grp2;  //save doing it later.
      for(int i= index;(i<npts || 
	    i<gp_pts) && total<maxpts;i++)
	{
	  *Xn++ = (i<0 || i>=gp_pts) ? i*ave_step : X[i]; 
	  if (i<grp2 || i>=npts)
	    *Yn++ = Y[i];
	  else
	    {
	      *Yn++ = Yv.front();
	      Yv.pop_front();
	    }
	  *En++ = (i<0 || i>=gp_pts) ? 0.0 : E[i];
	  total++;
	}
      Xn-=total;
      Yn-=total;
      En-=total;
      for(int i=0;i<total;i++)
	{
	  X[i]=Xn[i];
	  Y[i]=Yn[i];
	  E[i]=En[i];
	}
      delete [] Xn;
      delete [] Yn;
      delete [] En;
      storage_.stpnt[grp]=total;
    }
  return;
}



extern XtAppContext  app;
extern Widget top,text_w,main_w;    

void 
editbox::exit_edit(Widget w,XtPointer client_data,XtPointer call_data)
{
  cout<<"Cancel editbox called ILLIGAL OPPERATION"<<endl;
  editbox *THIS=static_cast<editbox*>(client_data);
  THIS->madebox=0;
  return;
}


editbox::editbox() : 
  madebox(0)
{}

editbox::~editbox()
{
  if (madebox)
    {
      madebox=0;
      XtDestroyWidget(ebox);
    }
}

void
editbox::make_edit()
{
  if (madebox)
    {
      XtPopup(ebox,XtGrabNone);
      return;
    }
  
  ebox=
    XtVaCreatePopupShell("EditBox",
			 topLevelShellWidgetClass,main_w,
			 XtNtitle, "Editing Window",
			 XmNdeleteResponse,XmDESTROY,
			 NULL);

  Widget mwind=
    XtVaCreateManagedWidget("EditInner",
			    xmMainWindowWidgetClass,ebox,
			    XtNtitle, "Edit Window",
			    NULL);

    men_item Edit_menu[] = {
    { "Exit", &xmPushButtonGadgetClass, 'E', 0,0,
      exit_edit, (XtPointer) this,  (men_item*) 0 },
    {0,}
  }; 

  Widget menu_bar=XmCreateMenuBar(mwind,"menubar",NULL,0);
  BuildPulldownMenu(menu_bar,"File",'F',0,Edit_menu,0);
  XtManageChild(menu_bar);

  
  Widget rowtwo=
    XtVaCreateWidget("aform",xmFormWidgetClass,mwind,
		     NULL);

  
  Xval=XtVaCreateManagedWidget("Xcolm",
			       xmTextWidgetClass,rowtwo,
			       XmNrows, 10,
			       XmNcolumns, 20,
			       XmNresizeHeight, False,
			       XmNresizeWidth, False,
			       XmNeditMode, XmMULTI_LINE_EDIT,
			       XmNeditable, True,
			       XmNleftAttachment,XmATTACH_FORM,
			       XmNtopAttachment,XmATTACH_FORM,
			       NULL);


  Yval=XtVaCreateManagedWidget("Ycolm",
			       xmTextWidgetClass,rowtwo,
			       XmNrows, 10,
			       XmNcolumns, 20,
			       XmNresizeHeight, False,
			       XmNresizeWidth, False,
			       XmNeditMode, XmMULTI_LINE_EDIT,
			       XmNeditable, True,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,Xval,
			       XmNtopAttachment,XmATTACH_FORM,
			       XmNbottomAttachment,XmATTACH_FORM,
			       NULL);
  Eval=XtVaCreateManagedWidget("Ecolm",
			       xmTextWidgetClass,rowtwo,
			       XmNrows, 10,
			       XmNcolumns, 20,
			       XmNresizeHeight, False,
			       XmNresizeWidth, False,
			       XmNeditMode, XmMULTI_LINE_EDIT,
			       XmNeditable, True,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,Yval,
			       XmNtopAttachment,XmATTACH_FORM,
			       XmNbottomAttachment,XmATTACH_FORM,
			       NULL);
  Widget ScrBar = XtVaCreateManagedWidget("Sbar",
			       xmScrollBarWidgetClass,rowtwo,
			       XmNmaximum, 100,
			       XmNsliderSize, 20,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,Eval,
			       XmNtopAttachment,XmATTACH_FORM,
			       XmNbottomAttachment,XmATTACH_FORM,
			       NULL);

  XtManageChild(rowtwo);
  
  XtManageChild(ebox);
  XtPopup(ebox,XtGrabNone);
  return;
}







