#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include <map>
#include "fglobal.h"
#include "fortran.h"
#include "cmd.h"
#include "wshare.h"
#include "npic.h"
#include "baseGraph.h"
#include "axis.h"
#include "spacebox.h"
#include "space.h"
#include "new_read.h"
#include "frame.h"
#include "box_plot.h"
#include "gaussbox.h"
#include "editbox.h"
#include "fileselect.h"
#include "svd.h"
#include "words.h"
#include "readfunc.h"
#include "help.h"


void
main_control(int& dtype,char a,char b,int aa,int bb,int cc)
/*
   Main control sorting     
 */
{
  extern Frame plook;    
  extern wback hold_;
  extern gauss gauss_box;
  extern fselect file_box;
  extern words fullcmd;
  editbox Ebox;

  switch(a)
    {
    case 'A':
      plook.setaxis(&b);
      return;
    case 'B':
      if (b=='S')
	fullcmd.set_wordlen(aa);
      else if(b=='B')
        hold_.graph_flag=2;
      else if (b=='R')
        hold_.graph_flag=3;
      else if (b=='X')
	hold_.graph_flag=4;
      else
	hold_.graph_flag=1;
      return;
    case 'C':
      plook.cursor(b);
      return;
    case 'D':
      if (b=='C') 
	cdat(dtype,aa);
      else if (b=='X')
	bin_pic(aa);
      else if (b=='Y')
	special();
      else
	getdata(dtype,b,aa,bb,cc);
      return;
    case 'E':
      if (b=='E')
	{
	  Ebox.make_edit();
	  return;
	}
      GeneralEdit(&b);
      //      edit_(&b,&aa,&bb,&cc);
      return;
    case 'F':
      if (b=='E')
	inteprate(&aa,&bb,&cc);
      else if(b=='G')
	gaussfit(&b);
      return;
    case 'G':
      if (b=='F')
        endby();
      //      else if (b=='H')
      //        setgamma();       
      else if (b=='W') 
	find_width();
      else
	gaussfit(&b);
      return;
    case 'H':
      if (b==' ')
	get_first_nonumb(b,hold_.is,80);
      help(b,dtype);
      //      help_(&b,&dtype);
      return;
    case 'I':
      if(b=='C' || b=='M' || b=='K')  
	p2(b);
      else 
	sums(&b);
      return;
    case 'J':
      if(b=='G') 
	gauss_box.make_wind();
      else if (b=='F')
	file_box.makebox();
      else if (b=='A')
	plook.make_wind();
      else
	wind_fit(aa,bb);
      return;
    case 'L':
      l_c("Entering debug territory .... ",1);
      check_history();
      return;
    case 'K':
      plook.redraw(1);
      return;
    case 'M':
      move(b);
      return;
    case 'N':
      norm(b);
      return;
    case 'O':
      output(b);
      return;
    case 'Q':
      qspace(&b);
      return;
    case 'P':
      plook.plotfn(&b);
      return;
    case 'R':
      if (b=='A') 
	smoof();
      else
	cmd_rebin(b);
      return;
    case 'S':
      SwapGrps(&b);
      return;
    case 'T':
      transf(&b,&aa,&bb);
      return;
    case 'U':
      output_cont(&b);
      return;
    case 'V':
      history(&b);
      return;
    case 'W':
      grp_ops(b);
      return;
    case 'X':
      if (b=='W' || b=='V')
	window_func(&b);
      else 
	self(b);
      return;
    case 'Y':
      if (b=='L')
	svdpoly();
      else
	polfit();
      return;
    default:
      return;
    }
  return;
}

void
cont_adds(char a,char b)
/*
     This is the control program for setting all the ploting defaults
     in addition it deals with all of the calls to text, boxes, 
     cursor calls to change and edit things. It also requires its own
     help

     NOTE: This is all independent of any 3d plotting proceedures */
{
  extern Frame plook;
  extern wback hold_;

  if (plook.select_window()) return;
  switch(a) 
    {
    case 'A':
      plook.setaxis(&b);
      break;
    case 'B':
      plook.do_box(b);
      break;
    case 'C':

      break;
    case 'D':
      plook.clear_obj(b);
      break;
    case 'E':
      plook.edit_item(b);      
    case 'F':
       break;      
    case 'H':
      graph_help(b);
      //      graph_help__(&b);
      break;
    case 'I':
      break;
    case 'K':
      //      bsa.keep();
      break;
    case 'L':
      plook.do_line(b);
      break;

    case 'M':
      plook. move(b);
      break;
    case 'O':
      break;
    case 'P':
      plook.plotfn(&b);
      break;
    case 'R':
      plook.read();
      break;
    case 'S':
      break;

    case 'T':
      plook.do_text(b);
      break;
 
    case 'V':
      break;

    case 'X':
      break;

    case  'W':
      plook.write(b);
      break;
    case 'Z':
      hold_.graph_flag=0;
    }
  return;
} 

void
exafs(char a,char b,int aa,int bb,int cc)
{
  extern Picture oneD;
  extern Frame plook;
  extern wback hold_;
  extern decompose single;

  switch(a) 
    {
    case 'A':
      plook.setaxis(&b);
      break;
    case 'C':
      //      oneD.Draw();
      //      oneD.linespectra(1,1,1,0.9);
      break;
    case 'D':
      break;
    case 'F':
      single.setup(b);
      single.runsvd();
      break;      
    case 'H':
      exafs_help(b);
      //      exafs_help__(&b);
      break;
    case 'I':
      break;
    case 'K':
      break;
    case 'M':
      wave_strip(&b);
      break;
    case 'O':
      break;
    case 'P':
      plook.plotfn(&b);
      break;
    case 'Q':
      if (b=='K' || b=='k')
	b='K';
      else
	b='X';
       qspace(&b);
      break;
    case 'R':
      break;
    case 'S':
      SwapGrps(&b);
      break;
    case 'T':
      if (b==' ')
	b='X';
      transf(&b,&aa,&bb);
      break;
    case 'V':
      wave_smoo(&b);
      break;
    case 'W':
      grp_ops(b);
      break;
    case 'X':
      break;
    case  'Y':
      break;
    case 'Z':
      hold_.graph_flag=0;
    }
  return;

}
void
rmcplots(char a,char b,int aa)
{

  extern wback hold_;
  extern Box_Screen bsa;
  //  char gv= (*b>='a' && *b<'z')  ? *b+('A'-'a') : *b;
  switch(a) 
    {
    case 'A':
      bsa.set_axis(b,aa);
      break;
    case 'C':
      break;
    case 'D':
      if(b=='R') 
	bsa.read_rmc(1,aa);
      else
	bsa.read_rmc(0,aa);
      break;
    case 'H':
      rmc_help(b);
      //      rmc_help__(&b);
      break;
    case 'I':
      break;
    case 'F':
       break;      
    case 'K':
      bsa.keep();
      break;

    case 'O':
      break;
    case 'P':
      if (b=='O')
	bsa.draw_region(aa,0);
      else
	bsa.draw_region(aa,0);
      break;
    case 'R':
      bsa.set_rscale(b);
      break;
    case 'S':
      break;

    case 'T':
      break;
 
    case 'V':
      bsa.set_viewpt(b);
      break;

    case 'X':
      break;

    case  'W':
      break;
    case 'Z':
      hold_.graph_flag=0;
    }
  return;

}

void 
twodplots(char a,char b,int aa,int bb,int cc)
{

  extern wback hold_;
  extern bin_file sd;
  extern Frame plook;
  //  extern Box_Screen bsa;

  char tt;
  switch(a) 
    {
    case 'A':
      if (b=='S') 
	sd.square();
      else if (b=='I')
	sd.intensity();
      else
	sd.twoaxis(b);
      break;
    case 'C':
      if (b=='V') 
	{
	  sd.arm_v_cursor();
	  break;
	}
      if (b=='M')
	{
	  sd.arm_v_cursor(1);
	  break;
	}
      plook.cursor(b);
      break;
    case 'D':
      if(b=='A') ascii_pic();
      if(b=='I') esrf_pic(1); 
      if(b=='E') esrf_pic(0);
      if(b=='F') fit2d_pic();
      if(b=='G') bin_gadds(&aa,&bb,&cc);  // cc ignored
      if(b=='S') bin_pic(1,0); 
      if(b=='X') bin_pic(0,0);
      break;
    case 'F':
      if(b=='P') 
	sd.polar(aa);
      else if (b=='V')
	sd.corr_values();
      else if (b=='M')
	sd.make_menu();
      else
	sd.corr_space(b);
      break;      
    case 'H':
      twod_help(b);
      break;
    case 'I':
      if (b=='N') 
	{
	  sd.new_set_intarv();
          return;
	}
      if (b=='V') 
	{
	  sd.set_intarc();
          return;
	}
      if (b=='X') 
	{
	  sd.set_intblock(0);
          return;
	}
      if (b=='Y')
	{
	  sd.set_intblock(1);
          return;
	}
      sd.set_intregion();
      break;
    case 'K':
      sd.keep();
      break;
    case 'N':
      sd.renorm(b,aa,bb);      
      break;
    case 'O':
      if (b=='C')
	sd.close();
      else
	sd.write_data(b,aa,bb,cc);
      break;
    case 'P':
      plook.plotfn(&b);
      break;
    case 'R':
      if (b=='C')
	{
	  get_first_nonumb(tt,hold_.is,80);
 	  sd.re_centre(tt,bb);
          break;
	}
      if (b=='F')
	{
	  get_first_nonumb(tt,hold_.is,80);
	  sd.flip(tt,aa);
          break;
	}
      if (b=='O') 
	{
	  get_first_nonumb(tt,hold_.is,80);
	  sd.roll(tt);
	  break;
	}
      if (b=='T')
	{
	  sd.rotate();
	  break;
	}
      sd.rebin(b);
      break;
    case 'S':
      if (b=='C')
	sd.copy(aa,bb);      
      if (b=='E')
	sd.enhance(aa,bb);
      if (b=='M')
	sd.smooth(aa,bb);
      break;

    case 'T':
      sd.set_trans(aa);         //not implemented
      break;
 
    case 'V':
      sd.set_values(b);        
      break;


    case  'W':
      if (b=='A')
	sd.spec_ops(&b,0);
      if (b=='M')
        sd.spec_ops(&b,1);
      if (b=='T')
        sd.spec_ops(&b,2);
      if (b=='D')
        sd.spec_ops(&b,3);
      break;
    case 'X':
      sd.selfop(b,aa,bb,cc);
      break;
    case 'Z':
      hold_.graph_flag=0;
    }
  return;

}








