#include <vector>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include "cmd.h"
#include "fglobal.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"


Draw_Method::Draw_Method() : Curs_Screen(),screen(0),
  print_fig(0),p_count(1)
{
}

Draw_Method::~Draw_Method()
{}

void
Draw_Method::clear_picture()
  /* This also resets all the plotting parameters */
{
  float x1,x2,y1,y2;
  cpgsls(1);
  cpgscf(2);
  cpgsch(1.0f);
  cpgslw(1);
  cpgpage();
  cpgvstd();
  cpgqvp(1,&x1,&x2,&y1,&y2);   //1 == units
  x2+=x1;
  x1=0.0;
  y2+=y1;
  y1=0.0;
  if (0.707*(x2-x1) > y2-y1)
    {
      x2=(y2-y1)/(0.707*(x2-x1));
      y2=1.0;
    }
  else
    {
      y2=0.707*(x2-x1)/(y2-y1);
      x2=1.0;
    }
  x1=x2*bord[0];
  x2*=bord[1];
  y1=y2*bord[2];
  y2*=bord[3];
  cpgsvp(x1,x2,y1,y2);
    
}

int
Draw_Method::select_window()
{
  if (!screen)
    {
      screen=make_fullscreen();
      if (!screen) 
	{
	  l_c("Error with Plotting device",1);
	  return 1;
	}
      cpgask(0);
      cpgscr(0,1.0,1.0,1.0); 
      cpgscr(1,0.0,0.0,0.0);
    }
  cpgslct(screen);
  return 0;   
}
 

void
Draw_Method::header_draw(GraphItem &A) 
// Draw Error bars on a plot graph
{
  extern titls about_;    
  cpgsci(A.colour);  
  cpgsls(1);         //set line for error bar
  cpgsch(A.size);
  cpgscf(A.ltype);
  cpgsfs(1);       //set fill style
  cpgslw(1);       //line width!!
  char words[41];
  strncpy(words,about_.hd[A.grp],40);
  words[40]=0; 
  float x1=(aval[0]+aval[1])/2.0;  //central in x
  float y1=aval[3]+(aval[3]-aval[2])*0.05;  
  cpgptxt(x1,y1,0.0,0.5,words);  //0 deg, centred.
  return;
}

void
Draw_Method::error_draw(GraphItem &A) 
// Draw Error bars on a plot graph
{
  extern Spec_In storage_;

  int count=2;
  float tempx[2];
  float tempy[2];
  const int grp(A.grp);
  cpgsci(A.colour);  
  cpgsls(1);         //set line for error bar
  cpgslw((int) A.size);

  for (int i=0;i<storage_.stpnt[grp];i++)
    {
      if (!log_flag[0])
	tempx[0]=tempx[1]=storage_.storx[grp][i];
      else 
        tempx[0]=tempx[1]=log10(fabs(storage_.storx[grp][i]));
      if (!log_flag[1])
	{
	  tempy[0]=storage_.story[grp][i]+storage_.store[grp][i];
	  tempy[1]=storage_.story[grp][i]-storage_.store[grp][i];
	}
      else
	{
	  tempy[0]=
	    log10(fabs((storage_.story[grp][i]+storage_.store[grp][i])));
	  tempy[1]=
	    log10(fabs((storage_.story[grp][i]-storage_.store[grp][i])));
	}
      if (tempx[0]>aval[0] && tempx[1]<aval[1])
	{
	  if (tempy[0]>aval[3]) tempy[0]=aval[3];
	  if (tempy[1]<aval[2]) tempy[0]=aval[2];
	}
      cpgline(count,tempx,tempy);
    }
  return;
}

void
Draw_Method::setcolour(const int col) const
{
  cpgsci(col);
}

void 
Draw_Method::line_draw(GraphItem &A) const
{
  extern Spec_In storage_;

  int line;
  cpgsci(A.colour);  
  if (A.ltype>0)
    {
      cpgsls(A.ltype);         //set line for error bar
      line=0;
    }
  else
    {
      line= -1 * A.ltype;
    }
  cpgslw((int) A.size);
  const int grp(A.grp);

  int ct=0;
  float *tx=new float[storage_.stpnt[grp]];
  float *ty=new float[storage_.stpnt[grp]];
  double ymcut=aval[2]-5.0*(aval[3]-aval[2]);  //needed due to error with
  double yxcut=aval[3]+5.0*(aval[3]-aval[2]);  //division in pgplot.


  for (int i=0;i<storage_.stpnt[grp];i++)
    {
      if (!log_flag[0])
	tx[ct]=(float) storage_.storx[grp][i];
      else 
        tx[ct]= (float) log10(fabs(storage_.storx[grp][i]));
      if (!log_flag[1])
	{
	  ty[ct]=storage_.story[grp][i];
	}
      else
	{
	  ty[ct]= (float)
	    log10(fabs(storage_.story[grp][i]));
	}
      if (tx[ct]>aval[0] && tx[ct]<aval[1] &&
	  ty[ct]>ymcut && ty[ct]<yxcut)
	ct++;
    }

  if (ct) 
    {
      if (!line)
	cpgline(ct,tx,ty);
      else
	cpgpt(ct,tx,ty,line);
    }
  delete [] tx;
  delete [] ty;
  return;
}


void 
Draw_Method::realise_axis()
{
  cpgslw(1);
  cpgsci(1);
  cpgsch(1.0);
  cpgswin(aval[0],aval[1],aval[2],aval[3]);
  float y1,y2;

  int xc(0),yc(0);
  int pt=1;
  char inschar[]="ABC STVN";
  char xch[12];

  for(int i=0;i<8;i++)
    {
      if (aflag[0] & pt) 
	{
	  xch[xc]=inschar[i];
	  xc++;
	}
      pt*=2;
    }

  if (log_flag[0])
    xch[xc++]='L';

  xch[xc]=0;
  if (atick[0]<=0) 
    y1=0.0;
  else // if (!log_flag[0])
    y1= (float) ((aval[1]-aval[0]) / atick[0]);


  if (atick[2]<=0) 
    y2=0.0;
  else
    y2= (float) ((aval[3]-aval[2]) / atick[2]);


  if (8 & aflag[0])
    {
      cpgsls(2);
      cpgbox("G",y1,atick[1],"",y2,atick[3]);
    }
  cpgsls(1);
  float f1=(float) num_size[0];
  cpgsch(f1);
  cpgbox(xch,y1,atick[1],"",y2,atick[3]);


  pt=1;
  for(int i=0;i<8;i++)
    {
     if (aflag[1] & pt) 
	{
	  xch[yc]=inschar[i];
	  yc++;
	}
      pt*=2;
    }
  if (log_flag[1])
    xch[yc++]='L';

  xch[yc]=0;
  if (8 & aflag[1])
    {
      cpgsls(2);
      cpgbox("",y1,atick[1],"G",y2,atick[3]);
    }
  f1=(float) num_size[1];
  cpgsch(f1);
  cpgsls(1);
  cpgbox("",y1,atick[1],xch,y2,atick[3]);

  return;

}

void
Draw_Method::close_print()
{
  if(print_fig)
    {
      cpgslct(print_fig);
      cpgclos();
      print_fig=0;
    }
  if (screen)
    cpgslct(screen);
  return;
}

int 
Draw_Method::open_print(const char *str)
{
  char s[256];
  if (print_fig)
    {
      cpgslct(print_fig);
      cpgclos();
      print_fig=0;
    }
  if (!str)
    {
      sprintf(s,"plot_%d.ps/cps",p_count);
      print_fig=cpgopen(s);
    }
  else
    print_fig=cpgopen(str);

  if (!print_fig)
    {
      l_c("Error opening print file",1);
      if (screen)
	cpgslct(screen);
      return 1;
    }
  cpgscf(2);  
  cpgslct(print_fig);

  if (!str)
    {
      sprintf(s,"Plotting to files plot_%d.cps",p_count);  
      p_count++;
    }
  else
    sprintf(s,"Plotting to str");
  l_c(s,1);
  return 0;
}







