#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "fortran.h"
#include "cmd.h"
#include "extract.h"
#include "readfunc.h"

int calc_offset(int &);

void 
getdata(const int dtype,char ans,int grp,int grp2,int grp3)
{
  switch(dtype)
    {
    case 1:
      readin(ans);
      return;
    case 2:
      readfour(ans);
      return;
    case 3:
      readdcs(ans);
      return;
    case 4:
      readgenie();
      return;
    case 5:
      readxye(ans);
      return;
    case 6:
      readxray();
      return;
    case 7:    
      //      superin_(&grp,hold_.is);
      return;
    case 8:    
      readXrayWF(ans);
      return;
    case 9:    
      select_col(ans);
      return;
    case 10:    
      bin_xray(&grp,&grp2,&grp3);
      return;
    case 11:    
      select_scan(ans);
      return;
    default:
      return;
    }
}


void
cdat(int &dtype,int grp)
{
  const int sel(11);  //max number of different parameters.
  if (grp>sel || grp<1) 
    {
      l_c("Multiple X,Y,Z on one line, text=one line ----  1",1);
      l_c("Fourbris style, text=line 2 ------------------  2",1);
      l_c("Read in DCS data -----------------------------  3",1);
      l_c("Read in genie data ---------------------------  4",1);
      l_c("Read in x,y (e), specifing header lines ------  5",1);
      l_c("Read in Semians X-Ray data format ------------  6",1);
      l_c("Read in WAXD data format ---------------------  7",1);
      l_c("Read in 5 col data format (two group output)--  8",1);
      l_c("Read in any col, grp_in,x,y col data ---------  9",1);
      l_c("Read Darsbury bin data from param file ------  10",1);
      l_c("Read ESRF scan files  -----------------------  11",1);
      while (grp>sel || grp<1) 
	{
	  char ss[256];
	  sprintf(ss,"Enter default read in function =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,grp)) return;
	}
    }
  dtype=grp;
  set_file_func(dtype);
  return;
}


double
getvax_num(const float A)
{
  union 
   {
     char a[4];
     float f;
     int ival;
   } Bd;

  Bd.f=A;
  int sign  = (Bd.ival & 0x8000) ? -1 : 1;
  int expt = ((Bd.ival & 0x7f80) >> 7);   //reveresed ? 
  if (!expt) return 0.0;
  int fmask = ((Bd.ival & 0x7f) << 16) | ((Bd.ival & 0xffff0000) >> 16);
  expt-=128;
  fmask |=  0x800000;
  float frac = (float) fmask  / 0x1000000;
  double onum= frac * sign * 
         pow(2.0,expt);
  return onum;
}

int 
calc_offset(int &A)
{
  A+= A/512;
  if (A % 512 < 4) return 1;
  return 0;
}

int
readgenieFunc(ifstream& datain,const int grp,const int offset,const int Ngrp,
	      const char* fname)
{
  const int headbit(248);  
  const int offtable(96);
  //  const int begdata(348);
  extern Spec_In storage_;
  extern titls about_;
  
  char ss[255]; 
  Gen_section idata;

  datain.seekg(offtable,ios::beg);
  datain.read(idata.cod,16);
  if (datain.fail())
    {
      l_c("Error with input stream",1);
      datain.close();
      return 1;
    }

  int skip_npts = idata.iod[3];
  int top_length = idata.iod[2] * 4;
  int init_length = 4 * (idata.iod[0]-1);
  int total_grp = idata.iod[1];
  int start_head = (offset-1) * (top_length + 12 * skip_npts) + init_length;
  int sbit = start_head+headbit-12;
  
  if (total_grp<offset)
    {
      sprintf(ss,"Only %d Total grps",total_grp);
      l_c(ss,1);
      datain.close();
      return 1;
    }
  calc_offset(sbit);
  datain.seekg(sbit,ios::beg);
  datain.read(idata.cod,16);
      
  if (datain.fail() || top_length<0 || top_length>10000
                    || skip_npts<0 || skip_npts>50000) 
    {
      l_c("Error with first read of genie file",1);
      datain.close();
      return 1;
    }

  // double len = idata.fod[3];
  //  double prim_len = idata.fod[2];

  int qstatus;
  if (idata.iod[0]==6)
    qstatus=1;
  else if (idata.iod[0]==3)
    qstatus=0;
  else 
    {
      qstatus=0;
      l_c("Unkown Q-status, adopting Energy type",1);
    }

  int gseek=700;
  //  calc_offset(gseek);
  datain.seekg(gseek,ios::beg);
  datain.read(idata.cod,4);
  int npts = idata.iod[0]+1;
  sprintf(ss,"Number of points in header= %d",npts);
  l_c(ss,1);
  if (npts<1) 
    {
      datain.close();
      return 1;
    } 
  if (npts>skip_npts || npts<1)
    npts=skip_npts;
  if (npts>maxpts)
    {
      l_c("Excessive points in grp, will update code later",1);
      npts=maxpts;
    }
  float* HD=new float[npts+100];      //extra space for number 10;
  char *cHD;
  double* X=storage_.storx[grp];
      
  //  const int theoff(48);
  //  datain.seekg(theoff,ios::cur);
  //  datain.read(idata.cod,4);
  // double theta = idata.fod[0] / 2.0;
  
  int grp_offset,grp_end;
  for(int xye=0;xye<3;xye++)
    {
      cHD= (char*) HD;
      if (xye==1)
	X=storage_.story[grp];
      else if (xye==2)
	X=storage_.store[grp];
      grp_offset=start_head+top_length+xye*4*skip_npts;
      grp_end=grp_offset+4*(npts+1);
      //      calc_offset(grp_offset);
      //      calc_offset(grp_end);

      datain.seekg(grp_offset,ios::beg);
      datain.read(cHD,grp_end-grp_offset);

      for(int i=0;i<npts-1;i++)
	{
	  for(int j=0;j<4;j++)
	    idata.cod[j]= *cHD++;
	  X[i]=getvax_num(idata.fod[0]);
	} 
    }
  datain.close();
  storage_.stpnt[grp]=npts;
  delete [] HD;

  int i;
  for(i=strlen(fname);i>=0 && fname[i]!='\\';i--);
  if (fname[i]=='\\') 
    i++;
  strncpy(about_.hd[grp],fname+i,40);

  return 0;
}

void readgenie()
  /* function to inteprate the string hold_.is and ask question
     before passing actual read to readgenieFunc */
{

  extern wback hold_;

  char ss[256];
  int grp;
  int flag = cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1)
    {
      flag=2;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  grp--;

  char fname[255];
  zerofile(fname,hold_.is,80,' ');
  ifstream datain;
  datain.open(fname,ios::in);
  if (!datain)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0,255);
      extractfile(fname,ss,255);
      datain.open(fname,ios::in);
      if (!datain) return;
    }

  int offset=1;
  int ntry=1;
  if (flag!=2)
    {
      flag=cmdnumber(hold_.is,offset);
      if (flag) 
	flag=cmdnumber(hold_.is,ntry);
    }
  readgenieFunc(datain,grp,offset,ntry,fname);

  return;
}
  


template<class T> int 
setvalues(const char *mc,const int x1,T* A,const int x2,
	  T* B,const int x3,T* C)
  /*  Call to read in various values in position x1,x2,x3 from the
      string mc 
  */
{
  if (!mc) return 0;
  int len = strlen(mc);
  if (len<1) return 0;
  int i;
  for(i=0;i<len && mc[i] && 
	(mc[i]==' '  || mc[i]==',' || mc[i]=='\t');i++);
  if (i==len || !mc[i]) return 0;
  int maxT(0);
  if (x1>0)
    maxT++;
  if (x2>0)
    maxT++;
  if (x3>0)
    maxT++;

  if (!maxT) return 0;

  char *ss=new char[len+1];
  char **endptr=new char*;

  int count=1;
  int total=0;
  double nmb;
  do {
    int j=0;
    for(;i<len && mc[i]!='\n' && mc[i]!=0
	  && mc[i]!='\t' && mc[i]!=' ' && mc[i]!=',';i++)
      {
	ss[j]=mc[i];
	j++;
      }
    ss[j]=0;
    if (x1==count)
      {
	nmb=strtod(ss,endptr);
	if (*endptr!=ss+j)
	  {
	    delete endptr;
	    delete [] ss;
	    return total;
	  }
	*A= (T) nmb;
	total++;
      }
    if (x2==count)
      {
	nmb=strtod(ss,endptr);
	if (*endptr!=ss+j)
	  {
	    delete endptr;
	    delete [] ss;
	    return total;
	  }
	*B= (T) nmb;
	total++;
      }
    if (x3==count)
      {
	nmb=strtod(ss,endptr);
	if (*endptr!=ss+j)
	  {
	    delete endptr;
	    delete [] ss;
	    return total;
	  }
	*C= (T) nmb;
	total++;
      }
    count++;
    for(;i<len &&  
	  (mc[i]==' ' || mc[i]==',' || mc[i]=='\t');i++);
    } while (total!=maxT && i<len && mc[i]!=0);
  delete endptr;
  delete [] ss;
  return total;
}

int 
XrayWFFunc(ifstream& imfle,const int grp)
  /* Reads data in the format of header line , header line,
     npts : lambda, { x y e y2 e2 } * NPTS where values can be split
     over multiple lines
  */
{
  extern Spec_In storage_;
  extern titls about_;
  char ss[512];
  int ct;

  if(imfle.good())
    {
      imfle.getline(ss,255,'\n');
      ss[255]=0; //ensure we have ended line.
      for(ct=0;ss[ct]=='\t' || ss[ct]==' ';ct++);
      strncpy(about_.hd[grp],ss+ct,40);
    }
  if(imfle.good())
    {
      imfle.getline(ss,255,'\n');
      ss[255]=0; //ensure we have ended line.
      for(ct=0;ss[ct]=='\t' || ss[ct]==' ';ct++);
      strncpy(about_.hd[grp+1],ss+ct,40);
    }
  if (imfle.good())
    {
      imfle.getline(ss,255,'\n');
      double lam;
      if (cmdnumber(ss,ct,255) && cmdnumber(ss,lam,255))
	{
	  sprintf(ss,"Lambda == %g",lam);
	  l_c(ss,1);
	}
    }
  imfle.clear();
  ct=0;
  double *X1=storage_.storx[grp];
  double *Y1=storage_.story[grp];
  double *E1=storage_.store[grp];
  double *X2=storage_.storx[grp+1];
  double *Y2=storage_.story[grp+1];
  double *E2=storage_.store[grp+1];
  double Values[5];
  int ipt=0;
  while(imfle.good()) //now read a section of lines and process
    {
      imfle.getline(ss,512,'\n');
      while(cmdnumber(ss,Values[ipt],512))
	{
	  if (ipt==4)
	    {
	      X1[ct]=Values[0];
	      Y1[ct]=Values[1];
	      E1[ct]=Values[2];
	      X2[ct]=Values[0];
	      Y2[ct]=Values[3];
	      E2[ct]=Values[4];
	      ct++;
	      ipt=0;
	    }
	  else
	    ipt++;
	}
    }
  imfle.close();
  if (ct==0)  //read no points...
    return 1;
  storage_.stpnt[grp]=ct;
  storage_.stpnt[grp+1]=ct;
  return 0;
}



int
FourBUnitFunc(ifstream& imfle,const int grp,const int offset)
{
  char ss[512];
  int type,npts;
    
  for(int i=0;i<offset-1;i++)
    {
      imfle.getline(ss,512,'\n');
      if (!cmdnumber(ss,type,512) || !cmdnumber(ss,npts,512) ||
	  type>3 || type<1 || npts>maxpts || npts<0)
	{
	  l_c("Error with fourbris style headers",1);
	  return 1;
	}
      if (type==1)      //note type 3 left alone.
	type=2;   
      else if (type==2)
	type=1;

      imfle.getline(ss,512,'\n');  //read line of titles...
      //Now read throught file it is inefficent but we only know number
      // of points, not number of lines.
      int Fpts=0;
      double inpt;
      int kk=0;
      while(imfle.good() && npts>Fpts)
	{
	  imfle.getline(ss,512,'\n');  //max line length 512 char!!
	  while(cmdnumber(ss,inpt,512) && npts>Fpts)
	    {
	      kk++;
	      kk%=type;
	      if (!kk) Fpts++;
	    }
	}
      if(!imfle.good()) 
	return 2;
    }
  return FourBFunc(imfle,grp,1);
}	     


int
FourBFunc(ifstream& imfle,const int grp,const int Ngrp)
{
  extern Spec_In storage_;
  extern titls about_;

  char ss[512];
  char thold[41];
  int type,npts;
  double step;

  for(int i=0;i<Ngrp && i+grp<tg;i++)
    {
      imfle.getline(ss,512,'\n');
      if (!cmdnumber(ss,type,512) || !cmdnumber(ss,npts,512) ||
	  type>3 || type<1 || npts>maxpts || npts<0)
	{
	  l_c("Error with fourbris style headers",1);
	  return 1;
	}
      if (type==1) 
	type=2;
      else if (type==2)
	type=1;
      if (type!=3 && (!cmdnumber(ss,step,512) || step==0.0))
	{
	  l_c("Error with fourbris style headers",1);
	  return 1;
	}
      imfle.getline(ss,512,'\n');
      int kk;
      for(kk=0;kk<512 && 
	    (ss[kk]==' ' || ss[kk]=='\t');kk++);
      strncpy(thold,ss+kk,40);
      thold[39]=0;

      double* Pts[3];
      if (type==1)
	Pts[0]=storage_.story[grp+i];
      else if(type==2)
	{
	  Pts[0]=storage_.story[grp+i];
	  Pts[1]=storage_.store[grp+i];
	}
      else if(type==3)
	{
	  Pts[0]=storage_.storx[grp+i];
	  Pts[1]=storage_.story[grp+i];
	  Pts[2]=storage_.store[grp+i];
	}

      kk=0;  //start at zero
      int Fpts=0;
      double inpt;
      while(imfle.good() && npts>Fpts)
	{
	  imfle.getline(ss,512,'\n');
	  while(cmdnumber(ss,inpt,512) && npts>Fpts)
	    {
	      *Pts[kk]++ = inpt;
	      kk++;
	      kk%=type;
	      if (!kk) Fpts++;
	    }
	}
      if (Fpts!=npts)
	{

	  if (Fpts>1)
	    {
	      Fpts--;
	      storage_.stpnt[grp+i]=Fpts;
	      strncpy(about_.hd[grp+i],thold,40);
	    }
	  sprintf(ss,"Error with data part of file only %d read",Fpts);
	  l_c(ss,1);
	  return 1;
	}
      storage_.stpnt[grp+i]=npts;
      strncpy(about_.hd[grp+i],thold,40);
      sprintf(ss,"Read %d into grp %d :: %s",npts,grp+1+i,thold);
      l_c(ss,1);
    }
  return 0;
}	     

int
readinFunc(ifstream& imfle,const char ans,const int grp,
		const int head,const int tail)
  /* This attempts to read a file with x,y,z with  ' ',',' or ,'\n'
     delimination of absolutely any length lines. 
  */

{
  extern Spec_In storage_;
  extern titls about_;

  int xyc= (ans=='E') ? 3 : 2;
  double *XYE[3];
  XYE[0]=storage_.storx[grp];
  XYE[1]=storage_.story[grp];
  XYE[2]=storage_.store[grp];
  char tline[512];
  char bufline[512];
  bufline[0]=0;
  int lct=0;
  int i;

  tline[511]=0;  //ensure that we ALWAYS have an endline.
  while(imfle.good() && head>lct) 
    {
      imfle.getline(tline,512,'\n');
      lct++;
      if (tail==lct)
	{
	  for(i=0;i<512 && (tline[i]==' ' || tline[i]=='#' ||    
			    tline[i]=='\t');i++);
	  if (i<512)
	    strncpy(bufline,tline+i,40);  //we may have error in which case...
	}
      while(imfle.fail() && !imfle.eof() && imfle.gcount()>500)
	{
	  imfle.clear();
	  imfle.getline(tline,512,'\n');
	}
    }
      
  if (!imfle.good()) 
    {
      l_c("Error with file",1);
      return 1;
    }
  if (bufline[0])
    strncpy(about_.hd[grp],bufline,40);
        
  int ct=0;
  int ept=0;
  int cntback;
  double tval;
  int precheck=0;
  int bcount=0;
  bufline[0]=0; //start with zero string.
  try {

    while(ct<maxpts)
      {
	imfle.getline(tline,512,'\n');
	int ic;

	for(ic=0;ic<(int) strlen(tline) && tline[ic]!='#';ic++)
	  if (tline[ic]=='\t' || tline[ic]==',')
	    tline[ic]=' ';

	if (tline[ic]=='#')
	  {
	    tline[ic]=0;
	    while (imfle.fail() && !imfle.eof())
	      {
		imfle.clear();
		imfle.getline(bufline,512,'\n');
	      }
	  }
	
	if (imfle.fail() && !imfle.eof()   //case of ultra long line...
	    && imfle.gcount()>509)         // # terminated don't need cutback.
	  {
	    bcount=strlen(bufline);
	    precheck=0;      //initial zero as found later.
	    
	    for(cntback=strlen(tline)-1;cntback>=0 &&  //check long string 
		  tline[cntback]!=' ';cntback--);      //for end
	    if (cntback<10)   //error  
	      throw 1;
	    if (bcount)                //new string for bit to add to buffer.
	      {
		for(precheck=0;precheck<cntback && 
		      tline[precheck]!=' ';precheck++);
		if (precheck==cntback || precheck+bcount>250) 
		  throw 2;  //big errors
		strncpy(bufline+bcount,tline,precheck);
		bufline[bcount+precheck]=0;
		while(ct<maxpts && 
		      cmdnumber(bufline,tval,bcount+precheck))
		  {
		    XYE[ept][ct]=tval;
		    ept++;
		    if (ept>=xyc) 
		      {
			ept=0;
			ct++;
		      }
		  }
	      }  //end of pre buffer
	    
	    while(ct<maxpts &&    //no do current.
		  cmdnumber(tline+precheck,tval,cntback-precheck))
	      {
		XYE[ept][ct]=tval;
		ept++;
		if (ept==xyc) 
		  {
		    ept=0;
		    ct++;
		  }
	      }
	    strncpy(bufline,tline+cntback,512-cntback);
	    bufline[512]=0;  //This should always be 0
	    imfle.clear();
	  }
	else if (imfle.good())  //ie end of line found..
	  {
	    int precheck=0;
	    int lenR=strlen(tline);
	    bcount=strlen(bufline);  //we may have an overrun from last time
	    if (bcount)
	      {
		for(precheck=0;precheck<lenR && 
		      tline[precheck]!=' ';precheck++);
		if (precheck==lenR || precheck+bcount>250) 
		  throw 2;  //big errors
		strncpy(bufline+bcount,tline,precheck);
		bufline[bcount+precheck]=0;
		while(ct<maxpts && 
		      cmdnumber(bufline,tval,bcount+precheck))
		  {
		    XYE[ept][ct]=tval;
		    ept++;
		    if (ept>=xyc) 
		      {
			ept=0;
			ct++;
		      }
		  }
	      }  //end of pre buffer
	    
	    
	    while(ct<maxpts && 
		  cmdnumber(tline+precheck,tval,lenR-precheck))
	      {
		XYE[ept][ct]=tval;
		ept++;
		if (ept==xyc) 
		  {
		    ept=0;
		    ct++;
		  }
	      }
	    //End of main part.
	  }
	else  if (imfle.eof())
	  throw 3;
      }
  }
  catch(int &A)
    { 
      if (A<3)
	l_c("Error occurred in input file",1);
    }
  imfle.close();
  storage_.stpnt[grp]=(ept==0) ? ct : ++ct;
  if (ept==1)
    {
      XYE[1][ct-1]=0.0;
      XYE[2][ct-1]=0.0;
    }
  if (xyc==2)
    for(int i=0;i<ct;i++)
      XYE[2][i]=0.0;
  sprintf(tline,"Read in %d pts",ct);
  l_c(tline,1);
  return (ct) ? 0 : 1;
}


void 
readXrayWF(const char ans)
  /* 
     Routine does the primary readin data format (DC 1) 
     reads x,y or x,y,e in a continuous format. 
  */
{
  extern wback hold_;
  extern Spec_In storage_;
  int grp;
  char ss[255];
  char fname[255];

  zerofile(fname,hold_.is,80);  //get filename
  int flag = cmdnumber(hold_.is,grp);
  while(!flag || grp>tg-1 || grp<1)
    {
      flag=1;
      strcpy(ss,"First of Two consecutive groups  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }

  if (XrayWFFunc(imfle,grp))
    {
      sprintf(ss,"Error with file -- %s",ss);
      l_c(ss,1);
    }
  else
    {
      sprintf(ss,"Read in %d pts",storage_.stpnt[grp]);
      l_c(ss,1);
    }
  return;
}


void 
readfour(const char ans)
  /* 
     Reads in fourbris format data.
  */
{
  extern wback hold_;
  int grp;
  char ss[255];
  char fname[255];

  zerofile(fname,hold_.is,80);
  int Ngrp=1;
  int flag = cmdnumber(hold_.is,grp);
  flag += cmdnumber(hold_.is,Ngrp);

  while(!flag || grp>tg || grp<1)
    {
      flag=2;
      strcpy(ss,"First Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;
  if (ans=='O')   //Offset read
    {
      while(Ngrp<1)
	{
	  flag=2;
	  strcpy(ss,"Section number =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,Ngrp)) 
	    return;
	}    
    }
  else  //normal continuous read
    {
      while(Ngrp>tg-grp || Ngrp<1)
	{
	  flag=2;
	  strcpy(ss,"Number of additional sections  =>");
	  l_c(ss,0);
	  if(!cmdnumber(ss,Ngrp)) 
	    return;
	}    
    }

  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }
  if (ans=='O')
    FourBUnitFunc(imfle,grp,Ngrp);
  else
    FourBFunc(imfle,grp,Ngrp);
  return;
}

void 
readin(const char ans)
  /* 
     Routine does the primary readin data format (DC 1) 
     reads x,y or x,y,e in a continuous format. 
  */
{
  extern wback hold_;
  int grp;
  char ss[255];

  int flag = cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1)
    {
      flag=2;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  char fname[255];

  extractfile(fname,hold_.is,80);
  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }
  readinFunc(imfle,ans,grp);
  return;
}


void
readxray()
  /* Read in X6B and NSLS X-ray format (DC 6) */
{
  extern wback hold_;

  int lineH(3);
  int grp;
  char fname[255],ss[255];

  extractfile(fname,hold_.is,80);

  int flag = cmdnumber(hold_.is,grp);
  if (flag) flag+=cmdnumber(hold_.is,lineH);

  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  while(lineH>500 || lineH<0)
    {
      strcpy(ss,"Number of lines of header text =>");
      l_c(ss,0);
      if(!cmdnumber(ss,lineH)) return;
    }      

  ifstream imfle;
  imfle.open(fname,ios::in);
  
  for(int i=0;i<lineH-1;i++)
    do {
      imfle.clear();
      imfle.ignore(256,'\n');
    } while(imfle.fail() && imfle.gcount()>=255);   if (imfle.good())

  if (select_colFunc(imfle,grp,1,3,4,0))
    l_c("Error with file",1);
  return;
}

void 
readdcs(const char ans)
  /* 
     Routine does the primary readin data format (DC 3) 
     reads x,y or x,y,e in a continuous format. 
     Allows the user to remove an initial block and limit the number of
     lines in the file.
  */
{
  extern wback hold_;
  extern titls about_;

  int grp;
  char ss[255];

  int flag = cmdnumber(hold_.is,grp);
  int head,tail;

  char fname[255];
  zerofile(fname,hold_.is,80); //don't want this to interfer with the nmbers

  if (flag) 
    flag+=cmdnumber(hold_.is,head);
  if (flag) 
    flag+=cmdnumber(hold_.is,tail);

  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  while(flag<2 || head<0)
    {
      flag=4;
      strcpy(ss,"Number of header lines =>");
      l_c(ss,0);
      if(!cmdnumber(ss,head)) return;
    }

  if (flag==2) 
    tail=(head) ? 1 : 0;

  while (flag==4 || tail>head)
    {
      flag=3;
      strcpy(ss,"Line number for title =>");
      l_c(ss,0);
      if(!cmdnumber(ss,tail)) return;
    }


  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }
  if (!readinFunc(imfle,ans,grp,head,tail) && !tail)
    {
      int i;
      for(i=strlen(fname);i>=0 && fname[i]!='\\';i--);
      if (fname[i]=='\\') 
	i++;
      strncpy(about_.hd[grp],fname+i,40);
    }
  return;
}


void
readfour()
  /* head function for reading standard fourbris data */
{
  extern wback hold_;

  int grp,ncont;
  char ss[255];
  char fname[255];

  zerofile(fname,hold_.is,80);
  int flag = cmdnumber(hold_.is,grp);
  if (flag) 
    flag+=cmdnumber(hold_.is,ncont);

  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  if (flag<2 || grp+1==tg)
    ncont=1;

  while(ncont+grp<tg)
    {
      sprintf(ss,"Enter continuation groups (max %d) =>",tg-grp);
      l_c(ss,0);
      if (!cmdnumber(ss,ncont,255)) return;
    }

  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }
  FourBFunc(imfle,grp,ncont);
  return;
}

void 
readxye(const char ans)
  /* 
     Routine does the primary readin data format (DC 5) 
     reads x,y or x,y,e in a continuous format. 
     Allows the user to remove an initial block and limit the number of
     lines in the file.
  */
{
  extern wback hold_;

  int grp;
  char ss[255];

  int flag = cmdnumber(hold_.is,grp);

  while(!flag || grp>tg || grp<1)
    {
      flag=1;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp)) return;
    }    
  grp--;

  char fname[255];

  extractfile(fname,hold_.is,80);
  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }

  if (ans=='E')
    select_colFunc(imfle,grp,1,2,3);
  else
    select_colFunc(imfle,grp,1,2,-1);
  
  return;
}


void 
select_scan(const char ans)
{
  extern wback hold_;

  char ss[256];
  int grp,scan;
  int flag = cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1)
    {
      flag=2;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  grp--;

  
  if (flag) 
    flag+=cmdnumber(hold_.is,scan);

  while(flag<2 || scan<1)
    {
      flag=3;
      strcpy(ss,"Scan number =>");
      l_c(ss,0);
      if (!cmdnumber(ss,scan))  return;
    }    

  int xcol,ycol,ecol;
  xcol=ycol=ecol=0;
  if (flag!=3)
    {
      flag=cmdnumber(hold_.is,xcol);
      if (flag)
	flag=cmdnumber(hold_.is,ycol);
      if (flag)
	flag=cmdnumber(hold_.is,ecol);
      else
	ecol= -1;
    }

  char fname[255];
  extractfile(fname,hold_.is,80);
  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }
  esrf_read(imfle,grp,scan,xcol,ycol,ecol);
  return;
}


void select_col(const char ans)
  /* Routine designed to reading columns from a file.
     The file can have anynumber of columns, however only one
     line of none commented title is allowed.
  */
{
  extern wback hold_;
  extern Spec_In storage_;

  char ss[256];
  int grp;
  int flag = cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1)
    {
      flag=2;
      strcpy(ss,"Grp to read data into  =>");
      l_c(ss,0);
      if(!cmdnumber(ss,grp))  return;
    }    
  grp--;

  int xcol,ycol,ecol;
  xcol=ycol=ecol=0;
  if (flag!=2)
    {
      flag=cmdnumber(hold_.is,xcol);
      if (flag)
	flag=cmdnumber(hold_.is,ycol);
      if (flag)
	flag=cmdnumber(hold_.is,ecol);
      else
	ecol= -1;
    }

  char fname[255];
  extractfile(fname,hold_.is,80);
  ifstream imfle;
  imfle.open(fname,ios::in);
  if (!imfle)
    {
      sprintf(ss,"Enter name of file =>");
      l_c(ss,0);
      extractfile(fname,ss,255);
      imfle.open(fname);
      if (!imfle) return;
    }

  if (ans=='N')
    xcol= -1;
  if (!select_colFunc(imfle,grp,xcol,ycol,ecol) && ans=='N')
    for(int i=0;i<storage_.stpnt[grp];i++)
      storage_.storx[grp][i]=i;
  return;
}

int
select_colFunc(ifstream& imfle,const int grp,int xcol,int ycol,int ecol,
	       const int inq)
  /* Routine designed to reading columns from a file.
     The file can have anynumber of columns, however only one
     line of none commented title is allowed.
  */
{
  extern Spec_In storage_;
  extern titls about_;
  char ss[256];

  char vline[512];
  char tline[512];
  char *vpt,*tpt;
  imfle.getline(tline,512,'\n');
  tpt=tline;
  if (!imfle.good())
    {
      l_c("File format incorrect (no carriage returns)",1);
      imfle.close();
      return 1;
    }
  for(;*tpt==' ';tpt++);
  int i=strlen(tpt);
  for(int j=i;j<40;j++)
    tpt[j]=' ';
  tpt[40]=0;
  i=0;

  double xvp,yvp,evp;
  int cgrp=grp;
  int first=1;
  while(cgrp<tg)
    {
      vpt=vline;
      imfle.getline(vline,512,'\n');
      if (!imfle.good())
	{
	  imfle.close();
	  if (i || grp!=cgrp)
	    {
	      storage_.stpnt[cgrp]=i;
	      strncpy(about_.hd[cgrp],tpt,40);
	      sprintf(ss,"Points read : %d",(cgrp-grp)*maxpts+i);
	      l_c(ss,1);
	      return 0;
	    }
	  else
	    {
	      l_c("No points successfully read!!",1);
	      return 1;
	    }
	}
      for(;*vpt==' ';vpt++);
      if (*vpt!='#' && *vpt!='!' && *vpt)
	{
	  if (first)
	    {
	      char hold_line[255];
	      strncpy(hold_line,vpt,255);
	      int ct;
	      for(ct=0;cmdnumber(vpt,xvp,511);ct++);
	      if (ct>1)
		{
		  l_c(hold_line,1);
		  sprintf(ss,"Detected %d Columns",ct); 
		  l_c(ss,1);
		  if (xcol<1 || xcol>ct)
		    {
		      if (!inq)
			{
			  imfle.close();
			  return 1;
			}
		      sprintf(ss,"Which is the x column");
		      l_c(ss,0);
		      if (!cmdnumber(ss,xcol,255)) 
			{
			  imfle.close();
			  return 1;
			}
		    }
		  if (ycol<1 || ycol>ct)
		    {
		      if (!inq)
			{
			  imfle.close();
			  return 1;
			}
		      sprintf(ss,"Which is the y column");
		      l_c(ss,0);
		      if (!cmdnumber(ss,ycol,255))
			{
			  imfle.close();
			  return 1;
			}
		    }
		  first=0;
		  strncpy(vpt,hold_line,255);
		}
	    }
	  if (!first)
	    {
	      xvp=yvp=evp=0.0;
	      int cols=
		setvalues(vpt,xcol,&xvp,ycol,&yvp,ecol,&evp);
	      if (cols>1)
		{
		  storage_.storx[cgrp][i]=xvp;
		  storage_.story[cgrp][i]=yvp;
		  storage_.store[cgrp][i]=evp;
		  i++;
		}
	      if (i>=maxpts)
		{
		  storage_.stpnt[cgrp]=maxpts;
		  strncpy(about_.hd[cgrp],tpt,40);
		  i=0;
		  sprintf(ss,"Continue to the next group (y/n)");
		  l_c(ss,0);
		  int ii;
		  for(ii=0;ss[ii]==' ';ii++);
		  if (ss[ii]!='Y' && ss[ii]!='y')
		    {
		      cgrp++;
		      imfle.close();
		      sprintf(ss,"Points read : %d",(cgrp-grp)*maxpts);
		      l_c(ss,1);
		      return 0;
		    }
		  cgrp++;
		}
	
	    }
	}
    }
  return 0;
}


/* void
superin()
  / * The idea is to read a section of files in * /
{
  

}
*/


void 
esrf_read(ifstream& imfle,const int grp, const int scan,
	  int xcol,int ycol,int ecol)
  /* reads esrf_scan files */
{

  extern Spec_In storage_;
  extern titls about_;

  char vline[512];
  char tline[512];
  char ss[256];
  char *vpt,*tpt;
  std::string A;
  std::string::size_type pos;
  int Snum(0);
  imfle.getline(tline,512,'\n');
  tpt=tline;
  while(imfle.good() && scan!=Snum)
    {
      A=static_cast<std::string>(tline);
      if ((pos=A.find("#S"))!=std::string::npos)
	{
	  A.copy(ss,std::string::npos,pos+2);
	  if (!cmdnumber(ss,Snum))
	    Snum=0;
	}
      imfle.getline(tline,512,'\n');
    }
	  
  if(!imfle.good())
    {
      sprintf(ss,"File does not contain scan number %d",scan);
      l_c(ss,1);
      imfle.close();
      return;
    }
  

  double xvp,yvp,evp;
  int cgrp=grp;
  int first=1;
  int i=0;
  while(cgrp<tg)
    {
      vpt=vline;
      imfle.getline(vline,512,'\n');   //can't get number that is line
      A=static_cast<std::string>(vline);
      if ((pos=A.find("#S"))!=std::string::npos)
	{
	  A.copy(ss,std::string::npos,pos+2);
	  if (!cmdnumber(ss,Snum))
	    Snum=0;
	}
      if (!imfle.good() || Snum!=scan)
	{
	  imfle.close();
	  if (i || grp!=cgrp)
	    {
	      storage_.stpnt[cgrp]=i;
	      strncpy(about_.hd[cgrp],tpt,40);
	      sprintf(ss,"Points read : %d",(cgrp-grp)*maxpts+i);
	      l_c(ss,1);
	      return;
	    }
	  else
	    {
	      l_c("No points successfully read!!",1);
	      return;
	    }
	}
      for(;*vpt==' ';vpt++);  //remove leading spaces
      if (*vpt!='#' && *vpt!='!' && *vpt)
	{
	  if (first)
	    {
	      char hold_line[255];
	      strncpy(hold_line,vpt,255);
	      int ct;
	      for(ct=0;cmdnumber(vpt,xvp,511);ct++);
	      if (ct>1)
		{
		  l_c(vline,1);
		  sprintf(ss,"Detected %d Columns",ct); 
		  l_c(ss,1);
		  if (xcol<1 || xcol>ct)
		    {
		      sprintf(ss,"Which is the x column");
		      l_c(ss,0);
		      if (!cmdnumber(ss,xcol,255)) return;
		    }
		  if (ycol<1 || ycol>ct)
		    {
		      sprintf(ss,"Which is the y column");
		      l_c(ss,0);
		      if (!cmdnumber(ss,ycol,255)) return;
		    }
		  first=0;
		  strncpy(vpt,hold_line,255);
		}
	    }
	  if (!first)
	    {
	      xvp=yvp=evp=0.0;
	      int cols=
		setvalues(vpt,xcol,&xvp,ycol,&yvp,ecol,&evp);
	      if (cols>1)
		{
		  storage_.storx[cgrp][i]=xvp;
		  storage_.story[cgrp][i]=yvp;
		  storage_.store[cgrp][i]=evp;
		  i++;
		}
	      if (i>=maxpts)
		{
		  storage_.stpnt[cgrp]=maxpts;
		  strncpy(about_.hd[cgrp],tpt,40);
		  i=0;
		  sprintf(ss,"Continue to the next group (y/n)");
		  l_c(ss,0);
		  int ii;
		  for(ii=0;ss[ii]==' ';ii++);
		  if (ss[ii]!='Y' && ss[ii]!='y')
		    {
		      cgrp++;
		      imfle.close();
		      sprintf(ss,"Points read : %d",(cgrp-grp)*maxpts);
		      l_c(ss,1);
		      return;
		    }
		  cgrp++;
		}
	
	    }
	}
    }
  return;
}


template int setvalues(const char*,const int,double *,const int,
                        double *,const int,double *);

