#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <string>
#include <vector>
#include "wshare.h"
#include "cmd.h"
#include "fglobal.h" 
#include "XmPgplotP.hxx"
#include "baseGraph.h" 
#include "axis.h"
#include "frame.h"

extern XtAppContext  app;
extern Widget top,command_w,text_w,main_w;
extern int flag;
void draw2d(int*,int*);


void
Curs_Screen::remake_c_mode(const int mode)
{
  extern Motif_Pts motpt_;  

  if (mode==motpt_.mode) return;
  if (motpt_.mode==7)
    reset_c_mode();
  if (mode<7) 
    motpt_.mode=mode;
  else
    motpt_.mode=1;
  xmp_arm_cursor(scn,XMP_XRNG_CURSOR,x,y,
		 first_pt,(void *) this);
  return;
}

void
Curs_Screen::reset_c_mode(const int keep_mem)
{
  extern Motif_Pts motpt_;  

  if(cnpts!=0 && !keep_mem && motpt_.mode!=7)
    {
      delete [] cx;
      delete [] cy;
      delete [] pt;
      cnpts=0;
      pt=0;
      cx=cy=0;
    }
  if (motpt_.mode==7)
    {
      redisplay_cursor();
    }

  return;
}

void
Curs_Screen::arm_e_cursor()
{
  extern wback hold_;         
  extern Motif_Pts motpt_;  
  extern Spec_In storage_;

  double xmin,xmax,ymin,ymax;
  int grp;
  int gd_grp=0;
  char s[256];
  Graph_Data* Gd=dynamic_cast<Graph_Data*>(this);
  Graphs* Gs=dynamic_cast<Graphs*>(this);
  
  if (!Gs || !Gd) 
    {
      l_c("Window does not have point armed cursor",1);
      return;
    }
  Gd->getaxis(xmin,xmax,ymin,ymax);
  if (!cmdnumber(hold_.is,grp) || grp<1 || grp>tg
      || storage_.stpnt[grp-1]<1)
    gd_grp=1;
  else
    {
      gd_grp=Gs->isPlotted(grp-1);
    }
  if (gd_grp)
    {
      strcpy(s,"Input a displayed group to edit ->");
      l_c(s,0);
      if (!cmdnumber(s,grp) || grp<1 || grp>tg) return;
      gd_grp=Gs->isPlotted(grp-1);
      if (gd_grp) return;
    }
  grp--;
  if (storage_.stpnt[grp]<1) return;  //no points...

// Get Cursor from Pgx


  XmPgplotWidget w = (XmPgplotWidget) scn;
  if (!scn) return;  
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;
  Plist &apt= pgx->state->Apt;

  if(cnpts!=0)
    {
      delete [] apt.x;
      delete [] apt.y;
      delete [] pt;
      apt.npts=0;
      cnpts=0;
    }
  
  apt.npts=storage_.stpnt[grp];
  apt.x=new int[apt.npts];
  apt.y=new int[apt.npts];
  pt=new int[apt.npts];
  cnpts=0;
  cx=apt.x;
  cy=apt.y;

  double xp,yp;

  int count(0);
  for(int i=0;i<storage_.stpnt[grp];i++)
    {
      if (storage_.storx[grp][i]>xmin && storage_.storx[grp][i]<xmax 
	  && storage_.story[grp][i]>ymin && storage_.story[grp][i]<ymax)
	{
	  
	  xp=storage_.storx[grp][i];
	  xp*=world.xdiv;
	  xp+=world.xoff;
	  apt.x[count]=state->geom.xmin + (int) (xp+0.5);
	  yp=storage_.story[grp][i];
	  yp*=world.ydiv;
	  yp+=world.yoff;
	  apt.y[count]=state->geom.ymax - (int) (yp+0.5);
	  pt[count]=i;
	  count++;
	}
    }
  if (count<1)
    {
      delete [] apt.x;
      delete [] apt.y;
      delete [] pt;
      cx=cy=0;
      pt=0;
      apt.npts=0;
      return;
    }
  cnpts=count;
  edit_grp=grp;
  apt.npts=count;
  motpt_.mode=7;
  xmp_arm_cursor(scn,XMP_E_POINT,x,y,
		     first_pt,(void *) this);
  return;
}


void 
Curs_Screen::layer_cursor(float xx,float yy,const int type) 
  /* 
     Not currently called by anything -- can be deleted ?? (1/11/99)
   */
{
  XEvent evt;
  XEvent *event_return= &evt;
  xmp_arm_cursor(scn, XMP_NORM_CURSOR,xx,yy,
                 first_pt,(void *) this);
  bt=1;
  do
    {
    XtAppNextEvent(app,event_return);
    XtDispatchEvent(event_return);
    } while(bt);
  if (type<=0)  return;
 
  xmp_arm_cursor(scn,XMP_LINE_CURSOR,this->x,this->y,
                    line_pt,(void *) this);
  bt=1;
  do
    {
    XtAppNextEvent(app,event_return);
    XtDispatchEvent(event_return);
    } while(bt);
  xmp_disarm_cursor(scn);
  return;
  }

void 
Curs_Screen::first_pt(Widget w,XtPointer client_data,XtPointer call_data)
{
  extern Motif_Pts motpt_;

  XmpCursorCallbackStruct *cursor = (XmpCursorCallbackStruct *) call_data;
  Curs_Screen *im = (Curs_Screen *) client_data;
  Frame *fm = dynamic_cast<Frame*>(im);
  
  float &x = im->x = cursor->x;
  float &y = im->y = cursor->y;
  im->button = cursor->key;
  double xmin,xmax,ymin,ymax;
  if (fm)
    fm->getaxis(xmin,xmax,ymin,ymax);
  if (im->bt>0) 
    {
      im->bt--;      //time ot exit the event loop.
      return;
    }

  char ans;
  switch(motpt_.mode)
    {
    case 1:
      if (fm)
	fm->Curs_pt(im->x,im->y);
      return;
    case 2:            //start of CA command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
        motpt_.mode=1;
        return;
        }
      im->x1=x;
      im->y1=y;
      ans=cursor->key;
      if (ans=='M')
	{
	  if (fm) 
	    fm->Hand_Curs(im->x1,im->y1,x,y,ans);
	  return;
	}
      cpgsci(1);
      xmp_arm_cursor(im->scn,XMP_RECT_CURSOR,x,y,
                first_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 3: //start of CX command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  motpt_.mode=1;
	  return;
        }
      im->x1=x;
      im->y1=y;
      if (ans=='M')
	{
	  if (fm) 
	    fm->Hand_Curs(im->x1,im->y1,x,y,ans);
	  return;
	}
      cpgsci(1);
      xmp_arm_cursor(im->scn,XMP_XRNG_CURSOR,x,y,
		     first_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 4: //start of CY command
      if (x>xmax || x<xmin || y>ymax || y<ymin)
        {
	  motpt_.mode=1;
	  return;
        }
      im->x1=x;
      im->y1=y;
      if (ans=='M')
	{
	  if (fm) 
	    fm->Hand_Curs(im->x1,im->y1,x,y,ans);
	  return;
	}
      cpgsci(1);
      xmp_arm_cursor(im->scn,XMP_YRNG_CURSOR,x,y,
                  first_pt,(void *) im);
      motpt_.mode*=10;
      return;
    case 7:
      {
	ans=cursor->key;
	if (x>xmax || x<xmin || y>ymax || y<ymin)
	  {
	    motpt_.mode=1;
	    xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
			   first_pt,(void *) im);
	    return;
	  }
	XmPgplotWidget ww = (XmPgplotWidget) im->scn;
	XmPgplotPart *xmp = &ww->pgplot;
	PgxWin *pgx = xmp->pgx;
	PgxState *state = pgx->state; 
	//	XWcursor *curs = &state->cursor;
	if (ans=='A') 
	  im->set_newpoint(state->Apt.fd_pt,x,y);
	else if (ans=='D')
	  im->add_newpoint(state->Apt.fd_pt,x,y);
	return;
      }
    case 20:   //end of CA command
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     first_pt,(void *) im);
      motpt_.mode=2;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      if (fm) 
	fm->Hand_Curs(im->x1,im->y1,x,y,ans);
      return;
    case 30:
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     first_pt,(void *) im);
      motpt_.mode=3;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      if (fm) 
	fm->Hand_Curs(im->x1,im->y1,x,y,ans);
      return;
    case 40:
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     first_pt,(void *) im);
      motpt_.mode=4;
      if (x>xmax || x<xmin || y>ymax || y<ymin) return;
      ans=cursor->key;
      if (fm) 
	fm->Hand_Curs(im->x1,im->y1,x,y,ans);
      return;   
    default:    //the will be others!
      motpt_.mode=1; 
      xmp_arm_cursor(im->scn,XMP_NORM_CURSOR,x,y,
                     first_pt,(void *) im);
      return; 
    }
  }

void
Curs_Screen::add_newpoint(const int chk,const float x,const float y)
{
  extern Spec_In storage_;
  Frame *fm = dynamic_cast<Frame*>(this);
  
  XmPgplotWidget w = (XmPgplotWidget) scn;
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  //  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;

  int pv=pt[chk];

  if (storage_.stpnt[edit_grp]>=maxpts)
    {
      l_c("No Point added : Max points is group reached",1);
      return;
    }
  if (x>storage_.storx[edit_grp][pv]) pv++;
  for(int i=storage_.stpnt[edit_grp]+1;i>pv;i--)
    {
      storage_.storx[edit_grp][i]=storage_.storx[edit_grp][i-1];
      storage_.story[edit_grp][i]=storage_.story[edit_grp][i-1];
      storage_.store[edit_grp][i]=storage_.store[edit_grp][i-1];
    }

  add_editlist(pv,x,y);
  storage_.storx[edit_grp][pv]=(double) x;
  storage_.story[edit_grp][pv]=(double) y;
  if (pv<1) pv=1;
  storage_.store[edit_grp][pv]=storage_.store[edit_grp][pv-1];

  storage_.stpnt[edit_grp]++;
  if (fm)
    fm->redraw();
  
  return;
}

void
Curs_Screen::add_editlist(const int ipt,const float x,const float y)
{
  
  XmPgplotWidget w = (XmPgplotWidget) scn;
  if (!scn) return;  
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;
  Plist &apt= pgx->state->Apt;

  double xp,yp;
  int xv,yv;
  xp=x * world.xdiv + world.xoff;
  xv=state->geom.xmin + (int) (xp+0.5);

  yp=y * world.ydiv + world.yoff;
  yv=state->geom.ymax - (int) (yp+0.5);


  int *xx=new int[cnpts+1];
  int *yy=new int[cnpts+1];
  int *pp=new int[cnpts+1];

  int i;
  for(i=0;i<cnpts && apt.x[i]<xv ;i++)
    {
      xx[i]=apt.x[i];
      yy[i]=apt.y[i];
      pp[i]=pt[i];
    }
  xx[i]=xv;
  yy[i]=yv;
  pp[i]=ipt;
  for(;i<cnpts;i++)
    {
      xx[i]=apt.x[i];
      yy[i]=apt.y[i];
      pp[i]=pt[i]+1;
    } 

  if(cnpts!=0)
    {
      delete [] apt.x;
      delete [] apt.y;
      delete [] pt;
    }
  apt.x=xx;
  apt.y=yy;
  pt=pp;
  cnpts++;
  apt.npts++;
  return;
}




void
Curs_Screen::set_newpoint(const int chk,const float x,const float y)
{
  extern Spec_In storage_;
  extern Motif_Pts motpt_; 
  Frame* fm = dynamic_cast<Frame *>(this); 

  XmPgplotWidget w = (XmPgplotWidget) scn;
  XmPgplotPart *xmp = &w->pgplot;
  PgxWin *pgx = xmp->pgx;
  PgxState *state = pgx->state; 
  XWworld world = pgx->state->world;

  double yp;
  int pv=pt[chk];

  storage_.story[edit_grp][pv]=(double) y;
  if (fm)
    fm->redraw();

  yp=storage_.story[edit_grp][pv];
  yp*=world.ydiv;
  yp+=world.yoff;
  cy[chk]=state->geom.ymax - (int) (yp+0.5);

  motpt_.mode=7;
  xmp_arm_cursor(scn,XMP_E_POINT,x,y,
		     first_pt,(void *) this);

  return;

}



void 
Curs_Screen::line_pt(Widget w,XtPointer client_data,XtPointer call_data)
  {
  XmpCursorCallbackStruct *cursor = (XmpCursorCallbackStruct *) call_data;
  Curs_Screen *im = (Curs_Screen *) client_data;
  im->x1 = cursor->x;
  im->y1 = cursor->y;
  im->bt=0;
  im->button = cursor->key;
  return;
  }

Curs_Screen::Curs_Screen() :  Plot_Screen(),display(0),cus(0),win(0),
                              cnpts(0),cx(0),cy(0),pt(0),
                              bt(0),x(0.0),y(0.0),
                              x1(0.0),y1(0.0),button(' ')
        {}

Curs_Screen::~Curs_Screen() 
{ 
  if (cnpts)
    {
      delete [] pt;
      delete [] cx;
      delete [] cy;
    }
}

int 
Curs_Screen::make_fullscreen()
  {
  int rt=make_screen();
  init_cont_cursor();
  return rt;
  }


void 
Curs_Screen::init_cont_cursor()
  {
    //  XEvent evt;
  //  XEvent *event_return= &evt;
  if (!display && scn)
    {
      int shape=34;
      display=XtDisplay(scn);
      cus=XCreateFontCursor(display,shape);
      win=XtWindow(scn);
    }
  if (display && win && cus)
    {
      XDefineCursor(display,win,cus); 
      xmp_arm_cursor(scn, XMP_NORM_CURSOR,0.0f,0.0f,
		     first_pt,(void *) this);
      bt=0;
    }
  return;
  } 

void
Curs_Screen::free_cursor()
{
  XFreeCursor(display,cus);
  int shape=30;
  cus=XCreateFontCursor(display,shape);
  XDefineCursor(display,win,cus); 
  //  XUndefineCursor(display,win);
}

void
Curs_Screen::redisplay_cursor()
{
  if(display && win && cus)
    XDefineCursor(display,win,cus); 
}

int 
Curs_Screen::sband(const int md,const int posn,const float xx,
                   const float yy,float &xo,float &yo,char &ans)
{
  if (md<0 || md>8) return 0;
  XEvent evt;
  XEvent *event_return= &evt;
  bt=1;

  switch (md)
    {
    case 0:
      xmp_arm_cursor(scn,XMP_NORM_CURSOR,x,y,
                     line_pt,(void *) this);
      break;
    case 1:
      xmp_arm_cursor(scn,XMP_LINE_CURSOR,xx,yy,
                     line_pt,(void *) this);
      break;
    case 2:
      xmp_arm_cursor(scn,XMP_RECT_CURSOR,xx,yy,
                     line_pt,(void *) this);
       break;
    case 3:
      xmp_arm_cursor(scn,XMP_YRNG_CURSOR,x,y,
                     line_pt,(void *) this);
       break;
    case 4:
      xmp_arm_cursor(scn,XMP_XRNG_CURSOR,x,y,
                     line_pt,(void *) this);
       break; 
    case 5:
      xmp_arm_cursor(scn,XMP_HLINE_CURSOR,x,y,
                     line_pt,(void *) this);
       break;
    case 6:
      xmp_arm_cursor(scn,XMP_VLINE_CURSOR,x,y,
                     line_pt,(void *) this);
       break;
    case 7:
      xmp_arm_cursor(scn,XMP_CROSS_CURSOR,x,y,
                     line_pt,(void *) this);
    case 8:
      xmp_arm_cursor(scn,XMP_CIRCLE_CURSOR,x,y,
                     line_pt,(void *) this);
       break; 

    default:
      break;
    }
  do
    {
      XtAppNextEvent(app,event_return);
      XtDispatchEvent(event_return);
    } while(bt);  

  xo=x1;
  yo=y1;
  ans=button;
  
  xmp_arm_cursor(scn, XMP_NORM_CURSOR,xo,yo,
		 first_pt,(void *) this);

  return 1;
  
} 

int 
Plot_Screen::make_screen(const int type)
{
  static int count = 0;
  if (!screen_num)
    {
      pshell=XtVaCreatePopupShell("pshell",
				  topLevelShellWidgetClass,main_w,
				  XtNtitle, "Graphic Window",
				  XmNdeleteResponse, XmDESTROY,
				  NULL);
      
      
      mw = XtVaCreateManagedWidget("Mainpic",
				   xmMainWindowWidgetClass,pshell,
				   XmNvisualPolicy,XmVARIABLE,
				   //  XmNscrollingPolicy,XmAUTOMATIC,
				   // XmNscrollBarDisplayPolicy,XmAS_NEEDED,
				   XtNtitle, "Graphics Window",
				   NULL);


      if (type==3)
	{
//  	  Widget
//  	    row_work = XtVaCreateWidget("work", xmRowColumnWidgetClass,
//  					       mw,
//  					       XmNorientation, XmVERTICAL,
//                                                 XmNresizeHeight, True,
//  					       XmNnumColumns, 1,
//  					       NULL);

//  	  Widget 
//  	    pane = XtVaCreateWidget("spane",
//  				    xmPanedWindowWidgetClass,row_work,
//  				    NULL);

//  	  XtVaCreateManagedWidget("Text",xmLabelWidgetClass, row_work,
//  				  NULL);
	  
	  scn=XtVaCreateManagedWidget("images", xmPgplotWidgetClass,
				      mw,
//                                    XmNpaneMinimum, 100,
				      XmNheight, 400,
				      XmNwidth, 400,
				      XmpNmaxColors, 100,
				      XmNtraversalOn, False,
				      NULL);
	  //	  XtManageChild(scn);
	  //          XtManageChild(pane);
	  //	  XtManageChild(row_work);
	  XtManageChild(mw);
	  XtManageChild(pshell);
	  XtRealizeWidget(pshell);
	  screen_num=cpgopen(xmp_device_name(scn));
          return screen_num;
	}

      if (!count)
	{
	  scn=XtVaCreateManagedWidget("image", xmPgplotWidgetClass,
				      mw,
				      XmNheight, 400,
				      XmNwidth, 400,
				      XmpNmaxColors, 100,
				      XmNtraversalOn, False,
				      NULL);
	  count++;
	  
	}
      else if(count==1)
	{
	  scn=XtVaCreateManagedWidget("image2", xmPgplotWidgetClass,
				      mw,
				      XmNheight, 400,
				      XmNwidth, 400,
				      XmpNmaxColors, 100,
				      XmNtraversalOn, False,
				      NULL); 
          count++;
	}
      else 
	{
	  scn=XtVaCreateManagedWidget("image3", xmPgplotWidgetClass,
				      mw,
				      XmNheight, 400,
				      XmNwidth, 400,
				      XmpNmaxColors, 100,
				      XmNtraversalOn, False,
				      NULL); 
	}
      


      XtManageChild(scn);
      XtManageChild(mw);
      XtManageChild(pshell);
      XtRealizeWidget(pshell);
      screen_num=cpgopen(xmp_device_name(scn));
    }
  return screen_num; 
}


Plot_Screen::Plot_Screen() : pshell(0),mw(0),screen_num(0),scn(0)
  {}

Plot_Screen::~Plot_Screen() 
{
  if (screen_num)
    {
      XtDestroyWidget(pshell);
      screen_num=0;
    }
  return;
}
   

void 
Plot_Screen::report_cursor(Widget w, XtPointer context,
                                XEvent *event,
                                Boolean *call_next)
  /* not yet called */
{
  float wx,wy;
  if(event->type == MotionNotify)
    {
    if(xmp_pixel_to_world(w, event->xmotion.x, event->xmotion.y,
                       &wx, &wy) == 0) 
      {
      //Do something
      }
    }
  *call_next= True;
  return;
}

void 
plot_param::plot_entry
        (Widget w,XtPointer client_data,XtPointer call_data)
  {
    
  plot_param* THIS= (plot_param*) client_data; 
  if (THIS->get_val())
    THIS->make_wind(0);
  else
    THIS->set_val();
   
  XmTextFieldSetInsertionPosition(THIS->text[0],5);
  //  fm->redraw();  
  return;
  }   
  


void plot_param::plot_down(Widget w,XtPointer client_data,XtPointer call_data) 
  {
  plot_param* THIS= (plot_param*) client_data; 
  XtPopdown(THIS->plog);
  return;
  }  
 
void plot_param::remove_plot(Widget w,XtPointer client_data,XtPointer call_data)
  {
  plot_param* THIS= (plot_param*) client_data;
  XtDestroyWidget(w);
  if (THIS->plog==w) 
    { 
    THIS->plog=0;
    THIS->ng=0;
    }
  return;
  }
  
void 
plot_param::make_wind(int test)
{   

  // if test!=0 then check to see if window exists before going on else make it
  // if it doesn't.
  /*
  Widget td=0;
  static Position xx=0;
  static Position yy=0;

  static ActionAreaItem act3[]={
     {"Ok",plot_entry, (XtPointer) this , 1},
     {"DownLoad",down_load, (XtPointer) this, 1 },
     {"Dismiss",plot_down,(XtPointer) this, 1},
     };
     
  if (!plog && test) return;
  
  if (plog && plot_.plot_total!=ng)
    {
    XtVaGetValues(plog,XmNx,&xx,XmNy,&yy,NULL);
    td=plog;
    plog=0;
    ng=0;
    }

   if (!plog && plot_.plot_total) 
     {
    plog = XtVaCreatePopupShell("test",
               topLevelShellWidgetClass,command_w,
               XtNtitle, "Plot Param",
               NULL);

     Widget pane=
     XtVaCreateWidget("pane",xmPanedWindowWidgetClass,plog,
                          XmNsashWidth,1,
                          XmNsashHeight,1,
                          NULL);
                                          
     Widget rowtwo=
     XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,pane,
                       XmNpacking,XmPACK_COLUMN,
                       XmNisAligned, True,
                       XmNnumColumns,1,
                       XmNentryVerticalAlignment,XmALIGNMENT_END,
                       XmNorientation, XmVERTICAL,
                            NULL);                           

     char l_str[4]="G :";
     Widget rowcol,label;
     XmString str[5];
     int i;
     rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,
                              rowtwo,
                              XmNpacking,XmPACK_TIGHT,
                              XmNisAligned, True,
                              XmNnumColumns,5,
                              XmNentryVerticalAlignment,XmALIGNMENT_END,
                              XmNorientation, XmHORIZONTAL,
                              NULL);
                               
     str[0]=XmStringCreateLocalized("Line");
     str[1]=XmStringCreateLocalized("Grp    ");
     str[2]=XmStringCreateLocalized("  Col     ");
     str[3]=XmStringCreateLocalized("  Style   ");
     str[4]=XmStringCreateLocalized("  Size   ");
     for(i=0;i<5;i++)
       {
       label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
                                   XmNlabelString, str[i],  
//                                   XmNmarginHeight,(Dimension) 3,    
                                    NULL);
       XmStringFree(str[i]);
       }
       
     XtManageChild(rowcol);
     text=new Widget[(plot_.plot_total+1)*4];
//     if (!text) error("No memory for text widgets in plot_param");  

     for (i=0;i<plot_.plot_total+1;i++)   //Start of parameter table
       {
       rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
                                XmNpacking,XmPACK_TIGHT,
                                XmNisAligned, True,
                                XmNnumColumns,5,
                                XmNentryVerticalAlignment,XmALIGNMENT_END,
                                XmNorientation, XmHORIZONTAL,
                                NULL); 
                                
       str[0]=XmStringCreateLocalized(l_str);
       label=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
                                   XmNlabelString, str[0],  
                                   XmNmarginHeight,(Dimension) 0,    
                                    NULL);
       int j;                             
       for(j=0;j<4;j++)
         text[j+i*4]=
         XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
                             XmNvalue, "0.0",
                             XmNmarginHeight,(Dimension) 0,
                             XmNcolumns,5,
                             NULL);
                             
       XmStringFree(str[0]);                             
           
       XtManageChild(rowcol);
       for (j=0;j<4;j++)
         XtAddCallback(text[j+4*i],XmNactivateCallback,plot_entry,
                      (XtPointer) this); 
       if (i<8) 
	 {
	   l_str[0]=char(i+50);
	 }
       else
	 {
	   l_str[0]=char((i+2) / 10)+'0';
           l_str[1]=char((i+2) % 10)+'0';
	 }
       }
        
          
     XtManageChild(rowtwo);   //End of parameter table


     CreateActionArea(pane,act3,3);

     XtManageChild(pane);
     XtAddCallback(plog,XmNdestroyCallback,remove_plot,
                   (XtPointer) this);
     
     XtPopup(plog,XtGrabNone);   
     if (xx || yy) 
       XtVaSetValues(plog,XmNx,xx,XmNy,yy,NULL);
     ng=plot_.plot_total;
     set_val();
     if (td)
       XtDestroyWidget(td);
     }
   else
     {
     if (plog) 
       {
       set_val();
       XtPopup(plog,XtGrabNone);
       }
     }
  */
}   

plot_param::plot_param() : plog(0),text(0),ng(0)
{}

   
plot_param::~plot_param()
{
  Widget tvg=0;
  if (plog)
    {
      tvg=plog;
      XtDestroyWidget(tvg);
    }
  plog=0;
  delete [] text;
}
  
void 
plot_param::down_load
(Widget w,XtPointer client_data,XtPointer call_data)
{
  
  cout<<"I havent implimented this yet!"<<endl;
  return;
}
  
int 
plot_param::get_val()
{

// #pragma extern_model common_block  
  /*
  extern Plts plot_;
    
  char out[255];
  double temp;
  int ic[3],err;
  int n_g=0;
  for(int i=0;i<ng+1;i++)
    { 
      err=0;
      strcpy(out,XmTextFieldGetString(text[4*i]));     
      ic[0]=atoi(out);
      strcpy(out,XmTextFieldGetString(text[4*i+1]));     
      ic[1]=atoi(out);
      strcpy(out,XmTextFieldGetString(text[4*i+2]));     
      ic[2]=atoi(out);
      strcpy(out,XmTextFieldGetString(text[4*i+3]));          
      temp=atof(out);
      
      if (!i && plot_.plot_sel[0]==' ') 
	{
	  for (int j=0;j<3;j++)
	    {
	      if (ic[j]>tg || ic[j]<0) 
		ic[j]=0; 
	    }
	}
      else if (!i && ic[0]==0)
	{
	  ic[1]=0;
	  ic[2]=0;
	  plot_.plot_sel[0]=' ';
	  temp=0.0;
	}
      else if(i!=ng)
	{
	  if (!ic[0])
	    {
	      err=1;
	      temp=0.0;
	      ic[1]=ic[2]=0;
	    }
	  else
	    {
	      if ((ic[0]>tg || ic[0]<1)) 
		ic[0]=plot_.plot_graph[i];
	      if (ic[2]>255 || ic[2]<1)
		ic[2]=(plot_.plot_colour[i]<1) ? 1 : plot_.plot_colour[i];
	      if (ic[1]>255 || ic[1]<-255 || !ic[1])
		ic[1]=(!plot_.plot_style[i]) ? 1 : plot_.plot_style[i];      
	      if (temp>255.0 || temp<0.01) 
		temp=(plot_.plot_size[i]<0.1) ? 1.0 : plot_.plot_size[i];
	    }
	} 
      else
	{
	  //ng==i;
	  if (ic[0]>tg || ic[0]<1)
	    err=1;
	  else
	    {
	      if (ic[1]>255 || ic[1]<-255 || !ic[1])
		ic[1]=1;
	      if (ic[2]>255 || ic[2]<1)
		ic[2]=1;
	      if (temp>255.0 || temp<0.01) 
		temp=1.0;
	      
	    }
	}
    if (!err)
      {
	plot_.plot_graph[n_g]=ic[0];
	plot_.plot_style[n_g]=ic[1];
	plot_.plot_colour[n_g]=ic[2];
	plot_.plot_size[n_g]=temp;
	if (i!=ng)
	  plot_.plot_sel[n_g]=plot_.plot_sel[i];
	else
	  plot_.plot_sel[n_g]='O';
	n_g++;    
      }    
    else if (i!=ng)
      {
	plot_.plot_graph[n_g]=plot_.plot_graph[i];
	plot_.plot_style[n_g]=plot_.plot_style[i];
	plot_.plot_colour[n_g]=plot_.plot_colour[i];
	plot_.plot_size[n_g]=plot_.plot_size[i];
	plot_.plot_sel[n_g]=plot_.plot_sel[i]; 
      }     
  
    }
  
  if (n_g!=plot_.plot_total)
    {
      plot_.plot_total=n_g;
      return 1;
    }

  */
  return 0;
}
      
  
void 
plot_param::set_val()
{
    /*  extern Plts plot_;
    
  
  if (!plog) return;
 
  char out[255];
  int k;
  for(int i=0;i<ng;i++)
    {    
    sprintf(out,"%d",plot_.plot_graph[i]);    
    for(k=0;k<250 && out[k]==' ';k++);       
    XmTextSetString(text[4*i],out+k);
    sprintf(out,"%d",plot_.plot_style[i]);    
    for(k=0;k<250 && out[k]==' ';k++);       
    XmTextSetString(text[4*i+1],out+k);
    sprintf(out,"%d",plot_.plot_colour[i]);    
    for(k=0;k<250 && out[k]==' ';k++);       
    XmTextSetString(text[4*i+2],out+k); 
    sprintf(out,"%20g",plot_.plot_size[i]);    
    for(k=0;k<250 && out[k]==' ';k++);       
    XmTextSetString(text[4*i+3],out+k);   
    }
  for(int i=0;i<4;i++)
    XmTextSetString(text[4*ng+i],"");    
  return;
    */
}
  
  
