/* 
   This part of Cmdspec source files 
   Copyright (C) 1991-2001 Stuart Ansell 
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,

   Last modified 15 July 2001
*/

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include <map>
#include "cmd.h"
#include "fortran.h"
#include "fglobal.h"
#include "wshare.h"
#include "gaussbox.h"
#include "words.h"
#include "outinfo.h"
#include "control.h"
#include "npic.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"
#include "spacebox.h"
#include "space.h"
#include "new_read.h"
#include "box_plot.h"
#include "svd.h"
#include "fileselect.h"
#include "readfunc.h"
#include "file_rec.h"

int ttv=0;
XtAppContext  app;
Widget command_w,text_w;
Widget top,main_w;
int pos(0);
int flg(0);
int inprocess_flg(0); // Have we called view / yes / no.
int level(0);         //depth that we penetrate in the call list


Frame plook;
plot_param glook;
gauss gauss_box;
bin_file sd;
file_rec ocont;
Box_Screen bsa;
words fullcmd;
outinfo wrtout;
Picture oneD;
Motif_Pts motpt_;   //Can be C'ified
Plts plot_info;
decompose single;
fselect file_box;

wback hold_;
Spec_In storage_;
titls about_;


int
main(int argc,char *argv[])
{
    extern wback hold_;              // class item.
    motpt_.mode=1;
    //    viewinit_();   //call fortran set up for common areas.

    Widget menubar;
    Arg    args[5];
    int    n = 0;
   
    XtSetLanguageProc (NULL, NULL, NULL);
    hold_.graph_flag=0;

    /* initialize toolkit and create toplevel shell */
    top = XtVaAppInitialize (&app, "Spec",
        NULL, 0, &argc, argv, NULL, NULL);

    main_w = XtVaCreateManagedWidget ("main",
        xmMainWindowWidgetClass, top,
        XmNcommandWindowLocation, XmCOMMAND_BELOW_WORKSPACE,
        NULL);

// Set the colours as we would like!

/*   XColor colour;
   colour.flags = DoRed | DoGreen | DoBlue;
   Colormap cmap=DefaultColormapOfScreen(XtScreen(top));
   XAllocColor(XtDisplay(top),cmap, &colour);
  
   colour.red=10000; 
   colour.green = 20000;
   colour.blue = 10000;
//   XFreeColors (XtDisplay(top),cmap,&colour.pixel, 1,0);
   if (!XAllocColor(XtDisplay(top),cmap,&colour))
     cout<<"Can't allocate color here!"<<endl;
 */    
   
 // Create a simple MenuBar....


   men_item mode_menu[]= {
     { "Command",&xmPushButtonGadgetClass, 'C', NULL, NULL,
        mode_cmd, (XtPointer) 0, (men_item*) NULL },
     { "Graphic",&xmPushButtonGadgetClass, 'G', NULL, NULL,
        mode_cmd, (XtPointer) 1, (men_item*) NULL },
     { "Area",&xmPushButtonGadgetClass, 'A', NULL, NULL,
        mode_cmd, (XtPointer) 2, (men_item*) NULL },
     { "Box",&xmPushButtonGadgetClass, 'B', NULL, NULL,
        mode_cmd, (XtPointer) 3, (men_item*) NULL },
     { "Exafs",&xmPushButtonGadgetClass,'E', NULL, NULL,
        mode_cmd, (XtPointer) 4, (men_item*) NULL },
     {0,}
   };
  

 men_item data_menu[] = {
    { "Open...", &xmPushButtonGadgetClass, 'L', NULL, NULL,
        men_cmd, (XtPointer) "jf", (men_item*) NULL },
    { "List READ", &xmPushButtonGadgetClass, 'L', NULL, NULL,
        men_cmd, (XtPointer) "dc 1", (men_item*) NULL },
    { "Fourbris", &xmPushButtonGadgetClass, 'F', NULL, NULL,
        men_cmd, (XtPointer) "dc 2", (men_item*) NULL },
    { "DCS", &xmPushButtonGadgetClass, 'C', NULL, NULL,
        men_cmd, (XtPointer) "dc 3", (men_item*)  NULL },
    { "Genie", &xmPushButtonGadgetClass, 'G', NULL, NULL,
        men_cmd, (XtPointer) "dc 4", (men_item*)  NULL },
    { "Var-head xye", &xmPushButtonGadgetClass, 'V', NULL, NULL,
        men_cmd, (XtPointer) "dc 5", (men_item*)  NULL },
    { "WAX-ray", &xmPushButtonGadgetClass, 'W', NULL, NULL,
        men_cmd, (XtPointer) "dc 6", (men_item*)  NULL },
    { "Multi-WAX-ray", &xmPushButtonGadgetClass, 'M', NULL, NULL,
        men_cmd, (XtPointer) "dc 7", (men_item*)  NULL },
    { "X6B-xray", &xmPushButtonGadgetClass, 'X', NULL, NULL,
        men_cmd, (XtPointer) "dc 8", (men_item*)  NULL },
    { "Select Column", &xmPushButtonGadgetClass, 'S', NULL, NULL,
        men_cmd, (XtPointer) "dc 9", (men_item*)  NULL },
    { "Bin Xray", &xmPushButtonGadgetClass, 'B', NULL, NULL,
      men_cmd, (XtPointer) "dc 10", (men_item*)  NULL },
    { "Esrf scan", &xmPushButtonGadgetClass, 'E', NULL, NULL,
      men_cmd, (XtPointer) "dc 11", (men_item*)  NULL },
    {0,}
}; 

 men_item graphics_menu[] = {
    { "Axis", &xmPushButtonGadgetClass, 'A', "Meta<Key>a","Meta+A",
        change_graphics, 0,  (men_item*) NULL },
    { "Plot Info", &xmPushButtonGadgetClass, 'P', "Meta<Key>p","Meta+P",
        change_graphics, (XtPointer) 1, (men_item*) NULL },
    { "Gaussian Fits", &xmPushButtonGadgetClass, 'G', "Meta<Key>g","Meta+G",
        change_graphics, (XtPointer) 3, (men_item*) NULL },
    { "General Fits", &xmPushButtonGadgetClass, 'F', "Meta<Key>f","Meta+F",
        change_graphics, (XtPointer) 4, (men_item*) NULL },
    { "Hardcopy", &xmPushButtonGadgetClass, 'H', "Meta<Key>k","Meta+K",
        change_graphics, (XtPointer) 2, (men_item*) NULL },
    {0,}
}; 
  
 men_item file_menu[] = {
    { "Data Type", &xmCascadeButtonGadgetClass, 'D', NULL, NULL,
        0, 0, data_menu },
    { "sep1", &xmSeparatorGadgetClass,(char) 0,NULL, NULL,
        NULL, NULL,(men_item*) NULL },
    { "sep2", &xmSeparatorGadgetClass,(char) 0,NULL, NULL,
        NULL, NULL,(men_item*) NULL },
    { "Exit", &xmPushButtonGadgetClass, 'x',"Ctrl<Key>c","Ctrl+C",
       exit_out,0,(men_item*) NULL },
    {0,}
};
  
 men_item help_menu[] = { 
    { "Axis", &xmPushButtonGadgetClass, 'A', 0, 0,
        help_cmd,(XtPointer) 'A',(men_item*) 0 },   
    { "Cursor", &xmPushButtonGadgetClass, 'A', 0,0,
        help_cmd,(XtPointer) 'C',(men_item*) 0 },              
    { "Edit", &xmPushButtonGadgetClass, 'A', 0,0,
        help_cmd,(XtPointer) 'E',(men_item*) 0 },        
    {0,}
    };


    menubar=XmCreateMenuBar(main_w,"menubar",NULL,0);
    BuildPulldownMenu(menubar,"Mode",'M',0,mode_menu,0);
    BuildPulldownMenu(menubar,"File",'F',0,file_menu,0);
    BuildPulldownMenu(menubar,"Graphics",'G',0,graphics_menu,0);
    Widget help_mnn = BuildPulldownMenu(menubar,"Help",'H',0,help_menu,0);   

    XtVaSetValues(menubar,XmNmenuHelpWidget,help_mnn,NULL);

// Menubar is done -- manage it 
    
    XtManageChild (menubar);

    /* Create ScrolledText -- this is work area for the MainWindow */

    XtSetArg (args[n], XmNrows,10); n++;
    XtSetArg (args[n], XmNcolumns, 70); n++;
    XtSetArg (args[n], XmNeditable,  False); n++;
    XtSetArg (args[n], XmNeditMode,  XmMULTI_LINE_EDIT); n++;
    text_w = XmCreateScrolledText (main_w, "text_w", args, n);
    XtManageChild (text_w);
                                                   
    XmString file = XmStringCreateLocalized ("Command:");

// This is the point that the histroy is done.    

    command_w = XtVaCreateWidget ("command_w", xmCommandWidgetClass, main_w,
        XmNpromptString, file,
        XmNhistoryVisibleItemCount,5,
//        XtVaTypedArg, XmNbackground, "#3a7',
//        XmRString, "SkyBlue" , 8,
        NULL);
    XmStringFree (file);
    XtAddCallback (command_w, XmNcommandEnteredCallback, exec_cmd, text_w);
  
    XtManageChild (command_w);
    XmMainWindowSetAreas (main_w, menubar, command_w,
        NULL, NULL, XtParent (text_w));
    XtRealizeWidget (top);
//    XmChangeColor(main_w,colour.pixel);
//    XmChangeColor(command_w,colour.pixel);
    XtAppMainLoop (app);
}
/* execute the command and redirect output to the ScrolledText window */


void check_history()
  /* Debug command to check the histroy in the command window */
{
  Widget test=XmCommandGetChild(command_w,XmDIALOG_HISTORY_LIST);
  int Nvalues;
  XmStringTable tbl;
  XtVaGetValues(test,
		XmNitemCount,&Nvalues,
		XmNitems,&tbl,
		NULL);
  cout<<"Nvalues =="<<Nvalues<<endl;
  char* cmd[10];
  for(int i=1;i<=10;i++)
    {
      if ((Nvalues-i)>=0)
        {
	  XmStringGetLtoR (tbl[Nvalues-i], XmFONTLIST_DEFAULT_TAG, &cmd[i]);  
	  cout<<"String "<<i<<" =="<<cmd[i]<<endl;
	  XtFree(cmd[i]);
	}
    }

  return;
}

void place_cmd(char *s)
  /* Test function to check writting to the cmdline */
{
  int len;
  if (s && (len=strlen(s))>0)
    {
      XmString input=XmStringCreateLocalized (s);
      XmCommandSetValue(command_w,input);
      Widget test=XmCommandGetChild(command_w,XmDIALOG_COMMAND_TEXT);
      XtVaSetValues(test,XmNinsertPosition,len,NULL);
      XmTextSetCursorPosition(test,len);
      XmStringFree(input);
    }
  else
    {
      XmString input=XmStringCreateLocalized("");
      XmCommandSetValue(command_w,input);
      Widget test=XmCommandGetChild(command_w,XmDIALOG_COMMAND_TEXT);
      XtVaSetValues(test,XmNinsertPosition,0,NULL);
      XmTextSetCursorPosition(test,0);
      XmStringFree(input);
    }
  return;
}

void 
exec_cmd(Widget cmd_widget, XtPointer client_data, XtPointer call_data)
  /* command called form the main window to execute a text string */
{
  //#pragma extern_model common_block // need to define it here as can't be
  extern wback hold_;              // class item.

  char *cmd;
  char cmdin[82];
  char boldname[82];
  char numbers[82];

  XmCommandCallbackStruct *cbs = 
    (XmCommandCallbackStruct *) call_data;
  XmStringGetLtoR (cbs->value, XmFONTLIST_DEFAULT_TAG, &cmd);
  if (!cmd || !*cmd) 
    {                     // nothing typed?
      if (cmd)
        XtFree (cmd);
      return;
    }
  if (hold_.graph_flag>4)  // Frozen command entry.
    {
      XtFree(cmd);
      return; 
    }
  
  strncpy(hold_.is,cmd,80);    //zero hold.is ???
  strncpy(cmdin,cmd,80);      
  cmdin[80]=0;    
  XtFree (cmd);
  if (ocont.wr_out)               // are we writting out command ?
    ocont.write_elem(cmdin);
  
  int type=0; //type tells the fortran that it is from the command line = 0

  for(int i=0;i<80;i++)
    if(hold_.is[i]<10) hold_.is[i]=' ';
  ocont.str_exec(cmdin);
  if (flg)  //are we in a sub-command. (NOTE: QUERRY / LOOP forbidden )
    {
      flg=0;
      XmTextReplace(text_w,pos,pos,cmdin);
      pos+=strlen(cmdin);
      XmTextReplace(text_w,pos,pos,"\n");
      pos++;
      return;
    }
  inprocess_flg=1;  //now in view.
  place_cmd(0);    //place command string into command history

  numbers[0]=0;  //incase word_lookup does not change.
  boldname[0]=0;
  if (!fullcmd.word_lookup(boldname,numbers) && boldname[0])
    {
      XmTextReplace(text_w,pos,pos,boldname);
      int boldlen = strlen(boldname);
      //      XmTextSetHighlight(text_w,pos,pos+boldlen,
      //			 XmHIGHLIGHT_SECONDARY_SELECTED);
      pos+=boldlen;
      XmTextReplace(text_w,pos,pos,numbers);
      pos+=strlen(numbers);
      XmTextReplace(text_w,pos,pos,"\n");
      pos++;
    }  
  else
    {
  // Write out the command
      XmTextReplace(text_w,pos,pos,cmdin);
      pos+=strlen(cmdin);
      XmTextReplace(text_w,pos,pos,"\n");
      pos++;
    }
  view(type);

  if (hold_.wopt>1) 
    { 
      cout<<"IN wopt == 1 ** ERROR"<<endl;
      level++;
      cmdin[79]=0;
      XmString cmd_str=XmStringCreateLocalized (cmdin);
      XtVaSetValues(cmd_widget,XmNpromptString,cmd_str,NULL);
      XmStringFree(cmd_str);                          
    }
  else
    {
      XmString cmd_str;
      level=0;
      if (hold_.graph_flag==1)
        cmd_str=XmStringCreateLocalized ("Graphic Command:");
      else if(hold_.graph_flag==2)
        cmd_str=XmStringCreateLocalized("2d Plot Command:");
      else if(hold_.graph_flag==3)
        cmd_str=XmStringCreateLocalized("Rmc Plot Command:");
      else if(hold_.graph_flag==4)
        cmd_str=XmStringCreateLocalized("Exafs Command:");
      else
	cmd_str=XmStringCreateLocalized ("Command:");
      XtVaSetValues(cmd_widget,XmNpromptString,cmd_str,NULL);
      XmStringFree(cmd_str); 
    }
  if (ocont.active)
    {
      workhistory();
      if (!ocont.querry) 
	place_cmd("");
    }
  inprocess_flg=0;  //returning from view..
  return;
}


void mode_cmd(Widget m_w, XtPointer client_data, XtPointer call_data)
{
  /* 
     Excutes a mod command 
     uses global variable pos
  */

  extern wback hold_;              // class item.
  
  int type;
  char cmdword[80];
  type = (int) client_data;
  switch (type) 
    {
    case 0:
      strcpy(cmdword,"Switched to Command mode\n"); 
      hold_.graph_flag=0;
      break;
    case 1:
      strcpy(cmdword,"Switched to Graphics mode\n"); 
      hold_.graph_flag=1;
      break;
    case 2:
      strcpy(cmdword,"Switched to Area mode\n");
      hold_.graph_flag=2;
      break;
    case 3:
      strcpy(cmdword,"Switched to Box mode\n");
      hold_.graph_flag=3;
      break;
    case 4:
      strcpy(cmdword,"Switched to Exafs mode\n");
      hold_.graph_flag=4;
      break;
    }
  
  XmTextReplace(text_w,pos,pos,cmdword);
  pos+=strlen(cmdword);
  XmTextReplace(text_w,pos,pos,"\n"); 
  pos++;
  if (!level) s_line();
  return;
}


void men_cmd(Widget m_w, XtPointer client_data, XtPointer call_data)
{
  /* Excutes a menu command 
     uses GLOBAL pos for text insertion within the text widget */

  extern wback hold_;              // class item.
  
  char *cmd;
  char cmdin[82];
  cmd= (char*) client_data;

  strncpy(cmdin,cmd,80);    //don't copy too many chars
  cmdin[79]=0;
  int leng=strlen(cmdin);  //limit leng<=79

  if (leng>0)
    {
      cmdin[leng]='\n';
      cmdin[leng+1]=0;
      XmTextReplace(text_w, pos, pos,cmdin);
      pos += leng+1;
    }

  strcpy(hold_.is,cmdin);   // Adjust if hold become longer than 80 char.

  int type=0; //type tells the fortran that it is from the command line = 0
  view(type);
  return;
}

void 
layer_command(const char* DisStr)
  /* 
     this is to disallow text entry until a cursor operation has happened
   */
{
  extern wback hold_;              // class item.
  
  if (hold_.graph_flag ==1 ) hold_.graph_flag = 5;
  if (hold_.graph_flag ==2 ) hold_.graph_flag = 6;
  if (hold_.graph_flag ==3 ) hold_.graph_flag = 7;
//  XEvent evt;
//  XEvent *event_return= &evt;

  int count=0;
  while (DisStr[count]==' ' || DisStr[count]=='\t') 
    count++;
  level++;
  XmString cmd_str=XmStringCreateLocalized (const_cast<char*>(DisStr)+count);
  XtVaSetValues(command_w,XmNpromptString,cmd_str,NULL);
  XmStringFree(cmd_str);
  CheckForInterrupt();
  return;
} 


void help_cmd(Widget A,XtPointer b,XtPointer c)
{
  return;
}

void set_data_type(Widget A,XtPointer b,XtPointer c)
{
  return;
}

void 
change_graphics(Widget A,XtPointer b,XtPointer c)
  /* 
     The window command deals with the graphics menu bar 
  */
{
  extern wback hold_;
  
  if ( b == 0) 
    {
      plook.make_wind();
    }
  else if ( b== (XtPointer) 1)
    {
      glook.make_wind(0);
    }
  else if ( b== (XtPointer) 3)
    {
      gauss_box.make_wind();
    }
  else if ( b== (XtPointer) 4)
    {
      wind_fit(0,0);
    }
  else 
    {
      if(hold_.graph_flag==2)
	{
	  sd.keep();
	  return;
	}
      plook.redraw(1);
      return;
    }
  return;
}

void set_file_type(Widget A,XtPointer client_data,XtPointer c)
{
     //   int item=(int) client_data;
  return;
}

void update_plot()
{
  glook.make_wind(1);
  return;
}


void
reset_cursor()
{
  plook.reset_c_mode();
}

/*

void
arm_edit()
{
  plook.arm_e_cursor();
}
*/
int mpgband(const int mode,const int posn,const float xx,const float yy,
            float &xo,float &yo,char &ans)
{
  return plook.sband(mode,posn,xx,yy,xo,yo,ans);
}

void go_away(Widget A,XtPointer b,XtPointer c)
{
  cout<<"In go_away!"<<endl;
  ttv=2;
  //  Widget dialog=XtParent(A);
  //  dialog=XtParent(dialog);
  XtUnmanageChild(A);
  return;
}


void exit_out(Widget A,XtPointer b,XtPointer c)
{
  exit(0);
}

void writeString(const char *s,const int control,int leng)
  /* Writes the string to the text window removing excess space
     and chops the string in to 80 line sections if necessary */
{
  if (leng<=0)
    leng=strlen(s);
  int spc(0);
  for(int lastpt=0;lastpt<leng && s[lastpt] && 
	s[lastpt]!='\n';lastpt++)
    {
      if (s[lastpt]!=' ' || s[lastpt]!='\t')
	spc=lastpt;
    }
  char sline[82];  //max length for a line in text window.
  int linept(0);
  while (spc>0)
    {
      int ncopy = (spc>80) ? 80 : spc+1;
      strncpy(sline,s+linept,ncopy);
      sline[ncopy]='\n';
      sline[ncopy+1]=0;
      XmTextReplace(text_w,pos,pos,sline);
      wrtout.file_control(sline,control);
      pos+=ncopy+1;
      spc-=80;
      linept+=80;
    }
  return;
}

void writeCommand(const char *s,int leng)
  
  /* Writes the string to the command prompt window removing excess space
     and chops the string in to 80 line sections if necessary */
{
  if (leng<=0)
    leng=strlen(s);
  int startpt;
  for(startpt=0;startpt<leng && 
	(s[startpt]==' ' || s[startpt]=='\t');startpt++);
  
  int spc(0);
  for(int lastpt=startpt;lastpt<leng && s[lastpt] && 
	lastpt<leng && s[lastpt]!='\n';lastpt++)
    {
      if (s[lastpt]!=' ' || s[lastpt]!='\t')
	spc=lastpt;
    }
  char sline[82];  //max length for a cmdline in text window.
  int ncopy = (spc>79+startpt) ? 79 : 1+spc-startpt;
  strncpy(sline,s+startpt,ncopy);
  sline[ncopy]=0;
  XmString cmd_str=XmStringCreateLocalized(sline);
  XtVaSetValues(command_w,XmNpromptString,cmd_str,NULL);
  XmStringFree(cmd_str);
  return;
}

void l_c(char* s,const int control,const int leng)
  /* Call from C++ to get a string or write a string */
{  

  XEvent evt;
  XEvent *event_return= &evt;

  writeString(s,control,leng); //s is the input string written to screen
  if (!control && ocont.active)  //ie reading from a file...
    {
      std::string nret;
      int chk=0;
      while((chk=ocont.getnextvalue(nret))>=2); //cont. if empty string 
      if (chk==1)                         //Not a question therefore process 
        {
	  writeString(nret.c_str(),control);  //check dealing with cmdstring
	  strncpy(s,nret.c_str(),leng-1);
	  s[leng-1]=0;
          return;
        }
    } 

  if (control)
    wrtout.file_control(s,control);  //does ocon.active affect this ?

  if (!control)
    {
      writeCommand(s,leng);
      flg=1;
      while(flg)  //continuous loop until data entry
	{
	  XtAppNextEvent(app,event_return);
	  XtDispatchEvent(event_return);     
	}  
      if (leng>80)
	{
	  strncpy(s,hold_.is,80);
	  s[80]=0;
	}
      else
	{
	  strncpy(s,hold_.is,leng-1);
	  s[leng-1]=0;
	}
    }
  else   //No return value.
    {
      CheckForInterrupt(); //update windows
      return;
    }
}

  
void s_line()
{  
  /* sets the command line when there is a refresh after exiting
     a command
  */

  extern wback hold_;              // class item.
  
  level=0;
  XmString cmd_str;
  if (hold_.graph_flag==1)
    cmd_str=XmStringCreateLocalized ("Graphic Command :");
  else if(hold_.graph_flag==2)
    cmd_str=XmStringCreateLocalized("2d Plot Command :");
  else if (hold_.graph_flag==3)
    cmd_str=XmStringCreateLocalized("Rmc Plot Command :");
  else if (hold_.graph_flag==4)
    cmd_str=XmStringCreateLocalized("Exafs Command :");
  else
    cmd_str=XmStringCreateLocalized ("Command:");
  XtVaSetValues(command_w,XmNpromptString,cmd_str,NULL);
  XmStringFree(cmd_str); 
  return;
}


void
CheckForInterrupt()
{
    Display *dpy = XtDisplay (top);
 
    /* Make sure all our requests get to the server */
    XFlush (dpy);

    /* Let Motif process all pending exposure events for us. */
    XmUpdateDisplay (top);
    return;
}

void
endhistory()
{
  if (ocont.wr_out)
    ocont.wclose();
  return;  
}

void
starthistory()
{
  if(ocont.wr_out) 
    {
      ocont.wclose();
      return;
    }
  char s[256];
  strcpy(s,"Output history file =>");
  l_c(s,0);
  if (!ocont.wopen(s))
    {
      l_c("Error opening file",1);
      return;
    }
  l_c("All commands will now be logged",1);
  return;
}


void
readhistory()
{
  
  extern wback hold_;
  char s[256];
  if (!ocont.open(hold_.is))
    {
      strcpy(s,"What is the history file =>");
      l_c(s,0);
      if (!ocont.open(s))
	{
	  l_c("Error opening file",1);
	  return;
	}
    }
  l_c("Successfully opened file",1);
  ocont.makeactive();
  return;
}  
  
void 
workhistory()
{
  extern wback hold_;

  int strv,type=0;
  
  if (ocont.querry)
      ocont.querry--;
  while(ocont.needloop())
    {
      //    layer_write(); //MAYBE need something here..????
      string rtval;
      strv=ocont.getnextvalue(rtval);   //writes to hold_.is
      strncpy(hold_.is,rtval.c_str(),80);
      hold_.is[79]=0; 
      if (strv==1)   //got a resonable line
	{
	  writeString(rtval.c_str(),1);  //check dealing with cmdstring
	  view(type);
	}
      else if (strv==2)  //question
	{
	  // We are in a querry
          place_cmd(hold_.is);
	  //   ocont.deactive();    //don't close file need that later
	}
    }
  s_line();
  return;
}

void
history(char *ans)
{
  if (*ans=='R')
    {
      readhistory();
      return;
    }

  if (*ans=='C') 
    {
      if(ocont.wr_out) 
	ocont.wclose();
      return;
    }
  
  if (*ans=='O')
    {
      if(ocont.wr_out) 
	{
	  ocont.wclose();
	  return;
	}
      starthistory();
    }
}

void set_file_func(const int dtype)
{
  file_box.set_func(dtype);
}


/*
void 
check_size(Widget w,XtPointer client_data,XEvent* event,char* s)
{
  
  XResizeRequestEvent *rqe = (XResizeRequestEvent *) event;
  Widget scns = (Widget) client_data;
  Widget m_w = XtParent(scns);
  Widget p_s = XtParent(m_w);
   
  Dimension width, height;

  XtVaGetValues(scns,
                XmNwidth, &width,
                XmNheight, &height,
                NULL);
  cout<<"Scns "<<width<<" "<<height<<endl;
  XtVaGetValues(m_w,
                XmNwidth, &width,
                XmNheight, &height,
                NULL);
  cout<<"main_w "<<width<<" "<<height<<endl;
  XtVaGetValues(p_s,
                XmNwidth, &width,
                XmNheight, &height,
                NULL);
  cout<<"Pshell "<<width<<" "<<height<<endl;
  width=rqe->width;
  height=rqe->height;
  cout<<"Set "<<width<<" "<<height<<endl;
  width=500;
  height=500;
  / *  XtVaSetValues(p_s,
		XmNwidth, width,
		XmNheight, height,
		NULL);
  XtVaSetValues(m_w,
		XmNwidth, width,
		XmNheight, height,
		NULL);
  XtVaSetValues(scns,
		XmNwidth, width,
		XmNheight, height,
		NULL);  * /
  //  XFlush(rqe->display);
  XResizeWindow(rqe->display,rqe->window,width,height);
  //  XFlush(rqe->display);
  CheckForInterrupt(); 
  return;
}

*/











/*void layer_control__()
{
  layer_control();
}


void layer_write__()
{
  layer_write();
}

void layer_continue__()
{
  layer_continue();
}
*/

/* 
  
void 
layer_control()
  /* Job is to take control of the window, get some text
     and return to the calling funciton * /
{
  extern wback hold_;              // class item.
  
  char cmdin[82];
  XEvent evt;
  XEvent *event_return= &evt;

  for(int k=0;k<hold_.len || k==0;k++)
    {
      strncpy(cmdin,hold_.os[k],80);
      cmdin[80]='\n';
      cmdin[81]=0;        
      XmTextReplace(text_w, pos, pos,cmdin);
      pos +=strlen(cmdin);
      wrtout.file_control(cmdin,0);
    }
  if (ocont.active)
    {
      int chk=0;
      while((chk=ocont.getnextvalue())>=2);  //continue while empty string
      if (chk==1)                            // 
        {
          strncpy(cmdin,hold_.is,80);
          cmdin[80]='\n';
          cmdin[81]=0;
          XmTextReplace(text_w, pos, pos,cmdin);
          pos +=strlen(cmdin); 
          return;
        }
    } 
  int  kk;  
  for(kk=0;cmdin[kk]!='\n' && cmdin[kk] && kk<80;kk++);
  cmdin[kk]=0;
  hold_.len=0;
  level++;
  XmString cmd_str=XmStringCreateLocalized(cmdin);
  XtVaSetValues(command_w,XmNpromptString,cmd_str,NULL);
  XmStringFree(cmd_str);
  flg=1;
  while(flg)
    {
      XtAppNextEvent(app,event_return);
      XtDispatchEvent(event_return);     
    }  
  return;
}

void layer_continue()
{
  extern wback hold_;            
  
  XEvent evt;
  XEvent *event_return= &evt;
    
  hold_.len=0;
  flg=1;
  do 
    {
      XtAppNextEvent(app,event_return);
      XtDispatchEvent(event_return);     
    }  while(flg);
  return;
}  

  
void 
layer_write()
  {
 //  #pragma extern_model common_block    // need to define it here as can't be
  extern wback hold_;              // class item.
  
  char cmdin[82];

  for(int k=0;k<hold_.len || k==0;k++)
    {
      strncpy(cmdin,hold_.os[k],80);
      cmdin[80]='\n';
      cmdin[81]=0;        
      XmTextReplace(text_w, pos, pos,cmdin);
      pos += strlen(cmdin);
      hold_.os[k][0]=0;
      cmdin[80]=0;
      wrtout.file_control(cmdin,1);
    } 
  hold_.len=0;
  CheckForInterrupt();
  return;
  } 
  
*/






