#ifndef cmd_h
#define cmd_h

#define maxpts 4000
#define tg 40
#define mx_grph 20 // note: see also pg_max.
#define holdlen 80  //So we can use a longer line later

void history(char *);
void workhistory();
void readhistory();
void starthistory();
void endhistory();
void l_c(char*,const int=0,const int= 80);
void place_cmd(char *);             // Test function 
void check_history();
void arm_edit();
void layer_command(const char*);   
void writeString(const char*,const int,int =0);
void writeCommand(const char*,int =0);



void output(const char,const char* =0);
void output_screen(const char);
void wave_smoo(char *);
void wave_strip(char *);
void transf(char*,int *,int *);
void derivative();
void select_col(const char);
void esrf_read(ifstream&,const int,const int,int,
	       int,int =-1);
template<class T> int setvalues(const char *,const int=0,T * =0,const int=0,
                           T * =0,const int=0,T * =0);

void draw2d(int*,int*);
void draw3d(int*,int*);

void drawrmc(const int,const int);
void main_control(int&,char,char,int,int,int); 
void cont_adds(char,char);
void rmcplots(char,char,int);
void exafs(char,char,int,int,int); 
void twodplots(char,char,int,int,int); 

void output_cont(char *);
void find_width();
int info_width(const int,const int,const double,const double,
               double*,double*,double*,double&);
void qspace(char *);
void endby();
void window_func(char*);
void gaussfit(const char *);
void setgamma();
void cmd_rebin(const char);
void mirror(const char *);
void self_range(const int,int);
void cut_pts(const int,int);
void sort(const int =0);
void blend();
void find_maxmin(const int,double&,double&);
void inteprate(int*,int*,int*);
void wind_fit(const int,const int);
void view(const int);

struct wback
{
  char is[80];
  int wopt;
  int graph_flag;
};

union Gen_section
{  
  float fod[4];
  int   iod[4];
  char  cod[16];
};


struct AreaX
{
  int pt[tg];
};

struct titls             //Titles in spec.
{
  char hd[tg][40];
};

struct Spec_In           //data points in spec.
{
  double storx[tg][maxpts];
  double story[tg][maxpts];
  int stpnt[tg];
  double store[tg][maxpts];
};


class Plts              //List of stuff currently drawn
{
 public:
  
  
  
  int screen;
  int prter;
  int twod;
  int box;
};


struct Range  // Xmin ranges for pgplot
{
  double xmin;
  double xmax;
  double ymin;
  double ymax;
  double v[4];
  bool revs;
};

struct Wndw  // viewport window for pgspec.
{
  float w[4];   
  int pts[4];
  float as[2];
};


struct Capval
{
  double vv[11];
};

class str_var
{
private:

  int n_var;             // n_variables
  std::vector<std::string> vars;   // variable strings 

};

#endif






