#ifndef box_plot_h
#define box_plot_h

class Plot_Screen;

class atom
{
 private:

  double x,y,z;
  double radi;
  int type;
  std::vector<int> Bonded;


 public:
  
  atom();
  atom(const double,const double,const double,
       const double,const int);
  atom(const atom&);
  atom& operator=(const atom&);
  ~atom();
  void link(const int);
  void getvalues(double&,double&,double&,int&,double&) const;
  int range(const double*) const;
  int givebonded(int*& ) const;
  
};

class BoxMaps
{
 private:
  
  int n_pts;          
  std::vector<atom> At;
  int n_diff;
  double *radi;
  int count_word(char *) const;   //ret. atoms in molecule (from name);

 public:

  int read_data(char*);
  int read_rmc_data(char*);
  BoxMaps();
  BoxMaps(const BoxMaps&);
  BoxMaps& operator=(const BoxMaps&);
  ~BoxMaps();
  int atom_info(const double*,double *&,double *&,
		double *&,int *&,double *&,int *&) const;
  int makebondlist(const int,int *&) const;
};

class Box_Screen : public Plot_Screen
{
 private:
  
  const int max_Maps;            // number of maps 
  double range[6];
  double cx,cy,cz;               //centre of box
  double rd[3];                  //rmax-rmin for range. 

  double ltz;      // point to light from.
  double stx,sty,spr;  // spread and range of projection 
  double alpha,beta;       //angles
  double csa,sna,snb,csb;  // rotation cos/sin 
  int fill_circle;         // are the circles filled ?
  double rscale;           // radius scale
  double ldist;            // longest line distance between atoms


  BoxMaps *DD;             // place to get plot from
  int na_sel;              //number of atoms selected 
  float *vpx,*vpy;         // points mapped to the screen at viewpoint
  int *d_order;            // distance
  int n_plots;     //number of plots
  int plist[40];  // groups that are plotted

 public:
  
  Box_Screen();
  virtual ~Box_Screen();
  
  void draw_region(const int,const int =0);
  void plot_axis(const int=0);
  void planept(double &,double &,double*) const;
  void planept(float &,float &,double*) const;
  void viewplane(float &,float &,double*) const;
  void viewplane(float &,float &,const double,
		  const double,const double) const;
  void read_rmc(const int,int);
  void set_axis(const char,int);
  void set_rscale(const char);
  void set_viewpt(const char);
  void rotate(double *) const;
  void rotate(double &,double &,double &) const;
  void rev_rotate(double *) const;
  void sort_points(double *,double *,double *);
  void draw_circles(const int,double *,double *,double *,
		    int *,double *,int*) const;
  void draw_lines(const int,const int,double *,double *,
		    double *,int *,int*) const;
  void sort_drawing();
  void keep();
};

#endif











