#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "fglobal.h"
#include "cmd.h"
#include "extract.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"
#include "box_plot.h"
#define PI 3.141592653589


atom::atom() :
  x(0.0),y(0.0),z(0.0),radi(0.0),type(-1)
{}

atom::atom(const double X,const double Y,const double Z,
	   const double R,const int tp) :
  x(X),y(Y),z(Z),radi(R),type(tp)
{}

void
atom::link(const int A)
{
  Bonded.push_back(A); //number in the main list a bit cheesy
}

int 
atom::range(const double* range) const
{
  if (x>range[0] && x<range[1] &&
      y>range[2] && y<range[3] &&
      z>range[4] && z<range[5])
    return 0;
  else
    return 1;
}

void
atom::getvalues(double& xx,double& yy,double& zz,int& tp,double& rd) const
{
  xx=x; yy=y; zz=z; 
  tp=type;
  rd=radi;
  return;
}

int
atom::givebonded(int*& bl) const
{
  int nx=Bonded.size();
  if (nx<=0) 
    {
      bl=0;
      return 0;
    }
  bl=new int[nx];
  for(int i=0;i<nx;i++)
    bl[i]=Bonded[i];
  return nx;
}

atom::atom(const atom& A) :
  x(A.x),y(A.y),z(A.z),radi(A.radi),type(A.type)
{
  Bonded=A.Bonded;
}

atom&
atom::operator=(const atom& A) 
{
  if (&A != this)
    {
      x=A.x;
      y=A.y;
      z=A.z;
      radi=A.radi;
      type=A.type;
      Bonded=A.Bonded;
    }
  return *this;
}


atom::~atom()
{}

BoxMaps::BoxMaps() 
  : n_pts(0),n_diff(0),radi(0)                  
{ }
  

int 
BoxMaps::read_rmc_data(char *s) 
{
  ifstream imfle;
  if (s)
    imfle.open(s,ios::in);  // removed ios::nocreate
  char ss[256];

  if (!imfle || !s)
    {
      imfle.close();
      strcpy(ss,"What is the rmc data set file =>");
      l_c(ss,0);
      s_line();
      int j;
      for(j=0;ss[j]>' ' && j<80;j++);
      ss[j]=0; 
      imfle.open(ss,ios::in);   // removed ios::nocreate
    }
   
  if (!imfle) return 1;
  int pts;
  double junk;
  imfle>>pts;  //number of molecules + atoms
  imfle>>junk>>junk>>junk>>junk;

  if (!imfle || pts<1) 
    {
      imfle.close();
      return 1;
    } 

  At.clear();
  
  std::vector<double> idr;   //place to read in radi list
  double x,y,z,rd,dx,dy,dz;
  int tp;
  int n_atoms=0;
  int n_central;
  for(int i=0;i<pts && imfle.good();i++)
    {
      imfle.getline(ss,255,'\n');  //remove trailing <return>
      imfle.getline(ss,255,'\n');
      int npart=count_word(ss);
      imfle>>x>>y>>z>>rd>>tp;  //get first atom
      if (tp>=static_cast<int>(idr.size()))
	{
	  idr.resize(tp+1);
	}
      idr[tp]=rd;
      n_central=n_atoms;
      atom central(x,y,z,rd,tp);
      At.push_back(central);
      n_atoms++;

      for(int i=1;i<npart;i++)
	{
	  imfle>>dx>>dy>>dz>>rd>>tp;
	  if (tp>=static_cast<int>(idr.size()))
	    {
	      idr.resize(tp+1);
	    }
	  idr[tp]=rd;
	  atom matom(x+dx,y+dy,z+dz,rd,tp);
	  matom.link(n_central);
	  At[n_central].link(n_atoms);
	  At.push_back(matom);
	  n_atoms++;
	}
    }

  int tps=idr.size();
  imfle.close();    
  n_pts=At.size();
  sprintf(ss,"Readed in %d points",n_pts);
  l_c(ss,1);
  sprintf(ss,"%d different radii",tps);
  l_c(ss,1);

  if(tps!=n_diff)
    {
      if (n_diff)
	delete [] radi;
      radi=new double[tps];
      n_diff=tps;
    }  
  for(int i=0;i<tps;i++)
    radi[i]=idr[i];

  return 0;
}

int
BoxMaps::count_word(char* name) const
{
  if (!name || strlen(name)<1) return 0;
  int offset;
  for(offset=0;offset<255 && isspace(name[offset]);offset++);
  int count=0;
  for(int i=offset;i<static_cast<int>(strlen(name))
	&& !isspace(name[i]);i++)
    {
      if (isupper(name[i])) 
	count++;
      else if (isdigit(name[i]))
	count+=static_cast<int>(name[i]-'1'); //note '1'== add zero
    }
  for(int i=0;i<static_cast<int>(strlen(name));i++)
    toupper(name[i]);
  if (!strncmp("ATO",name+offset,3)) return 1;
  return count;
}

BoxMaps::~BoxMaps()
{
  delete [] radi;
}

BoxMaps::BoxMaps(const BoxMaps& A)
{
  n_pts=A.n_pts;
  At=A.At;  //can this really be done ??? complete copy?
  if (n_diff)
    delete [] radi;
  radi=0;
  n_diff=A.n_diff;
  
  if(n_diff)
    radi=new double[n_diff];
  
  for(int i=0;i<n_diff;i++)
    radi[i]=A.radi[i];
 return;
}

int
BoxMaps::makebondlist(const int Anum,int*& bl) const
{
  return At[Anum].givebonded(bl);
}

int
BoxMaps::atom_info(const double* range,double*& xx,double*& yy,double*& zz,
		   int*& tpv,double*& tp,int*& vn) const
  /* collect the number of atoms in the plotting range */
{
  if (n_pts<1) return 0;
  xx=new double[n_pts];
  yy=new double[n_pts];
  zz=new double[n_pts]; 
  tpv=new int[n_pts];
  vn=new int[n_pts];
  int n_inc=0;
  double rd;
  for(int i=0;i<n_pts;i++)
    {
      
      if (!At[i].range(range))
	{
	  At[i].getvalues(xx[n_inc],yy[n_inc],zz[n_inc],
			  tpv[n_inc],rd);
	  vn[n_inc]=i;
          n_inc++;
	}
    }
  if (n_inc<1) 
    {
      delete [] xx;
      delete [] yy;
      delete [] zz;
      delete [] tpv;
      delete [] vn;
      return n_inc;
    }
  tp=new double[n_diff];
  for(int i=0;i<n_diff;i++)
    tp[i]=radi[i];
  return n_inc;
}


BoxMaps&
BoxMaps::operator=(const BoxMaps& A)
{
  if (this!= &A)
    {
      n_pts=A.n_pts;
      At=A.At;  //can this really be done ??? complete copy?
      if (n_diff)
      delete [] radi;
      radi=0;
      n_diff=A.n_diff;
      
      if(n_diff)
      radi=new double[n_diff];
      
      for(int i=0;i<n_diff;i++)
      radi[i]=A.radi[i];
    }
 return *this;
}

Box_Screen::Box_Screen() : Plot_Screen(),
   max_Maps(10),alpha(45.0),beta(0.0),fill_circle(1),rscale(1.5),
  ldist(2.5),DD(new BoxMaps[max_Maps]),na_sel(0),
  vpx(0),vpy(0),d_order(0),n_plots(0)
{ 
  ltz= -10.0;
  csa=cos(pi*alpha/180.0);
  sna=sin(pi*alpha/180.0);
  csb=cos(pi*beta/180.0);
  snb=sin(pi*beta/180.0);
  range[0]=range[2]=range[4]=0.0;
  range[1]=range[3]=range[5]=5.0;
  rd[0]=rd[1]=rd[2]=5.0;
  cx=cy=cz=2.5;
}
  

Box_Screen::~Box_Screen()
{
  extern Plts plot_info;
  delete [] DD;
  delete [] vpx;
  delete [] vpy;
  delete [] d_order;
  plot_info.box=0;
}


void
Box_Screen::keep()
{
  extern Plts plot_info;
  int plot_fig=0;
  static int count=1;
  char s[256];
  sprintf(s,"rplot_%d.gif/GIF",count);
  count++;
  plot_fig=cpgopen(s);
  if (!plot_fig)
    {
      l_c("Error opening plot file",1);
      if (plot_info.screen) 
	cpgslct(plot_info.screen);
      else if (scn)
	cpgslct(xmp_device_id(scn));
      return;   
    }
  cpgslct(plot_fig);
  sort_drawing();
  cpgclos();
  l_c("Successfully Closed rmc plot",1);
  
  int temp=plot_info.screen;
  if (temp) 
      cpgslct(temp);
  else if (scn)
    cpgslct(xmp_device_id(scn));
  return;
}


void
Box_Screen::sort_drawing()
{
  if (n_plots<1) return;
  draw_region(plist[0],1);
  return;
}
//   for(int i=1;i<n_plots;i++)
//     {
//       DD[plist[i]].plot_over();
//     }


void
Box_Screen::draw_region(const int n_draw,const int keep)
{
  if (n_draw<1 || n_draw>max_Maps) return;
  extern Plts plot_info;
  if (!plot_info.box)
    {
      plot_info.box=make_screen(2);
      cpgwnad(0.0,1.0,0.0,1.0);
      cpgask(0);    
    }
  if (!keep)
    cpgslct(xmp_device_id(scn));
  cpgsvp(0.05,0.95,0.05,0.95);
  cpgask(0); 
  cpgpage();
  plot_axis();
  double *x,*y,*z;
  int *tv;
  int *vn;
  double *rdi;
  int inrange=DD[n_draw-1].atom_info(range,x,y,z,tv,rdi,vn);
  if (!keep)
    {
      plist[0]=n_draw;
      n_plots=1;
    }
  if (!inrange) return;  //no atoms to draw.
  if (na_sel!=inrange)
    {
      delete [] vpx;
      delete [] vpy;
      delete [] d_order;
      vpx=new float[inrange];
      vpy=new float[inrange];
      d_order=new int[inrange];
      na_sel=inrange;
    }

  for(int i=0;i<inrange;i++)
    {
      rotate(x[i],y[i],z[i]);
      viewplane(vpx[i],vpy[i],x[i],y[i],z[i]);
    }
  sort_points(x,y,z);
  draw_circles(n_draw-1,x,y,z,tv,rdi,vn);
  plot_axis(1);
  delete [] x;
  delete [] y;
  delete [] z;
  delete [] tv;
  delete [] rdi;
  delete [] vn;
  int temp=plot_info.screen;
  if (temp) cpgslct(temp);
  return;
}

void
Box_Screen::sort_points(double *x,double *y,double *z)
{
  if(na_sel<1) return;
  if (na_sel==1) 
    {
     d_order[0]=0;
     return;
    } 
  double *Dst=new double[na_sel];
  double tx,ty,tz;

  for(int i=0;i<na_sel;i++)
    {
      tx=(x[i]-cx);
      tx*=tx;
      ty=(y[i]-cy);
      ty*=ty;
      tz=(z[i]-ltz);
      tz*=tz;
      Dst[i]=tx+ty+tz;
      d_order[i]=i;
    }
   rev_sort(Dst,d_order,na_sel);

   delete [] Dst;
   return;
}  


void
Box_Screen::planept(double &x,double &y,double *pt) const
{
  double m=(cz-ltz)/(2.0 * (pt[2]-ltz));
  x=cx+m*(pt[0]-cx);
  y=cy+m*(pt[1]-cy);

  return;
}

void
Box_Screen::planept(float &x,float &y,double *pt) const
{
  double m=(cz-ltz)/(2.0 * (pt[2]-ltz));
  x=cx+m*(pt[0]-cx);
  y=cy+m*(pt[1]-cy);
  return;
}

void
Box_Screen::viewplane(float &x,float &y,double *pt) const
{
  double m=(cz-ltz)/(2.0 * (pt[2]-ltz));
  x=cx+m*(pt[0]-cx);
  y=cy+m*(pt[1]-cy);
  x=(x-stx)/spr;
  y=(y-sty)/spr;
  return;
}

void
Box_Screen::viewplane(float &x,float &y,const double xx
                      ,const double yy,const double zz) const
{
  double m=(cz-ltz)/(2.0 * (zz-ltz));
  x=cx+m*(xx-cx);
  y=cy+m*(yy-cy);
  x=(x-stx)/spr;
  y=(y-sty)/spr;
  return;
}


void
Box_Screen::set_axis(const char a,int grp)
{
  extern wback hold_;
  char ss[256];
  double imin,imax;
  sprintf(ss,"Current Box: %8g,%8g,%8g,%8g,%8g,%8g",
              range[0],range[1],range[2],
	      range[3],range[4],range[5]);
  l_c(ss,1);
  int flag=0;
  if (a=='V') return;
  if (a=='C' || a=='S')
    {
      double ic[3];
      if (a=='C')
	sprintf(ss,"Current centre : %8g,%8g,%8g",
              (range[0]+range[1])/2.0,(range[2]+range[3])/2.0,
	      (range[4]+range[5])/2.0);
      else
	sprintf(ss,"Current widths : %8g,%8g,%8g",
		rd[0],rd[1],rd[2]);
      l_c(ss,1);
      while(flag<3 && cmdnumber(hold_.is,ic[flag]))
        {
	  flag++;
        }
      //Do centre first

      if (a=='S')
	{
	  if (flag!=1 || flag!=3)
	    {
	      sprintf(ss,"Enter widths =>");
	      l_c(ss,0);
	      flag=0;
	      while(flag<3 && cmdnumber(ss,ic[flag]))
		{
		  flag++;
		}
	      if (flag!=1 || flag!=3)
		return;
	    }
	  if (flag==1)
	    {
	      ic[1]=ic[2]=ic[0];
	    }
	  for(int i=0;i<3;i++)
	    {
	      rd[i]=ic[i];
	      double cp=(range[2*i]+range[2*i+1])/2.0;
	      range[2*i]=cp-(rd[i]/2.0);
	      range[2*i+1]=cp+(rd[i]/2.0);
	    }
	}
      // Case for ACentre
      if (flag!=3)
	{
	  sprintf(ss,"Enter new centre =>");
	  l_c(ss,0);
	  flag=0;
	  while(flag<3 && cmdnumber(ss,ic[flag]))
	    {
	      flag++;
	    }
	  if (flag!=3)
	    return;
	}
      range[0]+=ic[0]-cx;  range[1]+=ic[0]-cx; 
      range[2]+=ic[1]-cy;  range[3]+=ic[1]-cy; 
      range[4]+=ic[2]-cz;  range[5]+=ic[2]-cz; 
      cx=ic[0];  //rd unchanged..
      cy=ic[1];
      cz=ic[2];
      return;
    }
 
      
  if (a!='A' && a!='X' && a!='Y' && a!='Z')
    {
      if (!cmdnumber(hold_.is,imin) || !cmdnumber(hold_.is,imax))
	{
	  sprintf(ss,"Box coords =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin) || !cmdnumber(ss,imax)) return;
	}
      range[0]= (imax > imin) ? imin : imax;
      range[1]= (imax > imin) ? imax : imin;
      cx=(imax+imin)/2.0;
      rd[0]=range[1]-range[0];
      range[2]=range[4]=range[0];
      range[3]=range[5]=range[1];
      cy=cz=cx;
      rd[1]=rd[2]=rd[0];
      return;
    }   

  if(a!='Y' && a!='Z')
    {
      // Set x axis
      if (!cmdnumber(hold_.is,imin) || !cmdnumber(hold_.is,imax))
	{
          flag=1;
	  sprintf(ss,"X coords =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin) || !cmdnumber(ss,imax)) return;
	}
      range[0]= (imax > imin) ? imin : imax;
      range[1]= (imax > imin) ? imax : imin;
      cx=(imax+imin)/2.0;
      rd[0]=range[1]-range[0];
    }  
  if(a!='X' && a!='Z')
    {
      // Set y axis
      if (flag || !cmdnumber(hold_.is,imin) || !cmdnumber(hold_.is,imax))
	{
          flag=1;
	  sprintf(ss,"Y coords =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin) || !cmdnumber(ss,imax)) return;
	}
      range[2]= (imax > imin) ? imin : imax;
      range[3]= (imax > imin) ? imax : imin;
      cy=(imax+imin)/2.0;
      rd[1]=range[1]-range[0];
    }
  if(a!='X' && a!='Y')
    {
      // Set z axis
      if (flag || !cmdnumber(hold_.is,imin) || !cmdnumber(hold_.is,imax))
	{
	  sprintf(ss,"Z coords =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin) || !cmdnumber(ss,imax)) return;
	}
      range[4]= (imax > imin) ? imin : imax;
      range[5]= (imax > imin) ? imax : imin;
      cz=(imax+imin)/2.0;
      rd[2]=range[1]-range[0];
    }
  return;
}

void
Box_Screen::set_rscale(const char a)
{
  extern wback hold_;
  char ss[256];
  double imin;
  int it;

  if (a=='F')
    {
      if (!cmdnumber(hold_.is,it) || it<1 || it>3)
	{
	  sprintf(ss,"Fill type (1,2,3)");
	  l_c(ss,0);
	  if (!cmdnumber(ss,it) || it<1 || it>3) return;
	}
      fill_circle=it;
      return;
    }
  if (a=='S') 
    {
      if (!cmdnumber(hold_.is,imin) || imin<0.0)
	{
	  sprintf(ss,"R scale =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin) || imin<0.0) return;
	}
      rscale=imin;
      return;
    }
  if (a=='L')
    {
      if (!cmdnumber(hold_.is,imin))
	{
	  sprintf(ss,"Line dist =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin)) return;
	}
      ldist=imin;
      return;
    }

  if (fill_circle==1)
    sprintf(ss,"Full Outline Draw");
  else if (fill_circle==2)
    sprintf(ss,"Overlayed Outline Draw");
  else
    sprintf(ss,"Filled Atoms");
  l_c(ss,1);

  sprintf(ss,"Current Scale: %8g",
              rscale);
  l_c(ss,1);

  if (ldist<0.0) 
    sprintf(ss,"Line connections turned off");
  else
    sprintf(ss,"Line distance: %8g",ldist);
  l_c(ss,1);
  return;

}

void
Box_Screen::set_viewpt(const char a)
{
  extern wback hold_;
  char ss[256];
  double imin,imax;
  int flag=0;

  if (a=='A')
    {
      sprintf(ss,"Current Angles : %8g,%8g",
              alpha,beta);
      l_c(ss,1); 
      if (!cmdnumber(hold_.is,imin) || !cmdnumber(hold_.is,imax))
	{
	  sprintf(ss,"alpha and beta =>");
	  l_c(ss,0);
	  if (!cmdnumber(ss,imin)) return;
	  if (!cmdnumber(ss,imax)) imax=beta;
	}
      alpha=imin; 
      beta=imax;
      alpha-= ((int)(alpha/360.0))*360.0; 
      beta-= ((int) (beta/360.0))*360.0;
      csa=cos(pi*alpha/180.0);
      sna=sin(pi*alpha/180.0);
      csb=cos(pi*beta/180.0);
      snb=sin(pi*beta/180.0);      
      sprintf(ss,"Current Angles : %8g,%8g",
              alpha,beta);
      l_c(ss,1); 
      return;
    }
  sprintf(ss,"Current Viewpoint: %8g",ltz);
  l_c(ss,1); 
  // Set z axis
  if (flag || !cmdnumber(hold_.is,imin))
    {
      sprintf(ss,"Vp  coord =>");
      l_c(ss,0);
      if (!cmdnumber(ss,imin)) return;
    }
  ltz=imin;

  return;
}


void
Box_Screen::rev_rotate(double *pt) const
{
  /* using two rotation matrix (from centre of range) 
                                : cos sin
                                 -sin cos    
   note this is now in the reverse thus inverse of this matrix */

  double wb;
  pt[0]=((pt[0]-range[0])/rd[0])-0.5;
  pt[1]=((pt[1]-range[2])/rd[1])-0.5;
  pt[2]=((pt[2]-range[4])/rd[2])-0.5;
  wb= csa * pt[1] + sna * pt[0];
  pt[0] = csa * pt[0] - sna * pt[1];
  pt[1] = csb * wb - snb * pt[2];
  pt[2] = csb * pt[2] + snb * wb;
  pt[0] = ((pt[0]+0.5) * rd[0])+range[0];
  pt[1] = ((pt[1]+0.5) * rd[1])+range[2]; 
  pt[2] = ((pt[2]+0.5) * rd[2])+range[4];
  return;
}

void
Box_Screen::rotate(double *pt) const
{
  /* using two rotation matrix (from centre of range) 
                                : cos sin
                                 -sin cos    */
  double wb;
  pt[0]=((pt[0]-range[0])/rd[0])-0.5;
  pt[1]=((pt[1]-range[2])/rd[1])-0.5;
  pt[2]=((pt[2]-range[4])/rd[2])-0.5;
  wb= csa * pt[1] - sna * pt[0];
  pt[0] = csa * pt[0] + sna * pt[1];
  pt[1] = csb * wb + snb * pt[2];
  pt[2] = csb * pt[2] - snb * wb;
  pt[0] = ((pt[0]+0.5) * rd[0])+range[0];
  pt[1] = ((pt[1]+0.5) * rd[1])+range[2]; 
  pt[2] = ((pt[2]+0.5) * rd[2])+range[4];
  return;
}

void
Box_Screen::rotate(double &x,double &y,double &z) const
{
  /* using two rotation matrix (from centre of range) 
                                : cos sin
                                 -sin cos    */
  double wb;
  x=((x-range[0])/rd[0])-0.5;
  y=((y-range[2])/rd[1])-0.5;
  z=((z-range[4])/rd[2])-0.5;
  wb= csa * y - sna * x;
  x = csa * x + sna * y;
  y = csb * wb + snb * z;
  z = csb * z - snb * wb;
  x = ((x+0.5) * rd[0])+range[0];
  y = ((y+0.5) * rd[1])+range[2]; 
  z = ((z+0.5) * rd[2])+range[4];
  return;
}

void
Box_Screen::draw_lines(const int ndraw,const int st,double *x,double *y,
		       double *z,int *tv,int* vn) const
{
  if (na_sel<2 || st>=na_sel) return;
  double sdist=ldist * ldist;   
  double dta,dtb,dist;

  float xpts[2],ypts[2];

  int ita=d_order[st];
  int itb;

  xpts[0]=vpx[ita];
  ypts[0]=vpy[ita];

  int* bond;
  int nbond=DD[ndraw].makebondlist(vn[ita],bond);
  for(int i=st+1;i<na_sel;i++)
    {
      itb=d_order[i];
      dta=x[ita]-x[itb];
      dtb=y[ita]-y[itb];
      dist=z[ita]-z[itb];
      dist=dist * dist + dta*dta + dtb*dtb;
      int is_bonded;
      for(is_bonded=0;
	  is_bonded<nbond && vn[itb]!=bond[is_bonded];
	  is_bonded++);
      if(dist<sdist || is_bonded!=nbond)
	{
	  xpts[1]=vpx[itb];
	  ypts[1]=vpy[itb];
	  cpgline(2,xpts,ypts);
	}
    }
  delete [] bond;
}

void
Box_Screen::draw_circles(const int ndraw,double *x,double *y,
			 double *z,int *tv,double *rd,int* vn) const
  /* tv == type value[na_sel] */
{
  int ipt;

  double pt[3];
  float rx,ry;
  double rat;  

  cpgslw(2);
  cpgsfs(2);
  if (fill_circle==3) cpgsfs(1);
  for(int i=0;i<na_sel;i++)
    {
      ipt=d_order[i];
      rat=rd[tv[ipt]];      //radius
      pt[0]=x[ipt]-rat;
      pt[1]=y[ipt];
      pt[2]=z[ipt];
      viewplane(rx,ry,pt);
      rat=(vpx[ipt]-rx)/rscale;

      if (fill_circle==1)
	{
	  cpgsci(tv[ipt]+1);
	  cpgcirc(vpx[ipt],vpy[ipt],rat);
	}
      else if(fill_circle==2)
	{
	  cpgsci(0);
	  cpgsfs(1); 
	  cpgcirc(vpx[ipt],vpy[ipt],rat);
          cpgsci(tv[ipt]+1);
          cpgsfs(2);
	  cpgcirc(vpx[ipt],vpy[ipt],rat);
	}
      else
	{
	  cpgsci(tv[ipt]+1);
	  cpgcirc(vpx[ipt],vpy[ipt],rat);
	}
       cpgsci(1);
       draw_lines(ndraw,i,x,y,z,tv,vn);
    }

  cpgslw(1);
  cpgsci(1);
  return;
}



void
Box_Screen::plot_axis(const int sts)
{
  double pt[3];
  float xpts[2],ypts[2];
  //  pt[0]=((pt[0]-range[0])/(range[1]-range[0]))-0.5;
  double x,y;
  static float **ptsq(0);      //twelve projections of square
  static double mn_dist;
  static int mnpt;
  int ia[3],ib[3],ptn;
  ia[0]=ia[1]=ia[2]=0;
  double dist;
  if (!ptsq) 
    ptsq=fmatrix(8,2);
  for(int i=0;i<8;i++)
    {
      ia[2]=i/4;
      ia[1]=(i-(4 * ia[2]))/2;
      ia[0]=i % 2;
      pt[0]=range[ia[0]];
      pt[1]=range[ia[1]+2];
      pt[2]=range[ia[2]+4];
 //      cout<<"pt 0 "<<pt[0]<<" "<<pt[1]<<" "<<pt[2]<<" "<<endl;
      rotate(pt);
 // cout<<"pt "<<pt[0]<<" "<<pt[1]<<" "<<pt[2]<<" "<<endl;
      dist=pt[0]*pt[0]+pt[1]*pt[1]+(pt[2]-ltz)*(pt[2]-ltz);
      if (!i || dist<mn_dist)
	{
	  mnpt=i;
	  mn_dist=dist;
	}
      planept(x,y,pt);
 //      cout<<"Ia "<<ia[0]<<" "<<ia[1]<<" "<<ia[2]<<endl;
 //      cout<<"Pt "<<pt[0]<<" "<<pt[1]<<" "<<pt[2]<<endl;
 //      cout<<"x=="<<x<<" y== "<<y<<endl;
      ptsq[i][0]=x;
      ptsq[i][1]=y;
    }
  double xmin,xmax,ymin,ymax;
  xmax=xmin=ptsq[0][0];
  ymax=ymin=ptsq[0][1];
  for(int i=1;i<8;i++)
    {
      if (xmin>ptsq[i][0])
	xmin=ptsq[i][0];
      else if(xmax<ptsq[i][0])
	xmax=ptsq[i][0];
      if (ymin>ptsq[i][1])
	ymin=ptsq[i][1];
      else if(ymax<ptsq[i][1])
	ymax=ptsq[i][1];
    }
  spr=(xmax-xmin > ymax-ymin) ? xmax-xmin : ymax-ymin;
  stx=xmin;
  sty=ymin;
  if (!sts) return;

  /* interlude : To get the outside points project onto a plane at 
     infinate distance from the view point. All the outside lines
     have to be drawn solid and all inner points are hidden! */

  int lt[8];
  //  float **iv=ptsq;
  int num=tiger_cage(8,ptsq,lt);
  int kk;
  for(kk=0;kk<num && mnpt!=lt[kk];kk++);
  if (mnpt!=lt[kk])
    {
      lt[kk]=mnpt;
      num++;
    }
  int outfa,outfb;
  int ii;
  for(int i=0;i<7;i++)
    {
      ia[2]=i/4;
      ia[1]=(i-(4 * ia[2]))/2;
      ia[0]=i % 2;
      
      for(ii=0;ii<num && i!=lt[ii];ii++);
      outfa=(ii==num) ? 0 : 1;	

      for(int j=0;j<3;j++)
	{
	  if(!ia[j])
	    {
	      ib[0]=ia[0];
	      ib[1]=ia[1];
	      ib[2]=ia[2];
              ib[j]=1;	
              ptn=ib[0]+ ib[1]*2+ ib[2]*4;

              if (outfa)
		{
		  for(ii=0;ii<num && ptn!=lt[ii];ii++);
		  outfb=(ii==num) ? 0 : 1;	
		}

              xpts[0]=(ptsq[i][0]-stx)/spr;
              xpts[1]=(ptsq[ptn][0]-stx)/spr;
              ypts[0]=(ptsq[i][1]-sty)/spr;
              ypts[1]=(ptsq[ptn][1]-sty)/spr;
              if (outfa && outfb)
		cpgsls(1);
	      else
		cpgsls(2);
              cpgline(2,xpts,ypts);
	    }
	}
    }
  cpgsls(1);
  freematrix(ptsq);
  ptsq=0;
  return;
}

void
Box_Screen::read_rmc(const int type,int grp)
{
  /* if type=1 then read from default output, else read 
     from new modified output */

  extern wback hold_;
  char name[81];        //hold_ does not exceed 80 char.
  extractfile(name,hold_.is,80);

  grp--;
  int test;
  if (grp<0 || grp>=max_Maps) return;
  if (type)
    //    test=DD[grp].read_data((char *) name);
    test=DD[grp].read_rmc_data(static_cast<char*>(name));
  else
    test=DD[grp].read_rmc_data((char *) name);
  if (test)
    {
      char ss[255];
      strcpy(ss,"Error opening file");
      l_c(ss,1);
      return;
    }
  return;

}


/*
int 
BoxMaps::read_data(char *s) 
{
  ifstream imfle;
  if (s)
    imfle.open(s,ios::nocreate|ios::in);
  char ss[256];

  if (!imfle || !s)
    {
      imfle.close();
      strcpy(ss,"What is the box data set file =>");
      l_c(ss,0);
      s_line();
      int j;
      for(j=0;ss[j]>' ' && j<80;j++);
      ss[j]=0; 
      imfle.open(ss,ios::nocreate|ios::in); 
    }
   
  if (!imfle) return 1;
  int pts,tps;
  imfle>>pts>>tps;

  if (!imfle || pts<1 || tps<1) 
    {
      imfle.close();
      return 1;
    } 
  if (pts!=n_pts)      // Lets us get some memory
    {
      if(n_pts)
	{
	  delete [] x;
	  delete [] y;
	  delete [] z;
	  delete [] type;
	}
      x=new double[pts];
      y=new double[pts];
      z=new double[pts];
      type=new int[pts];
      n_pts=pts;
    }
  if(tps!=n_diff)
    {
      if (n_diff)
	delete [] radi;
      radi=new double[tps];
      n_diff=tps;
    }

  for(int i=0;i<n_diff;i++)
    imfle>>radi[i];

  double junk;
  for(int i=0;i<n_pts;i++)
    imfle>>x[i]>>y[i]>>z[i]>>junk>>type[i];
  imfle.close();    
  sprintf(ss,"Readed in %d points",pts);
  l_c(ss,1);
  return 0;
}

*/
