#ifndef base_graph_h
#define base_graph_h



class GraphItem
{

 public:

  int grp;   // 0 -- tg-1 
  int colour; //0 -255 
  int type;   //0 invalid: 1 normal: 2 error
  int ltype;  // line type 0-5 
  float size;  // size 

  GraphItem();
  GraphItem(const int,const int,const int,const int,const float);
  GraphItem(istream &);
  GraphItem(const GraphItem&);
  GraphItem& operator=(const GraphItem&);
  ~GraphItem();
  void write_gph(ostream &) const;
  void write_data(ostream &) const;
  int isPlotted(const int) const;
};

class Graph_Data 
{
  friend ostream& operator<<(ostream &,const Graph_Data &);
  friend istream& operator>>(istream &,Graph_Data &);

 protected:
  
  int made_window;  //do we have a window
  double aval[4];   //xy max,min
  double O_aval[4];   //xy max,min Alternative (for second graph)
  double bord[4];  //Border round graph 
  int atick[4];     //Ticks to display.
  double num_size[2]; //size of numbers 
  double O_num_size[2]; //alternative size of numbers 
  int log_flag[2];    //change x or y axis to logs
  int O_log_flag[2];    //change x or y axis to logs
  int aflag[2];       //flags for numbers,ticks etc...
  int O_aflag[2];       //alternative flags for numbers,ticks etc...

 public:
  
  Graph_Data();
  virtual ~Graph_Data();
  int check_window() const;
  void getaxis(double &,double &,double &,double &) const;
  void getaxisO(double &,double &,double &,double &) const;
  void getsize(double &,double &) const;
  void getsizeO(double &,double &) const;

};

class Plot_Screen
  {
  private:
    
    Widget pshell;   //The shell to maintain the top window.
    Widget mw;       //main window in the shell.
    int screen_num;

    static void report_cursor(Widget, XtPointer, XEvent *,
                        Boolean *);

  protected:

    Widget scn;      //The picture window in the main window
    int make_screen(const int =0); // generate a new screen
    int made_screen() { return screen_num;}

  public:


    Plot_Screen();
    virtual ~Plot_Screen();
};  
 
class Curs_Screen : public Plot_Screen
{

  /* Specialise the class to allow cursor operations  */

 private:

  Display *display;
  Cursor cus;     //FontCursor (from X) 
  Window win;
  int edit_grp;   // group that is being edited
  int cnpts;      // number of points in display
  int *cx;        // 
  int *cy;
  int *pt;
  
  int maxCross;   //max number of crosses that can be stored.
  int drawnCross; //number of crosses that should be drawn.
  int* cxs;       //Mirror of memory poiter pgx->state->Cross

  static void first_pt(Widget,XtPointer,XtPointer);
  static void line_pt(Widget,XtPointer,XtPointer);
  void layer_cursor(float,float,const int);
  void add_editlist(const int,const float,const float);
  
 protected:
  
  int bt;

  float x,y;
  float x1,y1;
  char button;
  void init_cont_cursor();  
  void free_cursor();
  void redisplay_cursor();
  
 public:
  
  Curs_Screen();
  virtual ~Curs_Screen();
  
  int sband(const int,const int,const float,const float,
	    float&,float&,char&);
  int make_fullscreen();
  void arm_e_cursor();
  void reset_c_mode(const int= 0);
  void remake_c_mode(const int= 1); //set mode to 1 
  void set_newpoint(const int,const float,const float);
  void add_newpoint(const int,const float,const float);

  //Stuff for drawing crosses. 

  void add_Cross(const float,const float,const float,const float);
  void move_Cross(const int,const float,const float,
		 const float,const float);
  void delete_Cross(const int);
};


class Draw_Method : public Curs_Screen,public virtual Graph_Data
{
 private:
  
  int screen;    // main drawing screen
  int print_fig; // print screen
  int p_count;   // level for outputing data.

 public:

  Draw_Method();
  ~Draw_Method();
  int select_window();
  void clear_picture();
  int open_print(const char * =0);
  void close_print();
  void realise_axis();
  //  void axis_make();
  void setcolour(const int) const;
  void header_draw(GraphItem &A);
  void error_draw(GraphItem &A);
  void line_draw(GraphItem &A) const;
};



#endif
