#ifndef axis_h
#define axis_h

 extern "C" void axis_make_box();
 extern "C" int mpgband(const int,const int,const float,const float,
			float&,float&,char&);
 extern "C" void h_cursor__(float*,float*,float*,float*,char*);
 extern "C" void reset_cursor();
 extern "C" void reset_cursor__();
 extern "C" void bin_pic(const int,const int=0);
 extern "C" void bin_gadds(int*,int*,int*);
 extern "C" void special();

 void esrf_pic(const int=1);
 void ascii_pic();
 void fit2d_pic();


void check_size(Widget,XtPointer,XEvent*,char*);

typedef void (*CURFN)(Widget,XtPointer,XtPointer);


class Graph_Data;

struct axis_menu;

struct Motif_Pts 
{
  int mode;
  int pt;
};


class fastout
{
private: 
public:
  
  fastout(); 
  
  
};

class axis_param : public virtual Graph_Data
{
  
private:    
  
  //Graphics bits
      
  Widget alog;        // Overall the dialog
  Widget text[4];     // text for axis xmin,xmax,ymin,ymax
  Widget vport[4];    // text for viewport.
  Widget axsize[2];   // text for scale.      
  Widget ticks[4];    // Type of ticks required
  Widget oma[2];    //  Type of default box (option menu axis)
  axis_menu *tpmenu;  //Place to hold info to pass to menus
                        //number bits
 
  int cflag[2];       //change x or y axis allowed

  static void axis_entry(Widget,XtPointer,XtPointer); 
  static void view_entry(Widget,XtPointer,XtPointer); 
  static void line_entry(Widget,XtPointer,XtPointer); 
  static void flg_change(Widget,XtPointer,XtPointer);
  static void change_axis(Widget,XtPointer,XtPointer);
  static void ten_percent(Widget,XtPointer,XtPointer);
  static void re_draw(Widget,XtPointer,XtPointer);
  static void old_val(Widget,XtPointer,XtPointer);
  static void axis_option_handler(Widget,XtPointer,XtPointer);
  static void axis_log_handler(Widget,XtPointer,XtPointer);
  static void axis_down(Widget,XtPointer,XtPointer);
  static void remove_axis(Widget,XtPointer,XtPointer);  
  static void Num_off(Widget,XtPointer,XtPointer);

public:
  
  axis_param();
  ~axis_param();
  
  void axis_make_box();   //function to make a box for pgplot.
  void axis_make_box(const float,const float,const float,const float); 
  void num_entry(const double,const double=0.0);

  void set_axis_wind();
  void make_wind();               
  
};


struct axis_menu
{
  axis_param *THIS;
  int count;
};


class plot_param
{
 
#define max_pg 20
#define tg 40 
  
  
private:
  
  Widget plog;
  Widget *text;
  
  int ng;
  
  static void plot_entry(Widget,XtPointer,XtPointer);
  static void down_load(Widget,XtPointer,XtPointer);
  static void plot_down(Widget,XtPointer,XtPointer);
  static void remove_plot(Widget,XtPointer,XtPointer);
  
public:
  
  void set_val();
  int get_val();
  void make_wind(int=0);
  plot_param();
  ~plot_param();
  
};   



union Uns
{
  int g;
  float f;
  char c[4];
};

    
#endif














